/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.gateway.endpoints;

import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.SpringApiIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringCloudGatewayUrlTargetInfo
implements UrlTargetInfo {
    private final List<Authority> myAuthorities;
    @NotNull
    private final Set<String> methods;
    private final String urlPath;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myElementPointer;

    public static SpringCloudGatewayUrlTargetInfo create(@NotNull String url, @Nullable PsiElement resolveTo, @NotNull Set<String> methods, @NotNull List<Authority> authorities) {
        if (url == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(0);
        }
        if (methods == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(1);
        }
        if (authorities == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(2);
        }
        return new SpringCloudGatewayUrlTargetInfo(url, resolveTo, methods, authorities);
    }

    @NotNull
    public Set<String> getMethods() {
        Set<String> set = this.methods;
        if (set == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public String getSource() {
        String string = UastUrlAttributeUtils.getUastDeclaringLocation((PsiElement)this.resolveToPsiElement());
        if (string == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        return UastUrlAttributeUtils.getUastDeclaringDocumentationElement((PsiElement)this.resolveToPsiElement());
    }

    public SmartPsiElementPointer<PsiElement> getElementPointer() {
        return this.myElementPointer;
    }

    private SpringCloudGatewayUrlTargetInfo(@NotNull String url, @Nullable PsiElement resolveTo, @NotNull Set<String> methods, @NotNull List<Authority> authorities) {
        if (url == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(5);
        }
        if (methods == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(6);
        }
        if (authorities == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(7);
        }
        this.urlPath = url;
        this.myElementPointer = resolveTo == null ? null : SmartPointerManager.getInstance((Project)resolveTo.getProject()).createSmartPsiElementPointer(resolveTo);
        this.methods = methods;
        this.myAuthorities = authorities;
    }

    @NotNull
    public List<String> getSchemes() {
        List list = UrlConstants.HTTP_SCHEMES;
        if (list == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        List<Authority> list = this.myAuthorities;
        if (list == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public UrlPath getPath() {
        UrlPath urlPath = UrlPathContextKt.chopLeadingEmptyBlock((UrlPath)UrlPath.fromExactString((String)this.urlPath));
        if (urlPath == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(10);
        }
        return urlPath;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.RequestMapping;
        if (icon == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(11);
        }
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @NotNull
    public String getUrlPath() {
        String string = this.urlPath;
        if (string == null) {
            SpringCloudGatewayUrlTargetInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.myElementPointer == null ? null : this.myElementPointer.getElement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringCloudGatewayUrlTargetInfo)) {
            return false;
        }
        SpringCloudGatewayUrlTargetInfo info = (SpringCloudGatewayUrlTargetInfo)o;
        if (!this.getUrlPath().equals(info.getUrlPath())) {
            return false;
        }
        return !(this.myElementPointer != null ? !this.myElementPointer.equals(info.getElementPointer()) : info.myElementPointer != null);
    }

    public int hashCode() {
        int result = this.getUrlPath().hashCode();
        result = 31 * result + (this.myElementPointer != null ? this.myElementPointer.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorities";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/cloud/gateway/endpoints/SpringCloudGatewayUrlTargetInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/cloud/gateway/endpoints/SpringCloudGatewayUrlTargetInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorities";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

