/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model;

import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbWithHome;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.xml.EjbBase;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjbCommonModelUtil {
    public static <T> List<T> collectEjbClasses(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces, Function<? super Pair<GenericValue<PsiClass>, EjbClassRoleEnum>, ? extends T> mapper) {
        ArrayList result = new ArrayList();
        if (includeClass) {
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejb.getEjbClass(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS))));
        }
        if (ejb instanceof EjbWithHome) {
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            if (includeHomeInterfaces) {
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getHome(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE))));
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getLocalHome(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE))));
            }
            if (includeComponentInterfaces) {
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getRemote(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE))));
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getLocal(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE))));
                if (ejb instanceof SessionBean) {
                    SessionBean sessionBean = (SessionBean)ejb;
                    if (Boolean.TRUE.equals(sessionBean.getLocalBean().getValue())) {
                        ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(sessionBean.getEjbClass(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS))));
                    } else {
                        for (GenericValue<PsiClass> genericValue : sessionBean.getBusinessLocals()) {
                            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(genericValue, (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE))));
                        }
                        for (GenericValue<PsiClass> genericValue : sessionBean.getBusinessRemotes()) {
                            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(genericValue, (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE))));
                        }
                        ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(sessionBean.getServiceEndpoint(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE))));
                    }
                }
            }
        }
        if (includeComponentInterfaces && ejb instanceof MessageDrivenBean) {
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(((MessageDrivenBean)ejb).getMessageListenerInterface(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE))));
        }
        return result;
    }

    public static List<GenericValue<PsiClass>> getEjbClassesReferences(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces) {
        return EjbCommonModelUtil.collectEjbClasses(ejb, includeClass, includeHomeInterfaces, includeComponentInterfaces, s -> (GenericValue)s.getFirst());
    }

    public static List<PsiClass> getEjbClasses(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces) {
        return EjbCommonModelUtil.collectEjbClasses(ejb, includeClass, includeHomeInterfaces, includeComponentInterfaces, s -> (PsiClass)((GenericValue)s.getFirst()).getValue());
    }

    @NotNull
    public static <T, V extends Collection<T>> V mapEjbClassRoles(@NotNull V result, @NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet, @NotNull Function<? super EjbClassRole, ? extends T> mapper) {
        EjbHelper ejbHelper;
        if (result == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(1);
        }
        if (mapper == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(2);
        }
        if ((ejbHelper = EjbHelper.getEjbHelper()) != null) {
            for (EjbClassRole role : ejbHelper.getAllEjbRoles(project)) {
                if (module != null && module != role.getModule() || facet != null && facet != role.getFacet()) continue;
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)role));
            }
        }
        V v = result;
        if (v == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(3);
        }
        return v;
    }

    @NotNull
    public static List<Interceptor> getAllInterceptors(@NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet) {
        if (project == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(4);
        }
        return EjbCommonModelUtil.mapEjbClassRoles(new ArrayList(), project, module, facet, ejbClassRole -> ejbClassRole.getInterceptor());
    }

    @NotNull
    public static List<EnterpriseBean> getAllEjbs(@NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet) {
        if (project == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(5);
        }
        return EjbCommonModelUtil.mapEjbClassRoles(new ArrayList(), project, module, facet, ejbClassRole -> ejbClassRole.getEnterpriseBean());
    }

    public static List<EnterpriseBean> getAllEjbs(@NotNull Project project) {
        if (project == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(6);
        }
        return EjbCommonModelUtil.getAllEjbs(project, null, null);
    }

    @NotNull
    public static EnterpriseBean getMergedEnterpriseBean(@NotNull EjbBase base) {
        EnterpriseBean bean;
        Module module;
        if (base == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(7);
        }
        if ((module = base.getModule()) != null && (bean = (EnterpriseBean)ElementPresentationManager.findByName(EjbCommonModelUtil.getAllEjbs(module.getProject(), module, null), (String)((String)base.getEjbName().getValue()))) != null) {
            EnterpriseBean enterpriseBean = bean;
            if (enterpriseBean == null) {
                EjbCommonModelUtil.$$$reportNull$$$0(8);
            }
            return enterpriseBean;
        }
        EjbBase ejbBase = base;
        if (ejbBase == null) {
            EjbCommonModelUtil.$$$reportNull$$$0(9);
        }
        return ejbBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/EjbCommonModelUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/EjbCommonModelUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapEjbClassRoles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedEnterpriseBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapEjbClassRoles";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterceptors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllEjbs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMergedEnterpriseBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9 -> new IllegalStateException(string);
        };
    }
}

