/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public final class ExclusionsDependencyFilter
implements DependencyFilter {
    private final Set<String> excludes = new HashSet<String>();

    public ExclusionsDependencyFilter(Collection<String> excludes) {
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(parents, "parents cannot be null");
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        String id = dependency.getArtifact().getArtifactId();
        if (this.excludes.contains(id)) {
            return false;
        }
        id = dependency.getArtifact().getGroupId() + ':' + id;
        return !this.excludes.contains(id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ExclusionsDependencyFilter that = (ExclusionsDependencyFilter)obj;
        return this.excludes.equals(that.excludes);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.excludes.hashCode();
        return hash;
    }
}

