/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend.")
public class V1alpha1StorageVersionStatus {
    public static final String SERIALIZED_NAME_COMMON_ENCODING_VERSION = "commonEncodingVersion";
    @SerializedName(value="commonEncodingVersion")
    private String commonEncodingVersion;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1alpha1StorageVersionCondition> conditions = null;
    public static final String SERIALIZED_NAME_STORAGE_VERSIONS = "storageVersions";
    @SerializedName(value="storageVersions")
    private List<V1alpha1ServerStorageVersion> storageVersions = null;

    public V1alpha1StorageVersionStatus commonEncodingVersion(String commonEncodingVersion) {
        this.commonEncodingVersion = commonEncodingVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If all API server instances agree on the same encoding storage version, then this field is set to that version. Otherwise this field is left empty. API servers should finish updating its storageVersionStatus entry before serving write operations, so that this field will be in sync with the reality.")
    public String getCommonEncodingVersion() {
        return this.commonEncodingVersion;
    }

    public void setCommonEncodingVersion(String commonEncodingVersion) {
        this.commonEncodingVersion = commonEncodingVersion;
    }

    public V1alpha1StorageVersionStatus conditions(List<V1alpha1StorageVersionCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1alpha1StorageVersionStatus addConditionsItem(V1alpha1StorageVersionCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1alpha1StorageVersionCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest available observations of the storageVersion's state.")
    public List<V1alpha1StorageVersionCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1alpha1StorageVersionCondition> conditions) {
        this.conditions = conditions;
    }

    public V1alpha1StorageVersionStatus storageVersions(List<V1alpha1ServerStorageVersion> storageVersions) {
        this.storageVersions = storageVersions;
        return this;
    }

    public V1alpha1StorageVersionStatus addStorageVersionsItem(V1alpha1ServerStorageVersion storageVersionsItem) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList<V1alpha1ServerStorageVersion>();
        }
        this.storageVersions.add(storageVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reported versions per API server instance.")
    public List<V1alpha1ServerStorageVersion> getStorageVersions() {
        return this.storageVersions;
    }

    public void setStorageVersions(List<V1alpha1ServerStorageVersion> storageVersions) {
        this.storageVersions = storageVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1StorageVersionStatus v1alpha1StorageVersionStatus = (V1alpha1StorageVersionStatus)o;
        return Objects.equals(this.commonEncodingVersion, v1alpha1StorageVersionStatus.commonEncodingVersion) && Objects.equals(this.conditions, v1alpha1StorageVersionStatus.conditions) && Objects.equals(this.storageVersions, v1alpha1StorageVersionStatus.storageVersions);
    }

    public int hashCode() {
        return Objects.hash(this.commonEncodingVersion, this.conditions, this.storageVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1StorageVersionStatus {\n");
        sb.append("    commonEncodingVersion: ").append(this.toIndentedString(this.commonEncodingVersion)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    storageVersions: ").append(this.toIndentedString(this.storageVersions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

