/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.httpClient.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.swagger.core.SwJacksonObjectMapperFactoryKt;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwObjectSchema;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.swagger.core.providers.httpClient.json.SwJsonMappingsFactory;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.swagger.core.ui.SpecificationReferencesInlineHelper;
import com.intellij.testFramework.LightVirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010)\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020#2\u0006\u0010-\u001a\u00020#H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\u000bH\u0002J\u0014\u00100\u001a\u0004\u0018\u00010#2\b\u0010/\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u000209H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010#2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0013H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u00042\u0006\u0010=\u001a\u00020#H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010/\u001a\u00020\u000bH\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00132\u0006\u0010A\u001a\u00020?H\u0002J\u001e\u0010B\u001a\u0004\u0018\u00010\u00042\b\u0010/\u001a\u0004\u0018\u00010\u000b2\b\u0010A\u001a\u0004\u0018\u00010?H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase;", "", "prefix", "", "", "<init>", "(Ljava/util/List;)V", "getPrefix", "()Ljava/util/List;", "myRootModelElements", "", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "getMyRootModelElements", "()Ljava/util/Collection;", "setMyRootModelElements", "(Ljava/util/Collection;)V", "myFactory", "Lcom/intellij/swagger/core/providers/httpClient/json/SwJsonMappingsFactory;", "myJsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "myYamlObjectMapper", "myDynamicSchemaRootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "myReferencesInlineHelper", "Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper;", "buildFile", "Lcom/intellij/testFramework/LightVirtualFile;", "createNestedNodeWithSchemaPrefixes", "rootNode", "prefixes", "handlePrefixes", "", "buildTopLevelSchema", "buildAffectedDefinitionsSchema", "prepareDefinitionToInline", "Lcom/fasterxml/jackson/databind/JsonNode;", "definition", "Lcom/intellij/swagger/core/model/api/SwDefinition;", "assembleSchemaAndMerge", "schemaRootNode", "modelElements", "substituteNodeToMerge", "isMultipleModels", "", "mergeSchemas", "newNode", "validateAndConvertSchema", "modelElement", "validateAndBuildSchema", "maximumAllowedLength", "", "referencePattern", "Ljava/util/regex/Pattern;", "definitionNameGroup", "", "substituteReferences", "rawDefinitionText", "", "schemaText", "objectMapper", "schemaAsString", "schema", "specificationFileTypeFor", "Lcom/intellij/openapi/fileTypes/FileType;", "mapperForFileType", "fileType", "rawElementText", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwRequestBodyToJsonSchemaConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwRequestBodyToJsonSchemaConverter.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 7 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n*L\n1#1,246:1\n1803#2,3:247\n1617#2,9:250\n1869#2:259\n1870#2:261\n1626#2:262\n1669#2,8:263\n1#3:260\n1#3:280\n1321#4,2:271\n23#5:273\n23#5:274\n23#5:275\n23#5:276\n23#5:277\n455#6:278\n455#6:279\n36#7:281\n*S KotlinDebug\n*F\n+ 1 SwRequestBodyToJsonSchemaConverter.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwRequestBodyToJsonSchemaConverterBase\n*L\n51#1:247,3\n66#1:250,9\n66#1:259\n66#1:261\n66#1:262\n67#1:263,8\n66#1:260\n81#1:271,2\n99#1:273\n151#1:274\n155#1:275\n165#1:276\n169#1:277\n190#1:278\n193#1:279\n78#1:281\n*E\n"})
public abstract class SwRequestBodyToJsonSchemaConverterBase {
    @NotNull
    private final List<String> prefix;
    protected Collection<? extends SwModelElement> myRootModelElements;
    @NotNull
    private final SwJsonMappingsFactory myFactory;
    @NotNull
    private final ObjectMapper myJsonObjectMapper;
    @NotNull
    private final ObjectMapper myYamlObjectMapper;
    @NotNull
    private final ObjectNode myDynamicSchemaRootNode;
    @NotNull
    private final SpecificationReferencesInlineHelper myReferencesInlineHelper;
    private final long maximumAllowedLength;
    @NotNull
    private final Pattern referencePattern;
    private final int definitionNameGroup;

    public SwRequestBodyToJsonSchemaConverterBase(@NotNull List<String> prefix) {
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        this.prefix = prefix;
        this.myFactory = new SwJsonMappingsFactory();
        this.myJsonObjectMapper = SwJacksonObjectMapperFactoryKt.createJsonJacksonMapper();
        this.myYamlObjectMapper = SwJacksonObjectMapperFactoryKt.createYamlJacksonMapper();
        this.myDynamicSchemaRootNode = this.myFactory.schemaRoot();
        this.myReferencesInlineHelper = new SpecificationReferencesInlineHelper(0, 1, null);
        this.maximumAllowedLength = Registry.Companion.intValue("definition.for.schema.length.limit", 1000);
        String string = "[^\"'\\n]*#/(\\S+/)*([^/\\s'\"]*)";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.referencePattern = pattern;
        this.definitionNameGroup = 2;
    }

    @NotNull
    public final List<String> getPrefix() {
        return this.prefix;
    }

    @NotNull
    protected final Collection<SwModelElement> getMyRootModelElements() {
        Collection<SwModelElement> collection = this.myRootModelElements;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myRootModelElements");
        return null;
    }

    protected final void setMyRootModelElements(@NotNull Collection<? extends SwModelElement> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.myRootModelElements = collection;
    }

    @Nullable
    protected final LightVirtualFile buildFile() {
        LightVirtualFile lightVirtualFile;
        this.buildTopLevelSchema();
        this.buildAffectedDefinitionsSchema();
        this.handlePrefixes();
        String string = this.schemaAsString((JsonNode)this.myDynamicSchemaRootNode);
        if (string == null) {
            return null;
        }
        String validatedSchema = string;
        LightVirtualFile $this$buildFile_u24lambda_u240 = lightVirtualFile = new LightVirtualFile("OpenapiRequestBodySchema.json", (CharSequence)validatedSchema);
        boolean bl = false;
        $this$buildFile_u24lambda_u240.setWritable(false);
        return lightVirtualFile;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectNode createNestedNodeWithSchemaPrefixes(ObjectNode rootNode, List<String> prefixes) {
        void $this$fold$iv;
        Iterable iterable = prefixes;
        ObjectNode initial$iv = rootNode;
        boolean $i$f$fold = false;
        ObjectNode accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void name2;
            String string = (String)element$iv;
            ObjectNode node = accumulator$iv;
            boolean bl = false;
            node.put("type", "object");
            Intrinsics.checkNotNullExpressionValue((Object)node.putObject("properties").putObject((String)name2), (String)"putObject(...)");
        }
        return accumulator$iv;
    }

    private final void handlePrefixes() {
        if (this.prefix.isEmpty()) {
            return;
        }
        JsonNode ref = this.myDynamicSchemaRootNode.remove("$ref");
        this.createNestedNodeWithSchemaPrefixes(this.myDynamicSchemaRootNode, this.prefix).replace("$ref", ref);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTopLevelSchema() {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = this.getMyRootModelElements();
        JsonNode jsonNode = (JsonNode)this.myDynamicSchemaRootNode;
        SwRequestBodyToJsonSchemaConverterBase swRequestBodyToJsonSchemaConverterBase = this;
        boolean $i$f$mapNotNull = false;
        void var3_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SwObjectSchema it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SwModelElement p0 = (SwModelElement)element$iv$iv;
            boolean bl2 = false;
            if (p0.getSchema() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$mapNotNull$iv = list;
        boolean $i$f$distinctBy = false;
        HashSet<SmartPsiElementPointer<? extends PsiElement>> set$iv = new HashSet<SmartPsiElementPointer<? extends PsiElement>>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SmartPsiElementPointer<? extends PsiElement> key$iv;
            SwObjectSchema it = (SwObjectSchema)e$iv;
            boolean bl = false;
            Object object = it.getPsiPointer();
            if (object == null) {
                object = it;
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        list = list$iv;
        swRequestBodyToJsonSchemaConverterBase.assembleSchemaAndMerge(jsonNode, list);
    }

    private final void buildAffectedDefinitionsSchema() {
        SwModelElement swModelElement = (SwModelElement)CollectionsKt.firstOrNull((Iterable)this.getMyRootModelElements());
        if (swModelElement == null || (swModelElement = swModelElement.getSourcePsi()) == null || (swModelElement = swModelElement.getManager()) == null) {
            return;
        }
        SwModelElement psiManager = swModelElement;
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)this.getMyRootModelElements()), SwRequestBodyToJsonSchemaConverterBase::buildAffectedDefinitionsSchema$lambda$0), SwRequestBodyToJsonSchemaConverterBase::buildAffectedDefinitionsSchema$lambda$1), SwRequestBodyToJsonSchemaConverterBase::buildAffectedDefinitionsSchema$lambda$2), arg_0 -> SwRequestBodyToJsonSchemaConverterBase.buildAffectedDefinitionsSchema$lambda$3(this, arg_0)), arg_0 -> SwRequestBodyToJsonSchemaConverterBase.buildAffectedDefinitionsSchema$lambda$4((PsiManager)psiManager, arg_0)), SwRequestBodyToJsonSchemaConverterBase::buildAffectedDefinitionsSchema$lambda$5), SwRequestBodyToJsonSchemaConverterBase::buildAffectedDefinitionsSchema$lambda$6), (Function1)((Function1)new Function1<SwDefinition, JsonNode>((Object)this){

            public final JsonNode invoke(SwDefinition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwRequestBodyToJsonSchemaConverterBase.access$prepareDefinitionToInline((SwRequestBodyToJsonSchemaConverterBase)this.receiver, p0);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode modelSchema = (JsonNode)element$iv;
            boolean bl = false;
            this.mergeSchemas((JsonNode)this.myDynamicSchemaRootNode, modelSchema);
        }
    }

    private final JsonNode prepareDefinitionToInline(SwDefinition definition) {
        String string = this.validateAndConvertSchema(definition);
        if (string == null) {
            return null;
        }
        String definitionSchema = string;
        String definitionName = definition.getName().getValue();
        return this.myFactory.definition(definitionName, definitionSchema);
    }

    private final void assembleSchemaAndMerge(JsonNode schemaRootNode, Collection<? extends SwModelElement> modelElements) {
        JsonNode effectiveNodeToMerge = this.substituteNodeToMerge(schemaRootNode, modelElements.size() > 1);
        for (SwModelElement swModelElement : modelElements) {
            ProgressManager.checkCanceled();
            JsonNode validSchemaOrNull = this.validateAndBuildSchema(swModelElement);
            if (validSchemaOrNull != null) {
                this.mergeSchemas(effectiveNodeToMerge, validSchemaOrNull);
                continue;
            }
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Invalid schema assembled for data model of type " + swModelElement.getClass().getName() + ". Particular schema will be skipped");
        }
    }

    private final JsonNode substituteNodeToMerge(JsonNode schemaRootNode, boolean isMultipleModels) {
        JsonNode jsonNode;
        if (isMultipleModels) {
            JsonNode jsonNode2 = schemaRootNode.withArray("oneOf");
            Intrinsics.checkNotNull((Object)jsonNode2);
            jsonNode = jsonNode2;
        } else {
            jsonNode = schemaRootNode;
        }
        return jsonNode;
    }

    private final void mergeSchemas(JsonNode schemaRootNode, JsonNode newNode) {
        SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(schemaRootNode, newNode, true);
    }

    private final String validateAndConvertSchema(SwModelElement modelElement) {
        JsonNode jsonNode = this.validateAndBuildSchema(modelElement);
        if (jsonNode == null) {
            return null;
        }
        JsonNode validSchemaObject = jsonNode;
        return this.schemaAsString(validSchemaObject);
    }

    private final JsonNode validateAndBuildSchema(SwModelElement modelElement) {
        if (modelElement == null) {
            return null;
        }
        FileType fileType = this.specificationFileTypeFor(modelElement);
        if (fileType == null) {
            return null;
        }
        FileType fileType2 = fileType;
        ObjectMapper objectMapper = this.mapperForFileType(fileType2);
        if (objectMapper == null) {
            return null;
        }
        ObjectMapper mapperForFileType = objectMapper;
        String string = this.rawElementText(modelElement, fileType2);
        if (string == null) {
            return null;
        }
        String rawDefinitionText = string;
        String definitionWithSubstitutedReferences = this.substituteReferences(rawDefinitionText);
        return this.validateAndBuildSchema(definitionWithSubstitutedReferences, mapperForFileType);
    }

    private final String substituteReferences(CharSequence rawDefinitionText) {
        if ((long)rawDefinitionText.length() > this.maximumAllowedLength) {
            return "";
        }
        Matcher matcher = this.referencePattern.matcher(StringUtil.newBombedCharSequence((CharSequence)rawDefinitionText, (long)300L));
        String string = matcher.replaceAll(arg_0 -> SwRequestBodyToJsonSchemaConverterBase.substituteReferences$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
        return string;
    }

    private final JsonNode validateAndBuildSchema(String schemaText, ObjectMapper objectMapper) {
        JsonNode jsonNode;
        try {
            jsonNode = objectMapper.readTree(schemaText);
        }
        catch (JsonParseException parseException) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Unable to assemble json schema from syntactically invalid element", (Throwable)parseException);
            jsonNode = null;
        }
        catch (IOException exception) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to assemble json schema", (Throwable)exception);
            jsonNode = null;
        }
        return jsonNode;
    }

    private final String schemaAsString(JsonNode schema2) {
        String string;
        try {
            string = this.myJsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema2);
        }
        catch (JsonParseException parseException) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Unable to assemble json schema from syntactically invalid element", (Throwable)parseException);
            string = null;
        }
        catch (IOException exception) {
            SwRequestBodyToJsonSchemaConverterBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwRequestBodyToJsonSchemaConverterBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to assemble json schema from syntactically invalid element", (Throwable)exception);
            string = null;
        }
        return string;
    }

    private final FileType specificationFileTypeFor(SwModelElement modelElement) {
        PsiElement psiElement = modelElement.getSourcePsi();
        return psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getFileType() : null;
    }

    private final ObjectMapper mapperForFileType(FileType fileType) {
        ObjectMapper objectMapper;
        FileType fileType2 = fileType;
        if (fileType2 instanceof JsonFileType) {
            objectMapper = this.myJsonObjectMapper;
        } else if (fileType2 instanceof YAMLFileType) {
            objectMapper = this.myYamlObjectMapper;
        } else {
            return null;
        }
        return objectMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String rawElementText(SwModelElement modelElement, FileType fileType) {
        Object object;
        if (modelElement == null) {
            return null;
        }
        FileType fileType2 = fileType;
        if (fileType2 instanceof JsonFileType) {
            PsiElement psiElement = modelElement.getSourcePsi();
            Object object2 = psiElement;
            if (psiElement == null) return null;
            PsiElement $this$childrenOfType$iv = object2;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, JsonObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            object2 = list;
            if (list == null) return null;
            JsonObject jsonObject = (JsonObject)CollectionsKt.singleOrNull((List)object2);
            object2 = jsonObject;
            if (jsonObject == null) return null;
            object = object2.getText();
            return object;
        } else {
            YAMLMapping yAMLMapping;
            if (!(fileType2 instanceof YAMLFileType)) return null;
            PsiElement psiElement = modelElement.getSourcePsi();
            if (psiElement == null) return null;
            PsiElement $this$childrenOfType$iv = psiElement;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLMapping.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            List list2 = list;
            if (list2 == null) return null;
            YAMLMapping yAMLMapping2 = (YAMLMapping)CollectionsKt.singleOrNull((List)list2);
            if (yAMLMapping2 == null) return null;
            YAMLMapping it = yAMLMapping = yAMLMapping2;
            boolean bl = false;
            if (it.getTextRange().getLength() >= 1000) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            YAMLMapping yAMLMapping3 = yAMLMapping;
            YAMLMapping yAMLMapping4 = yAMLMapping3;
            if (yAMLMapping4 == null) return null;
            YAMLMapping childMapping = yAMLMapping4;
            String indent = SwaggerUtilsKt.getYamlIndent((YAMLPsiElement)childMapping);
            object = indent + childMapping.getText();
        }
        return object;
    }

    private static final Unit buildAffectedDefinitionsSchema$lambda$0(SwModelElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProgressManager.checkCanceled();
        return Unit.INSTANCE;
    }

    private static final PsiFile buildAffectedDefinitionsSchema$lambda$1(SwModelElement modelElement) {
        Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
        PsiElement psiElement = modelElement.getSourcePsi();
        return psiElement != null ? psiElement.getContainingFile() : null;
    }

    private static final VirtualFile buildAffectedDefinitionsSchema$lambda$2(PsiFile specPsi) {
        Intrinsics.checkNotNullParameter((Object)specPsi, (String)"specPsi");
        return specPsi.getVirtualFile();
    }

    private static final String buildAffectedDefinitionsSchema$lambda$3(SwRequestBodyToJsonSchemaConverterBase this$0, PsiFile specPsi) {
        Intrinsics.checkNotNullParameter((Object)specPsi, (String)"specPsi");
        return this$0.myReferencesInlineHelper.prepareSpecificationText$intellij_swagger_core(specPsi).getSuccessOrNull();
    }

    private static final PsiFile buildAffectedDefinitionsSchema$lambda$4(PsiManager $psiManager, String selfContainedSpec) {
        Intrinsics.checkNotNullParameter((Object)selfContainedSpec, (String)"selfContainedSpec");
        return $psiManager.findFile((VirtualFile)new LightVirtualFile("self-contained.json", (CharSequence)selfContainedSpec));
    }

    /*
     * WARNING - void declaration
     */
    private static final SwSpecificationFile buildAffectedDefinitionsSchema$lambda$5(PsiFile selfContainedSpecPsi) {
        void psiElement$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)selfContainedSpecPsi, (String)"selfContainedSpecPsi");
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        PsiElement psiElement = (PsiElement)selfContainedSpecPsi;
        boolean withSelf$iv = true;
        boolean $i$f$getParentOfType = false;
        return this_$iv.getParentOfType((PsiElement)psiElement$iv, SwSpecificationFile.class, withSelf$iv);
    }

    private static final Iterable buildAffectedDefinitionsSchema$lambda$6(SwSpecificationFile specModel) {
        Intrinsics.checkNotNullParameter((Object)specModel, (String)"specModel");
        return specModel.getAllLocalObjectDefinitions();
    }

    private static final String substituteReferences$lambda$0(SwRequestBodyToJsonSchemaConverterBase this$0, MatchResult matchResult) {
        MatchResult matchResult2;
        MatchResult it = matchResult2 = matchResult;
        boolean bl = false;
        Object object = it.groupCount() >= this$0.definitionNameGroup ? matchResult2 : null;
        if (object == null || (object = object.group(this$0.definitionNameGroup)) == null) {
            object = "Unknown";
        }
        Object definitionName = object;
        return "#/definitions/" + (String)definitionName;
    }

    public static final /* synthetic */ JsonNode access$prepareDefinitionToInline(SwRequestBodyToJsonSchemaConverterBase $this, SwDefinition definition) {
        return $this.prepareDefinitionToInline(definition);
    }
}

