/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.AsyncFramesHeader;
import com.intellij.javascript.debugger.SuspendContextViewKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptExecutionStack;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0003\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/debugger/ExecutionStackView;", "Lorg/jetbrains/debugger/ScriptExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "displayName", "", "isCurrent", "", "<init>", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/String;Z)V", "getSuspendContext", "()Lorg/jetbrains/debugger/SuspendContext;", "getViewSupport$intellij_javascript_debugger_backend", "()Lorg/jetbrains/debugger/DebuggerViewSupport;", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "getTopFrame", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "copyWithIsCurrent", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nSuspendContextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendContextView.kt\ncom/intellij/javascript/debugger/ExecutionStackView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SuspendContext.kt\norg/jetbrains/debugger/SuspendContextKt\n*L\n1#1,235:1\n1#2:236\n73#3:237\n*S KotlinDebug\n*F\n+ 1 SuspendContextView.kt\ncom/intellij/javascript/debugger/ExecutionStackView\n*L\n183#1:237\n*E\n"})
public final class ExecutionStackView
extends ScriptExecutionStack {
    @NotNull
    private final SuspendContext<?> suspendContext;
    @NotNull
    private final DebuggerViewSupport viewSupport;
    @Nullable
    private final Script topFrameScript;
    @Nullable
    private final SourceInfo topFrameSourceInfo;
    @Nullable
    private CallFrameView topCallFrameView;

    public ExecutionStackView(@NotNull SuspendContext<?> suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo, @NlsContexts.ListItem @NotNull String displayName, boolean isCurrent) {
        Intrinsics.checkNotNullParameter(suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        super(suspendContext.getVm(), displayName, SuspendContextViewKt.access$getThreadIcon(isCurrent));
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackView(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            string = "";
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo, string, bl);
    }

    @NotNull
    public final SuspendContext<?> getSuspendContext() {
        return this.suspendContext;
    }

    @NotNull
    public final DebuggerViewSupport getViewSupport$intellij_javascript_debugger_backend() {
        return this.viewSupport;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CallFrameView getTopFrame() {
        block6: {
            CallFrameView callFrameView;
            CallFrame topCallFrame;
            block5: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block5;
                CallFrameView callFrameView2 = this.topCallFrameView;
                Intrinsics.checkNotNull((Object)callFrameView2);
                if (Intrinsics.areEqual((Object)callFrameView2.getCallFrame(), (Object)topCallFrame)) break block6;
            }
            ExecutionStackView executionStackView = this;
            CallFrame callFrame = topCallFrame;
            if (callFrame != null) {
                void it;
                CallFrame callFrame2 = callFrame;
                ExecutionStackView executionStackView2 = executionStackView;
                boolean bl = false;
                callFrameView = new CallFrameView((CallFrame)it, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, this.suspendContext.getVm(), this.suspendContext.getMethodReturnValue(), 16, null);
                executionStackView = executionStackView2;
            } else {
                callFrameView = null;
            }
            executionStackView.topCallFrameView = callFrameView;
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Promise promise = this.suspendContext.getFrames();
        SuspendContext<?> context$iv = this.suspendContext;
        boolean $i$f$onSuccess = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onSuccess$iv.onSuccess((Consumer)new ContextDependentAsyncResultConsumer<CallFrame[]>(context$iv, firstFrameIndex, this, container){
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ ExecutionStackView this$0;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;
            {
                this.$firstFrameIndex$inlined = n;
                this.this$0 = executionStackView;
                this.$container$inlined = xStackFrameContainer;
                super($context);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void accept(Object result, Vm vm) {
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(result, this.$firstFrameIndex$inlined, this.this$0, this.$container$inlined){
                    final /* synthetic */ Object $result;
                    final /* synthetic */ int $firstFrameIndex$inlined;
                    final /* synthetic */ ExecutionStackView this$0;
                    final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;
                    {
                        this.$result = $result;
                        this.$firstFrameIndex$inlined = n;
                        this.this$0 = executionStackView;
                        this.$container$inlined = xStackFrameContainer;
                    }

                    public final void run() {
                        CallFrame[] frames = (CallFrame[])this.$result;
                        boolean bl = false;
                        int count = frames.length - this.$firstFrameIndex$inlined;
                        List result = null;
                        if (count < 1) {
                            result = CollectionsKt.emptyList();
                        } else {
                            result = new ArrayList<E>(count);
                            int n = frames.length;
                            for (int i = this.$firstFrameIndex$inlined; i < n; ++i) {
                                boolean isInLibraryContent;
                                if (i == 0) {
                                    ArrayList arrayList = (ArrayList)result;
                                    CallFrameView callFrameView = this.this$0.getTopFrame();
                                    Intrinsics.checkNotNull((Object)callFrameView);
                                    arrayList.add(callFrameView);
                                    continue;
                                }
                                CallFrame frame = frames[i];
                                Script script = this.this$0.getSuspendContext().getVm().getScriptManager().getScript(frame);
                                if (script == null) continue;
                                SourceInfo sourceInfo = this.this$0.getViewSupport$intellij_javascript_debugger_backend().getSourceInfo(script, frame);
                                boolean bl2 = isInLibraryContent = sourceInfo != null && this.this$0.getViewSupport$intellij_javascript_debugger_backend().isInLibraryContent(sourceInfo, script);
                                if (isInLibraryContent && !XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) continue;
                                String asyncFunctionName = frame.getAsyncFunctionName();
                                if (asyncFunctionName != null) {
                                    ((ArrayList)result).add(new AsyncFramesHeader(asyncFunctionName));
                                }
                                ((ArrayList)result).add(new CallFrameView(frame, this.this$0.getViewSupport$intellij_javascript_debugger_backend(), script, sourceInfo, Boolean.valueOf(isInLibraryContent), this.this$0.getSuspendContext().getVm(), null, 64, null));
                            }
                        }
                        this.$container$inlined.addStackFrames(result, true);
                    }
                });
            }
        }), (String)"onSuccess(...)");
    }

    @NotNull
    public final ExecutionStackView copyWithIsCurrent(boolean isCurrent) {
        if (Intrinsics.areEqual((Object)this.getIcon(), (Object)SuspendContextViewKt.access$getThreadIcon(isCurrent))) {
            return this;
        }
        String string = this.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return new ExecutionStackView(this.suspendContext, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, string, isCurrent);
    }
}

