/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlTypeSystem;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlForeach;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedNameVariable
extends RenameableFakePsiElement
implements VtlVariable {
    public static final Key<FixedNameVariable> SCOPE = Key.create((String)"VtlScope");
    private final String myName;
    @Nullable
    private final String myTypeName;
    private final PsiElement myParent;
    private final boolean myScope;

    FixedNameVariable(PsiElement parent, @NotNull String name, @Nullable String typeName) {
        if (name == null) {
            FixedNameVariable.$$$reportNull$$$0(0);
        }
        this(parent, name, typeName, false);
    }

    public FixedNameVariable(PsiElement parent, @NotNull String name, boolean scope) {
        if (name == null) {
            FixedNameVariable.$$$reportNull$$$0(1);
        }
        this(parent, name, null, scope);
    }

    FixedNameVariable(PsiElement parent, @NotNull String name, @Nullable String typeName, boolean scope) {
        if (name == null) {
            FixedNameVariable.$$$reportNull$$$0(2);
        }
        super((PsiElement)parent.getContainingFile());
        this.myParent = parent;
        this.myName = name;
        this.myTypeName = typeName;
        this.myScope = scope;
    }

    public PsiElement getParent() {
        return this.getRealScope().myParent;
    }

    public FixedNameVariable getRealScope() {
        return this.myParent instanceof FixedNameVariable ? (FixedNameVariable)this.myParent : this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myParent.getNavigationElement();
        if (psiElement == null) {
            FixedNameVariable.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FixedNameVariable.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.variable", new Object[0]);
    }

    public boolean isWritable() {
        return false;
    }

    public PsiElement setName(@NotNull @NonNls String s) throws IncorrectOperationException {
        if (s == null) {
            FixedNameVariable.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException(VelocityBundle.message("operation.not.allowed", new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedNameVariable)) {
            return false;
        }
        FixedNameVariable that = (FixedNameVariable)o;
        if (this.myScope != that.myScope) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myParent.equals((Object)that.myParent)) {
            return false;
        }
        return !(this.myTypeName != null ? !this.myTypeName.equals(that.myTypeName) : that.myTypeName != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myTypeName != null ? this.myTypeName.hashCode() : 0);
        result = 31 * result + this.myParent.hashCode();
        result = 31 * result + (this.myScope ? 1 : 0);
        return result;
    }

    @Override
    @Nullable
    public VtlVariableType getPsiType() {
        if (this.myTypeName == null) {
            return null;
        }
        return VtlTypeSystem.getTypeSystem().createTypeByFQClassName(this.getProject(), this.myTypeName, this.getResolveScope());
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FixedNameVariable.$$$reportNull$$$0(6);
        }
        if (state == null) {
            FixedNameVariable.$$$reportNull$$$0(7);
        }
        if (place == null) {
            FixedNameVariable.$$$reportNull$$$0(8);
        }
        if (this.myScope) {
            FixedNameVariable realScope = this.getRealScope();
            if (!PsiTreeUtil.treeWalkUp((PsiScopeProcessor)new PsiScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return !(element instanceof VtlAssignment.AssignedVariable) || processor.execute(element, state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/velocity/psi/directives/FixedNameVariable$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PsiElement)place, null, (ResolveState)ResolveState.initial().put(SCOPE, (Object)realScope))) {
                return false;
            }
            Class parentClass = this.getParent().getClass();
            if (!this.processInDelegateScope(processor, state, lastParent, place, PsiTreeUtil.getParentOfType((PsiElement)this.myParent, (Class)parentClass), "parent")) {
                return false;
            }
            if (!this.processInDelegateScope(processor, state, lastParent, place, PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myParent, (Class)parentClass), "topmost")) {
                return false;
            }
            if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "depth", "java.lang.Integer"), state)) {
                return false;
            }
            if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "replaced", null), state)) {
                return false;
            }
            if (this.getParent() instanceof VtlForeach) {
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "count", "java.lang.Integer"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "index", "java.lang.Integer"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "hasNext", "java.lang.Boolean"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "first", null), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "last", null), state)) {
                    return false;
                }
            }
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private boolean processInDelegateScope(final PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, PsiElement next, final String accessor) {
        return next == null || next.processDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof FixedNameVariable && ((FixedNameVariable)element).myName.equals(FixedNameVariable.this.myName)) {
                    return processor.execute((PsiElement)new FixedNameVariable(element, accessor, true), state);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/velocity/psi/directives/FixedNameVariable$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, state, lastParent, place);
    }

    public String toString() {
        return "FixedNameVariable{myName='" + this.myName + "', myTypeName='" + this.myTypeName + "', myScope=" + this.myScope + "}";
    }

    @Nullable
    public static FixedNameVariable getReferenceScope(@NotNull VtlReferenceExpression ref) {
        VtlReferenceExpression qualifier;
        if (ref == null) {
            FixedNameVariable.$$$reportNull$$$0(9);
        }
        PsiElement resolve = (qualifier = ref.getQualifier()) == null ? null : qualifier.resolve();
        return resolve instanceof FixedNameVariable && ((FixedNameVariable)resolve).myScope ? (FixedNameVariable)resolve : null;
    }

    @NotNull
    public PsiElement getTargetElement() {
        PsiElement macro;
        PsiElement navigationElement;
        if (this.myScope && (navigationElement = this.getNavigationElement()) instanceof VtlMacroCall && (macro = ((VtlMacroCall)navigationElement).getReferenceExpression().resolve()) != null) {
            PsiElement psiElement = macro;
            if (psiElement == null) {
                FixedNameVariable.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        FixedNameVariable fixedNameVariable = this;
        if (fixedNameVariable == null) {
            FixedNameVariable.$$$reportNull$$$0(11);
        }
        return fixedNameVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/directives/FixedNameVariable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/directives/FixedNameVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11 -> new IllegalStateException(string);
        };
    }
}

