/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModel;
import com.intellij.spring.mvc.apiversioning.highlighting.ConfigureApiVersionInserterFix;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringApiVersioningTestConfigurationInspectionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningTestConfigurationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getVisitor", "module", "Lcom/intellij/openapi/module/Module;", "isApiVersionInserterConfigured", "testPsiClass", "Lcom/intellij/psi/PsiClass;", "customizerFqn", "", "element", "Lcom/intellij/psi/PsiElement;", "builderFqn", "getTestConfigurations", "", "containingClass", "configurationBaseClass", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getImportedTestConfigurations", "", "getInnerTestConfigurations", "hasApiVersionInserterConfigured", "psiClass", "getRawParameterMethodSignature", "Lcom/intellij/psi/impl/light/LightMethodBuilder;", "psiManager", "Lcom/intellij/psi/PsiManager;", "getParameterizedParameterMethodSignature", "getBaseMethodSignature", "uMethod", "Lorg/jetbrains/uast/UMethod;", "intellij.spring.mvc.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSpringApiVersioningTestConfigurationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringApiVersioningTestConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningTestConfigurationInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,535:1\n1761#2,3:536\n1374#2:539\n1460#2,5:540\n12970#3,2:545\n*S KotlinDebug\n*F\n+ 1 SpringApiVersioningTestConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningTestConfigurationInspection\n*L\n136#1:536,3\n153#1:539\n153#1:540,5\n169#1:545,2\n*E\n"})
public final class SpringApiVersioningTestConfigurationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                PsiFile psiFile = holder.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile psiFile2 = psiFile;
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                if (virtualFile == null) {
                    PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
                    return psiElementVisitor;
                }
                VirtualFile vFile = virtualFile;
                boolean inTests = ProjectFileIndex.getInstance((Project)psiFile2.getProject()).isInTestSourceContent(vFile);
                if (!inTests) {
                    PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
                    return psiElementVisitor;
                }
                Module module2 = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
                if (module2 == null) {
                    PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
                    return psiElementVisitor;
                }
                module = module2;
                if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) break block6;
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (SpringApiVersioningModel.Companion.getInstance(project).isAvailable(module)) break block7;
            }
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return this.getVisitor(holder, module);
    }

    private final PsiElementVisitor getVisitor(ProblemsHolder holder, Module module) {
        return new PsiElementVisitor(this, module, holder){
            final /* synthetic */ SpringApiVersioningTestConfigurationInspection this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressManager.checkCanceled();
                UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression uCallExpression2 = uCallExpression;
                if (!Intrinsics.areEqual((Object)uCallExpression2.getMethodName(), (Object)"apiVersion")) {
                    return;
                }
                Object object = uCallExpression2.resolve();
                if (object == null || (object = object.getContainingClass()) == null || (object = object.getQualifiedName()) == null) {
                    return;
                }
                Object containingClassFqn = object;
                if (!SpringApiVersioningTestConfigurationInspectionKt.access$getBUILDERS$p().keySet().contains(containingClassFqn)) {
                    return;
                }
                Pair pair = (Pair)SpringApiVersioningTestConfigurationInspectionKt.access$getBUILDERS$p().get(containingClassFqn);
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                String builderFqn = (String)pair2.component1();
                String customizerFqn = (String)pair2.component2();
                UElement $this$getParentOfType_u24default$iv = (UElement)uCallExpression2;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UClass uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                    return;
                }
                UClass testPsiClass = uClass;
                boolean apiVersionInserterConfigured = SpringApiVersioningTestConfigurationInspection.access$isApiVersionInserterConfigured(this.this$0, (PsiClass)testPsiClass, customizerFqn, this.$module, element, builderFqn);
                if (!apiVersionInserterConfigured) {
                    UIdentifier uIdentifier = uCallExpression2.getMethodIdentifier();
                    Intrinsics.checkNotNull((Object)uIdentifier, (String)"null cannot be cast to non-null type org.jetbrains.uast.UIdentifier");
                    PsiElement psiElement = uIdentifier.getSourcePsi();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement psiElement2 = psiElement;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConfigureApiVersionInserterFix(customizerFqn, psiElement2)};
                    this.$holder.registerProblem(psiElement2, SpringMvcBundle.message("mvc.inspection.test.api.version.inserter.not.configured", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    private final boolean isApiVersionInserterConfigured(PsiClass testPsiClass, String customizerFqn, Module module, PsiElement element, String builderFqn) {
        boolean bl;
        block3: {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)element.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            Collection<PsiClass> testConfigurations = this.getTestConfigurations(testPsiClass, customizerFqn, module, scope);
            Iterable $this$any$iv = testConfigurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiClass psiClass = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!this.hasApiVersionInserterConfigured(psiClass, builderFqn, customizerFqn, module)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Collection<PsiClass> getTestConfigurations(PsiClass containingClass, String configurationBaseClass, Module module, GlobalSearchScope scope) {
        return CollectionsKt.plus((Collection)this.getImportedTestConfigurations(containingClass), (Iterable)this.getInnerTestConfigurations(module, scope, configurationBaseClass));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiClass> getImportedTestConfigurations(PsiClass containingClass) {
        void $this$flatMapTo$iv$iv;
        List list = SemService.getSemService((Project)containingClass.getProject()).getSemElements(SpringImport.IMPORT_JAM_KEY, (PsiElement)containingClass);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSemElements(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SpringImport it = (SpringImport)element$iv$iv;
            boolean bl = false;
            List list2 = it.getImportedClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getImportedClasses(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<PsiClass> getInnerTestConfigurations(Module module, GlobalSearchScope scope, String configurationBaseClass) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.springframework.boot.test.context.TestConfiguration", GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass testConfigurationAnnoPsiClass = psiClass;
        List configurations = new ArrayList();
        AnnotatedMembersSearch.search((PsiClass)testConfigurationAnnoPsiClass, (SearchScope)((SearchScope)scope)).forEach(arg_0 -> SpringApiVersioningTestConfigurationInspection.getInnerTestConfigurations$lambda$0(configurations, configurationBaseClass, arg_0));
        return configurations;
    }

    private final boolean hasApiVersionInserterConfigured(PsiClass psiClass, String builderFqn, String customizerFqn, Module module) {
        UMethod uMethod;
        block2: {
            Object[] objectArray = new Function0[]{() -> SpringApiVersioningTestConfigurationInspection.hasApiVersionInserterConfigured$lambda$0(this, builderFqn, psiClass, module), () -> SpringApiVersioningTestConfigurationInspection.hasApiVersionInserterConfigured$lambda$1(this, customizerFqn, psiClass, module)};
            List signatureProviders = CollectionsKt.listOf((Object[])objectArray);
            for (Function0 it : (Iterable)signatureProviders) {
                LightMethodBuilder methodSignature;
                boolean bl = false;
                UMethod uMethod2 = (LightMethodBuilder)it.invoke() == null ? null : (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiClass.findMethodBySignature((PsiMethod)methodSignature, false)), UMethod.class);
                if (uMethod2 == null) continue;
                uMethod = uMethod2;
                break block2;
            }
            uMethod = null;
        }
        if (uMethod == null) {
            return false;
        }
        UMethod uMethod3 = uMethod;
        return this.hasApiVersionInserterConfigured(uMethod3, builderFqn);
    }

    private final LightMethodBuilder getRawParameterMethodSignature(String builderFqn, PsiManager psiManager, Module module) {
        LightMethodBuilder lightMethodBuilder = this.getBaseMethodSignature(psiManager).addParameter("builder", (PsiType)PsiType.getTypeByName((String)builderFqn, (Project)module.getProject(), (GlobalSearchScope)GlobalSearchScope.moduleWithLibrariesScope((Module)module)));
        Intrinsics.checkNotNullExpressionValue((Object)lightMethodBuilder, (String)"addParameter(...)");
        return lightMethodBuilder;
    }

    private final LightMethodBuilder getParameterizedParameterMethodSignature(String customizerFqn, PsiManager psiManager, Module module) {
        Object[] objectArray;
        JvmMethod jvmMethod;
        Object[] objectArray2;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(customizerFqn, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        JvmParameter jvmParameter = psiClass != null && (objectArray2 = psiClass.findMethodsByName("customize")) != null && (jvmMethod = (JvmMethod)ArraysKt.firstOrNull((Object[])objectArray2)) != null && (objectArray = jvmMethod.getParameters()) != null ? (JvmParameter)ArraysKt.firstOrNull((Object[])objectArray) : null;
        PsiParameter psiParameter = jvmParameter instanceof PsiParameter ? (PsiParameter)jvmParameter : null;
        if (psiParameter == null) {
            return null;
        }
        PsiParameter psiParameter2 = psiParameter;
        return this.getBaseMethodSignature(psiManager).addParameter(psiParameter2);
    }

    private final LightMethodBuilder getBaseMethodSignature(PsiManager psiManager) {
        String[] stringArray = new String[]{"public"};
        LightMethodBuilder lightMethodBuilder = new LightMethodBuilder(psiManager, "customize").setModifiers(stringArray).setMethodReturnType((PsiType)PsiTypes.voidType());
        Intrinsics.checkNotNullExpressionValue((Object)lightMethodBuilder, (String)"setMethodReturnType(...)");
        return lightMethodBuilder;
    }

    private final boolean hasApiVersionInserterConfigured(UMethod uMethod, String builderFqn) {
        Ref.BooleanRef result = new Ref.BooleanRef();
        uMethod.accept((UastVisitor)new AbstractUastVisitor(builderFqn, result){
            final /* synthetic */ String $builderFqn;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$builderFqn = $builderFqn;
                this.$result = $result;
            }

            public boolean visitCallExpression(UCallExpression node) {
                PsiClass qualifierClass;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression uExpression = node.getReceiver();
                if (uExpression == null) {
                    return super.visitCallExpression(node);
                }
                UExpression qualifierExpression = uExpression;
                PsiClass psiClass = qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierExpression.getExpressionType());
                if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$builderFqn) && Intrinsics.areEqual((Object)node.getMethodName(), (Object)"apiVersionInserter")) {
                    this.$result.element = true;
                    return false;
                }
                return super.visitCallExpression(node);
            }
        });
        return result.element;
    }

    private static final boolean getInnerTestConfigurations$lambda$0(List $configurations, String $configurationBaseClass, PsiMember psiMember) {
        if (psiMember instanceof PsiClass) {
            boolean bl;
            block3: {
                PsiClass[] psiClassArray = ((PsiClass)psiMember).getSupers();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getSupers(...)");
                Object[] $this$any$iv = psiClassArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)$configurationBaseClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                $configurations.add(psiMember);
            }
        }
        return true;
    }

    private static final LightMethodBuilder hasApiVersionInserterConfigured$lambda$0(SpringApiVersioningTestConfigurationInspection this$0, String $builderFqn, PsiClass $psiClass, Module $module) {
        PsiManager psiManager = $psiClass.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        return this$0.getRawParameterMethodSignature($builderFqn, psiManager, $module);
    }

    private static final LightMethodBuilder hasApiVersionInserterConfigured$lambda$1(SpringApiVersioningTestConfigurationInspection this$0, String $customizerFqn, PsiClass $psiClass, Module $module) {
        PsiManager psiManager = $psiClass.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        return this$0.getParameterizedParameterMethodSignature($customizerFqn, psiManager, $module);
    }

    public static final /* synthetic */ boolean access$isApiVersionInserterConfigured(SpringApiVersioningTestConfigurationInspection $this, PsiClass testPsiClass, String customizerFqn, Module module, PsiElement element, String builderFqn) {
        return $this.isApiVersionInserterConfigured(testPsiClass, customizerFqn, module, element, builderFqn);
    }
}

