/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.psi.impl.SqlStatementImpl;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlShowStatementImpl
extends SqlStatementImpl {
    private static final Set<IElementType> DOUBLE_TYPES = Set.of(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_PROCEDURE, MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_GLOBAL, MysqlTypes.MYSQL_SESSION, MysqlTypes.MYSQL_FULL);
    private static final Map<IElementType, IElementType> TYPE_MAPPING = Map.of(MysqlTypes.MYSQL_SCHEMAS, MysqlTypes.MYSQL_DATABASES, MysqlTypes.MYSQL_INDEXES, MysqlTypes.MYSQL_INDEX, MysqlTypes.MYSQL_KEYS, MysqlTypes.MYSQL_INDEX);
    private volatile Pair<IElementType, IElementType> myShowType;

    public MysqlShowStatementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            MysqlShowStatementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myShowType = null;
    }

    @Nullable
    public Pair<IElementType, IElementType> getShowType() {
        IElementType second;
        if (this.myShowType != null) {
            return this.myShowType;
        }
        PsiElement leaf = MysqlShowStatementImpl.getNextLeaf(PsiTreeUtil.getDeepestFirst((PsiElement)this));
        IElementType first2 = MysqlShowStatementImpl.getType(leaf);
        if (first2 != null) {
            first2 = TYPE_MAPPING.getOrDefault(first2, first2);
        }
        IElementType iElementType = second = DOUBLE_TYPES.contains(first2) ? MysqlShowStatementImpl.getType(MysqlShowStatementImpl.getNextLeaf(leaf)) : null;
        if (second != null && first2 == MysqlTypes.MYSQL_GLOBAL || first2 == MysqlTypes.MYSQL_SESSION) {
            first2 = second;
            second = null;
        }
        this.myShowType = Pair.create((Object)first2, (Object)second);
        return this.myShowType;
    }

    @Nullable
    private static IElementType getType(@Nullable PsiElement leaf) {
        ASTNode node = leaf == null ? null : leaf.getNode();
        return node == null ? null : node.getElementType();
    }

    @Nullable
    private static PsiElement getNextLeaf(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return null;
        }
        while ((leaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf)) instanceof PsiComment) {
        }
        return leaf;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/dialects/mysql/psi/MysqlShowStatementImpl", "<init>"));
    }
}

