/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.yaml;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;

class ConfigKeyPathYamlContext
extends ConfigKeyPathContext {
    static final TailType VALUE_TAIL_TYPE = new InsertTailType(){

        public int processTail(@NotNull Editor editor, int tailOffset) {
            if (editor == null) {
                1.$$$reportNull$$$0(0);
            }
            return 1.insertTail(editor, tailOffset, ": ");
        }

        public String toString() {
            return "YAML_VALUE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/microservices/jvm/config/yaml/ConfigKeyPathYamlContext$1", "processTail"));
        }
    };
    private static final TailType SEPARATOR_TAIL_TYPE = new IndentTailType(){

        @Override
        protected String getInsertion(int indent) {
            return ":\n" + StringUtil.repeatSymbol((char)' ', (int)(indent + 2));
        }

        public String toString() {
            return "YAML_SEPARATOR";
        }
    };
    private static final TailType INDEXED_TAIL_TYPE = new IndentTailType(){

        @Override
        protected String getInsertion(int indent) {
            return ":\n" + StringUtil.repeatSymbol((char)' ', (int)(indent + 2)) + "- ";
        }

        public String toString() {
            return "YAML_INDEXED";
        }
    };
    private final YAMLKeyValue myKeyValue;
    private final ConfigKeyPathReference myPrevious;
    private final TextRange myTextRange;

    ConfigKeyPathYamlContext(@NotNull MetaConfigKey key, YAMLKeyValue keyValue, ConfigKeyPathReference previous, @NotNull TextRange textRange) {
        if (key == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(1);
        }
        super(key);
        this.myKeyValue = keyValue;
        this.myPrevious = previous;
        this.myTextRange = textRange;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange.shiftRight(ElementManipulators.getOffsetInElement((PsiElement)this.myKeyValue));
        TextRange textRange2 = ConfigYamlUtils.trimIndexedAccess(textRange, this.myKeyValue);
        if (textRange2 == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(2);
        }
        return textRange2;
    }

    @Override
    @Nullable
    public ConfigKeyPathReference getPrevious() {
        return this.myPrevious;
    }

    @Override
    @NotNull
    public TailType getValueTailType() {
        TailType tailType = VALUE_TAIL_TYPE;
        if (tailType == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(3);
        }
        return tailType;
    }

    @Override
    @NotNull
    public TailType getSeparatorTailType() {
        TailType tailType = SEPARATOR_TAIL_TYPE;
        if (tailType == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(4);
        }
        return tailType;
    }

    @Override
    @NotNull
    public TailType getIndexedTailType(@NotNull Supplier<Boolean> canHaveNext) {
        if (canHaveNext == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(5);
        }
        TailType tailType = INDEXED_TAIL_TYPE;
        if (tailType == null) {
            ConfigKeyPathYamlContext.$$$reportNull$$$0(6);
        }
        return tailType;
    }

    @Override
    @Nullable
    public PsiElement nextMapKeyPart() {
        ConfigKeyPathReference previous = this.getPrevious();
        if (previous == null) {
            return null;
        }
        PsiClass valueClass = ConfigKeyPathUtils.getPsiClass(ConfigKeyPathUtils.unwrapIndexed(previous.getValueType()));
        if (valueClass != null && ConfigKeyPathUtils.stopResolvingProperty(valueClass)) {
            if (this.myKeyValue.equals((Object)previous.getElement())) {
                return this.myKeyValue;
            }
            String prefix = ConfigYamlUtils.getMapKeyPrefix(this);
            if (prefix != null && !StringUtil.startsWithChar((CharSequence)prefix, (char)'[') && !StringUtil.endsWithChar((CharSequence)prefix, (char)']')) {
                return this.myKeyValue;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/yaml/ConfigKeyPathYamlContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canHaveNext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/yaml/ConfigKeyPathYamlContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTailType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorTailType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedTailType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedTailType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static abstract class IndentTailType
    extends InsertTailType {
        private IndentTailType() {
        }

        public int processTail(@NotNull Editor editor, int tailOffset) {
            if (editor == null) {
                IndentTailType.$$$reportNull$$$0(0);
            }
            Project project = Objects.requireNonNull(editor.getProject());
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            int indent = this.getElementIndent(project, document, tailOffset);
            String insertion = this.getInsertion(indent);
            int offset = IndentTailType.insertTail(editor, tailOffset, insertion);
            AutoPopupController.getInstance((Project)Objects.requireNonNull(editor.getProject())).scheduleAutoPopup(editor);
            return offset;
        }

        protected int getElementIndent(Project project, Document document, int tailOffset) {
            PsiFile psiFile = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getPsiFile(document));
            assert (tailOffset > 0);
            PsiElement element = psiFile.findElementAt(tailOffset - 1);
            return element == null ? 0 : YAMLUtil.getIndentToThisElement((PsiElement)element);
        }

        protected abstract String getInsertion(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/microservices/jvm/config/yaml/ConfigKeyPathYamlContext$IndentTailType", "processTail"));
        }
    }

    private static abstract class InsertTailType
    extends TailType {
        private InsertTailType() {
        }

        private static Character getNext(Document document, int offset) {
            if (offset > document.getTextLength() - 1) {
                return null;
            }
            return Character.valueOf(document.getText(TextRange.from((int)offset, (int)1)).charAt(0));
        }

        protected static int insertTail(Editor editor, int tailOffset, String insertion) {
            Document document = editor.getDocument();
            int offset = tailOffset;
            Character next = InsertTailType.getNext(document, tailOffset);
            if (next != null && (next.charValue() == '\'' || next.charValue() == '\"')) {
                ++offset;
            }
            int start = 0;
            while (start < insertion.length() && (next = InsertTailType.getNext(document, offset)) != null && next.charValue() == insertion.charAt(start)) {
                ++start;
                ++offset;
            }
            document.insertString(offset, (CharSequence)insertion.substring(start));
            return InsertTailType.moveCaret((Editor)editor, (int)tailOffset, (int)(offset - tailOffset + insertion.length() - start));
        }
    }
}

