/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.sixrr.xrp.attributetotag.AttributeToTagDialog;
import com.sixrr.xrp.attributetotag.AttributeToTagProcessor;
import com.sixrr.xrp.base.BaseAttributeRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.utils.RefactorXBundle;

class AttributeToTagHandler
extends BaseAttributeRefactoringHandler {
    AttributeToTagHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.attributeToTag";
    }

    @Override
    protected String getRefactoringName() {
        return RefactorXBundle.message("attribute.to.tag", new Object[0]);
    }

    @Override
    protected void handleAttribute(XmlAttribute attribute, Project project) {
        AttributeToTagDialog dialog = new AttributeToTagDialog(attribute);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String tagName = dialog.getTagName();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            AttributeToTagProcessor processor = new AttributeToTagProcessor(attribute, tagName, context);
            processor.setPreviewUsages(previewUsages);
            processor.run();
        }, RefactorXBundle.message("replace.attribute.with.tag", new Object[0]), null);
    }
}

