/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbTextExtensionName;
import com.intellij.protobuf.lang.psi.PbTextFieldName;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.impl.PbTextElementBase;
import com.intellij.protobuf.lang.resolve.PbTextFieldNameReference;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nullable;

abstract class PbTextFieldNameMixin
extends PbTextElementBase
implements PbTextFieldName {
    PbTextFieldNameMixin(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public PbField getDeclaredField() {
        PsiReference ref = this.getEffectiveReference();
        if (ref == null) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PbField)) {
            return null;
        }
        return (PbField)resolved;
    }

    @Override
    @Nullable
    public PbNamedTypeElement getDeclaredNamedType() {
        PsiReference ref = null;
        PbTextExtensionName extensionName = this.getExtensionName();
        if (extensionName != null && extensionName.isAnyTypeUrl()) {
            ref = extensionName.getEffectiveReference();
        } else {
            PbTypeName typeName;
            PbField field = this.getDeclaredField();
            if (field != null && (typeName = field.getTypeName()) != null) {
                ref = typeName.getEffectiveReference();
            }
        }
        if (ref == null) {
            return null;
        }
        PsiElement refElement = ref.resolve();
        if (!(refElement instanceof PbNamedTypeElement)) {
            return null;
        }
        return (PbNamedTypeElement)refElement;
    }

    @Override
    @Nullable
    public BuiltInType getDeclaredBuiltInType() {
        PbField field = this.getDeclaredField();
        if (field == null) {
            return null;
        }
        PbTypeName typeName = field.getTypeName();
        if (typeName == null) {
            return null;
        }
        return typeName.getBuiltInType();
    }

    public PsiReference getReference() {
        if (this.getExtensionName() != null) {
            return null;
        }
        return new PbTextFieldNameReference(this);
    }

    @Override
    @Nullable
    public PsiReference getEffectiveReference() {
        PbTextExtensionName extensionName = this.getExtensionName();
        if (extensionName != null) {
            if (extensionName.isAnyTypeUrl()) {
                return null;
            }
            return extensionName.getEffectiveReference();
        }
        return new PbTextFieldNameReference(this);
    }
}

