<?php
/**
 * @license GPL-2.0-or-later
 * @file
 * @ingroup Maintenance
 * @defgroup Maintenance Maintenance
 */

/**
 * @defgroup MaintenanceArchive Maintenance archives
 * @ingroup Maintenance
 */

if ( !defined( 'RUN_MAINTENANCE_IF_MAIN' ) ) {
	// Define this so scripts can easily find doMaintenance.php
	define( 'RUN_MAINTENANCE_IF_MAIN', __DIR__ . '/doMaintenance.php' );

	// Original name for compat, harmless
	// Support: MediaWiki < 1.31
	define( 'DO_MAINTENANCE', RUN_MAINTENANCE_IF_MAIN );
}

if ( defined( 'MEDIAWIKI' ) ) {
	// This file is included by many autoloaded class files, and so may
	// potentially be invoked in the context of a web request or another CLI
	// script. It's not appropriate to run the following file-scope code in
	// such a case.
	return;
}

// Abort if called from a web server
// wfIsCLI() is not available yet
if ( PHP_SAPI !== 'cli' && PHP_SAPI !== 'phpdbg' ) {
	echo "This script must be run from the command line\n";
	exit( 1 );
}

define( 'MW_ENTRY_POINT', 'cli' );

// Bail on old versions of PHP, or if composer has not been run yet to install
// dependencies.
require_once __DIR__ . '/../includes/BootstrapHelperFunctions.php';
require_once __DIR__ . '/../includes/PHPVersionCheck.php';
wfEntryPointCheck( 'text' );

/**
 * @var string|false $maintClass
 * @phan-var class-string|false
 */
$maintClass = false;

// Some extensions rely on MW_INSTALL_PATH to find core files to include. Setting it here helps them
// if they're included by a core script (like DatabaseUpdater) after Maintenance.php has already
// been run.
if ( strval( getenv( 'MW_INSTALL_PATH' ) ) === '' ) {
	putenv( 'MW_INSTALL_PATH=' . realpath( __DIR__ . '/..' ) );
}

require_once __DIR__ . '/includes/Maintenance.php';
require_once __DIR__ . '/includes/LoggedUpdateMaintenance.php';
require_once __DIR__ . '/includes/FakeMaintenance.php';
