-- Tests for the mw.svg module

local testframework = require 'Module:TestFramework'

local function testSvgToString()
	local svg = mw.svg.new()
	svg:setContent('<path d="M10.5 5h6.505C18.107 5 19 5.896 19 6.997V14h-7v2h5.005c1.102 0 1.995.888 1.995 2v2H1v-2c0-1.105.893-2 1.995-2H8v-2H1V6.997C1 5.894 1.893 5 2.995 5H9.5V2.915a1.5 1.5 0 1 1 1 0zm-4 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m7 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"/>')
	svg:setAttribute('width', '20px')
	svg:setAttribute('test-special-chars', '<>&\'"')
	return svg:toString()
end

local function testSvgToImage()
	local svg = mw.svg.new()
	svg:setContent('<path d="M10.5 5h6.505C18.107 5 19 5.896 19 6.997V14h-7v2h5.005c1.102 0 1.995.888 1.995 2v2H1v-2c0-1.105.893-2 1.995-2H8v-2H1V6.997C1 5.894 1.893 5 2.995 5H9.5V2.915a1.5 1.5 0 1 1 1 0zm-4 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m7 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"/>')
	svg:setAttribute('width', '20px')
	svg:setAttribute('height', '20px')
	svg:setImgAttribute('width', '20px')
	return mw.text.killMarkers(svg:toImage())
end

-- Tests
local tests = {
	{
		name = 'mw.svg toString',
		func = testSvgToString,
		expect = { '<svg xmlns="http://www.w3.org/2000/svg" test-special-chars="&lt;&gt;&amp;\'&quot;" width="20px"><path d="M10.5 5h6.505C18.107 5 19 5.896 19 6.997V14h-7v2h5.005c1.102 0 1.995.888 1.995 2v2H1v-2c0-1.105.893-2 1.995-2H8v-2H1V6.997C1 5.894 1.893 5 2.995 5H9.5V2.915a1.5 1.5 0 1 1 1 0zm-4 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m7 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"/></svg>' }
	},
	{
		-- Verify toImage() returns a strip item
		name = 'mw.svg toImage',
		func = testSvgToImage,
		expect = { '' }
	}
}

return testframework.getTestProvider( tests )
