/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRuntime;
import java.awt.Point;

public class NSMutablePoint
extends NSPoint {
    private int _backingPoint = 0;
    private boolean _freePoint = true;

    public NSMutablePoint() {
        this(0.0f, 0.0f);
    }

    public NSMutablePoint(float f, float f2) {
        this._backingPoint = this.privateCreateBackingPoint();
        this.setX(f);
        this.setY(f2);
    }

    public NSMutablePoint(NSPoint nSPoint) {
        this(nSPoint.x(), nSPoint.y());
    }

    public NSMutablePoint(Point point) {
        this(point.x, point.y);
    }

    private NSMutablePoint(int n) {
        this._backingPoint = n;
        this._freePoint = false;
    }

    protected void finalize() {
        if (this._freePoint && this._backingPoint != 0) {
            this.privateDestroyBackingPoint(this._backingPoint);
        }
    }

    public float x() {
        return this.privateX(this._backingPoint);
    }

    public float y() {
        return this.privateY(this._backingPoint);
    }

    public void setX(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN x");
        }
        this.privateSetX(this._backingPoint, f);
    }

    public void setY(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN y");
        }
        this.privateSetY(this._backingPoint, f);
    }

    public Object clone() {
        return new NSMutablePoint(this);
    }

    private native int privateCreateBackingPoint();

    private native void privateDestroyBackingPoint(int var1);

    private native float privateX(int var1);

    private native float privateY(int var1);

    private native void privateSetX(int var1, float var2);

    private native void privateSetY(int var1, float var2);

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
    }
}

