/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class JdbcConsoleAuditor
implements DataAuditor {
    private final JdbcConsole myConsole;

    public JdbcConsoleAuditor(@NotNull JdbcConsole console) {
        if (console == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(0);
        }
        this.myConsole = console;
    }

    public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
        if (request2 == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(2);
        }
        this.updateFilePresentation();
    }

    public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
        if (request2 == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(3);
        }
        if (producer == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(4);
        }
        this.updateFilePresentation();
    }

    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(5);
        }
        this.myConsole.updateConsoleOnRequestStarted(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onStarted();
        }
    }

    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(6);
        }
        this.myConsole.updateConsoleOnRequestFinished(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onFinished();
        }
    }

    public void txCompleted(@NotNull DataRequest.Context context, @NotNull DataAuditor.TxEvent event) {
        if (context == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(7);
        }
        if (event == null) {
            JdbcConsoleAuditor.$$$reportNull$$$0(8);
        }
        this.myConsole.updateConsoleOnTxCompleted(event.completed);
    }

    private void updateFilePresentation() {
        DbUIUtil.invokeLaterIfNeeded(() -> {
            Project project = this.myConsole.getProject();
            if (!project.isDisposed()) {
                FileEditorManagerEx.getInstanceEx((Project)project).updateFilePresentation(this.myConsole.getVirtualFile());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/audit/JdbcConsoleAuditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "jobSubmitted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "jobFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStarted";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "txCompleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

