/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.ChangeCellTypeActionGroupKt;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/run/actions/ChangeCellTypeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/data/types/domain/Domain;)V", "getDomain", "()Lcom/intellij/database/data/types/domain/Domain;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.database.impl"})
public final class ChangeCellTypeAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final Domain domain;

    public ChangeCellTypeAction(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this.grid = grid;
        this.domain = domain;
    }

    @NotNull
    public final Domain getDomain() {
        return this.domain;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(this.domain.simpleName());
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex row = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex column2 = modelIndex2;
        return StringUtil.equalsIgnoreCase((CharSequence)this.domain.simpleName(), (CharSequence)GridCellEditorsUtil.guessTypeNameForEditing((CoreGrid)((CoreGrid)this.grid), (ModelIndex)row, (ModelIndex)column2));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ModelIndexSet modelIndexSet = this.grid.getSelectionModel().getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndexSet, (String)"getSelectedRows(...)");
        ModelIndexSet rows = modelIndexSet;
        ModelIndexSet modelIndexSet2 = this.grid.getSelectionModel().getSelectedColumns();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndexSet2, (String)"getSelectedColumns(...)");
        ModelIndexSet columns = modelIndexSet2;
        if (rows.asIterable().isEmpty() || columns.asIterable().isEmpty()) {
            return;
        }
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex editedRow = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex editedColumn = modelIndex2;
        ChangeCellTypeActionGroupKt.access$changeCellType(this.grid, rows, columns, this.domain, editedRow, editedColumn);
    }
}

