/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.SearchableTargetsSearchResult;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001aF\u0010\u0013\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0002`\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b\u001aH\u0010\u0019\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0002`\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001aH\u0010\u001a\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fj\u0002`\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002*:\u0010\u000e\"\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f2\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u00a8\u0006\u001b"}, d2={"getQueryForFirstNElements", "", "elements", "", "Lcom/intellij/database/psi/DbTable;", "maxElementsCount", "", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "tryFindSearchableTargets", "Lcom/intellij/database/fulltextsearch/SearchableTargetsSearchResult;", "targets", "", "perTargetCheckAtMost", "FtsElement", "Lkotlin/Triple;", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "Lcom/intellij/database/model/basic/BasicTableOrView;", "Lcom/intellij/database/psi/DbElement;", "chooseElementsIterator", "Lkotlin/sequences/Sequence;", "Lcom/intellij/database/fulltextsearch/FtsElement;", "tables", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "byTable", "byColumn", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nftsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ftsUtil.kt\ncom/intellij/database/fulltextsearch/FtsUtilKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n97#2,5:105\n1#3:110\n*S KotlinDebug\n*F\n+ 1 ftsUtil.kt\ncom/intellij/database/fulltextsearch/FtsUtilKt\n*L\n85#1:105,5\n*E\n"})
public final class FtsUtilKt {
    @NotNull
    public static final String getQueryForFirstNElements(@NotNull List<? extends DbTable> elements, int maxElementsCount, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        DbDataSource dbDataSource = ((DbTable)CollectionsKt.first(elements)).getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource dataSource = dbDataSource;
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((Dbms)dataSource.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx dialect = databaseDialectEx;
        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(dialect).qualifyReferences(true);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"qualifyReferences(...)");
        DdlBuilder builder = ddlBuilder;
        int count = 0;
        List<FullTextSearchAction.SearchGroup> groups = new FullTextSearchAction.TableGrouper((Collection<? extends DbTable>)elements).getGroups();
        Iterator<FullTextSearchAction.SearchGroup> iterator = groups.iterator();
        while (iterator.hasNext()) {
            Set<BasicTableOrView> tables = iterator.next().component1();
            for (Triple triple : FtsUtilKt.chooseElementsIterator((Collection<? extends BasicTableOrView>)tables, dataSource, options)) {
                List predicates = (List)triple.component1();
                BasicTableOrView table = (BasicTableOrView)triple.component2();
                if (predicates.isEmpty()) continue;
                FullTextSearchAction.Companion.searchStatement(builder, table, dataSource, options, predicates, true);
                builder.newStatement().newLine();
                if (++count < maxElementsCount) continue;
                Object[] objectArray = new Object[]{maxElementsCount};
                String comment = "-- " + DatabaseBundle.message((String)"full.text.search.first.N.queries", (Object[])objectArray);
                return comment + "\n\n" + builder.getStatement() + "\n" + comment;
            }
        }
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        return string;
    }

    @NotNull
    public static final SearchableTargetsSearchResult tryFindSearchableTargets(@NotNull Collection<? extends DbTable> targets, int perTargetCheckAtMost, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        boolean someTablesAreSkipped = false;
        block0: for (DbTable dbTable : targets) {
            int count = 0;
            List<FullTextSearchAction.SearchGroup> groups = new FullTextSearchAction.TableGrouper(CollectionsKt.listOf((Object)dbTable)).getGroups();
            Iterator<FullTextSearchAction.SearchGroup> iterator = groups.iterator();
            while (iterator.hasNext()) {
                Set<BasicTableOrView> tables = iterator.next().component1();
                Collection collection = tables;
                DbDataSource dbDataSource = dbTable.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
                Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> it = FtsUtilKt.chooseElementsIterator(collection, dbDataSource, options);
                Iterator iterator2 = it.iterator();
                while (iterator2.hasNext()) {
                    List predicates = (List)((Triple)iterator2.next()).component1();
                    if (!((Collection)predicates).isEmpty()) {
                        return SearchableTargetsSearchResult.FOUND;
                    }
                    if (++count < perTargetCheckAtMost) continue;
                    someTablesAreSkipped = true;
                    continue block0;
                }
            }
        }
        return someTablesAreSkipped ? SearchableTargetsSearchResult.UNKNOWN : SearchableTargetsSearchResult.NOT_FOUND;
    }

    @NotNull
    public static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> chooseElementsIterator(@NotNull Collection<? extends BasicTableOrView> tables, @NotNull DbDataSource dataSource, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return Intrinsics.areEqual((Object)dataSource.getDbms(), (Object)Dbms.CASSANDRA) ? FtsUtilKt.byColumn(tables, dataSource, options) : FtsUtilKt.byTable(tables, dataSource, options);
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byTable(Collection<? extends BasicTableOrView> tables, DbDataSource dataSource, FullTextSearchOptions options) {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)tables), arg_0 -> FtsUtilKt.byTable$lambda$1(dataSource, options, arg_0));
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byColumn(Collection<? extends BasicTableOrView> tables, DbDataSource dataSource, FullTextSearchOptions options) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)tables), arg_0 -> FtsUtilKt.byColumn$lambda$5(dataSource, options, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Triple byTable$lambda$1(DbDataSource $dataSource, FullTextSearchOptions $options, BasicTableOrView table) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Dbms dbms = $dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> predicates = FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, $dataSource.getVersion(), table, $options);
        Object object = DbImplUtilCore.findElement((DbDataSource)$dataSource, (DasObject)((DasObject)table));
        DbTableImpl dbTableImpl = object instanceof DbTableImpl ? (DbTableImpl)((Object)object) : null;
        if (dbTableImpl == null) {
            return null;
        }
        DbTableImpl dbElement = dbTableImpl;
        object = predicates;
        Collection collection = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        List uniquePredicates = (List)destination$iv;
        ContainerUtil.removeDuplicates((Collection)uniquePredicates);
        return new Triple((Object)uniquePredicates, (Object)table, (Object)dbElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Triple byColumn$lambda$5$lambda$4(DbDataSource $dataSource, BasicTableOrView $table, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ColumnRef column2 = (ColumnRef)entry.getKey();
        List predicates = (List)entry.getValue();
        if (!(column2 instanceof DasColumnRef)) return null;
        DasColumnRef dasColumnRef = (DasColumnRef)column2;
        DasColumnRef dasColumnRef2 = dasColumnRef;
        if (dasColumnRef2 == null) return null;
        DasColumnRef it = dasColumnRef2;
        boolean bl = false;
        DbElement dbElement = DbImplUtilCore.findElement((DbDataSource)$dataSource, (DasObject)((DasObject)((DasColumnRef)column2).getCol()));
        if (!(dbElement instanceof DbColumn)) return null;
        DbColumn dbColumn = (DbColumn)dbElement;
        DbColumn dbColumn2 = dbColumn;
        if (dbColumn2 == null) return null;
        it = dbColumn2;
        boolean bl2 = false;
        Triple triple = new Triple((Object)predicates, (Object)$table, (Object)it);
        return triple;
    }

    private static final Sequence byColumn$lambda$5(DbDataSource $dataSource, FullTextSearchOptions $options, BasicTableOrView table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Dbms dbms = $dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, $dataSource.getVersion(), table, $options)), arg_0 -> FtsUtilKt.byColumn$lambda$5$lambda$4($dataSource, table, arg_0));
    }
}

