/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.BreaksHelperBase;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DummyBreaksFormatterKt;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.LinearBreaksHelper;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.MultiFormatter;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.NumericBreakFormatter;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log10Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SymlogTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NonlinearBreaksHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "targetCount", "", "providedFormatter", "Lkotlin/Function1;", "", "", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "niceLogBreaks", "", "(DDILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;Z)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "Companion", "plot-base"})
public final class NonlinearBreaksHelper
extends BreaksHelperBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;
    private static final int MIN_BREAKS_COUNT = 3;

    public NonlinearBreaksHelper(double rangeStart, double rangeEnd, int targetCount, @Nullable Function1<Object, String> providedFormatter, @NotNull StringFormat.ExponentFormat expFormat, @NotNull ContinuousTransform transform2, boolean niceLogBreaks) {
        ContinuousTransform continuousTransform;
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        super(rangeStart, rangeEnd, targetCount);
        this.providedFormatter = providedFormatter;
        DoubleSpan domain = new DoubleSpan(rangeStart, rangeEnd);
        DoubleSpan transformedDomain = ScaleUtil.INSTANCE.applyTransform(domain, transform2);
        int targetCount2 = niceLogBreaks ? (((continuousTransform = transform2) instanceof Log10Transform ? true : continuousTransform instanceof SymlogTransform) ? NonlinearBreaksHelper.Companion.recalculateBreaksCount(targetCount, transformedDomain) : targetCount) : targetCount;
        List<Double> transformedBreakValues = new LinearBreaksHelper(transformedDomain.getLowerEnd(), transformedDomain.getUpperEnd(), targetCount2, DummyBreaksFormatterKt.getDUMMY_FORMATTER(), expFormat, false, 32, null).getBreaks();
        this.breaks = CollectionsKt.filterNotNull((Iterable)transform2.applyInverse(transformedBreakValues));
        NonlinearBreaksHelper nonlinearBreaksHelper = this;
        Function1 function1 = this.providedFormatter;
        if (function1 == null) {
            NonlinearBreaksHelper nonlinearBreaksHelper2 = this;
            NonlinearBreaksHelper nonlinearBreaksHelper3 = nonlinearBreaksHelper;
            boolean bl = false;
            List breakFormatters = NonlinearBreaksHelper.Companion.createFormatters(this.getBreaks(), expFormat);
            nonlinearBreaksHelper = nonlinearBreaksHelper3;
            function1 = (Function1)((KFunction)new Function1<Object, String>((Object)new MultiFormatter(this.getBreaks(), breakFormatters)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((MultiFormatter)this.receiver).apply(p0);
                }
            });
        }
        nonlinearBreaksHelper.formatter = function1;
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NonlinearBreaksHelper$Companion;", "", "()V", "MIN_BREAKS_COUNT", "", "createFormatter", "Lkotlin/Function1;", "", "domainValue", "", "step", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "createFormatters", "", "breakValues", "recalculateBreaksCount", "breaksCount", "transformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nNonlinearBreaksHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonlinearBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/NonlinearBreaksHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1559#2:124\n1590#2,4:125\n*S KotlinDebug\n*F\n+ 1 NonlinearBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/NonlinearBreaksHelper$Companion\n*L\n99#1:124\n99#1:125,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int recalculateBreaksCount(int breaksCount, DoubleSpan transformedDomain) {
            int recalculatedBreaksCount = MathKt.roundToInt((double)(Math.floor(transformedDomain.getUpperEnd()) - Math.ceil(transformedDomain.getLowerEnd()))) + 1;
            return (3 <= recalculatedBreaksCount ? recalculatedBreaksCount <= breaksCount : false) ? recalculatedBreaksCount : breaksCount;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Function1<Object, String>> createFormatters(List<Double> breakValues, StringFormat.ExponentFormat expFormat) {
            void $this$mapIndexedTo$iv$iv;
            if (breakValues.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            if (breakValues.size() == 1) {
                double domainValue = ((Number)breakValues.get(0)).doubleValue();
                double step2 = domainValue / (double)10;
                return CollectionsKt.listOf(this.createFormatter(domainValue, step2, expFormat));
            }
            Iterable $this$mapIndexed$iv = breakValues;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void currValue;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d = ((Number)item$iv$iv).doubleValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double step3 = Math.abs((double)(i == false ? currValue - ((Number)breakValues.get((int)(i + true))).doubleValue() : currValue - ((Number)breakValues.get((int)(i - true))).doubleValue()));
                collection.add(Companion.createFormatter((double)currValue, step3, expFormat));
            }
            List formatters = (List)destination$iv$iv;
            return formatters;
        }

        private final Function1<Object, String> createFormatter(double domainValue, double step2, StringFormat.ExponentFormat expFormat) {
            return (Function1)new Function1<Object, String>((Object)new NumericBreakFormatter(domainValue, step2, expFormat)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((NumericBreakFormatter)this.receiver).apply(p0);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

