/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.render.text.RichText;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0014J\u0006\u0010\u001d\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u0003J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000bJ\u0010\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u0003J\u0010\u0010%\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u0003J\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u000bJ\u0015\u0010+\u001a\u00020\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0015J\u000e\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u000bJ\u000e\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u000bJ\u000e\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001304J\b\u00105\u001a\u00020\u001aH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "text", "", "wrapWidth", "", "markdown", "", "(Ljava/lang/String;IZ)V", "myFontFamily", "myFontSize", "", "myFontStyle", "myFontWeight", "myLineHeight", "myLines", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement;", "myTextColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "myVerticalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "getText", "()Ljava/lang/String;", "yStart", "addClassName", "", "className", "buildComponent", "linesCount", "repositionLines", "setFontFamily", "fontFamily", "setFontSize", "px", "setFontStyle", "cssName", "setFontWeight", "setHorizontalAnchor", "anchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "setLineHeight", "v", "setTextOpacity", "value", "(Ljava/lang/Double;)V", "setVerticalAnchor", "setX", "x", "setY", "y", "textColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "updateStyleAttribute", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMultilineLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n1855#2,2:153\n1855#2,2:155\n1855#2,2:157\n1855#2,2:159\n1855#2,2:161\n1855#2,2:163\n1864#2,3:165\n*S KotlinDebug\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel\n*L\n35#1:151,2\n42#1:153,2\n59#1:155,2\n66#1:157,2\n102#1:159,2\n113#1:161,2\n117#1:163,2\n140#1:165,3\n*E\n"})
public final class MultilineLabel
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<SvgTextElement> myLines;
    @Nullable
    private Color myTextColor;
    private double myFontSize;
    @Nullable
    private String myFontWeight;
    @Nullable
    private String myFontFamily;
    @Nullable
    private String myFontStyle;
    private double myLineHeight;
    @Nullable
    private Text.VerticalAnchor myVerticalAnchor;
    private double yStart;

    /*
     * WARNING - void declaration
     */
    public MultilineLabel(@NotNull String text2, int wrapWidth, boolean markdown) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        this.myLines = RichText.toSvg$default(RichText.INSTANCE, this.text, wrapWidth, 0, markdown, 4, null);
        Iterable iterable = this.myLines;
        ObservableList<SvgNode> observableList = this.getRootGroup().children();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode p0 = (SvgNode)element$iv;
            boolean bl = false;
            observableList.add(p0);
        }
    }

    public /* synthetic */ MultilineLabel(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(string, n, bl);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    protected void buildComponent() {
    }

    @Override
    public void addClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.addClass(className);
        }
    }

    @NotNull
    public final WritableProperty<Color> textColor() {
        return new WritableProperty<Color>(this){
            final /* synthetic */ MultilineLabel this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@Nullable Color value) {
                Iterable $this$forEach$iv = MultilineLabel.access$getMyLines$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SvgTextElement p0 = (SvgTextElement)element$iv;
                    boolean bl = false;
                    p0.fillColor();
                }
                MultilineLabel.access$setMyTextColor$p(this.this$0, value);
                MultilineLabel.access$updateStyleAttribute(this.this$0);
            }
        };
    }

    public final void setHorizontalAnchor(@NotNull Text.HorizontalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.setAttribute("text-anchor", Text.INSTANCE.toTextAnchor$plot_base(anchor));
        }
    }

    public final void setVerticalAnchor(@NotNull Text.VerticalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        this.myVerticalAnchor = anchor;
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.setAttribute("dy", Text.INSTANCE.toDY$plot_base(anchor));
        }
        this.repositionLines();
    }

    public final void setFontSize(double px) {
        this.myFontSize = px;
        this.updateStyleAttribute();
    }

    public final void setFontWeight(@Nullable String cssName) {
        this.myFontWeight = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontStyle(@Nullable String cssName) {
        this.myFontStyle = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontFamily(@Nullable String fontFamily) {
        this.myFontFamily = fontFamily;
        this.updateStyleAttribute();
    }

    public final void setTextOpacity(@Nullable Double value) {
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.fillOpacity().set(value);
        }
    }

    private final void updateStyleAttribute() {
        String styleAttr = Text.INSTANCE.buildStyle$plot_base(this.myTextColor, this.myFontSize, this.myFontWeight, this.myFontFamily, this.myFontStyle);
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.setAttribute("style", styleAttr);
        }
    }

    public final void setX(double x2) {
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.x().set(x2);
        }
    }

    public final void setY(double y2) {
        this.yStart = y2;
        this.repositionLines();
    }

    public final void setLineHeight(double v) {
        this.myLineHeight = v;
        this.repositionLines();
    }

    /*
     * WARNING - void declaration
     */
    private final void repositionLines() {
        double d;
        double totalHeightShift = this.myLineHeight * (double)(this.myLines.size() - 1);
        Text.VerticalAnchor verticalAnchor = this.myVerticalAnchor;
        switch (verticalAnchor == null ? -1 : WhenMappings.$EnumSwitchMapping$0[verticalAnchor.ordinal()]) {
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = totalHeightShift / (double)2;
                break;
            }
            case 3: {
                d = totalHeightShift;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double adjustedYStart = this.yStart - d;
        Iterable $this$forEachIndexed$iv = this.myLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elem;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SvgTextElement svgTextElement = (SvgTextElement)item$iv;
            int index = n;
            boolean bl = false;
            elem.y().set(adjustedYStart + this.myLineHeight * (double)index);
        }
    }

    public final int linesCount() {
        return this.myLines.size();
    }

    public static final /* synthetic */ List access$getMyLines$p(MultilineLabel $this) {
        return $this.myLines;
    }

    public static final /* synthetic */ void access$setMyTextColor$p(MultilineLabel $this, Color color) {
        $this.myTextColor = color;
    }

    public static final /* synthetic */ void access$updateStyleAttribute(MultilineLabel $this) {
        $this.updateStyleAttribute();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion;", "", "()V", "splitLines", "", "", "text", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nMultilineLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1549#2:151\n1620#2,3:152\n*S KotlinDebug\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion\n*L\n148#1:151\n148#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> splitLines(@NotNull String text2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            char[] cArray = new char[]{'\n'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

