/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.psi.Jinja2StringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoUnresolvedReferenceInspection;
import com.intellij.template.lang.core.templateLanguages.TemplateFileReference;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class DjangoTemplateUnresolvedReferenceInspection
extends DjangoUnresolvedReferenceInspection {
    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedTemplateReferenceInspection";
    }

    @Override
    protected DjangoInspectionVisitorAdapter createVisitor(InspectionManager manager) {
        return new UnresolvedTemplateReferenceVisitor(manager);
    }

    private static final class UnresolvedTemplateReferenceVisitor
    extends DjangoInspectionVisitorAdapter {
        private UnresolvedTemplateReferenceVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                UnresolvedTemplateReferenceVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        public void visitStringLiteral(Jinja2StringLiteral stringLiteral) {
            PsiReference[] references;
            super.visitStringLiteral(stringLiteral);
            for (PsiReference ref : references = stringLiteral.getReferences()) {
                if (!(ref instanceof TemplateFileReference) || ref.isSoft() || UnresolvedTemplateReferenceVisitor.isResolved(ref)) continue;
                this.reportUnresolvedTemplateReference(ref, stringLiteral);
            }
        }

        private static boolean isResolved(@NotNull PsiReference ref) {
            if (ref == null) {
                UnresolvedTemplateReferenceVisitor.$$$reportNull$$$0(1);
            }
            if (ref.resolve() != null) {
                return true;
            }
            if (ref instanceof PsiPolyVariantReference) {
                return ((PsiPolyVariantReference)ref).multiResolve(false).length != 0;
            }
            return false;
        }

        private void reportUnresolvedTemplateReference(PsiReference ref, Jinja2StringLiteral stringLiteral) {
            this.reportProblem(ref, (PsiElement)stringLiteral, DjangoBundle.message((String)"inspection.unresolved-template-reference.error-msg", (Object[])new Object[]{stringLiteral.getText()}));
        }

        private void reportProblem(PsiReference ref, PsiElement elem, @InspectionMessage String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, ref.getRangeInElement(), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getQuickFixActions(ref));
            this.myProblems.add(d);
        }

        public LocalQuickFix[] getQuickFixActions(PsiReference reference) {
            ArrayList actions2 = new ArrayList();
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, actions2);
            }
            return actions2.toArray(LocalQuickFix.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/lang/template/inspection/DjangoTemplateUnresolvedReferenceInspection$UnresolvedTemplateReferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isResolved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

