/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSCustomExtractInterfaceHandler;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConvertAliasToInterfaceIntention
extends JavaScriptIntention
implements JSCustomExtractInterfaceHandler {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        TypeScriptTypeAlias alias;
        if (project == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(1);
        }
        if ((alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element2)) == null) {
            return;
        }
        TypeScriptType declaration = alias.getTypeDeclaration();
        if (!(declaration instanceof TypeScriptObjectType)) {
            return;
        }
        String aliasName = alias.getName();
        if (aliasName == null) {
            return;
        }
        ASTNode aliasNode = alias.getNode();
        TypeScriptTypeParameterList typeParams = alias.getTypeParameterList();
        String typeParamText = typeParams == null ? "" : typeParams.getText();
        ASTNode interfaceNode = JSChangeUtil.createStatementFromTextWithContext("interface " + aliasName + typeParamText + " {}", element2);
        assert (interfaceNode != null);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(JSStubElementTypes.ATTRIBUTE_LISTS, aliasNode, interfaceNode);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(TypeScriptStubElementTypes.OBJECT_TYPE, aliasNode, interfaceNode);
        aliasNode.getTreeParent().replaceChild(aliasNode, interfaceNode);
        CodeStyleManager.getInstance((Project)project).reformat(interfaceNode.getPsi(TypeScriptInterface.class));
    }

    static void findChildAndReplace(@NotNull TokenSet set, @NotNull ASTNode current, @NotNull ASTNode newElement) {
        if (set == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(2);
        }
        if (current == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(3);
        }
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(4);
        }
        ASTNode aliasAttributeList = current.findChildByType(set);
        ASTNode interfaceAttributeList = newElement.findChildByType(set);
        TypeScriptConvertAliasToInterfaceIntention.replaceNodes(newElement, aliasAttributeList, interfaceAttributeList);
    }

    private static void findChildAndReplace(@NotNull IElementType element2, @NotNull ASTNode current, @NotNull ASTNode newElement) {
        if (element2 == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(5);
        }
        if (current == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(6);
        }
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(7);
        }
        ASTNode aliasAttributeList = current.findChildByType(element2);
        ASTNode interfaceAttributeList = newElement.findChildByType(element2);
        TypeScriptConvertAliasToInterfaceIntention.replaceNodes(newElement, aliasAttributeList, interfaceAttributeList);
    }

    private static void replaceNodes(@NotNull ASTNode newElement, ASTNode newNode, ASTNode oldNode) {
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(8);
        }
        if (newNode != null && oldNode != null) {
            newElement.replaceChild(oldNode, newNode.copyElement());
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(10);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        PsiFile file = element2.getContainingFile();
        if (!(file instanceof JSFile) || !DialectDetector.isTypeScript(element2)) {
            return false;
        }
        TypeScriptTypeAlias alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element2);
        return alias != null && alias.getTypeDeclaration() instanceof TypeScriptObjectType;
    }

    @Nullable
    static TypeScriptTypeAlias getAlias(@NotNull PsiElement element2) {
        TypeScriptTypeAlias alias;
        if (element2 == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(11);
        }
        if ((alias = (TypeScriptTypeAlias)PsiTreeUtil.getParentOfType((PsiElement)element2, TypeScriptTypeAlias.class)) == null) {
            return null;
        }
        TypeScriptType declaration = alias.getTypeDeclaration();
        if (declaration == null || PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)element2, (boolean)true)) {
            return null;
        }
        return alias;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.interface.action.family.name", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.interface.action.title", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean isAvailableOnEditorAndFile(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(14);
        }
        if (file == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(15);
        }
        return this.isAvailable(file.getProject(), editor, file);
    }

    @Override
    public void invoke(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(16);
        }
        if (file == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(17);
        }
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)JavaScriptBundle.message("extract.interface.command.name", new Object[0]), null, () -> this.invoke(file.getProject(), editor, file), (PsiFile[])new PsiFile[]{file});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToInterfaceIntention";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToInterfaceIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildAndReplace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceNodes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnEditorAndFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }
}

