/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NotImplementedError;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMismatchedCollectionQueryUpdateInspectionBase
extends JSInspection {
    protected final List<String> myUpdateNames = new ArrayList<String>();
    @NonNls
    public String queries = "trace,write,forEach,length,size";
    @NonNls
    public String updates = "pop,push,shift,splice,unshift,add,insert,remove,reverse,copyWithin,fill,sort";

    public JSMismatchedCollectionQueryUpdateInspectionBase() {
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    protected static void parseString(String string, Collection<? super String> out) {
        out.clear();
        out.addAll(StringUtil.split((String)string, (String)","));
    }

    private static String formatString(Collection<String> strings) {
        int size = strings.size();
        if (size > 0) {
            StringBuilder out = new StringBuilder();
            for (String s : strings) {
                out.append(s).append(',');
            }
            return out.substring(0, out.length() - 1);
        }
        return "";
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(1);
        }
        this.updates = JSMismatchedCollectionQueryUpdateInspectionBase.formatString(this.myUpdateNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(3);
        }
        return new MismatchedCollectionQueryUpdateVisitor(holder);
    }

    protected boolean isQuery(@NotNull JSReferenceExpression ref2) {
        if (ref2 == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(4);
        }
        JSElvisOwner callExpression = null;
        PsiElement parent = ref2.getParent();
        if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == ref2) {
            callExpression = (JSCallExpression)parent;
        }
        if (!((callExpression != null ? callExpression : ref2).getParent() instanceof JSExpressionStatement)) {
            return true;
        }
        String functionName = ref2.getReferenceName();
        if (functionName == null || this.myUpdateNames.contains(functionName)) {
            return false;
        }
        if (callExpression != null) {
            JSExpression[] arguments;
            for (JSExpression argument : arguments = callExpression.getArguments()) {
                if (!(argument instanceof JSFunction)) continue;
                return true;
            }
            PsiElement resolve2 = ref2.resolve();
            if (!JSCorePredefinedLibrariesProvider.isLibraryElement(resolve2)) {
                return true;
            }
            if (resolve2 instanceof JSFunctionItem) {
                JSParameterItem[] parameters2 = ((JSFunctionItem)resolve2).getParameters();
                for (int i = 0; i < parameters2.length && i <= arguments.length; ++i) {
                    JSParameterItem parameter = parameters2[i];
                    JSType type2 = parameter.getSimpleType();
                    if (!(type2 instanceof JSFunctionType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isUpdateName(@NotNull JSReferenceExpression usage) {
        String functionName;
        if (usage == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(5);
        }
        return (functionName = usage.getReferenceName()) != null && this.myUpdateNames.contains(functionName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isQuery";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpdateName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends JSElementVisitor {
        private final ProblemsHolder myHolder;
        private JSType myType;

        MismatchedCollectionQueryUpdateVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
            if (varStatement == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSVarStatement(varStatement);
            PsiElement nearestParent = varStatement.getParent();
            if (nearestParent instanceof JSForInStatement && ((JSForInStatement)nearestParent).getVarDeclaration() == varStatement) {
                return;
            }
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)varStatement, () -> {
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)nearestParent, JSBlockStatement.class, (boolean)false);
                if (parent == null && !((parent = varStatement.getParent()) instanceof JSClass)) {
                    return;
                }
                for (JSVariable variable : varStatement.getVariables()) {
                    this.process(variable, (JSElement)parent);
                }
            });
        }

        private void process(@NotNull JSVariable variable, @NotNull JSElement parent) {
            JSAttributeList attributeList;
            if (variable == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(2);
            }
            if (parent instanceof JSClass && ((attributeList = variable.getAttributeList()) == null || attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE)) {
                return;
            }
            if (!this.checkVariable(variable, parent)) {
                return;
            }
            @NotNull Couple<Boolean> emptyInitializerAndWritten = this.collectionContentsAreUpdated(variable, parent);
            boolean read = this.collectionContentsAreQueried(variable, parent);
            Object place = variable.getNameIdentifier();
            if (place == null) {
                place = variable;
            }
            if (((Boolean)emptyInitializerAndWritten.second).booleanValue() && !read) {
                this.myHolder.registerProblem(place, JavaScriptBundle.message("collection.updated.but.not.queried", new Object[0]), new LocalQuickFix[0]);
            } else if (read && ((Boolean)emptyInitializerAndWritten.first).booleanValue() && !((Boolean)emptyInitializerAndWritten.second).booleanValue()) {
                this.myHolder.registerProblem(place, JavaScriptBundle.message("collection.queried.but.not.update", new Object[0]), new LocalQuickFix[0]);
            }
        }

        private boolean collectionContentsAreQueried(JSVariable variable, JSElement context2) {
            return this.collectionQueryCalled(variable, context2);
        }

        @NotNull
        private Couple<Boolean> collectionContentsAreUpdated(JSVariable variable, JSElement context2) {
            JSExpression initializer = variable.getInitializer();
            boolean hasEmptyInitializer = initializer != null && this.isEmptyInitializer(initializer);
            JSExpression destructuringInitializer = JSDestructuringUtil.getNearestDestructuringInitializer(variable);
            if (destructuringInitializer != null && !this.isEmptyInitializer(destructuringInitializer)) {
                hasEmptyInitializer = false;
            }
            if (this.collectionUpdateCalled(variable, context2)) {
                Couple couple = Couple.of((Object)hasEmptyInitializer, (Object)true);
                if (couple == null) {
                    MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(3);
                }
                return couple;
            }
            Couple couple = Couple.of((Object)hasEmptyInitializer, (Object)VariableAccessUtil.variableIsAssigned(variable, context2));
            if (couple == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(4);
            }
            return couple;
        }

        private boolean isEmptyInitializer(@NotNull JSExpression initializer) {
            if (initializer == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(5);
            }
            if (initializer instanceof JSArrayLiteralExpression) {
                if (!((JSArrayLiteralExpression)initializer).isEmpty()) {
                    return false;
                }
            } else if (initializer instanceof JSNewExpression) {
                JSArrayLiteralExpression psi;
                ASTNode arrayLiteral;
                ASTNode node;
                JSExpression[] arguments;
                JSArgumentList argumentList = ((JSNewExpression)initializer).getArgumentList();
                if (argumentList != null && !JSGenericTypeImpl.isGenericActionScriptVectorType(this.myType) ? (arguments = argumentList.getArguments()).length != 0 : (node = initializer.getNode()) != null && (arrayLiteral = node.findChildByType(JSElementTypes.ARRAY_LITERAL_EXPRESSION)) != null && (psi = (JSArrayLiteralExpression)arrayLiteral.getPsi(JSArrayLiteralExpression.class)) != null && !psi.isEmpty()) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private boolean checkVariable(JSVariable variable, JSElement context2) {
            this.myType = variable.getJSType();
            if (this.myType == null || !JSTypeUtils.isIndexableType(this.myType)) {
                return false;
            }
            if (VariableAccessUtil.variableIsAssignedFrom(variable, context2)) {
                return false;
            }
            return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)context2).filter(Conditions.instanceOf((Class[])new Class[]{JSReturnStatement.class, JSArgumentList.class, JSObjectLiteralExpression.class, JSArrayLiteralExpression.class, JSFunctionExpression.class}))).traverse().flatMap(this::expandForCheck).filter(arg -> VariableAccessUtil.mayEvaluateToVariable(arg, variable)).isEmpty();
        }

        private JBIterable<JSExpression> expandForCheck(PsiElement e) {
            if (e instanceof JSReturnStatement) {
                return JBIterable.of((Object)((JSReturnStatement)e).getExpression());
            }
            if (e instanceof JSArgumentList) {
                return JBIterable.of((Object[])((JSArgumentList)e).getArguments());
            }
            if (e instanceof JSObjectLiteralExpression) {
                return JBIterable.of((Object[])((JSObjectLiteralExpression)e).getProperties()).map(p -> p.getValue());
            }
            if (e instanceof JSArrayLiteralExpression) {
                return JBIterable.of((Object[])((JSArrayLiteralExpression)e).getExpressions());
            }
            if (e instanceof JSFunctionExpression) {
                JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunctionExpression)e);
                return JBIterable.of((Object)expression);
            }
            throw new NotImplementedError("Please implement me for: " + e.getClass().getCanonicalName());
        }

        private boolean collectionQueryCalled(JSVariable variable, JSElement context2) {
            CollectionQueryCalledVisitor visitor = new CollectionQueryCalledVisitor(variable);
            context2.accept(visitor);
            return visitor.isQueryCalled();
        }

        private boolean collectionUpdateCalled(@NotNull JSVariable variable, @NotNull JSElement context2) {
            if (variable == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(6);
            }
            if (context2 == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(7);
            }
            CollectionUpdateCalledVisitor visitor = new CollectionUpdateCalledVisitor(variable);
            context2.accept(visitor);
            return visitor.isUpdateCalled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varStatement";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectionContentsAreUpdated";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSVarStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isEmptyInitializer";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectionUpdateCalled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private class CollectionQueryCalledVisitor
    extends Visitor {
        private boolean queried;

        CollectionQueryCalledVisitor(JSVariable variable) {
            super(variable);
        }

        @Override
        public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
            if (node == null) {
                CollectionQueryCalledVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReferenceExpression(node);
            if (!this.queried) {
                JSEmbeddedContent content;
                if (DialectDetector.isJSX((PsiElement)node) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class)) != null && this.checkReference((PsiElement)node)) {
                    this.queried = true;
                    return;
                }
                JSExpression qualifier = node.getQualifier();
                if (qualifier != null && this.checkReference((PsiElement)qualifier) && JSMismatchedCollectionQueryUpdateInspectionBase.this.isQuery(node)) {
                    this.queried = true;
                }
            }
        }

        @Override
        public void visitTypeScriptCastExpression(@NotNull TypeScriptCastExpression node) {
            if (node == null) {
                CollectionQueryCalledVisitor.$$$reportNull$$$0(1);
            }
            super.visitTypeScriptCastExpression(node);
            if (!this.queried) {
                this.queried = this.checkReference((PsiElement)node.getExpression());
            }
        }

        @Override
        public void visitJSForInStatement(@NotNull JSForInStatement node) {
            if (node == null) {
                CollectionQueryCalledVisitor.$$$reportNull$$$0(2);
            }
            super.visitJSForInStatement(node);
            if (!this.queried) {
                JSExpression collectionExpression = node.getCollectionExpression();
                this.queried = this.checkReference((PsiElement)collectionExpression);
            }
        }

        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
            if (node == null) {
                CollectionQueryCalledVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSBinaryExpression(node);
            if (!this.queried && node.getOperationSign() == JSTokenTypes.IN_KEYWORD) {
                this.queried = this.checkReference((PsiElement)node.getROperand());
            }
        }

        @Override
        public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            if (node == null) {
                CollectionQueryCalledVisitor.$$$reportNull$$$0(4);
            }
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.queried && !((parent = node.getParent()) instanceof JSDefinitionExpression)) {
                JSExpression qualifier = node.getQualifier();
                this.queried = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isQueryCalled() {
            return this.queried;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$CollectionQueryCalledVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptCastExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIndexedPropertyAccessExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CollectionUpdateCalledVisitor
    extends Visitor {
        private boolean updated;

        CollectionUpdateCalledVisitor(JSVariable variable) {
            super(variable);
        }

        @Override
        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                CollectionUpdateCalledVisitor.$$$reportNull$$$0(0);
            }
            if (!this.updated) {
                super.visitElement(element2);
            }
        }

        @Override
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            JSExpression qualifier;
            JSExpression methodExpression;
            if (node == null) {
                CollectionUpdateCalledVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSCallExpression(node);
            if (!this.updated && (methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression && JSMismatchedCollectionQueryUpdateInspectionBase.this.isUpdateName((JSReferenceExpression)methodExpression) && this.checkReference((PsiElement)(qualifier = ((JSReferenceExpression)methodExpression).getQualifier()))) {
                this.updated = true;
            }
        }

        @Override
        public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            if (node == null) {
                CollectionUpdateCalledVisitor.$$$reportNull$$$0(2);
            }
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.updated && (parent = node.getParent()) instanceof JSDefinitionExpression) {
                JSExpression qualifier = node.getQualifier();
                this.updated = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isUpdateCalled() {
            return this.updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$CollectionUpdateCalledVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIndexedPropertyAccessExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Visitor
    extends JSRecursiveWalkingElementVisitor {
        protected final JSVariable myVariable;

        Visitor(JSVariable variable) {
            this.myVariable = variable;
        }

        protected boolean checkReference(@Nullable PsiElement element2) {
            if (element2 instanceof JSReferenceExpression) {
                if (this.myVariable.equals(element2 = ((JSReferenceExpression)element2).resolve())) {
                    return true;
                }
            } else {
                if (element2 instanceof JSParenthesizedExpression) {
                    return this.checkReference((PsiElement)((JSParenthesizedExpression)element2).getInnerExpression());
                }
                if (element2 instanceof JSConditionalExpression) {
                    JSExpression thenExpression = (JSExpression)((JSConditionalExpression)element2).getThenBranch();
                    JSExpression elseExpression = (JSExpression)((JSConditionalExpression)element2).getElseBranch();
                    return this.checkReference((PsiElement)thenExpression) || this.checkReference((PsiElement)elseExpression);
                }
                if (element2 instanceof JSAssignmentExpression && JSUtils.isNullishOrORAssignment((JSAssignmentExpression)element2) && ((JSAssignmentExpression)element2).getDefinitionExpression() != null) {
                    return this.checkReference((PsiElement)((JSAssignmentExpression)element2).getDefinitionExpression().getExpression());
                }
            }
            return false;
        }
    }
}

