/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class KarmaRunSettingsSerializationUtil {
    private static final String CONFIG_FILE = "config-file";
    private static final String KARMA_PACKAGE_DIR = "karma-package-dir";
    private static final String WORKING_DIRECTORY = "working-directory";
    private static final String KARMA_OPTIONS = "karma-options";
    private static final String BROWSERS = "browsers";
    private static final String NODE_INTERPRETER = "node-interpreter";
    private static final String NODE_OPTIONS = "node-options";
    private static final String SCOPE_KIND = "scope-kind";
    private static final String TEST_FILE_PATH = "test-file-path";
    private static final String TEST_NAMES = "test-names";
    private static final String TEST_NAME = "test-name";

    private KarmaRunSettingsSerializationUtil() {
    }

    static KarmaRunSettings readXml(@NotNull Element element) {
        String browsers;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(0);
        }
        KarmaRunSettings.Builder builder = new KarmaRunSettings.Builder();
        String configPath = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)CONFIG_FILE));
        builder.setConfigPath(configPath);
        Object karmaOptions = JDOMExternalizerUtil.readCustomField((Element)element, (String)KARMA_OPTIONS);
        if (karmaOptions == null && !StringUtil.isEmptyOrSpaces((String)(browsers = JDOMExternalizerUtil.readCustomField((Element)element, (String)BROWSERS)))) {
            karmaOptions = "--browsers=" + browsers;
        }
        builder.setKarmaOptions((String)karmaOptions);
        String karmaPackageDir = JDOMExternalizerUtil.readCustomField((Element)element, (String)KARMA_PACKAGE_DIR);
        if (karmaPackageDir != null) {
            builder.setKarmaPackage(KarmaUtil.PKG_DESCRIPTOR.createPackage(karmaPackageDir));
        }
        builder.setWorkingDirectory(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)WORKING_DIRECTORY)));
        builder.setInterpreterRef(NodeJsInterpreterRef.create((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)NODE_INTERPRETER)));
        builder.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)NODE_OPTIONS)));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        KarmaScopeKind scopeKind = KarmaRunSettingsSerializationUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        builder.setTestFilePath(JDOMExternalizerUtil.readCustomField((Element)element, (String)TEST_FILE_PATH));
        if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            builder.setTestNames(KarmaRunSettingsSerializationUtil.readTestNames(element));
        }
        return builder.build();
    }

    @NotNull
    private static KarmaScopeKind readScopeKind(@NotNull Element element) {
        String value;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(value = JDOMExternalizerUtil.readCustomField((Element)element, (String)SCOPE_KIND)))) {
            KarmaScopeKind karmaScopeKind;
            try {
                karmaScopeKind = KarmaScopeKind.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (karmaScopeKind == null) {
                KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(2);
            }
            return karmaScopeKind;
        }
        KarmaScopeKind karmaScopeKind = KarmaScopeKind.ALL;
        if (karmaScopeKind == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(3);
        }
        return karmaScopeKind;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(4);
        }
        if ((testNamesElement = parent.getChild(TEST_NAMES)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TEST_NAME);
        if (list == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    static void writeXml(@NotNull Element element, @NotNull KarmaRunSettings settings) {
        String testFilePath;
        String workingDir;
        if (element == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            KarmaRunSettingsSerializationUtil.$$$reportNull$$$0(8);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)CONFIG_FILE, (String)settings.getConfigPathSystemIndependent());
        if (StringUtil.isNotEmpty((String)settings.getKarmaOptions())) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)KARMA_OPTIONS, (String)settings.getKarmaOptions());
        }
        if (settings.getKarmaPackage() != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)KARMA_PACKAGE_DIR, (String)settings.getKarmaPackage().getSystemIndependentPath());
        }
        if (!(workingDir = settings.getWorkingDirectorySystemIndependent()).isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)WORKING_DIRECTORY, (String)workingDir);
        }
        JDOMExternalizerUtil.writeCustomField((Element)element, (String)NODE_INTERPRETER, (String)settings.getInterpreterRef().getReferenceName());
        if (StringUtil.isNotEmpty((String)settings.getNodeOptions())) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)NODE_OPTIONS, (String)settings.getNodeOptions());
        }
        settings.getEnvData().writeExternal(element);
        KarmaScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind != KarmaScopeKind.ALL) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)SCOPE_KIND, (String)scopeKind.name());
        }
        if (StringUtil.isNotEmpty((String)(testFilePath = settings.getTestFileSystemIndependentPath()))) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)TEST_FILE_PATH, (String)testFilePath);
        }
        if (scopeKind == KarmaScopeKind.SUITE || scopeKind == KarmaScopeKind.TEST) {
            Element testNamesElement = new Element(TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunSettingsSerializationUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

