/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbImplUtil;
import com.intellij.dbt.DbtDirectories;
import com.intellij.dbt.DbtUtils;
import com.intellij.jinja.tags.Jinja2FunctionCall;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlResolveExtension;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dbt/DbtSqlExtension;", "Lcom/intellij/sql/psi/impl/SqlResolveExtension;", "<init>", "()V", "process", "", "reference", "Lcom/intellij/sql/psi/SqlReference;", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "DbtModelDasSymbol", "DbtSeedFile", "DbtCsvType", "CsvColumnElement", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtSqlExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtSqlExtension.kt\ncom/intellij/dbt/DbtSqlExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n295#2,2:133\n*S KotlinDebug\n*F\n+ 1 DbtSqlExtension.kt\ncom/intellij/dbt/DbtSqlExtension\n*L\n48#1:133,2\n*E\n"})
public final class DbtSqlExtension
implements SqlResolveExtension {
    public boolean process(@NotNull SqlReference reference, @NotNull SqlScopeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element = psiElement;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)SqlCompositeElementTypes.SQL_TABLE_REFERENCE)) {
            return true;
        }
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class);
        if (sqlQueryExpression == null) {
            return true;
        }
        SqlQueryExpression sqlQueryExpression2 = sqlQueryExpression;
        SqlTableExpression sqlTableExpression = sqlQueryExpression2.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getFromClause()) == null || (sqlTableExpression = sqlTableExpression.getFromExpression()) == null) {
            return true;
        }
        SqlTableExpression fromExpression = sqlTableExpression;
        Jinja2FunctionCall jinja2FunctionCall = DbtUtils.Companion.getJinjaCall((PsiElement)fromExpression);
        if (jinja2FunctionCall == null) {
            return true;
        }
        Jinja2FunctionCall jinjaCall = jinja2FunctionCall;
        if (!DbtUtils.Companion.isRefCall(jinjaCall)) {
            return true;
        }
        String string = DbtUtils.Companion.getReferencedName(jinjaCall);
        if (string == null) {
            return true;
        }
        String referencedName = string;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return true;
        }
        Module module2 = module;
        PsiFile modelPsiFile = DbtDirectories.Companion.findModel(referencedName, module2);
        if (modelPsiFile != null) {
            Object v7;
            block13: {
                Set set = modelPsiFile.getViewProvider().getLanguages();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLanguages(...)");
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Language it = (Language)element$iv;
                    boolean bl = false;
                    if (!it.isKindOf((Language)SqlLanguage.INSTANCE)) continue;
                    v7 = element$iv;
                    break block13;
                }
                v7 = null;
            }
            Language language = v7;
            if (language == null) {
                return true;
            }
            Language sqlDialect = language;
            PsiFile psiFile = modelPsiFile.getViewProvider().getPsi(sqlDialect);
            if (psiFile == null) {
                return true;
            }
            PsiFile sqlFile = psiFile;
            SqlQueryExpression sqlQueryExpression3 = DbtUtils.Companion.findLastSelectQuery(sqlFile);
            if (sqlQueryExpression3 == null) {
                return true;
            }
            SqlQueryExpression targetSqlQueryExpression = sqlQueryExpression3;
            PsiElement psiElement2 = (PsiElement)targetSqlQueryExpression;
            String string2 = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return processor.executeTarget((DasSymbol)new DbtModelDasSymbol(psiElement2, string2, null), null, null, ResolveState.initial());
        }
        PsiFile psiFile = DbtDirectories.Companion.findSeedFile(referencedName, module2);
        if (psiFile == null) {
            return true;
        }
        PsiFile seedPsiFile = psiFile;
        DbtSeedFile fakeCsvTable = new DbtSeedFile(seedPsiFile);
        DbtCsvType dasType = new DbtCsvType(seedPsiFile);
        ReservedEntity.Typed dasObject = new ReservedEntity.Typed(DbImplUtil.getDbms((PsiElement)element), element.getText(), ObjectKind.TABLE, (DasType)dasType);
        PsiElement psiElement3 = (PsiElement)fakeCsvTable;
        String string3 = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        DbtModelDasSymbol symbol = new DbtModelDasSymbol(psiElement3, string3, (DasObject)dasObject);
        return processor.executeTarget((DasSymbol)symbol, (DasType)dasType, null, ResolveState.initial());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001d\u0010\u0017\u001a\u0017\u0012\u000e\u0012\f0\u0000\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u00190\u0018\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/dbt/DbtSqlExtension$CsvColumnElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/database/symbols/DasSymbol;", "name", "", "parent", "Lcom/intellij/psi/PsiFile;", "offset", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;I)V", "getParent", "getName", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isQuoted", "", "getDbms", "Lcom/intellij/database/Dbms;", "Lorg/jetbrains/annotations/NotNull;", "isValid", "getDasObject", "Lcom/intellij/database/model/DasObject;", "getPsiDeclarations", "Lcom/intellij/util/containers/JBIterable;", "Lkotlin/jvm/internal/EnhancedNullability;", "getNavigationElement", "getContextElement", "getTextOffset", "getText", "intellij.dbt"})
    public static final class CsvColumnElement
    extends FakePsiElement
    implements DasSymbol {
        @NotNull
        private final String name;
        @NotNull
        private final PsiFile parent;
        private final int offset;

        public CsvColumnElement(@NotNull String name, @NotNull PsiFile parent, int offset) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.name = name;
            this.parent = parent;
            this.offset = offset;
        }

        @NotNull
        public PsiFile getParent() {
            return this.parent;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            return objectKind;
        }

        public boolean isQuoted() {
            return false;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = DbImplUtil.getDbms((PsiElement)((PsiElement)this));
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            return dbms;
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public DasObject getDasObject() {
            return null;
        }

        @NotNull
        public JBIterable<CsvColumnElement> getPsiDeclarations() {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }

        @NotNull
        public CsvColumnElement getNavigationElement() {
            return this;
        }

        @NotNull
        public CsvColumnElement getContextElement() {
            return this;
        }

        public int getTextOffset() {
            return this.offset;
        }

        @NotNull
        public String getText() {
            return this.name;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0014\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/dbt/DbtSqlExtension$DbtCsvType;", "Lcom/intellij/sql/psi/impl/SqlTableTypeBase;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "columnNames", "", "", "columnOffsets", "", "columns", "Lcom/intellij/psi/PsiElement;", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "getColumnCount", "getColumnName", "i", "getColumnDasType", "Lcom/intellij/database/types/DasBuiltinType;", "getMethods", "Lcom/intellij/database/model/DasObject;", "isColumnQuoted", "", "getColumnElement", "getSourceColumnElement", "", "getColumnQualifier", "intellij.dbt"})
    public static final class DbtCsvType
    extends SqlTableTypeBase {
        @NotNull
        private final List<String> columnNames;
        @NotNull
        private final List<Integer> columnOffsets;
        @NotNull
        private final List<PsiElement> columns;

        public DbtCsvType(@NotNull PsiFile file) {
            int i;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.columnNames = new ArrayList();
            this.columnOffsets = new ArrayList();
            this.columns = new ArrayList();
            int lastSeparatorOffset = -1;
            int n = file.getTextLength();
            for (i = 0; i < n; ++i) {
                char c = file.getText().charAt(i);
                switch (c) {
                    case '\n': 
                    case ',': {
                        String string;
                        Intrinsics.checkNotNullExpressionValue((Object)file.getText(), (String)"getText(...)");
                        int n2 = lastSeparatorOffset + 1;
                        String string2 = string.substring(n2, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        this.columnNames.add(((Object)StringsKt.trim((CharSequence)string2)).toString());
                        this.columnOffsets.add(lastSeparatorOffset + 1);
                        lastSeparatorOffset = i;
                    }
                }
                if (c == '\n') break;
            }
            n = this.columnNames.size();
            for (i = 0; i < n; ++i) {
                this.columns.add((PsiElement)new CsvColumnElement(this.getColumnName(i), file, ((Number)this.columnOffsets.get(i)).intValue()));
            }
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = SqlTypeFactory.createTableDataType((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"createTableDataType(...)");
            return dataType;
        }

        public int getColumnCount() {
            return ((Collection)this.columns).size();
        }

        @NotNull
        public String getColumnName(int i) {
            return this.columnNames.get(i);
        }

        @NotNull
        public DasBuiltinType<?> getColumnDasType(int i) {
            return DasTypeSystemBase.UNKNOWN;
        }

        @NotNull
        public List<DasObject> getMethods() {
            return new ArrayList();
        }

        public boolean isColumnQuoted(int i) {
            return false;
        }

        @NotNull
        public PsiElement getColumnElement(int i) {
            return this.columns.get(i);
        }

        @Nullable
        public Void getSourceColumnElement(int i) {
            return null;
        }

        @Nullable
        public Void getColumnQualifier(int i) {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u001d\u0010\u0015\u001a\u0017\u0012\u000e\u0012\f0\u0004\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00170\u0016\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dbt/DbtSqlExtension$DbtModelDasSymbol;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/database/symbols/DasSymbol;", "element", "Lcom/intellij/psi/PsiElement;", "name", "", "dasObject", "Lcom/intellij/database/model/DasObject;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/database/model/DasObject;)V", "getName", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isQuoted", "", "getDbms", "Lcom/intellij/database/Dbms;", "Lorg/jetbrains/annotations/NotNull;", "isValid", "getDasObject", "getPsiDeclarations", "Lcom/intellij/util/containers/JBIterable;", "Lkotlin/jvm/internal/EnhancedNullability;", "getNavigationElement", "getContextElement", "intellij.dbt"})
    public static final class DbtModelDasSymbol
    extends UserDataHolderBase
    implements DasSymbol {
        @NotNull
        private final PsiElement element;
        @NotNull
        private final String name;
        @Nullable
        private final DasObject dasObject;

        public DbtModelDasSymbol(@NotNull PsiElement element, @NotNull String name, @Nullable DasObject dasObject) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.element = element;
            this.name = name;
            this.dasObject = dasObject;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            return objectKind;
        }

        public boolean isQuoted() {
            return false;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = DbImplUtil.getDbms((PsiElement)this.element);
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            return dbms;
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public DasObject getDasObject() {
            return this.dasObject;
        }

        @NotNull
        public JBIterable<PsiElement> getPsiDeclarations() {
            JBIterable jBIterable = JBIterable.of((Object)this.element);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.element;
        }

        @NotNull
        public PsiElement getContextElement() {
            return this.element;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/dbt/DbtSqlExtension$DbtSeedFile;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/database/model/DasTypeAwareObject;", "originalFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getParent", "getDasType", "Lcom/intellij/database/types/DasType;", "intellij.dbt"})
    public static final class DbtSeedFile
    extends FakePsiElement
    implements DasTypeAwareObject {
        @NotNull
        private final PsiFile originalFile;

        public DbtSeedFile(@NotNull PsiFile originalFile) {
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            this.originalFile = originalFile;
        }

        @NotNull
        public PsiFile getParent() {
            return this.originalFile;
        }

        @NotNull
        public DasType getDasType() {
            return (DasType)new DbtCsvType(this.originalFile);
        }
    }
}

