/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.psi.SqlCommonTokens;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011BK\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0012J(\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/UntilPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "canStartWithComment", "", "untilMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "acceptEOF", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;ZLcom/intellij/sql/formatter/model/NodeMatcher;ZLcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "(Ljava/lang/Byte;Ljava/lang/Byte;Lcom/intellij/sql/formatter/model/NodeMatcher;ZLcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.core.impl"})
public final class UntilPattern
extends FlowPattern {
    private final boolean canStartWithComment;
    @NotNull
    private final NodeMatcher untilMatcher;
    private final boolean acceptEOF;
    @NotNull
    private final BlockRole role;

    public UntilPattern(@Nullable Byte applicableState, @Nullable Byte resultState, boolean canStartWithComment, @NotNull NodeMatcher untilMatcher, boolean acceptEOF, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)untilMatcher, (String)"untilMatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.canStartWithComment = canStartWithComment;
        this.untilMatcher = untilMatcher;
        this.acceptEOF = acceptEOF;
        this.role = role;
    }

    public /* synthetic */ UntilPattern(Byte by, Byte by2, boolean bl, NodeMatcher nodeMatcher, boolean bl2, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            blockRole = BlockRole.NOTHING;
        }
        this(by, by2, bl, nodeMatcher, bl2, blockRole, (Function0<? extends SqlBlock>)function0);
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    public UntilPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull NodeMatcher untilMatcher, boolean acceptEOF, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)untilMatcher, (String)"untilMatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this(applicableState, resultState, false, untilMatcher, acceptEOF, role, producer);
    }

    public /* synthetic */ UntilPattern(Byte by, Byte by2, NodeMatcher nodeMatcher, boolean bl, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            blockRole = BlockRole.NOTHING;
        }
        this(by, by2, nodeMatcher, bl, blockRole, (Function0<? extends SqlBlock>)function0);
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        if (since >= n) {
            return null;
        }
        if (SqlUtilFun.isComment(nodes.get(since)) && !this.canStartWithComment) {
            return null;
        }
        if (NodeMatcherKt.matches(nodes.get(since), this.untilMatcher)) {
            return null;
        }
        int par = 0;
        for (int k = since; k < n; ++k) {
            ASTNode theNode = nodes.get(k);
            if (par <= 0 && NodeMatcherKt.matches(theNode, this.untilMatcher)) {
                return RangesKt.until((int)since, (int)k);
            }
            IElementType iElementType = theNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonTokens.SQL_LEFT_PAREN))) {
                ++par;
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCommonTokens.SQL_RIGHT_PAREN))) continue;
            --par;
        }
        return this.acceptEOF ? RangesKt.until((int)since, (int)n) : null;
    }
}

