/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlElsifSectionBlock;
import com.intellij.sql.formatter.model.SqlForkBlock;
import com.intellij.sql.formatter.model.SqlForkSectionBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0005\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/formatter/model/SqlForkElementBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "forkBlock", "Lcom/intellij/sql/formatter/model/SqlForkBlock;", "getForkBlock", "()Lcom/intellij/sql/formatter/model/SqlForkBlock;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "configureFormattingAttributes", "", "overrideShape", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "overrideShape$intellij_database_sql_core_impl", "Lcom/intellij/sql/formatter/model/SqlForkSectionBlock;", "intellij.database.sql.core.impl"})
public abstract class SqlForkElementBlock
extends SqlNodeBlock {
    private SqlForkElementBlock() {
    }

    @Nullable
    public abstract SqlForkBlock getForkBlock();

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node;
        return aSTNode instanceof SqlExpression ? BlockRole.BODY : (aSTNode instanceof SqlStatement ? BlockRole.ELEMENT : super.determineRole(node));
    }

    @Override
    protected boolean userRequiresExpand() {
        return !this.getContext().getSql().IMP_IF_THEN_COLLAPSE;
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        SqlForkBlock sqlForkBlock = this.getForkBlock();
        this.setInnerWrap((Wrap)(sqlForkBlock != null ? sqlForkBlock.getForkWrap$intellij_database_sql_core_impl() : null));
        for (SqlBlock b : this.getNestedBlocks()) {
            SqlBlock sqlBlock = b;
            if (sqlBlock instanceof SqlElsifSectionBlock) {
                boolean toIndent = s.IMP_IF_THEN_INDENT_THEN_ELSE;
                b.setMyWrap(this.getInnerWrap());
                b.setMyIndent(toIndent ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (sqlBlock instanceof SqlForkSectionBlock) {
                boolean toWrap = ((SqlForkSectionBlock)b).isElse$intellij_database_sql_core_impl() ? s.IMP_IF_THEN_WRAP_ELSE : s.IMP_IF_THEN_WRAP_THEN;
                boolean toIndent = s.IMP_IF_THEN_INDENT_THEN_ELSE;
                b.setMyWrap(toWrap ? this.getInnerWrap() : null);
                b.setMyIndent(toIndent ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (sqlBlock instanceof SqlCodeFlowBlock || sqlBlock instanceof SqlStatementBlock) {
                b.setMyWrap(s.IMP_IF_THEN_WRAP_INNER ? this.getInnerWrap() : null);
                b.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (!(sqlBlock instanceof SqlKeyword) || ((SqlKeyword)b).getElementType() != SqlCommonKeywords.SQL_END) continue;
            b.setMyWrap(this.getInnerWrap());
            b.setMyIndent(s.IMP_IF_THEN_INDENT_END ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
        }
    }

    public final void overrideShape$intellij_database_sql_core_impl(@NotNull BlockShape shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        for (SqlBlock b : this.getNestedBlocks()) {
            if (!(b instanceof SqlForkElementBlock)) continue;
            b.setShape(shape);
            ((SqlForkElementBlock)b).overrideShape$intellij_database_sql_core_impl(shape);
        }
    }

    public /* synthetic */ SqlForkElementBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

