/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector.jdbc;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsMetadataWrapper
extends DatabaseMetaDataWrapper {
    protected MsMetadataWrapper(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData data) {
        if (connection == null) {
            MsMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            MsMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection, data);
    }

    @Override
    public ClosableIt<DatabaseMetaDataWrapper.Schema> schemas(@NotNull JBIterable<String> catalogs, @Nullable String current) {
        if (catalogs == null) {
            MsMetadataWrapper.$$$reportNull$$$0(2);
        }
        return ClosableIt.lazyAppendIfEmpty(MsMetadataWrapper.mssqlSchemas(catalogs.iterator(), this), () -> super.schemas(catalogs, current));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemas(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(MsMetadataWrapper.mssqlSchemasInCatalog(DbUtil.intern(catalogs.next()), meta), () -> MsMetadataWrapper.mssqlSchemas(catalogs, meta));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemasInCatalog(final String catalog, DatabaseMetaDataWrapper meta) {
        RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeSafe(() -> meta.getConnection().getRemoteConnection().createStatement());
        if (statement == null) {
            return ClosableIt.empty();
        }
        ClosableIt.AutoCloseableGuard<AutoCloseable> g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());
        try {
            1 res = meta.setUp(new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select name from [" + catalog + "].sys.schemas")), g.get()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern(this.myRs.getString("name", 1)), catalog);
                }
            });
            g.release();
            1 var5_7 = res;
            if (g != null) {
                g.close();
            }
            return var5_7;
        }
        catch (Throwable throwable) {
            try {
                if (g != null) {
                    try {
                        g.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOG.debug((Throwable)e);
                return ClosableIt.empty();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/introspector/jdbc/MsMetadataWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "schemas";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @Override
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new MsMetadataWrapper(connection, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/mssql/introspector/jdbc/MsMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

