/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.EdtScheduler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CommittedChangesFilterDialog
extends DialogWrapper {
    private final ChangesBrowserSettingsEditor panel;
    private ChangeBrowserSettings settings;
    private final JLabel myErrorLabel;
    private Job validateAlarm;
    private final Runnable validateRunnable;

    private void scheduleValidation() {
        this.validateAlarm = EdtScheduler.getInstance().schedule(500, ModalityState.stateForComponent((Component)this.panel.getComponent()), this.validateRunnable);
    }

    public CommittedChangesFilterDialog(Project project, @NotNull ChangesBrowserSettingsEditor panel, @NotNull ChangeBrowserSettings settings) {
        if (panel == null) {
            CommittedChangesFilterDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CommittedChangesFilterDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myErrorLabel = new JLabel();
        this.validateAlarm = null;
        this.validateRunnable = () -> {
            this.validateInput();
            this.scheduleValidation();
        };
        this.panel = panel;
        this.panel.setSettings(settings);
        this.setTitle(VcsBundle.message((String)"browse.changes.filter.title", (Object[])new Object[0]));
        this.init();
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.validateInput();
        this.scheduleValidation();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.panel.getComponent(), "Center");
        panel.add((Component)this.myErrorLabel, "South");
        JPanel jPanel = panel;
        if (jPanel == null) {
            CommittedChangesFilterDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void validateInput() {
        String error = this.panel.validateInput();
        this.setOKActionEnabled(error == null);
        this.myErrorLabel.setText(error == null ? " " : error);
    }

    protected void doOKAction() {
        this.validateInput();
        if (this.isOKActionEnabled()) {
            this.validateAlarm.cancel(null);
            this.settings = this.panel.getSettings();
            super.doOKAction();
        }
    }

    public ChangeBrowserSettings getSettings() {
        return this.settings;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "AbstractVcsHelper.FilterDialog." + this.panel.getDimensionServiceKey();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesFilterDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangesFilterDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

