/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.JavaModuleData;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.data.AnnotationProcessingData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public final class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    private final IdentityHashMap<GradleBuildScriptClasspathModel, List<BuildScriptClasspathData.ClasspathEntry>> buildScriptEntriesMap = new IdentityHashMap();

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.buildScriptEntriesMap.clear();
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (ideProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(2);
        }
        this.populateJavaProjectCompilerSettings(gradleProject, ideProject);
        this.populateProjectSdkModel(gradleProject, ideProject);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    @NotNull
    private String getCompileOutputPath() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        String string = projectDirPath + "/build/classes";
        if (string == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(5);
        }
        this.populateJavaModuleCompilerSettings(gradleModule, ideModule);
        this.populateBuildScriptClasspathData(gradleModule, ideModule);
        this.populateAnnotationProcessorData(gradleModule, ideModule);
        this.populateDependenciesGraphData(gradleModule, ideModule);
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    private void populateAnnotationProcessorData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        AnnotationProcessingModel apModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(6);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(7);
        }
        if ((apModel = (AnnotationProcessingModel)this.resolverCtx.getExtraProject(gradleModule, AnnotationProcessingModel.class)) == null) {
            return;
        }
        if (!this.resolverCtx.isResolveModulePerSourceSet()) {
            AnnotationProcessingData apData = JavaGradleProjectResolver.getMergedAnnotationProcessingData(apModel);
            DataNode dataNode = ideModule.createChild(AnnotationProcessingData.KEY, (Object)apData);
            JavaGradleProjectResolver.populateAnnotationProcessingOutput((DataNode<AnnotationProcessingData>)dataNode, apModel);
        } else {
            Collection all = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            for (DataNode node : all) {
                AnnotationProcessingData apData = JavaGradleProjectResolver.getAnnotationProcessingData(apModel, ((GradleSourceSetData)node.getData()).getModuleName());
                if (apData == null) continue;
                DataNode dataNode = node.createChild(AnnotationProcessingData.KEY, (Object)apData);
                JavaGradleProjectResolver.populateAnnotationProcessorOutput((DataNode<AnnotationProcessingData>)dataNode, apModel, ((GradleSourceSetData)node.getData()).getModuleName());
            }
        }
    }

    private static void populateAnnotationProcessorOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(9);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(10);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) != null && config.getProcessorOutput() != null) {
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    private static void populateAnnotationProcessingOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel) {
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(12);
        }
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            if (config.getProcessorOutput() == null) continue;
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources()));
        }
    }

    @NotNull
    private static AnnotationProcessingData getMergedAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel) {
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(13);
        }
        LinkedHashSet<String> mergedAnnotationProcessorPath = new LinkedHashSet<String>();
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            mergedAnnotationProcessorPath.addAll(config.getAnnotationProcessorPath());
        }
        ArrayList<String> apArguments = new ArrayList<String>();
        AnnotationProcessingConfig mainConfig = apModel.bySourceSetName("main");
        if (mainConfig != null) {
            apArguments.addAll(mainConfig.getAnnotationProcessorArguments());
        }
        AnnotationProcessingData annotationProcessingData = AnnotationProcessingData.create(mergedAnnotationProcessorPath, apArguments);
        if (annotationProcessingData == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(14);
        }
        return annotationProcessingData;
    }

    @Nullable
    private static AnnotationProcessingData getAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(16);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) == null) {
            return null;
        }
        return AnnotationProcessingData.create(config.getAnnotationProcessorPath(), config.getAnnotationProcessorArguments());
    }

    private void populateBuildScriptClasspathData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        GradleBuildScriptClasspathModel buildScriptClasspathModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(17);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(18);
        }
        List classpathEntries = (buildScriptClasspathModel = (GradleBuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, GradleBuildScriptClasspathModel.class)) != null ? this.buildScriptEntriesMap.computeIfAbsent(buildScriptClasspathModel, it -> ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> BuildScriptClasspathData.ClasspathEntry.create((Set)model.getClasses(), (Set)model.getSources(), (Set)model.getJavadoc()))) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    private void populateDependenciesGraphData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectDependencies projectDependencies;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(20);
        }
        if ((projectDependencies = (ProjectDependencies)this.resolverCtx.getExtraProject(gradleModule, ProjectDependencies.class)) != null) {
            ideModule.createChild(ProjectKeys.DEPENDENCIES_GRAPH, (Object)projectDependencies);
        }
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set<Class<?>> set = Set.of(AnnotationProcessingModel.class, ProjectDependencies.class);
        if (set == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(21);
        }
        return set;
    }

    private void populateJavaProjectCompilerSettings(@NotNull IdeaProject ideaProject, @NotNull DataNode<ProjectData> projectNode) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (projectNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(23);
        }
        String compileOutputPath = this.getCompileOutputPath();
        LanguageLevel languageLevel = this.getLanguageLevel(ideaProject);
        String targetBytecodeVersion = this.getTargetBytecodeVersion(ideaProject);
        List<String> compilerArguments = this.getCompilerArguments(ideaProject);
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, compileOutputPath, languageLevel, targetBytecodeVersion, compilerArguments);
        javaProjectData.setJdkName(ideaProject.getJdkName());
        projectNode.createChild(JavaProjectData.KEY, (Object)javaProjectData);
    }

    private void populateJavaModuleCompilerSettings(@NotNull IdeaModule ideaModule, @NotNull DataNode<ModuleData> moduleNode) {
        ExternalProject externalProject;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(24);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(25);
        }
        if ((externalProject = (ExternalProject)this.resolverCtx.getExtraProject(ideaModule, ExternalProject.class)) == null) {
            return;
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            Map<ExternalSourceSet, DataNode<GradleSourceSetData>> sourceSets = this.findSourceSets(ideaModule, externalProject, moduleNode);
            for (Map.Entry<ExternalSourceSet, DataNode<GradleSourceSetData>> entry : sourceSets.entrySet()) {
                ExternalSourceSet sourceSet = entry.getKey();
                DataNode<GradleSourceSetData> sourceSetDataNode = entry.getValue();
                JavaModuleData moduleData = JavaGradleProjectResolver.createSourceSetModuleData(ideaModule, sourceSet);
                sourceSetDataNode.createChild(JavaModuleData.KEY, (Object)moduleData);
                this.populateModuleSdkModel(ideaModule, sourceSetDataNode, sourceSet);
            }
        }
        this.populateModuleSdkModel(ideaModule, moduleNode, null);
        JavaModuleData moduleData = JavaGradleProjectResolver.createMainModuleData(ideaModule, externalProject);
        moduleNode.createChild(JavaModuleData.KEY, (Object)moduleData);
    }

    @NotNull
    private static JavaModuleData createMainModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(26);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(27);
        }
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(ideaModule, externalProject);
        String targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(ideaModule, externalProject);
        List<String> compilerArguments = JavaGradleProjectResolver.getCompilerArguments(externalProject);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion, compilerArguments);
    }

    @NotNull
    private static JavaModuleData createSourceSetModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(29);
        }
        LanguageLevel languageLevel = JavaGradleProjectResolver.getLanguageLevel(ideaModule, sourceSet);
        String targetBytecodeVersion = JavaGradleProjectResolver.getTargetBytecodeVersion(ideaModule, sourceSet);
        List<String> compilerArguments = JavaGradleProjectResolver.getCompilerArguments(sourceSet);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion, compilerArguments);
    }

    @NotNull
    private Map<ExternalSourceSet, DataNode<GradleSourceSetData>> findSourceSets(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> moduleNode) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(30);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(31);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(32);
        }
        Collection sourceSetNodes = ExternalSystemApiUtil.getChildren(moduleNode, (Key)GradleSourceSetData.KEY);
        LinkedHashMap<String, DataNode> sourceSetIndex = new LinkedHashMap<String, DataNode>();
        for (DataNode sourceSetNode : sourceSetNodes) {
            sourceSetIndex.put(((GradleSourceSetData)sourceSetNode.getData()).getId(), sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> result = new LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>>();
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            String moduleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)ideaModule, (ExternalSourceSet)sourceSet);
            DataNode sourceSetNode = (DataNode)sourceSetIndex.get(moduleId);
            if (sourceSetNode == null) continue;
            result.put(sourceSet, (DataNode<GradleSourceSetData>)sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> linkedHashMap = result;
        if (linkedHashMap == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(33);
        }
        return linkedHashMap;
    }

    @NotNull
    private List<Pair<IdeaModule, ExternalProject>> getExternalModules(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(34);
        }
        List<Pair<IdeaModule, ExternalProject>> list = ideaProject.getModules().stream().map(it -> new Pair(it, (Object)((ExternalProject)this.resolverCtx.getExtraProject(it, ExternalProject.class)))).filter(it -> it.second != null).collect(Collectors.toList());
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Nullable
    private LanguageLevel getLanguageLevel(@NotNull IdeaProject ideaProject) {
        List<Pair<IdeaModule, ExternalProject>> externalModules;
        LanguageLevel languageLevel;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(36);
        }
        if ((languageLevel = (LanguageLevel)(externalModules = this.getExternalModules(ideaProject)).stream().map(it -> JavaGradleProjectResolver.getLanguageLevel((IdeaModule)it.first, (ExternalProject)it.second)).filter(it -> it != null).min(Comparator.naturalOrder()).orElse(null)) != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, this.isPreview(ideaProject));
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        LanguageLevel languageLevel;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(37);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(38);
        }
        if ((languageLevel = JavaGradleProjectResolver.getLanguageLevel(externalProject)) != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, JavaGradleProjectResolver.isPreview(externalProject));
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        LanguageLevel languageLevel;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(39);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(40);
        }
        if ((languageLevel = JavaGradleProjectResolver.getLanguageLevel(sourceSet)) != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, JavaGradleProjectResolver.isPreview(sourceSet));
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalSourceSet sourceSet) {
        String sourceCompatibility;
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(41);
        }
        if ((sourceCompatibility = sourceSet.getSourceCompatibility()) == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, JavaGradleProjectResolver.isPreview(sourceSet));
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@NotNull ExternalProject externalProject) {
        String sourceCompatibility;
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(42);
        }
        if ((sourceCompatibility = externalProject.getSourceCompatibility()) == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(sourceCompatibility, JavaGradleProjectResolver.isPreview(externalProject));
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@Nullable IdeaJavaLanguageSettings languageSettings, boolean isPreview) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion languageLevel = languageSettings.getLanguageLevel();
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(languageLevel.toString(), isPreview);
    }

    @Nullable
    private static LanguageLevel parseLanguageLevel(@NotNull String languageLevelString, boolean isPreview) {
        LanguageLevel languageLevel;
        if (languageLevelString == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(43);
        }
        if ((languageLevel = LanguageLevel.parse((String)languageLevelString)) == null) {
            return null;
        }
        return JavaGradleProjectResolver.setPreview(languageLevel, isPreview);
    }

    @NotNull
    private static LanguageLevel setPreview(@NotNull LanguageLevel languageLevel, boolean isPreview) {
        if (languageLevel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(44);
        }
        if (languageLevel.isPreview() == isPreview) {
            LanguageLevel languageLevel2 = languageLevel;
            if (languageLevel2 == null) {
                JavaGradleProjectResolver.$$$reportNull$$$0(45);
            }
            return languageLevel2;
        }
        com.intellij.util.lang.JavaVersion javaVersion = languageLevel.toJavaVersion();
        LanguageLevel languageLevel3 = LanguageLevel.getEntries().stream().filter(it -> it.isPreview() == isPreview).filter(it -> it.toJavaVersion().equals((Object)javaVersion)).findFirst().orElse(languageLevel);
        if (languageLevel3 == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(46);
        }
        return languageLevel3;
    }

    @Nullable
    private String getTargetBytecodeVersion(@NotNull IdeaProject ideaProject) {
        String targetBytecodeVersion;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(47);
        }
        if ((targetBytecodeVersion = (String)this.getExternalModules(ideaProject).stream().map(it -> JavaGradleProjectResolver.getTargetBytecodeVersion((IdeaModule)it.first, (ExternalProject)it.second)).filter(it -> it != null).min(Comparator.naturalOrder()).orElse(null)) != null) {
            return targetBytecodeVersion;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull ExternalProject externalProject) {
        String targetCompatibility;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(48);
        }
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(49);
        }
        if ((targetCompatibility = externalProject.getTargetCompatibility()) != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        String targetCompatibility;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(50);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(51);
        }
        if ((targetCompatibility = sourceSet.getTargetCompatibility()) != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@Nullable IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion targetByteCodeVersion = languageSettings.getTargetBytecodeVersion();
        if (targetByteCodeVersion == null) {
            return null;
        }
        return targetByteCodeVersion.toString();
    }

    private boolean isPreview(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(52);
        }
        return this.getCompilerArguments(ideaProject).contains("--enable-preview");
    }

    private static boolean isPreview(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(53);
        }
        return JavaGradleProjectResolver.getCompilerArguments(externalProject).contains("--enable-preview");
    }

    private static boolean isPreview(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(54);
        }
        return JavaGradleProjectResolver.getCompilerArguments(sourceSet).contains("--enable-preview");
    }

    @NotNull
    private List<String> getCompilerArguments(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(55);
        }
        List<String> list = this.getExternalModules(ideaProject).stream().map(it -> JavaGradleProjectResolver.getCompilerArguments((ExternalProject)it.getSecond())).min(Comparator.comparing(it -> it.size())).orElse(Collections.emptyList());
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    private static List<String> getCompilerArguments(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(57);
        }
        List<String> list = externalProject.getSourceSets().values().stream().map(it -> JavaGradleProjectResolver.getCompilerArguments(it)).min(Comparator.comparing(it -> it.size())).orElse(Collections.emptyList());
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    private static List<String> getCompilerArguments(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(59);
        }
        List list = sourceSet.getCompilerArguments();
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(60);
        }
        return list;
    }

    private void populateProjectSdkModel(@NotNull IdeaProject ideaProject, @NotNull DataNode<? extends ProjectData> projectNode) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(61);
        }
        if (projectNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(62);
        }
        Sdk sdk = this.lookupProjectSdk(ideaProject);
        String sdkName = (String)ObjectUtils.doIfNotNull((Object)sdk, it -> it.getName());
        ProjectSdkData projectSdkData = new ProjectSdkData(sdkName);
        projectNode.createChild(ProjectSdkData.KEY, (Object)projectSdkData);
    }

    private void populateModuleSdkModel(@NotNull IdeaModule ideaModule, @NotNull DataNode<? extends ModuleData> moduleNode, @Nullable ExternalSourceSet sourceSet) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(63);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(64);
        }
        try {
            Sdk sdk = this.lookupModuleSdk(ideaModule, sourceSet);
            String sdkName = (String)ObjectUtils.doIfNotNull((Object)sdk, it -> it.getName());
            ModuleSdkData moduleSdkData = new ModuleSdkData(sdkName);
            moduleNode.createChild(ModuleSdkData.KEY, (Object)moduleSdkData);
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
    }

    @Nullable
    private Sdk lookupProjectSdk(@NotNull IdeaProject ideaProject) {
        String sdkName;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(65);
        }
        if ((sdkName = ideaProject.getJdkName()) != null) {
            return this.resolveSdkByName(sdkName);
        }
        return null;
    }

    @Nullable
    private Sdk lookupModuleSdk(@NotNull IdeaModule ideaModule, @Nullable ExternalSourceSet sourceSet) {
        String sdkName;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(66);
        }
        if ((sdkName = ideaModule.getJdkName()) != null) {
            return this.resolveSdkByName(sdkName);
        }
        File javaToolchainHome = (File)ObjectUtils.doIfNotNull((Object)sourceSet, it -> it.getJavaToolchainHome());
        if (javaToolchainHome != null) {
            return ExternalSystemJdkUtil.lookupJdkByPath((String)NioPathUtil.toCanonicalPath((Path)javaToolchainHome.toPath()));
        }
        return null;
    }

    @Nullable
    private Sdk resolveSdkByName(@NotNull String sdkName) {
        Sdk gradleJvm;
        if (sdkName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(67);
        }
        if ((gradleJvm = this.lookupGradleJvm(sdkName)) != null) {
            return gradleJvm;
        }
        return ExternalSystemJdkUtil.lookupJdkByName((String)sdkName);
    }

    @Nullable
    private Sdk lookupGradleJvm(@NotNull String sdkName) {
        com.intellij.util.lang.JavaVersion expectedSdkVersion;
        if (sdkName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(68);
        }
        if ((expectedSdkVersion = com.intellij.util.lang.JavaVersion.tryParse((String)sdkName)) == null) {
            return null;
        }
        GradleProjectSettings projectSettings = this.getProjectSettings();
        if (projectSettings == null) {
            return null;
        }
        String gradleJvm = projectSettings.getGradleJvm();
        if (gradleJvm == null) {
            return null;
        }
        Sdk sdk = ProjectJdkTable.getInstance().findJdk(gradleJvm);
        if (sdk == null) {
            return null;
        }
        com.intellij.util.lang.JavaVersion actualSdkVersion = com.intellij.util.lang.JavaVersion.tryParse((String)sdk.getVersionString());
        if (actualSdkVersion == null) {
            return null;
        }
        if (actualSdkVersion.feature != expectedSdkVersion.feature) {
            return null;
        }
        return sdk;
    }

    @Nullable
    private GradleProjectSettings getProjectSettings() {
        Project project = this.resolverCtx.getExternalSystemTaskId().findProject();
        if (project != null) {
            GradleSettings settings = GradleSettings.getInstance((Project)project);
            String linkedProjectPath = this.resolverCtx.getProjectPath();
            return (GradleProjectSettings)settings.getLinkedProjectSettings(linkedProjectPath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 14, 21, 33, 35, 45, 46, 56, 58, 60 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 5: 
            case 7: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apModel";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 22: 
            case 34: 
            case 36: 
            case 47: 
            case 52: 
            case 55: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProject";
                break;
            }
            case 23: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectNode";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 37: 
            case 39: 
            case 48: 
            case 50: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 25: 
            case 32: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 27: 
            case 31: 
            case 38: 
            case 42: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 29: 
            case 40: 
            case 41: 
            case 51: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelString";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileOutputPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedAnnotationProcessingData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceSets";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalModules";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreview";
                break;
            }
            case 56: 
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveFinished";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 3: 
            case 14: 
            case 21: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 60: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorOutput";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessingOutput";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMergedAnnotationProcessingData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationProcessingData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "populateBuildScriptClasspathData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateDependenciesGraphData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "populateJavaProjectCompilerSettings";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "populateJavaModuleCompilerSettings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMainModuleData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createSourceSetModuleData";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findSourceSets";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExternalModules";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseLanguageLevel";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTargetBytecodeVersion";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isPreview";
                break;
            }
            case 55: 
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerArguments";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectSdkModel";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleSdkModel";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lookupProjectSdk";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lookupModuleSdk";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolveSdkByName";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJvm";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 14, 21, 33, 35, 45, 46, 56, 58, 60 -> new IllegalStateException(string);
        };
    }
}

