/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.model.pipeline;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSet;
import com.jetbrains.mlapi.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.mlapi.feature.preprocessor.MaybePreprocessKt;
import com.jetbrains.mlapi.model.MLModel;
import com.jetbrains.mlapi.model.MLModelBase;
import com.jetbrains.mlapi.model.prediction.ClassesProbabilities;
import com.jetbrains.mlapi.model.prediction.Logit;
import com.jetbrains.mlapi.model.prediction.Probability;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B1\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u001f0#H\u0014J\u001b\u0010&\u001a\u00028\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u001fH\u0014\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0000H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0000H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0000H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u0002H00\u0000\"\b\b\u0001\u00100*\u00020\u00022\f\u00101\u001a\b\u0012\u0004\u0012\u0002H002H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lcom/jetbrains/mlapi/model/pipeline/ModelPipeline;", "P", "", "Lcom/jetbrains/mlapi/model/MLModelBase;", "preprocessing", "Lcom/jetbrains/mlapi/feature/preprocessor/FeaturePreprocessor;", "baseModel", "Lcom/jetbrains/mlapi/model/MLModel;", "info", "", "", "(Lcom/jetbrains/mlapi/feature/preprocessor/FeaturePreprocessor;Lcom/jetbrains/mlapi/model/MLModel;Ljava/util/Map;)V", "getBaseModel", "()Lcom/jetbrains/mlapi/model/MLModel;", "getInfo", "()Ljava/util/Map;", "inputFeatures", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "getInputFeatures", "()Lcom/jetbrains/mlapi/feature/FeatureSet;", "inputFeatures$delegate", "Lkotlin/Lazy;", "predictedType", "Ljava/lang/Class;", "getPredictedType", "()Ljava/lang/Class;", "getPreprocessing", "()Lcom/jetbrains/mlapi/feature/preprocessor/FeaturePreprocessor;", "buildPredictionsDataFrame", "Lkotlinx/serialization/json/JsonElement;", "predictions", "", "close", "", "predictBatchWithInputFeatures", "", "featuresBatch", "Lcom/jetbrains/mlapi/feature/Feature;", "predictWithInputFeatures", "features", "(Ljava/util/Collection;)Ljava/lang/Object;", "predictingClasses", "Lcom/jetbrains/mlapi/model/prediction/ClassesProbabilities;", "predictingLogit", "Lcom/jetbrains/mlapi/model/prediction/Logit;", "predictingProbability", "Lcom/jetbrains/mlapi/model/prediction/Probability;", "predictingType", "T", "predictionClass", "Lkotlin/reflect/KClass;", "mlapi-core"})
public final class ModelPipeline<P>
extends MLModelBase<P> {
    @Nullable
    private final FeaturePreprocessor preprocessing;
    @NotNull
    private final MLModel<P> baseModel;
    @NotNull
    private final Map<String, Object> info;
    @NotNull
    private final Lazy inputFeatures$delegate;
    @NotNull
    private final Class<? extends P> predictedType;

    public ModelPipeline(@Nullable FeaturePreprocessor preprocessing, @NotNull MLModel<? extends P> baseModel, @NotNull Map<String, ? extends Object> info) {
        Intrinsics.checkNotNullParameter(baseModel, (String)"baseModel");
        Intrinsics.checkNotNullParameter(info, (String)"info");
        this.preprocessing = preprocessing;
        this.baseModel = baseModel;
        this.info = info;
        this.inputFeatures$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FeatureSet>(this){
            final /* synthetic */ ModelPipeline<P> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FeatureSet invoke() {
                if (this.this$0.getPreprocessing() == null) {
                    return this.this$0.getBaseModel().getInputFeatures();
                }
                return this.this$0.getPreprocessing().deduceRequiredInput(this.this$0.getBaseModel().getInputFeatures());
            }
        }));
        this.predictedType = this.baseModel.getPredictedType();
    }

    @Nullable
    public final FeaturePreprocessor getPreprocessing() {
        return this.preprocessing;
    }

    @NotNull
    public final MLModel<P> getBaseModel() {
        return this.baseModel;
    }

    @NotNull
    public final Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public FeatureSet getInputFeatures() {
        Lazy lazy = this.inputFeatures$delegate;
        return (FeatureSet)lazy.getValue();
    }

    @Override
    @NotNull
    public Class<? extends P> getPredictedType() {
        return this.predictedType;
    }

    @Override
    @NotNull
    protected P predictWithInputFeatures(@NotNull Collection<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Collection<Feature> processedFeatures = MaybePreprocessKt.maybePreprocessFeatures(this.preprocessing, features, this.baseModel.getInputFeatures());
        return this.baseModel.predict(processedFeatures);
    }

    @Override
    @NotNull
    public JsonElement buildPredictionsDataFrame(@NotNull Collection<? extends P> predictions) {
        Intrinsics.checkNotNullParameter(predictions, (String)"predictions");
        return this.baseModel.buildPredictionsDataFrame(predictions);
    }

    @Override
    @NotNull
    protected List<P> predictBatchWithInputFeatures(@NotNull List<? extends Collection<? extends Feature>> featuresBatch) {
        Intrinsics.checkNotNullParameter(featuresBatch, (String)"featuresBatch");
        List<Collection<Feature>> processedBatch = MaybePreprocessKt.maybePreprocessFeaturesBatch(this.preprocessing, featuresBatch, this.baseModel.getInputFeatures());
        return this.baseModel.predictBatch(processedBatch);
    }

    @Override
    @NotNull
    public <T> ModelPipeline<T> predictingType(@NotNull KClass<T> predictionClass) {
        Intrinsics.checkNotNullParameter(predictionClass, (String)"predictionClass");
        return new ModelPipeline<T>(this.preprocessing, this.baseModel.predictingType(predictionClass), this.info);
    }

    @NotNull
    public ModelPipeline<ClassesProbabilities> predictingClasses() {
        return this.predictingType(Reflection.getOrCreateKotlinClass(ClassesProbabilities.class));
    }

    @NotNull
    public ModelPipeline<Logit> predictingLogit() {
        return this.predictingType(Reflection.getOrCreateKotlinClass(Logit.class));
    }

    @NotNull
    public ModelPipeline<Probability> predictingProbability() {
        return this.predictingType(Reflection.getOrCreateKotlinClass(Probability.class));
    }

    @Override
    public void close() {
        this.baseModel.close();
    }
}

