/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.review;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequest;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDiscussion;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDraftNote;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabProject;
import org.jetbrains.plugins.gitlab.mergerequest.ui.review.GitLabMergeRequestDiscussionsViewModels;
import org.jetbrains.plugins.gitlab.mergerequest.ui.review.GitLabMergeRequestDiscussionsViewModelsKt;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabMergeRequestDiscussionViewModel;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabMergeRequestDiscussionViewModelBase;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabMergeRequestStandaloneDraftNoteViewModelBase;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteEditingViewModel;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteEditingViewModelKt;
import org.jetbrains.plugins.gitlab.ui.comment.NewGitLabNoteViewModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0016J\u000e\u0010(\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u0002`\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00110\u0010j\u0002`\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u0010j\u0002` X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/GitLabMergeRequestDiscussionsViewModelsImpl;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/GitLabMergeRequestDiscussionsViewModels;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "projectData", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;", "currentUser", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "mergeRequest", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;)V", "cs", "discussions", "Lkotlinx/coroutines/flow/Flow;", "", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestDiscussionViewModel;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/DiscussionsFlow;", "getDiscussions", "()Lkotlinx/coroutines/flow/Flow;", "draftNotes", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestStandaloneDraftNoteViewModelBase;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/DraftNotesFlow;", "getDraftNotes", "_newDiscussions", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/GitLabMergeRequestDiscussionsViewModels$NewDiscussionPosition;", "Lorg/jetbrains/plugins/gitlab/ui/comment/NewGitLabNoteViewModel;", "newDiscussions", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/review/NewDiscussionsFlow;", "getNewDiscussions", "requestNewDiscussion", "", "position", "focus", "", "cancelNewDiscussion", "destroy", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestDiscussionsViewModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestDiscussionsViewModels.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/review/GitLabMergeRequestDiscussionsViewModelsImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,111:1\n198#2,5:112\n230#2,5:117\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestDiscussionsViewModels.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/review/GitLabMergeRequestDiscussionsViewModelsImpl\n*L\n80#1:112,5\n100#1:117,5\n*E\n"})
public final class GitLabMergeRequestDiscussionsViewModelsImpl
implements GitLabMergeRequestDiscussionsViewModels {
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabUserDTO currentUser;
    @NotNull
    private final GitLabMergeRequest mergeRequest;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Flow<Collection<GitLabMergeRequestDiscussionViewModel>> discussions;
    @NotNull
    private final Flow<Collection<GitLabMergeRequestStandaloneDraftNoteViewModelBase>> draftNotes;
    @NotNull
    private final MutableStateFlow<Map<GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition, NewGitLabNoteViewModel>> _newDiscussions;
    @NotNull
    private final Flow<Map<GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition, NewGitLabNoteViewModel>> newDiscussions;

    public GitLabMergeRequestDiscussionsViewModelsImpl(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabProject projectData, @NotNull GitLabUserDTO currentUser, @NotNull GitLabMergeRequest mergeRequest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        this.project = project;
        this.currentUser = currentUser;
        this.mergeRequest = mergeRequest;
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (String)"GitLab Merge Request Review Discussions", (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (boolean)false, (int)4, null);
        this.discussions = (Flow)CoroutineUtilKt.modelFlow((Flow)CoroutineUtilKt.mapModelsToViewModels((Flow)CoroutineUtilKt.throwFailure(this.mergeRequest.getDiscussions()), (arg_0, arg_1) -> GitLabMergeRequestDiscussionsViewModelsImpl.discussions$lambda$0(this, projectData, arg_0, arg_1)), (CoroutineScope)this.cs, (Logger)GitLabMergeRequestDiscussionsViewModelsKt.access$getLOG$p());
        this.draftNotes = (Flow)CoroutineUtilKt.modelFlow((Flow)CoroutineUtilKt.mapModelsToViewModels((Flow)CoroutineUtilKt.mapFiltered((Flow)CoroutineUtilKt.throwFailure(this.mergeRequest.getDraftNotes()), GitLabMergeRequestDiscussionsViewModelsImpl::draftNotes$lambda$1), (arg_0, arg_1) -> GitLabMergeRequestDiscussionsViewModelsImpl.draftNotes$lambda$2(this, arg_0, arg_1)), (CoroutineScope)this.cs, (Logger)GitLabMergeRequestDiscussionsViewModelsKt.access$getLOG$p());
        this._newDiscussions = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.newDiscussions = (Flow)FlowKt.asStateFlow(this._newDiscussions);
    }

    @Override
    @NotNull
    public Flow<Collection<GitLabMergeRequestDiscussionViewModel>> getDiscussions() {
        return this.discussions;
    }

    @Override
    @NotNull
    public Flow<Collection<GitLabMergeRequestStandaloneDraftNoteViewModelBase>> getDraftNotes() {
        return this.draftNotes;
    }

    @Override
    @NotNull
    public Flow<Map<GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition, NewGitLabNoteViewModel>> getNewDiscussions() {
        return this.newDiscussions;
    }

    @Override
    public void requestNewDiscussion(@NotNull GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition position, boolean focus) {
        block3: {
            Map map2;
            Map map3;
            Map nextValue$iv;
            Object prevValue$iv;
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            MutableStateFlow<Map<GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition, NewGitLabNoteViewModel>> $this$updateAndGet$iv = this._newDiscussions;
            boolean $i$f$updateAndGet = false;
            do {
                prevValue$iv = $this$updateAndGet$iv.getValue();
                Map currentNewDiscussions = (Map)prevValue$iv;
                boolean bl = false;
                if (!currentNewDiscussions.containsKey(position) && this.mergeRequest.getCanAddNotes()) {
                    NewGitLabNoteViewModel newGitLabNoteViewModel;
                    NewGitLabNoteViewModel $this$requestNewDiscussion_u24lambda_u244_u24lambda_u243 = newGitLabNoteViewModel = GitLabNoteEditingViewModel.Companion.forNewDiffNote$intellij_vcs_gitlab(this.cs, this.project, this.mergeRequest, this.currentUser, position.getPosition());
                    boolean bl2 = false;
                    GitLabNoteEditingViewModelKt.onDoneIn($this$requestNewDiscussion_u24lambda_u244_u24lambda_u243, this.cs, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, position, null){
                        int label;
                        final /* synthetic */ GitLabMergeRequestDiscussionsViewModelsImpl this$0;
                        final /* synthetic */ GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition $position;
                        {
                            this.this$0 = $receiver;
                            this.$position = $position;
                            super(1, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.this$0.cancelNewDiscussion(this.$position);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    NewGitLabNoteViewModel vm2 = newGitLabNoteViewModel;
                    map3 = MapsKt.plus((Map)currentNewDiscussions, (Pair)TuplesKt.to((Object)position, (Object)vm2));
                    continue;
                }
                map3 = currentNewDiscussions;
            } while (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = map3)));
            Map $this$requestNewDiscussion_u24lambda_u245 = map2 = nextValue$iv;
            boolean bl = false;
            if (!focus) break block3;
            NewGitLabNoteViewModel newGitLabNoteViewModel = (NewGitLabNoteViewModel)$this$requestNewDiscussion_u24lambda_u245.get(position);
            if (newGitLabNoteViewModel != null) {
                newGitLabNoteViewModel.requestFocus();
            }
        }
    }

    @Override
    public void cancelNewDiscussion(@NotNull GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition position) {
        Map newMap;
        Map nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        MutableStateFlow<Map<GitLabMergeRequestDiscussionsViewModels.NewDiscussionPosition, NewGitLabNoteViewModel>> $this$update$iv = this._newDiscussions;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            Map it = (Map)prevValue$iv;
            boolean bl = false;
            NewGitLabNoteViewModel oldVm = (NewGitLabNoteViewModel)it.get(position);
            newMap = MapsKt.minus((Map)it, (Object)position);
            BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(oldVm, null){
                int label;
                final /* synthetic */ NewGitLabNoteViewModel $oldVm;
                {
                    this.$oldVm = $oldVm;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            NewGitLabNoteViewModel newGitLabNoteViewModel = this.$oldVm;
                            if (newGitLabNoteViewModel == null) break;
                            this.label = 1;
                            Object object2 = newGitLabNoteViewModel.destroy((Continuation<? super Unit>)((Continuation)this));
                            if (object2 == object) {
                                return object;
                            }
                            break;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = newMap)));
    }

    @Nullable
    public final Object destroy(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineUtilKt.cancelAndJoinSilently((CoroutineScope)this.cs, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final GitLabMergeRequestDiscussionViewModelBase discussions$lambda$0(GitLabMergeRequestDiscussionsViewModelsImpl this$0, GitLabProject $projectData, CoroutineScope $this$mapModelsToViewModels, GitLabMergeRequestDiscussion it) {
        Intrinsics.checkNotNullParameter((Object)$this$mapModelsToViewModels, (String)"$this$mapModelsToViewModels");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new GitLabMergeRequestDiscussionViewModelBase(this$0.project, $this$mapModelsToViewModels, $projectData, this$0.currentUser, it);
    }

    private static final boolean draftNotes$lambda$1(GitLabMergeRequestDraftNote it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDiscussionId() == null;
    }

    private static final GitLabMergeRequestStandaloneDraftNoteViewModelBase draftNotes$lambda$2(GitLabMergeRequestDiscussionsViewModelsImpl this$0, CoroutineScope $this$mapModelsToViewModels, GitLabMergeRequestDraftNote it) {
        Intrinsics.checkNotNullParameter((Object)$this$mapModelsToViewModels, (String)"$this$mapModelsToViewModels");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new GitLabMergeRequestStandaloneDraftNoteViewModelBase(this$0.project, $this$mapModelsToViewModels, it, this$0.mergeRequest);
    }
}

