/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.ManagedContext;
import org.zeromq.SocketType;
import org.zeromq.ZFrame;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZMQ;

public class ZSocket
implements AutoCloseable {
    private final SocketBase socketBase;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public ZSocket(int socketType) {
        this.socketBase = ManagedContext.getInstance().createSocket(socketType);
    }

    public ZSocket(SocketType socketType) {
        this(socketType.type());
    }

    public SocketType getSocketType() {
        return SocketType.type(this.getType());
    }

    public int getType() {
        return (Integer)this.getOption(16);
    }

    public boolean bind(String endpoint) {
        boolean result = this.socketBase.bind(endpoint);
        this.mayRaise();
        return result;
    }

    public boolean unbind(String endpoint) {
        boolean result = this.socketBase.bind(endpoint);
        this.mayRaise();
        return result;
    }

    public boolean connect(String endpoint) {
        boolean result = this.socketBase.connect(endpoint);
        this.mayRaise();
        return result;
    }

    public boolean disconnect(String endpoint) {
        boolean result = this.socketBase.termEndpoint(endpoint);
        this.mayRaise();
        return result;
    }

    public final boolean hasReceiveMore() {
        return (Integer)this.getOption(13) == 1;
    }

    public void subscribe(byte[] topic) {
        this.setOption(6, topic);
    }

    public void subscribe(String topic) {
        this.setOption(6, topic.getBytes(ZMQ.CHARSET));
    }

    public void unsubscribe(byte[] topic) {
        this.setOption(7, topic);
    }

    public void unsubscribe(String topic) {
        this.setOption(7, topic.getBytes(ZMQ.CHARSET));
    }

    public int send(byte[] b) {
        return this.send(b, 0);
    }

    public int send(byte[] b, int flags) {
        Msg msg = new Msg(b);
        if (this.socketBase.send(msg, flags)) {
            return msg.size();
        }
        this.mayRaise();
        return -1;
    }

    public int sendMessage(Msg msg, int flags) {
        if (this.socketBase.send(msg, flags)) {
            return msg.size();
        }
        this.mayRaise();
        return -1;
    }

    public int sendMessage(Msg msg) {
        return this.sendMessage(msg, 0);
    }

    public boolean sendFrame(ZFrame frame, int flags) {
        byte[] data = frame.getData();
        Msg msg = new Msg(data);
        if (this.socketBase.send(msg, flags)) {
            return true;
        }
        this.mayRaise();
        return false;
    }

    public boolean sendMessage(ZMsg message) {
        ZFrame frame = message.pop();
        boolean rc = false;
        while (frame != null && (rc = this.sendFrame(frame, !message.isEmpty() ? 1 : 0))) {
            frame = message.pop();
        }
        return rc;
    }

    public int sendStringUtf8(String str) {
        return this.sendStringUtf8(str, 0);
    }

    public int sendStringUtf8(String str, int flags) {
        byte[] b = str.getBytes(ZMQ.CHARSET);
        return this.send(b, flags);
    }

    public byte[] receive() {
        return this.receive(0);
    }

    public byte[] receive(int flags) {
        Msg msg = this.socketBase.recv(flags);
        if (msg == null) {
            return null;
        }
        return msg.data();
    }

    public Msg receiveMessage() {
        return this.socketBase.recv(0);
    }

    public Msg receiveMessage(int flags) {
        return this.socketBase.recv(flags);
    }

    public String receiveStringUtf8() {
        return this.receiveStringUtf8(0);
    }

    public String receiveStringUtf8(int flags) {
        byte[] b = this.receive(flags);
        return new String(b, ZMQ.CHARSET);
    }

    private void mayRaise() {
        int errno = this.socketBase.errno();
        if (errno != 0 && errno != 35) {
            throw new ZMQException(errno);
        }
    }

    private void setOption(int option2, Object value) {
        this.socketBase.setSocketOpt(option2, value);
    }

    private Object getOption(int option2) {
        return this.socketBase.getSocketOptx(option2);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            ManagedContext.getInstance().destroy(this.socketBase);
        }
    }
}

