/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ro extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabă";
        final String metaValue_hy = "armeană";
        final String metaValue_ban = "balineză";
        final String metaValue_bn = "bengaleză";
        final String metaValue_bug = "bugineză";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "coptă";
        final String metaValue_ka = "georgiană";
        final String metaValue_got = "gotică";
        final String metaValue_el = "greacă";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraică";
        final String metaValue_jv = "javaneză";
        final String metaValue_ja = "japoneză";
        final String metaValue_kaw = "kawi";
        final String metaValue_km = "khmeră";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreeană";
        final String metaValue_lo = "laoțiană";
        final String metaValue_la = "latină";
        final String metaValue_mak = "makasar";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolă";
        final String metaValue_my = "birmană";
        final String metaValue_nqo = "n’ko";
        final String metaValue_osa = "osage";
        final String metaValue_phn = "feniciană";
        final String metaValue_su = "sundaneză";
        final String metaValue_syr = "siriacă";
        final String metaValue_ta = "tamilă";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thailandeză";
        final String metaValue_bo = "tibetană";
        final String metaValue_uga = "ugaritică";
        final String metaValue_peo = "persană veche";
        final Object[][] data = new Object[][] {
            { "001", "Lume" },
            { "002", "Africa" },
            { "003", "America de Nord" },
            { "005", "America de Sud" },
            { "009", "Oceania" },
            { "011", "Africa Occidentală" },
            { "013", "America Centrală" },
            { "014", "Africa Orientală" },
            { "015", "Africa Septentrională" },
            { "017", "Africa Centrală" },
            { "018", "Africa Meridională" },
            { "019", "Americi" },
            { "021", "America Septentrională" },
            { "029", "Caraibe" },
            { "030", "Asia Orientală" },
            { "034", "Asia Meridională" },
            { "035", "Asia de Sud-Est" },
            { "039", "Europa Meridională" },
            { "053", "Australasia" },
            { "054", "Melanezia" },
            { "057", "Regiunea Micronezia" },
            { "061", "Polinezia" },
            { "142", "Asia" },
            { "143", "Asia Centrală" },
            { "145", "Asia Occidentală" },
            { "150", "Europa" },
            { "151", "Europa Orientală" },
            { "154", "Europa Septentrională" },
            { "155", "Europa Occidentală" },
            { "202", "Africa Subsahariană" },
            { "419", "America Latină" },
            { "AC", "Insula Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emiratele Arabe Unite" },
            { "AF", "Afganistan" },
            { "AG", "Antigua și Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americană" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Insulele Åland" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bosnia și Herțegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Insulele Caraibe Olandeze" },
            { "BR", "Brazilia" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Insula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Insulele Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republica Centrafricană" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Elveția" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Insulele Cook" },
            { "CL", "Chile" },
            { "CM", "Camerun" },
            { "CN", "China" },
            { "CO", "Columbia" },
            { "CP", "Insula Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capul Verde" },
            { "CW", "Curaçao" },
            { "CX", "Insula Christmas" },
            { "CY", "Cipru" },
            { "CZ", "Cehia" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemarca" },
            { "DM", "Dominica" },
            { "DO", "Republica Dominicană" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta și Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara Occidentală" },
            { "ER", "Eritreea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Uniunea Europeană" },
            { "EZ", "Zona euro" },
            { "FI", "Finlanda" },
            { "FJ", "Fiji" },
            { "FK", "Insulele Falkland" },
            { "FM", "Micronezia" },
            { "FO", "Insulele Feroe" },
            { "FR", "Franța" },
            { "GA", "Gabon" },
            { "GB", "Regatul Unit" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Franceză" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlanda" },
            { "GM", "Gambia" },
            { "GN", "Guineea" },
            { "GP", "Guadelupa" },
            { "GQ", "Guineea Ecuatorială" },
            { "GR", "Grecia" },
            { "GS", "Georgia de Sud și Insulele Sandwich de Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guineea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "R.A.S. Hong Kong, China" },
            { "HM", "Insula Heard și Insulele McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croația" },
            { "HT", "Haiti" },
            { "HU", "Ungaria" },
            { "IC", "Insulele Canare" },
            { "ID", "Indonezia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Insula Man" },
            { "IN", "India" },
            { "IO", "Teritoriul Britanic din Oceanul Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Iordania" },
            { "JP", "Japonia" },
            { "KE", "Kenya" },
            { "KG", "Kârgâzstan" },
            { "KH", "Cambodgia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "KN", "Saint Kitts și Nevis" },
            { "KP", "Coreea de Nord" },
            { "KR", "Coreea de Sud" },
            { "KW", "Kuweit" },
            { "KY", "Insulele Cayman" },
            { "KZ", "Kazahstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sfânta Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburg" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Republica Moldova" },
            { "ME", "Muntenegru" },
            { "MF", "Sfântul Martin" },
            { "MG", "Madagascar" },
            { "MH", "Insulele Marshall" },
            { "MK", "Macedonia de Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "R.A.S. Macao, China" },
            { "MP", "Insulele Mariane de Nord" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Mexic" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambic" },
            { "NA", "Namibia" },
            { "NC", "Noua Caledonie" },
            { "NE", "Niger" },
            { "NF", "Insula Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Țările de Jos" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Noua Zeelandă" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezia Franceză" },
            { "PG", "Papua-Noua Guinee" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Saint-Pierre și Miquelon" },
            { "PN", "Insulele Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Teritoriile Palestiniene" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania Periferică" },
            { "RE", "Réunion" },
            { "RO", "România" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudită" },
            { "SB", "Insulele Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Suedia" },
            { "SG", "Singapore" },
            { "SH", "Sfânta Elena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard și Jan Mayen" },
            { "SK", "Slovacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudanul de Sud" },
            { "ST", "São Tomé și Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Insulele Turks și Caicos" },
            { "TD", "Ciad" },
            { "TF", "Teritoriile Australe și Antarctice Franceze" },
            { "TG", "Togo" },
            { "TH", "Thailanda" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turcia" },
            { "TT", "Trinidad și Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Insulele Îndepărtate ale S.U.A." },
            { "UN", "Națiunile Unite" },
            { "US", "Statele Unite ale Americii" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Statul Cetății Vaticanului" },
            { "VC", "Saint Vincent și Grenadinele" },
            { "VE", "Venezuela" },
            { "VG", "Insulele Virgine Britanice" },
            { "VI", "Insulele Virgine Americane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis și Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-accente" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Africa de Sud" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regiune necunoscută" },
            { "aa", "afar" },
            { "ab", "abhază" },
            { "ae", "avestană" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharică" },
            { "an", "aragoneză" },
            { "ar", metaValue_ar },
            { "as", "asameză" },
            { "av", "avară" },
            { "ay", "aymara" },
            { "az", "azeră" },
            { "ba", "bașkiră" },
            { "be", "belarusă" },
            { "bg", "bulgară" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonă" },
            { "bs", "bosniacă" },
            { "ca", "catalană" },
            { "ce", "cecenă" },
            { "ch", "chamorro" },
            { "co", "corsicană" },
            { "cr", "cree" },
            { "cs", "cehă" },
            { "cu", "slavonă" },
            { "cv", "ciuvașă" },
            { "cy", "galeză" },
            { "da", "daneză" },
            { "de", "germană" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "engleză" },
            { "eo", "esperanto" },
            { "es", "spaniolă" },
            { "et", "estonă" },
            { "eu", "bască" },
            { "fa", "persană" },
            { "ff", "fulah" },
            { "fi", "finlandeză" },
            { "fj", "fijiană" },
            { "fo", "feroeză" },
            { "fr", "franceză" },
            { "fy", "frizonă occidentală" },
            { "ga", "irlandeză" },
            { "gd", "gaelică scoțiană" },
            { "gl", "galiciană" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croată" },
            { "ht", "haitiană" },
            { "hu", "maghiară" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indoneziană" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi din Sichuan" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandeză" },
            { "it", "italiană" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "congoleză" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazahă" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cașmiră" },
            { "ku", "kurmangi" },
            { "kv", "komi" },
            { "kw", "cornică" },
            { "ky", "kârgâză" },
            { "la", metaValue_la },
            { "lb", "luxemburgheză" },
            { "lg", "ganda" },
            { "li", "limburgheză" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituaniană" },
            { "lu", "luba-katanga" },
            { "lv", "letonă" },
            { "mg", "malgașă" },
            { "mh", "marshalleză" },
            { "mi", "maori" },
            { "mk", "macedoneană" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaeză" },
            { "mt", "malteză" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norvegiană bokmål" },
            { "nd", "ndebele de nord" },
            { "ne", "nepaleză" },
            { "ng", "ndonga" },
            { "nl", "neerlandeză" },
            { "nn", "norvegiană nynorsk" },
            { "no", "norvegiană" },
            { "nr", "ndebele de sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitană" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "odia" },
            { "os", "osetă" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "poloneză" },
            { "ps", "paștună" },
            { "pt", "portugheză" },
            { "qu", "quechua" },
            { "rm", "romanșă" },
            { "rn", "kirundi" },
            { "ro", "română" },
            { "ru", "rusă" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrită" },
            { "sc", "sardiniană" },
            { "sd", "sindhi" },
            { "se", "sami de nord" },
            { "sg", "sango" },
            { "sh", "sârbo-croată" },
            { "si", "singhaleză" },
            { "sk", "slovacă" },
            { "sl", "slovenă" },
            { "sm", "samoană" },
            { "sn", "shona" },
            { "so", "somaleză" },
            { "sq", "albaneză" },
            { "sr", "sârbă" },
            { "ss", "swati" },
            { "st", "sesotho" },
            { "su", metaValue_su },
            { "sv", "suedeză" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjică" },
            { "th", metaValue_th },
            { "ti", "tigrină" },
            { "tk", "turkmenă" },
            { "tl", metaValue_tl },
            { "tn", "setswana" },
            { "to", "tongană" },
            { "tr", "turcă" },
            { "ts", "tsonga" },
            { "tt", "tătară" },
            { "tw", "twi" },
            { "ty", "tahitiană" },
            { "ug", "uigură" },
            { "uk", "ucraineană" },
            { "ur", "urdu" },
            { "uz", "uzbecă" },
            { "ve", "venda" },
            { "vi", "vietnameză" },
            { "vo", "volapuk" },
            { "wa", "valonă" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "idiș" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chineză" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadiană" },
            { "ale", "aleută" },
            { "alt", "altaică meridională" },
            { "ang", "engleză veche" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramaică" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "arabă najdi" },
            { "arw", "arawak" },
            { "asa", "asu" },
            { "ast", "asturiană" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "baluchi occidentală" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuană" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "jargon chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurdă centrală" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "turcă crimeeană" },
            { "crj", "cree de sud-est" },
            { "crk", "cree (Prerii)" },
            { "crl", "cree de nord-est" },
            { "crm", "cree (Moose)" },
            { "crr", "algonquiană Carolina" },
            { "crs", "creolă franceză seselwa" },
            { "csb", "cașubiană" },
            { "csw", "cree (Mlaștini)" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "sorabă de jos" },
            { "dua", "duala" },
            { "dum", "neerlandeză medie" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "egipteană veche" },
            { "eka", "ekajuk" },
            { "elx", "elamită" },
            { "enm", "engleză medie" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipineză" },
            { "fon", "fon" },
            { "frc", "franceză cajun" },
            { "frm", "franceză medie" },
            { "fro", "franceză veche" },
            { "frr", "frizonă nordică" },
            { "frs", "frizonă orientală" },
            { "fur", "friulană" },
            { "gaa", "ga" },
            { "gag", "găgăuză" },
            { "gan", "chineză gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertină" },
            { "gmh", "germană înaltă medie" },
            { "goh", "germană înaltă veche" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "greacă veche" },
            { "gsw", "germană (Elveția)" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "hak", "chineză hakka" },
            { "haw", "hawaiiană" },
            { "hax", "haida de sud" },
            { "hil", "hiligaynon" },
            { "hit", "hitită" },
            { "hmn", "hmong" },
            { "hsb", "sorabă de sus" },
            { "hsn", "chineză xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadiană occidentală" },
            { "ilo", "iloko" },
            { "inh", "ingușă" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "iudeo-persană" },
            { "jrb", "iudeo-arabă" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "kabardian" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotaneză" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karaceai-balkar" },
            { "krl", "kareliană" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lij", "liguriană" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardă" },
            { "lol", "mongo" },
            { "lou", "creolă (Louisiana)" },
            { "loz", "lozi" },
            { "lrc", "luri de nord" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madureză" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "irlandeză medie" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manciuriană" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "mai multe limbi" },
            { "mus", "creek" },
            { "mwl", "mirandeză" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "chineză min nan" },
            { "nap", "napolitană" },
            { "naq", "nama" },
            { "nds", "germana de jos" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueană" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "nordică veche" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho de nord" },
            { "nus", "nuer" },
            { "nwc", "newari clasică" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa de nord-vest" },
            { "ojc", "ojibwa centrală" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa de vest" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "ota", "turcă otomană" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauană" },
            { "pcm", "pidgin nigerian" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pon", "pohnpeiană" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prusacă" },
            { "pro", "provensală veche" },
            { "quc", "quiché" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongan" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromână" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "aramaică samariteană" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliană" },
            { "sco", "scots" },
            { "sdh", "kurdă de sud" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro Senni" },
            { "sga", "irlandeză veche" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "arabă ciadiană" },
            { "sid", "sidamo" },
            { "slh", "lushootseed de usd" },
            { "sma", "sami de sud" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "salish (Strâmtori)" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriană" },
            { "swb", "comoreză" },
            { "syc", "siriacă clasică" },
            { "syr", metaValue_syr },
            { "szl", "sileziană" },
            { "tce", "tutchone de sud" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingoniană" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone de nord" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvană" },
            { "tzm", "tamazight din Atlasul Central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "limbă necunoscută" },
            { "vec", "venetă" },
            { "vmw", "makhuwa" },
            { "vot", "votică" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chineză wu" },
            { "xal", "calmucă" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapeză" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantoneză" },
            { "zap", "zapotecă" },
            { "zbl", "simboluri Bilss" },
            { "zen", "zenaga" },
            { "zgh", "tamazight standard marocană" },
            { "zun", "zuni" },
            { "zxx", "fară conținut lingvistic" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Aghb", "albaneză caucaziană" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaaliq" },
            { "Armi", "aramaică imperială" },
            { "Armn", metaValue_hy },
            { "Avst", "avestică" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmanică" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhidă" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabică aborigenă canadiană unificată" },
            { "Cari", "cariană" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "khorezmiană" },
            { "Copt", metaValue_cop },
            { "Cpmn", "cipro-minoană" },
            { "Cprt", "cipriotă" },
            { "Cyrl", "chirilică" },
            { "Cyrs", "chirilică slavonă bisericească veche" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogra" },
            { "Dsrt", "mormonă" },
            { "Dupl", "stenografie duployană" },
            { "Egyd", "demotică egipteană" },
            { "Egyh", "hieratică egipteană" },
            { "Egyp", "hieroglife egiptene" },
            { "Elba", "elbasan" },
            { "Elym", "elimaică" },
            { "Ethi", "etiopiană" },
            { "Geok", "georgiană bisericească" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitică" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "masaram gondi" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificată" },
            { "Hant", "tradițională" },
            { "Hatr", "hatrană" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "hieroglife anatoliene" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "silabică japoneză" },
            { "Hung", "maghiară veche" },
            { "Inds", "indus" },
            { "Ital", "italică veche" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Kits", "litere mici khitane" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latină Fraktur" },
            { "Latg", "latină gaelică" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineară A" },
            { "Linb", "lineară B" },
            { "Lisu", "fraser" },
            { "Lyci", "liciană" },
            { "Lydi", "lidiană" },
            { "Mahj", "mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "mandeană" },
            { "Mani", "maniheeană" },
            { "Marc", "marchen" },
            { "Maya", "hieroglife maya" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "meroitică cursivă" },
            { "Mero", "meroitică" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "nag mundari" },
            { "Nand", "nandinagari" },
            { "Narb", "arabă veche din nord" },
            { "Nbat", "nabateeană" },
            { "Newa", "newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orhon" },
            { "Orya", "oriya" },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Ougr", "uigură veche" },
            { "Palm", "palmirenă" },
            { "Pauc", "pau cin hau" },
            { "Perm", "permică veche" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi pentru inscripții" },
            { "Phlp", "pahlavi pentru psaltire" },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollardă fonetică" },
            { "Prti", "partă pentru inscripții" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Runr", "runică" },
            { "Samr", "samariteană" },
            { "Sarb", "arabă veche din sud" },
            { "Saur", "saurashtra" },
            { "Sgnw", "scrierea simbolică" },
            { "Shaw", "savă" },
            { "Shrd", "sharadă" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", "singaleză" },
            { "Sogd", "sogdiană" },
            { "Sogo", "sogdiană veche" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syrj", "siriacă occidentală" },
            { "Syrn", "siriacă orientală" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai le nouă" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancho" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiformă sumero-akkadiană" },
            { "Yezi", "yazidită" },
            { "Yiii", "yi" },
            { "Zanb", "Piața Zanabazar" },
            { "Zinh", "moștenită" },
            { "Zmth", "notație matematică" },
            { "Zsye", "emoji" },
            { "Zsym", "simboluri" },
            { "Zxxx", "nescrisă" },
            { "Zyyy", "comună" },
            { "Zzzz", "scriere necunoscută" },
            { "de_CH", "germană standard (Elveția)" },
            { "es_ES", "spaniolă (Europa)" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamandă" },
            { "pt_PT", "portugheză (Europa)" },
            { "sw_CD", "swahili (R.D. Congo)" },
            { "%%1901", "ortografie germană tradițională" },
            { "%%1994", "ortografie resiană standardizată" },
            { "%%1996", "ortografie germană de la 1996" },
            { "ar_001", "arabă standard modernă" },
            { "key.ca", "tip calendar" },
            { "key.cf", "Format monedă" },
            { "key.co", "ordine de sortare" },
            { "key.cu", "monedă" },
            { "key.em", "Prezentare emojiuri" },
            { "key.hc", "ciclu orar (12 sau 24)" },
            { "key.lb", "stil de întrerupere a rândului (chineză, japoneză, coreeană)" },
            { "key.lw", "întrerupere a rândului în interiorul cuvântului" },
            { "key.ms", "sistem de unități de măsură" },
            { "key.nu", "numere" },
            { "key.ss", "întrerupere propoziție după abr." },
            { "key.tz", "fus orar" },
            { "key.va", "variantă locală" },
            { "nds_NL", "saxona de jos" },
            { "%%ALUKU", "dialect aluku" },
            { "%%BARLA", "grupul de dialecte barlavento al limbii kabuverdianu" },
            { "%%BISKE", "dialect San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%CORNU", "Cornu" },
            { "%%GALLO", "Gallo" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "ortografie comuna cornish" },
            { "%%KSCOR", "ortografie standard" },
            { "%%LIPAW", "dialect lipovaz din resiană" },
            { "%%NEDIS", "dialect Natisone" },
            { "%%NJIVA", "dialect Gniva/Njiva" },
            { "%%NULIK", "volapük modernă" },
            { "%%OSOJS", "dialect Oseacco/Osojane" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "informatică" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "volapük clasică" },
            { "%%ROZAJ", "dialect resian" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "dialect saho" },
            { "%%SOLBA", "dialect Stolvizza/Solbica" },
            { "%%SOTAV", "grupul de dialecte sotavento al limbii kabuverdianu" },
            { "%%UCCOR", "ortografie unificată cornish" },
            { "zh_Hans", "chineză simplificată" },
            { "zh_Hant", "chineză tradițională" },
            { "%%AO1990", "Acordul de ortografie a limbii portugheze de la 1990" },
            { "%%ARANES", "Aranes" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvern" },
            { "%%CISAUP", "Cisaup" },
            { "%%CREISS", "Creiss" },
            { "%%DAJNKO", "alfabet dajnko" },
            { "%%EKAVSK", "sârbă cu pronunție ekaviană" },
            { "%%FONIPA", "alfabet fonetic internațional" },
            { "%%FONUPA", "alfabet fonetic uralic" },
            { "%%GASCON", "Gascon" },
            { "%%GRITAL", "Grital" },
            { "%%NDYUKA", "dialect ndyuka" },
            { "%%NICARD", "Nicard" },
            { "%%PAMAKA", "dialect pamaka" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "dialect scouse" },
            { "%%SIMPLE", "Simple" },
            { "%%TARASK", "ortografie taraskievica" },
            { "%%UCRCOR", "ortografie revizuită unificată cornish" },
            { "%%ULSTER", "Ulster" },
            { "%%UNIFON", "alfabet fonetic unifon" },
            { "%%ABL1943", "formularea ortografică de la 1943" },
            { "%%AKUAPEM", "Akuapem" },
            { "%%ALALC97", "ALA-LC, ediția din 1997" },
            { "%%AREVELA", "armeană orientală" },
            { "%%AREVMDA", "armeană occidentală" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%BALANKA", "dialectul balanka al limbii anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "alfabet Bohorič" },
            { "%%EMODENG", "limba engleză modernă timpurie" },
            { "%%FONNAPA", "Fonnapa" },
            { "%%GRCLASS", "Grclass" },
            { "%%GRMISTR", "Grmistr" },
            { "%%HEPBURN", "hepburn" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Lemosin" },
            { "%%METELKO", "alfabet metelko" },
            { "%%MONOTON", "monotonică" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "%%POLYTON", "politonică" },
            { "%%PROVENC", "Provenc" },
            { "%%REVISED", "ortografie revizuită" },
            { "%%SURSILV", "Sursilv" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "franceză medievală târzie până la 1606" },
            { "%%1694ACAD", "franceză modernă veche" },
            { "%%1959ACAD", "belarusă academică" },
            { "%%BAKU1926", "alfabet latin altaic unificat" },
            { "%%BASICENG", "Basiceng" },
            { "%%BISCAYAN", "Biscayan" },
            { "%%BORNHOLM", "Bornholm" },
            { "%%COLB1945", "Convenția ortografică a limbii portugheze braziliene de la 1945" },
            { "%%FONKIRSH", "Fonkirsh" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hognorsk" },
            { "%%HSISTEMO", "Hsistemo" },
            { "%%IJEKAVSK", "sârbă cu pronunție ijekaviană" },
            { "%%IVANCHOV", "Ivanchov" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Lengadoc" },
            { "%%LUNA1918", "Luna1918" },
            { "%%NEWFOUND", "Newfound" },
            { "%%OXENDICT", "ortografia dicționarului Oxford de limbă engleză" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "engleză standard scoțiană" },
            { "%%SPANGLIS", "Spanglis" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Synnejyl" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiit" },
            { "%%VALENCIA", "valenciană" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vecdruka" },
            { "%%VIVARAUP", "Vivaraup" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%XSISTEMO", "Xsistemo" },
            { "type.ca.roc", "calendarul Republicii Chineze" },
            { "type.co.eor", "regulile europene de sortare" },
            { "type.hc.h11", "sistem cu 12 ore (0–11)" },
            { "type.hc.h12", "sistem cu 12 ore (1–12)" },
            { "type.hc.h23", "sistem cu 24 de ore (0–23)" },
            { "type.hc.h24", "sistem cu 24 de ore (1–24)" },
            { "type.m0.bgn", "transliterare BGN SUA" },
            { "type.nu.ahom", "cifre ahom" },
            { "type.nu.arab", "cifre indo-arabe" },
            { "type.nu.armn", "numerale armenești" },
            { "type.nu.bali", "cifre balineze" },
            { "type.nu.beng", "cifre bengaleze" },
            { "type.nu.brah", "cifre brahmi" },
            { "type.nu.cakm", "cifre chakma" },
            { "type.nu.cham", "cifre cham" },
            { "type.nu.cyrl", "cifre chirilice" },
            { "type.nu.deva", "cifre devanagari" },
            { "type.nu.diak", "cifre dives akuru" },
            { "type.nu.ethi", "numerale etiopiene" },
            { "type.nu.geor", "numerale georgiene" },
            { "type.nu.gong", "cifre gunjala gondi" },
            { "type.nu.gonm", "cifre masaram gondi" },
            { "type.nu.grek", "numerale grecești" },
            { "type.nu.gujr", "cifre gujarati" },
            { "type.nu.guru", "cifre gurmukhi" },
            { "type.nu.hans", "numerale chinezești simplificate" },
            { "type.nu.hant", "numerale chinezești tradiționale" },
            { "type.nu.hebr", "numerale ebraice" },
            { "type.nu.hmng", "cifre pahawh hmong" },
            { "type.nu.hmnp", "cifre nyiakeng puachue hmong" },
            { "type.nu.java", "cifre javaneze" },
            { "type.nu.jpan", "numerale japoneze" },
            { "type.nu.kali", "cifre kayah li" },
            { "type.nu.kawi", "cifre kawi" },
            { "type.nu.khmr", "cifre khmere" },
            { "type.nu.knda", "cifre kannada" },
            { "type.nu.lana", "cifre tai tham hora" },
            { "type.nu.laoo", "cifre laoțiene" },
            { "type.nu.latn", "cifre occidentale" },
            { "type.nu.lepc", "cifre lepcha" },
            { "type.nu.limb", "cifre limbu" },
            { "type.nu.mlym", "cifre malayalam" },
            { "type.nu.modi", "cifre modi" },
            { "type.nu.mong", "Cifre mongole" },
            { "type.nu.mroo", "cifre mro" },
            { "type.nu.mtei", "cifre meetei mayek" },
            { "type.nu.mymr", "cifre birmaneze" },
            { "type.nu.nagm", "cifre nag mundari" },
            { "type.nu.nkoo", "cifre n’ko" },
            { "type.nu.olck", "cifre ol chiki" },
            { "type.nu.orya", "cifre oriya" },
            { "type.nu.osma", "cifre osmanya" },
            { "type.nu.rohg", "cifre hanifi rohingya" },
            { "type.nu.saur", "cifre saurashtra" },
            { "type.nu.shrd", "cifre sharada" },
            { "type.nu.sind", "cifre khudawadi" },
            { "type.nu.sinh", "cifre sinhala lith" },
            { "type.nu.sora", "cifre sora sompeng" },
            { "type.nu.sund", "cifre sundaneze" },
            { "type.nu.takr", "cifre takri" },
            { "type.nu.talu", "cifre tai lue noi" },
            { "type.nu.taml", "numerale tradiționale tamile" },
            { "type.nu.telu", "cifre telugu" },
            { "type.nu.thai", "cifre thailandeze" },
            { "type.nu.tibt", "cifre tibetane" },
            { "type.nu.tirh", "cifre tirhuta" },
            { "type.nu.tnsa", "cifre tangsa" },
            { "type.nu.vaii", "cifre vai" },
            { "type.nu.wara", "cifre warang citi" },
            { "type.nu.wcho", "cifre wancho" },
            { "type.ca.dangi", "calendar dangi" },
            { "type.co.ducet", "ordine de sortare Unicode implicită" },
            { "type.co.emoji", "ordine de sortare a emojiurilor" },
            { "type.lb.loose", "stil liber de întrerupere a liniei" },
            { "type.nu.roman", "numerale romane" },
            { "type.ca.coptic", "calendar copt" },
            { "type.ca.hebrew", "calendar ebraic" },
            { "type.ca.indian", "calendar național indian" },
            { "type.co.compat", "ordine de sortare anterioară, pentru compatibilitate" },
            { "type.co.pinyin", "ordine de sortare pinyin" },
            { "type.co.search", "căutare cu scop general" },
            { "type.co.stroke", "ordine de sortare după trasare" },
            { "type.co.unihan", "ordine de sortare după radical și trasare" },
            { "type.co.zhuyin", "ordine de sortare zhuyin" },
            { "type.d0.fwidth", "Cu lățime întreagă" },
            { "type.d0.hwidth", "Cu jumătate de lățime" },
            { "type.lb.normal", "stil de normal întrerupere a rândului" },
            { "type.lb.strict", "stil strict de întrerupere a rândului" },
            { "type.m0.ungegn", "transliterare GEGN ONU" },
            { "type.ms.metric", "sistemul metric" },
            { "type.nu.native", "cifre native" },
            { "type.ca.chinese", "calendar chinezesc" },
            { "type.ca.islamic", "calendarul hegirei" },
            { "type.ca.iso8601", "calendar ISO-8601" },
            { "type.ca.persian", "calendar persan" },
            { "type.cf.account", "Format monedă contabilitate" },
            { "type.d0.npinyin", "Numeric" },
            { "type.nu.arabext", "cifre indo-arabe extinse" },
            { "type.nu.armnlow", "numerale armenești cu minuscule" },
            { "type.nu.finance", "Sistemul numeric financiar" },
            { "type.nu.greklow", "numerale grecești cu minuscule" },
            { "type.nu.hanidec", "numerale zecimale chinezești" },
            { "type.nu.hansfin", "numerale financiare chinezești simplificate" },
            { "type.nu.hantfin", "numerale financiare chinezești tradiționale" },
            { "type.nu.jpanfin", "numerale financiare japoneze" },
            { "type.nu.mathdbl", "cifre matematice cu două linii" },
            { "type.nu.tamldec", "cifre tamile" },
            { "type.ca.buddhist", "calendar budist" },
            { "type.ca.ethiopic", "calendar etiopian" },
            { "type.ca.japanese", "calendar japonez" },
            { "type.cf.standard", "Format monedă standard" },
            { "type.co.phonetic", "ordine de sortare fonetică" },
            { "type.co.searchjl", "Căutați în funcție de consoana inițială hangul" },
            { "type.co.standard", "ordine de sortare standard" },
            { "type.ms.uksystem", "sistemul imperial de unități de măsură" },
            { "type.ms.ussystem", "sistemul american de unități de măsură" },
            { "type.nu.fullwide", "cifre cu lățimea întreagă" },
            { "type.nu.lanatham", "cifre tai tham tham" },
            { "type.nu.mathbold", "cifre matematice aldine" },
            { "type.nu.mathmono", "cifre matematice cu un singur spațiu" },
            { "type.nu.mathsanb", "cifre matematice aldine sans serif" },
            { "type.nu.mathsans", "cifre matematice sans serif" },
            { "type.nu.mymrshan", "cifre birmaneze shan" },
            { "type.nu.mymrtlng", "cifre birmaneze tai laing" },
            { "type.nu.romanlow", "numerale romane cu minuscule" },
            { "type.ca.gregorian", "calendar gregorian" },
            { "type.co.phonebook", "ordine de sortare după cartea de telefon" },
            { "type.co.dictionary", "ordine de sortare a dicționarului" },
            { "type.co.traditional", "ordine de sortare tradițională" },
            { "type.nu.traditional", "Numere tradiționale" },
            { "type.ca.islamic-civil", "calendarul hegirei (tabular, civil)" },
            { "type.ca.islamic-umalqura", "calendarul hegirei (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendar etiopian amete alem" },
        };
        return data;
    }
}
