/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.jre;

import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.AbstractUnixTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.transport.jre.NativeUnixSocketHelper;
import org.freedesktop.dbus.transport.jre.UnixBusAddress;

public class NativeUnixSocketTransport
extends AbstractUnixTransport {
    private final UnixDomainSocketAddress unixSocketAddress;
    private SocketChannel socket;
    private ServerSocketChannel serverSocket;

    NativeUnixSocketTransport(UnixBusAddress _address, TransportConfig _config) throws TransportConfigurationException {
        super((BusAddress)_address, _config);
        if (!_address.hasPath()) {
            throw new TransportConfigurationException("Native unix socket url has to specify 'path'");
        }
        this.unixSocketAddress = UnixDomainSocketAddress.of(_address.getPath());
        this.getSaslConfig().setAuthMode(1);
    }

    protected boolean hasFileDescriptorSupport() {
        return false;
    }

    public SocketChannel connectImpl() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            throw new IOException("Connect connect to a listening socket (use listenImpl() instead)");
        }
        this.socket = SocketChannel.open(this.unixSocketAddress);
        this.socket.configureBlocking(true);
        return this.socket;
    }

    protected void bindImpl() throws IOException {
        if (!this.getAddress().isListeningSocket()) {
            throw new IOException("Cannot listen on a client connection (use connectImpl() instead)");
        }
        if (!this.isBound()) {
            this.serverSocket = ServerSocketChannel.open(StandardProtocolFamily.UNIX).bind(this.unixSocketAddress);
            this.serverSocket.configureBlocking(true);
        }
    }

    public SocketChannel acceptImpl() throws IOException {
        this.socket = this.serverSocket.accept();
        this.socket.configureBlocking(true);
        return this.socket;
    }

    protected boolean isBound() {
        return this.serverSocket != null && this.serverSocket.isOpen();
    }

    protected void closeTransport() throws IOException {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
        }
        if (this.serverSocket != null && this.serverSocket.isOpen()) {
            this.serverSocket.close();
            Files.deleteIfExists(this.unixSocketAddress.getPath());
        }
    }

    public int getUid(SocketChannel _sock) throws IOException {
        return NativeUnixSocketHelper.getUid(_sock);
    }
}

