/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.schedulers;

import io.reactivex.rxjava3.annotations.Experimental;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class TestScheduler
extends Scheduler {
    final Queue<TimedRunnable> queue = new PriorityBlockingQueue<TimedRunnable>(11);
    final boolean useOnScheduleHook;
    long counter;
    volatile long time;

    public TestScheduler() {
        this(false);
    }

    @Experimental
    public TestScheduler(boolean useOnScheduleHook) {
        this.useOnScheduleHook = useOnScheduleHook;
    }

    public TestScheduler(long delayTime, TimeUnit unit) {
        this(delayTime, unit, false);
    }

    @Experimental
    public TestScheduler(long delayTime, TimeUnit unit, boolean useOnScheduleHook) {
        this.time = unit.toNanos(delayTime);
        this.useOnScheduleHook = useOnScheduleHook;
    }

    @Override
    public long now(@NonNull TimeUnit unit) {
        return unit.convert(this.time, TimeUnit.NANOSECONDS);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.advanceTimeTo(this.time + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        long targetTime = unit.toNanos(delayTime);
        this.triggerActions(targetTime);
    }

    public void triggerActions() {
        this.triggerActions(this.time);
    }

    private void triggerActions(long targetTimeInNanoseconds) {
        TimedRunnable current;
        while ((current = this.queue.peek()) != null && current.time <= targetTimeInNanoseconds) {
            this.time = current.time == 0L ? this.time : current.time;
            this.queue.remove(current);
            if (current.scheduler.disposed) continue;
            current.run.run();
        }
        this.time = targetTimeInNanoseconds;
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return new TestWorker();
    }

    final class TestWorker
    extends Scheduler.Worker {
        volatile boolean disposed;

        TestWorker() {
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delayTime, @NonNull TimeUnit unit) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            if (TestScheduler.this.useOnScheduleHook) {
                run = RxJavaPlugins.onSchedule(run);
            }
            TimedRunnable timedAction = new TimedRunnable(this, TestScheduler.this.time + unit.toNanos(delayTime), run, TestScheduler.this.counter++);
            TestScheduler.this.queue.add(timedAction);
            return new QueueRemove(timedAction);
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            if (TestScheduler.this.useOnScheduleHook) {
                run = RxJavaPlugins.onSchedule(run);
            }
            TimedRunnable timedAction = new TimedRunnable(this, 0L, run, TestScheduler.this.counter++);
            TestScheduler.this.queue.add(timedAction);
            return new QueueRemove(timedAction);
        }

        @Override
        public long now(@NonNull TimeUnit unit) {
            return TestScheduler.this.now(unit);
        }

        final class QueueRemove
        extends AtomicReference<TimedRunnable>
        implements Disposable {
            private static final long serialVersionUID = -7874968252110604360L;

            QueueRemove(TimedRunnable timedAction) {
                this.lazySet(timedAction);
            }

            @Override
            public void dispose() {
                TimedRunnable tr = this.getAndSet(null);
                if (tr != null) {
                    TestScheduler.this.queue.remove(tr);
                }
            }

            @Override
            public boolean isDisposed() {
                return this.get() == null;
            }
        }
    }

    static final class TimedRunnable
    implements Comparable<TimedRunnable> {
        final long time;
        final Runnable run;
        final TestWorker scheduler;
        final long count;

        TimedRunnable(TestWorker scheduler, long time, Runnable run, long count) {
            this.time = time;
            this.run = run;
            this.scheduler = scheduler;
            this.count = count;
        }

        public String toString() {
            return String.format("TimedRunnable(time = %d, run = %s)", this.time, this.run.toString());
        }

        @Override
        public int compareTo(TimedRunnable o) {
            if (this.time == o.time) {
                return Long.compare(this.count, o.count);
            }
            return Long.compare(this.time, o.time);
        }
    }
}

