/* EDIT WITH CARE.
 * Many sections of this file were automatically generated.
 */

/* packet-sysdig-event.c
 * Routines for Sysdig event dissection
 * http://www.sysdig.org/
 * Copyright 2015, Gerald Combs <gerald@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
 * Sysdig is a tool that captures and analyzes system state.
 * This dissects pcapng Sysdig Event Blocks (0x00000204), which contains
 * a system call entry or exit along with its associated parameters.
 */

/*
 * To do:
 * - Event with flags (0x00000208).
 * - Enter/exit delay.
 * - Most of this could be automatically generated from the Sysdig sources.
 *   - Alternatively we could modify Sysdig to dump its internal tables and
 *     generate a dissector from that output.
 * - Generate the column info table.
 * - Pull metainformation (processes, users, etc) into hash tables.
 */

#include <config.h>

#include <epan/exceptions.h>
#include <epan/packet.h>
#include <epan/strutil.h>

#include <packet-sysdig-event.h>

#include <wiretap/wtap.h>
#include <wiretap/pcapng_module.h>
/* #include <epan/expert.h> */
/* #include <epan/prefs.h> */

#define SYSDIG_PARAM_SIZE 2
#define SYSDIG_PARAM_SIZE_V2 2
#define SYSDIG_PARAM_SIZE_V2_LARGE 4

/* Prototypes */
void proto_reg_handoff_sysdig_event(void);
void proto_register_sysdig_event(void);

static dissector_handle_t sysdig_event_handle;

/* Initialize the protocol and registered fields */
static int proto_sysdig_event;
/* Add byte order? */
static int hf_se_cpu_id;
static int hf_se_thread_id;
static int hf_se_event_length;
static int hf_se_event_data_length;
static int hf_se_nparams;
static int hf_se_event_type;
static int hf_se_event_name;

static int hf_se_param_lens;
static int hf_se_param_len;

/* Name+type */
/* Header fields. Automatically generated by tools/generate-sysdig-event.py */
static int hf_param_ID_uint16;
static int hf_param_action_uint32;
static int hf_param_addr_bytes;
static int hf_param_addr_uint64;
static int hf_param_arg2_int_int64;
static int hf_param_arg2_str_string;
static int hf_param_arg_uint64;
static int hf_param_args_string;
static int hf_param_argument_uint64;
static int hf_param_aux_int32;
static int hf_param_backlog_int32;
static int hf_param_cap_effective_uint64;
static int hf_param_cap_inheritable_uint64;
static int hf_param_cap_permitted_uint64;
static int hf_param_cgroups_bytes;
static int hf_param_clockid_uint8;
static int hf_param_cmd_bytes;
static int hf_param_cmd_int16;
static int hf_param_cmd_int64;
static int hf_param_comm_string;
static int hf_param_container_id_string;
static int hf_param_core_uint8;
static int hf_param_cpu_sys_uint64;
static int hf_param_cpu_uint32;
static int hf_param_cpu_usr_uint64;
static int hf_param_cq_entries_uint32;
static int hf_param_cur_int64;
static int hf_param_cwd_string;
static int hf_param_data_bytes;
static int hf_param_desc_string;
static int hf_param_description_string;
static int hf_param_dev_string;
static int hf_param_dev_uint32;
static int hf_param_dir_string;
static int hf_param_dirfd_int64;
static int hf_param_domain_bytes;
static int hf_param_dpid_int64;
static int hf_param_dqb_bhardlimit_uint64;
static int hf_param_dqb_bsoftlimit_uint64;
static int hf_param_dqb_btime_bytes;
static int hf_param_dqb_curspace_uint64;
static int hf_param_dqb_ihardlimit_uint64;
static int hf_param_dqb_isoftlimit_uint64;
static int hf_param_dqb_itime_bytes;
static int hf_param_dqi_bgrace_bytes;
static int hf_param_dqi_flags_int8;
static int hf_param_dqi_igrace_bytes;
static int hf_param_egid_int32;
static int hf_param_entries_uint32;
static int hf_param_env_string;
static int hf_param_error_int32;
static int hf_param_euid_int32;
static int hf_param_event_data_bytes;
static int hf_param_event_data_uint64;
static int hf_param_event_type_uint32;
static int hf_param_exe_ino_ctime_bytes;
static int hf_param_exe_ino_mtime_bytes;
static int hf_param_exe_ino_uint64;
static int hf_param_exe_string;
static int hf_param_fd1_int64;
static int hf_param_fd2_int64;
static int hf_param_fd_in_int64;
static int hf_param_fd_int64;
static int hf_param_fd_out_int64;
static int hf_param_fdin_int64;
static int hf_param_fdlimit_int64;
static int hf_param_fdlimit_uint64;
static int hf_param_fdout_int64;
static int hf_param_fds_bytes;
static int hf_param_features_int32;
static int hf_param_filename_string;
static int hf_param_flags_int16;
static int hf_param_flags_int32;
static int hf_param_flags_uint32;
static int hf_param_flags_uint64;
static int hf_param_flags_uint8;
static int hf_param_gid_int32;
static int hf_param_gid_uint32;
static int hf_param_home_string;
static int hf_param_how_bytes;
static int hf_param_id_int64;
static int hf_param_id_string;
static int hf_param_id_uint32;
static int hf_param_image_string;
static int hf_param_img_bytes;
static int hf_param_in_fd_int64;
static int hf_param_initval_uint64;
static int hf_param_ino_uint64;
static int hf_param_interval_bytes;
static int hf_param_ip_uint64;
static int hf_param_json_string;
static int hf_param_key_int32;
static int hf_param_key_string;
static int hf_param_len_uint64;
static int hf_param_length_uint64;
static int hf_param_level_bytes;
static int hf_param_linkdirfd_int64;
static int hf_param_linkpath_string;
static int hf_param_loginuid_int32;
static int hf_param_mask_uint32;
static int hf_param_max_int64;
static int hf_param_maxevents_int64;
static int hf_param_min_complete_uint32;
static int hf_param_mode_int32;
static int hf_param_mode_uint32;
static int hf_param_mountfd_int64;
static int hf_param_msgcontrol_bytes;
static int hf_param_name_string;
static int hf_param_nativeID_uint16;
static int hf_param_newcur_int64;
static int hf_param_newdir_int64;
static int hf_param_newdirfd_int64;
static int hf_param_newfd_int64;
static int hf_param_newmax_int64;
static int hf_param_newpath_string;
static int hf_param_next_int64;
static int hf_param_nr_args_uint32;
static int hf_param_nsems_int32;
static int hf_param_nsops_uint32;
static int hf_param_nstype_int32;
static int hf_param_offin_uint64;
static int hf_param_offout_uint64;
static int hf_param_offset_uint64;
static int hf_param_oldcur_int64;
static int hf_param_olddir_int64;
static int hf_param_olddirfd_int64;
static int hf_param_oldfd_int64;
static int hf_param_oldmax_int64;
static int hf_param_oldpath_string;
static int hf_param_op_bytes;
static int hf_param_op_uint64;
static int hf_param_opcode_bytes;
static int hf_param_operation_int32;
static int hf_param_option_bytes;
static int hf_param_optlen_uint32;
static int hf_param_optname_bytes;
static int hf_param_out_fd_int64;
static int hf_param_path_string;
static int hf_param_pathname_string;
static int hf_param_peer_uint64;
static int hf_param_pgft_maj_uint64;
static int hf_param_pgft_min_uint64;
static int hf_param_pgid_int64;
static int hf_param_pgoffset_uint64;
static int hf_param_pid_fd_int64;
static int hf_param_pid_int64;
static int hf_param_pidns_init_start_ts_uint64;
static int hf_param_plugin_id_uint32;
static int hf_param_pos_uint64;
static int hf_param_prot_int32;
static int hf_param_proto_uint32;
static int hf_param_ptid_int64;
static int hf_param_queuelen_uint32;
static int hf_param_queuemax_uint32;
static int hf_param_queuepct_uint8;
static int hf_param_quota_fmt_int8;
static int hf_param_quota_fmt_out_int8;
static int hf_param_quotafilepath_string;
static int hf_param_ratio_uint32;
static int hf_param_reaper_tid_int64;
static int hf_param_request_bytes;
static int hf_param_request_uint64;
static int hf_param_res_int64;
static int hf_param_res_or_fd_bytes;
static int hf_param_res_uint64;
static int hf_param_resolve_int32;
static int hf_param_resource_bytes;
static int hf_param_ret_int64;
static int hf_param_rgid_int32;
static int hf_param_ruid_int32;
static int hf_param_scope_string;
static int hf_param_sem_flg_0_int16;
static int hf_param_sem_flg_1_int16;
static int hf_param_sem_num_0_uint16;
static int hf_param_sem_num_1_uint16;
static int hf_param_sem_op_0_int16;
static int hf_param_sem_op_1_int16;
static int hf_param_semflg_int32;
static int hf_param_semid_int32;
static int hf_param_semnum_int32;
static int hf_param_sgid_int32;
static int hf_param_shell_string;
static int hf_param_sig_bytes;
static int hf_param_sigmask_bytes;
static int hf_param_size_int32;
static int hf_param_size_uint32;
static int hf_param_size_uint64;
static int hf_param_source_string;
static int hf_param_source_uint64;
static int hf_param_special_string;
static int hf_param_spid_int64;
static int hf_param_sq_entries_uint32;
static int hf_param_sq_thread_cpu_uint32;
static int hf_param_sq_thread_idle_uint32;
static int hf_param_status_int64;
static int hf_param_suid_int32;
static int hf_param_tags_bytes;
static int hf_param_target_fd_int64;
static int hf_param_target_string;
static int hf_param_tid_int64;
static int hf_param_timeout_bytes;
static int hf_param_timeout_int64;
static int hf_param_to_submit_uint32;
static int hf_param_trusted_exepath_string;
static int hf_param_tty_int32;
static int hf_param_tty_uint32;
static int hf_param_tuple_bytes;
static int hf_param_type_int8;
static int hf_param_type_string;
static int hf_param_type_uint32;
static int hf_param_uargs_string;
static int hf_param_uid_int32;
static int hf_param_uid_uint32;
static int hf_param_val_bytes;
static int hf_param_val_int32;
static int hf_param_val_uint64;
static int hf_param_value_bytebuf_bytes;
static int hf_param_value_charbuf_string;
static int hf_param_vm_rss_uint32;
static int hf_param_vm_size_uint32;
static int hf_param_vm_swap_uint32;
static int hf_param_vpid_int64;
static int hf_param_vtid_int64;
static int hf_param_whence_bytes;

/* Initialize the subtree pointers */
static int ett_sysdig_event;
static int ett_sysdig_parm_lens;
static int ett_sysdig_syscall;

/* Initialize the pointer to the child plugin dissector */
static dissector_handle_t sinsp_dissector_handle;
static dissector_handle_t elf_dissector_handle;


/* Event names. Automatically generated by tools/generate-sysdig-event.py */
#define EVT_STR_NA                       "NA"
#define EVT_STR_ACCEPT                   "accept"
#define EVT_STR_ACCEPT4                  "accept4"
#define EVT_STR_ACCESS                   "access"
#define EVT_STR_ASYNCEVENT               "asyncevent"
#define EVT_STR_BIND                     "bind"
#define EVT_STR_BPF                      "bpf"
#define EVT_STR_BRK                      "brk"
#define EVT_STR_CAPSET                   "capset"
#define EVT_STR_CHDIR                    "chdir"
#define EVT_STR_CHMOD                    "chmod"
#define EVT_STR_CHOWN                    "chown"
#define EVT_STR_CHROOT                   "chroot"
#define EVT_STR_CLONE                    "clone"
#define EVT_STR_CLONE3                   "clone3"
#define EVT_STR_CLOSE                    "close"
#define EVT_STR_CONNECT                  "connect"
#define EVT_STR_CONTAINER                "container"
#define EVT_STR_COPY_FILE_RANGE          "copy_file_range"
#define EVT_STR_CPU_HOTPLUG              "cpu_hotplug"
#define EVT_STR_CREAT                    "creat"
#define EVT_STR_DELETE_MODULE            "delete_module"
#define EVT_STR_DROP                     "drop"
#define EVT_STR_DUP                      "dup"
#define EVT_STR_DUP2                     "dup2"
#define EVT_STR_DUP3                     "dup3"
#define EVT_STR_EPOLL_CREATE             "epoll_create"
#define EVT_STR_EPOLL_CREATE1            "epoll_create1"
#define EVT_STR_EPOLL_WAIT               "epoll_wait"
#define EVT_STR_EVENTFD                  "eventfd"
#define EVT_STR_EVENTFD2                 "eventfd2"
#define EVT_STR_EXECVE                   "execve"
#define EVT_STR_EXECVEAT                 "execveat"
#define EVT_STR_FCHDIR                   "fchdir"
#define EVT_STR_FCHMOD                   "fchmod"
#define EVT_STR_FCHMODAT                 "fchmodat"
#define EVT_STR_FCHOWN                   "fchown"
#define EVT_STR_FCHOWNAT                 "fchownat"
#define EVT_STR_FCNTL                    "fcntl"
#define EVT_STR_FINIT_MODULE             "finit_module"
#define EVT_STR_FLOCK                    "flock"
#define EVT_STR_FORK                     "fork"
#define EVT_STR_FSCONFIG                 "fsconfig"
#define EVT_STR_FSTAT                    "fstat"
#define EVT_STR_FSTAT64                  "fstat64"
#define EVT_STR_FUTEX                    "futex"
#define EVT_STR_GETCWD                   "getcwd"
#define EVT_STR_GETDENTS                 "getdents"
#define EVT_STR_GETDENTS64               "getdents64"
#define EVT_STR_GETEGID                  "getegid"
#define EVT_STR_GETEUID                  "geteuid"
#define EVT_STR_GETGID                   "getgid"
#define EVT_STR_GETPEERNAME              "getpeername"
#define EVT_STR_GETRESGID                "getresgid"
#define EVT_STR_GETRESUID                "getresuid"
#define EVT_STR_GETRLIMIT                "getrlimit"
#define EVT_STR_GETSOCKNAME              "getsockname"
#define EVT_STR_GETSOCKOPT               "getsockopt"
#define EVT_STR_GETUID                   "getuid"
#define EVT_STR_GROUPADDED               "groupadded"
#define EVT_STR_GROUPDELETED             "groupdeleted"
#define EVT_STR_INFRA                    "infra"
#define EVT_STR_INIT_MODULE              "init_module"
#define EVT_STR_INOTIFY_INIT             "inotify_init"
#define EVT_STR_INOTIFY_INIT1            "inotify_init1"
#define EVT_STR_IO_URING_ENTER           "io_uring_enter"
#define EVT_STR_IO_URING_REGISTER        "io_uring_register"
#define EVT_STR_IO_URING_SETUP           "io_uring_setup"
#define EVT_STR_IOCTL                    "ioctl"
#define EVT_STR_K8S                      "k8s"
#define EVT_STR_KILL                     "kill"
#define EVT_STR_LCHOWN                   "lchown"
#define EVT_STR_LINK                     "link"
#define EVT_STR_LINKAT                   "linkat"
#define EVT_STR_LISTEN                   "listen"
#define EVT_STR_LLSEEK                   "llseek"
#define EVT_STR_LSEEK                    "lseek"
#define EVT_STR_LSTAT                    "lstat"
#define EVT_STR_LSTAT64                  "lstat64"
#define EVT_STR_MEMFD_CREATE             "memfd_create"
#define EVT_STR_MESOS                    "mesos"
#define EVT_STR_MKDIR                    "mkdir"
#define EVT_STR_MKDIRAT                  "mkdirat"
#define EVT_STR_MKNOD                    "mknod"
#define EVT_STR_MKNODAT                  "mknodat"
#define EVT_STR_MLOCK                    "mlock"
#define EVT_STR_MLOCK2                   "mlock2"
#define EVT_STR_MLOCKALL                 "mlockall"
#define EVT_STR_MMAP                     "mmap"
#define EVT_STR_MMAP2                    "mmap2"
#define EVT_STR_MOUNT                    "mount"
#define EVT_STR_MPROTECT                 "mprotect"
#define EVT_STR_MUNLOCK                  "munlock"
#define EVT_STR_MUNLOCKALL               "munlockall"
#define EVT_STR_MUNMAP                   "munmap"
#define EVT_STR_NANOSLEEP                "nanosleep"
#define EVT_STR_NEWFSTATAT               "newfstatat"
#define EVT_STR_NOTIFICATION             "notification"
#define EVT_STR_OPEN                     "open"
#define EVT_STR_OPEN_BY_HANDLE_AT        "open_by_handle_at"
#define EVT_STR_OPENAT                   "openat"
#define EVT_STR_OPENAT2                  "openat2"
#define EVT_STR_PAGE_FAULT               "page_fault"
#define EVT_STR_PIDFD_GETFD              "pidfd_getfd"
#define EVT_STR_PIDFD_OPEN               "pidfd_open"
#define EVT_STR_PIPE                     "pipe"
#define EVT_STR_PIPE2                    "pipe2"
#define EVT_STR_PLUGINEVENT              "pluginevent"
#define EVT_STR_POLL                     "poll"
#define EVT_STR_PPOLL                    "ppoll"
#define EVT_STR_PRCTL                    "prctl"
#define EVT_STR_PREAD                    "pread"
#define EVT_STR_PREADV                   "preadv"
#define EVT_STR_PRLIMIT                  "prlimit"
#define EVT_STR_PROCESS_VM_READV         "process_vm_readv"
#define EVT_STR_PROCESS_VM_WRITEV        "process_vm_writev"
#define EVT_STR_PROCEXIT                 "procexit"
#define EVT_STR_PROCINFO                 "procinfo"
#define EVT_STR_PTRACE                   "ptrace"
#define EVT_STR_PWRITE                   "pwrite"
#define EVT_STR_PWRITEV                  "pwritev"
#define EVT_STR_QUOTACTL                 "quotactl"
#define EVT_STR_READ                     "read"
#define EVT_STR_READV                    "readv"
#define EVT_STR_RECV                     "recv"
#define EVT_STR_RECVFROM                 "recvfrom"
#define EVT_STR_RECVMMSG                 "recvmmsg"
#define EVT_STR_RECVMSG                  "recvmsg"
#define EVT_STR_RENAME                   "rename"
#define EVT_STR_RENAMEAT                 "renameat"
#define EVT_STR_RENAMEAT2                "renameat2"
#define EVT_STR_RMDIR                    "rmdir"
#define EVT_STR_SCAPEVENT                "scapevent"
#define EVT_STR_SECCOMP                  "seccomp"
#define EVT_STR_SELECT                   "select"
#define EVT_STR_SEMCTL                   "semctl"
#define EVT_STR_SEMGET                   "semget"
#define EVT_STR_SEMOP                    "semop"
#define EVT_STR_SEND                     "send"
#define EVT_STR_SENDFILE                 "sendfile"
#define EVT_STR_SENDMMSG                 "sendmmsg"
#define EVT_STR_SENDMSG                  "sendmsg"
#define EVT_STR_SENDTO                   "sendto"
#define EVT_STR_SETGID                   "setgid"
#define EVT_STR_SETNS                    "setns"
#define EVT_STR_SETPGID                  "setpgid"
#define EVT_STR_SETREGID                 "setregid"
#define EVT_STR_SETRESGID                "setresgid"
#define EVT_STR_SETRESUID                "setresuid"
#define EVT_STR_SETREUID                 "setreuid"
#define EVT_STR_SETRLIMIT                "setrlimit"
#define EVT_STR_SETSID                   "setsid"
#define EVT_STR_SETSOCKOPT               "setsockopt"
#define EVT_STR_SETUID                   "setuid"
#define EVT_STR_SHUTDOWN                 "shutdown"
#define EVT_STR_SIGNALDELIVER            "signaldeliver"
#define EVT_STR_SIGNALFD                 "signalfd"
#define EVT_STR_SIGNALFD4                "signalfd4"
#define EVT_STR_SOCKET                   "socket"
#define EVT_STR_SOCKETPAIR               "socketpair"
#define EVT_STR_SPLICE                   "splice"
#define EVT_STR_STAT                     "stat"
#define EVT_STR_STAT64                   "stat64"
#define EVT_STR_SWITCH                   "switch"
#define EVT_STR_SYMLINK                  "symlink"
#define EVT_STR_SYMLINKAT                "symlinkat"
#define EVT_STR_SYSCALL                  "syscall"
#define EVT_STR_TGKILL                   "tgkill"
#define EVT_STR_TIMERFD_CREATE           "timerfd_create"
#define EVT_STR_TKILL                    "tkill"
#define EVT_STR_TRACER                   "tracer"
#define EVT_STR_UMOUNT                   "umount"
#define EVT_STR_UMOUNT2                  "umount2"
#define EVT_STR_UNLINK                   "unlink"
#define EVT_STR_UNLINKAT                 "unlinkat"
#define EVT_STR_UNSHARE                  "unshare"
#define EVT_STR_USERADDED                "useradded"
#define EVT_STR_USERDELETED              "userdeleted"
#define EVT_STR_USERFAULTFD              "userfaultfd"
#define EVT_STR_VFORK                    "vfork"
#define EVT_STR_WRITE                    "write"
#define EVT_STR_WRITEV                   "writev"

/* EVT_... = PPME_... */
/* Event definitions. Automatically generated by tools/generate-sysdig-event.py */
#define EVT_GENERIC_E                  0
#define EVT_GENERIC_X                  1
#define EVT_SYSCALL_OPEN_E             2
#define EVT_SYSCALL_OPEN_X             3
#define EVT_SYSCALL_CLOSE_E            4
#define EVT_SYSCALL_CLOSE_X            5
#define EVT_SYSCALL_READ_E             6
#define EVT_SYSCALL_READ_X             7
#define EVT_SYSCALL_WRITE_E            8
#define EVT_SYSCALL_WRITE_X            9
#define EVT_SYSCALL_BRK_1_E           10
#define EVT_SYSCALL_BRK_1_X           11
#define EVT_SYSCALL_EXECVE_8_E        12
#define EVT_SYSCALL_EXECVE_8_X        13
#define EVT_SYSCALL_CLONE_11_E        14
#define EVT_SYSCALL_CLONE_11_X        15
#define EVT_PROCEXIT_E                16
#define EVT_PROCEXIT_X                17
#define EVT_SOCKET_SOCKET_E           18
#define EVT_SOCKET_SOCKET_X           19
#define EVT_SOCKET_BIND_E             20
#define EVT_SOCKET_BIND_X             21
#define EVT_SOCKET_CONNECT_E          22
#define EVT_SOCKET_CONNECT_X          23
#define EVT_SOCKET_LISTEN_E           24
#define EVT_SOCKET_LISTEN_X           25
#define EVT_SOCKET_ACCEPT_E           26
#define EVT_SOCKET_ACCEPT_X           27
#define EVT_SOCKET_SEND_E             28
#define EVT_SOCKET_SEND_X             29
#define EVT_SOCKET_SENDTO_E           30
#define EVT_SOCKET_SENDTO_X           31
#define EVT_SOCKET_RECV_E             32
#define EVT_SOCKET_RECV_X             33
#define EVT_SOCKET_RECVFROM_E         34
#define EVT_SOCKET_RECVFROM_X         35
#define EVT_SOCKET_SHUTDOWN_E         36
#define EVT_SOCKET_SHUTDOWN_X         37
#define EVT_SOCKET_GETSOCKNAME_E      38
#define EVT_SOCKET_GETSOCKNAME_X      39
#define EVT_SOCKET_GETPEERNAME_E      40
#define EVT_SOCKET_GETPEERNAME_X      41
#define EVT_SOCKET_SOCKETPAIR_E       42
#define EVT_SOCKET_SOCKETPAIR_X       43
#define EVT_SOCKET_SETSOCKOPT_E       44
#define EVT_SOCKET_SETSOCKOPT_X       45
#define EVT_SOCKET_GETSOCKOPT_E       46
#define EVT_SOCKET_GETSOCKOPT_X       47
#define EVT_SOCKET_SENDMSG_E          48
#define EVT_SOCKET_SENDMSG_X          49
#define EVT_SOCKET_SENDMMSG_E         50
#define EVT_SOCKET_SENDMMSG_X         51
#define EVT_SOCKET_RECVMSG_E          52
#define EVT_SOCKET_RECVMSG_X          53
#define EVT_SOCKET_RECVMMSG_E         54
#define EVT_SOCKET_RECVMMSG_X         55
#define EVT_SOCKET_ACCEPT4_E          56
#define EVT_SOCKET_ACCEPT4_X          57
#define EVT_SYSCALL_CREAT_E           58
#define EVT_SYSCALL_CREAT_X           59
#define EVT_SYSCALL_PIPE_E            60
#define EVT_SYSCALL_PIPE_X            61
#define EVT_SYSCALL_EVENTFD_E         62
#define EVT_SYSCALL_EVENTFD_X         63
#define EVT_SYSCALL_FUTEX_E           64
#define EVT_SYSCALL_FUTEX_X           65
#define EVT_SYSCALL_STAT_E            66
#define EVT_SYSCALL_STAT_X            67
#define EVT_SYSCALL_LSTAT_E           68
#define EVT_SYSCALL_LSTAT_X           69
#define EVT_SYSCALL_FSTAT_E           70
#define EVT_SYSCALL_FSTAT_X           71
#define EVT_SYSCALL_STAT64_E          72
#define EVT_SYSCALL_STAT64_X          73
#define EVT_SYSCALL_LSTAT64_E         74
#define EVT_SYSCALL_LSTAT64_X         75
#define EVT_SYSCALL_FSTAT64_E         76
#define EVT_SYSCALL_FSTAT64_X         77
#define EVT_SYSCALL_EPOLLWAIT_E       78
#define EVT_SYSCALL_EPOLLWAIT_X       79
#define EVT_SYSCALL_POLL_E            80
#define EVT_SYSCALL_POLL_X            81
#define EVT_SYSCALL_SELECT_E          82
#define EVT_SYSCALL_SELECT_X          83
#define EVT_SYSCALL_NEWSELECT_E       84
#define EVT_SYSCALL_NEWSELECT_X       85
#define EVT_SYSCALL_LSEEK_E           86
#define EVT_SYSCALL_LSEEK_X           87
#define EVT_SYSCALL_LLSEEK_E          88
#define EVT_SYSCALL_LLSEEK_X          89
#define EVT_SYSCALL_IOCTL_2_E         90
#define EVT_SYSCALL_IOCTL_2_X         91
#define EVT_SYSCALL_GETCWD_E          92
#define EVT_SYSCALL_GETCWD_X          93
#define EVT_SYSCALL_CHDIR_E           94
#define EVT_SYSCALL_CHDIR_X           95
#define EVT_SYSCALL_FCHDIR_E          96
#define EVT_SYSCALL_FCHDIR_X          97
#define EVT_SYSCALL_MKDIR_E           98
#define EVT_SYSCALL_MKDIR_X           99
#define EVT_SYSCALL_RMDIR_E          100
#define EVT_SYSCALL_RMDIR_X          101
#define EVT_SYSCALL_OPENAT_E         102
#define EVT_SYSCALL_OPENAT_X         103
#define EVT_SYSCALL_LINK_E           104
#define EVT_SYSCALL_LINK_X           105
#define EVT_SYSCALL_LINKAT_E         106
#define EVT_SYSCALL_LINKAT_X         107
#define EVT_SYSCALL_UNLINK_E         108
#define EVT_SYSCALL_UNLINK_X         109
#define EVT_SYSCALL_UNLINKAT_E       110
#define EVT_SYSCALL_UNLINKAT_X       111
#define EVT_SYSCALL_PREAD_E          112
#define EVT_SYSCALL_PREAD_X          113
#define EVT_SYSCALL_PWRITE_E         114
#define EVT_SYSCALL_PWRITE_X         115
#define EVT_SYSCALL_READV_E          116
#define EVT_SYSCALL_READV_X          117
#define EVT_SYSCALL_WRITEV_E         118
#define EVT_SYSCALL_WRITEV_X         119
#define EVT_SYSCALL_PREADV_E         120
#define EVT_SYSCALL_PREADV_X         121
#define EVT_SYSCALL_PWRITEV_E        122
#define EVT_SYSCALL_PWRITEV_X        123
#define EVT_SYSCALL_DUP_E            124
#define EVT_SYSCALL_DUP_X            125
#define EVT_SYSCALL_SIGNALFD_E       126
#define EVT_SYSCALL_SIGNALFD_X       127
#define EVT_SYSCALL_KILL_E           128
#define EVT_SYSCALL_KILL_X           129
#define EVT_SYSCALL_TKILL_E          130
#define EVT_SYSCALL_TKILL_X          131
#define EVT_SYSCALL_TGKILL_E         132
#define EVT_SYSCALL_TGKILL_X         133
#define EVT_SYSCALL_NANOSLEEP_E      134
#define EVT_SYSCALL_NANOSLEEP_X      135
#define EVT_SYSCALL_TIMERFD_CREATE_E 136
#define EVT_SYSCALL_TIMERFD_CREATE_X 137
#define EVT_SYSCALL_INOTIFY_INIT_E   138
#define EVT_SYSCALL_INOTIFY_INIT_X   139
#define EVT_SYSCALL_GETRLIMIT_E      140
#define EVT_SYSCALL_GETRLIMIT_X      141
#define EVT_SYSCALL_SETRLIMIT_E      142
#define EVT_SYSCALL_SETRLIMIT_X      143
#define EVT_SYSCALL_PRLIMIT_E        144
#define EVT_SYSCALL_PRLIMIT_X        145
#define EVT_SCHEDSWITCH_1_E          146
#define EVT_SCHEDSWITCH_1_X          147
#define EVT_DROP_E                   148
#define EVT_DROP_X                   149
#define EVT_SYSCALL_FCNTL_E          150
#define EVT_SYSCALL_FCNTL_X          151
#define EVT_SCHEDSWITCH_6_E          152
#define EVT_SCHEDSWITCH_6_X          153
#define EVT_SYSCALL_EXECVE_13_E      154
#define EVT_SYSCALL_EXECVE_13_X      155
#define EVT_SYSCALL_CLONE_16_E       156
#define EVT_SYSCALL_CLONE_16_X       157
#define EVT_SYSCALL_BRK_4_E          158
#define EVT_SYSCALL_BRK_4_X          159
#define EVT_SYSCALL_MMAP_E           160
#define EVT_SYSCALL_MMAP_X           161
#define EVT_SYSCALL_MMAP2_E          162
#define EVT_SYSCALL_MMAP2_X          163
#define EVT_SYSCALL_MUNMAP_E         164
#define EVT_SYSCALL_MUNMAP_X         165
#define EVT_SYSCALL_SPLICE_E         166
#define EVT_SYSCALL_SPLICE_X         167
#define EVT_SYSCALL_PTRACE_E         168
#define EVT_SYSCALL_PTRACE_X         169
#define EVT_SYSCALL_IOCTL_3_E        170
#define EVT_SYSCALL_IOCTL_3_X        171
#define EVT_SYSCALL_EXECVE_14_E      172
#define EVT_SYSCALL_EXECVE_14_X      173
#define EVT_SYSCALL_RENAME_E         174
#define EVT_SYSCALL_RENAME_X         175
#define EVT_SYSCALL_RENAMEAT_E       176
#define EVT_SYSCALL_RENAMEAT_X       177
#define EVT_SYSCALL_SYMLINK_E        178
#define EVT_SYSCALL_SYMLINK_X        179
#define EVT_SYSCALL_SYMLINKAT_E      180
#define EVT_SYSCALL_SYMLINKAT_X      181
#define EVT_SYSCALL_FORK_E           182
#define EVT_SYSCALL_FORK_X           183
#define EVT_SYSCALL_VFORK_E          184
#define EVT_SYSCALL_VFORK_X          185
#define EVT_PROCEXIT_1_E             186
#define EVT_PROCEXIT_1_X             187
#define EVT_SYSCALL_SENDFILE_E       188
#define EVT_SYSCALL_SENDFILE_X       189
#define EVT_SYSCALL_QUOTACTL_E       190
#define EVT_SYSCALL_QUOTACTL_X       191
#define EVT_SYSCALL_SETRESUID_E      192
#define EVT_SYSCALL_SETRESUID_X      193
#define EVT_SYSCALL_SETRESGID_E      194
#define EVT_SYSCALL_SETRESGID_X      195
#define EVT_SCAPEVENT_E              196
#define EVT_SCAPEVENT_X              197
#define EVT_SYSCALL_SETUID_E         198
#define EVT_SYSCALL_SETUID_X         199
#define EVT_SYSCALL_SETGID_E         200
#define EVT_SYSCALL_SETGID_X         201
#define EVT_SYSCALL_GETUID_E         202
#define EVT_SYSCALL_GETUID_X         203
#define EVT_SYSCALL_GETEUID_E        204
#define EVT_SYSCALL_GETEUID_X        205
#define EVT_SYSCALL_GETGID_E         206
#define EVT_SYSCALL_GETGID_X         207
#define EVT_SYSCALL_GETEGID_E        208
#define EVT_SYSCALL_GETEGID_X        209
#define EVT_SYSCALL_GETRESUID_E      210
#define EVT_SYSCALL_GETRESUID_X      211
#define EVT_SYSCALL_GETRESGID_E      212
#define EVT_SYSCALL_GETRESGID_X      213
#define EVT_SYSCALL_EXECVE_15_E      214
#define EVT_SYSCALL_EXECVE_15_X      215
#define EVT_SYSCALL_CLONE_17_E       216
#define EVT_SYSCALL_CLONE_17_X       217
#define EVT_SYSCALL_FORK_17_E        218
#define EVT_SYSCALL_FORK_17_X        219
#define EVT_SYSCALL_VFORK_17_E       220
#define EVT_SYSCALL_VFORK_17_X       221
#define EVT_SYSCALL_CLONE_20_E       222
#define EVT_SYSCALL_CLONE_20_X       223
#define EVT_SYSCALL_FORK_20_E        224
#define EVT_SYSCALL_FORK_20_X        225
#define EVT_SYSCALL_VFORK_20_E       226
#define EVT_SYSCALL_VFORK_20_X       227
#define EVT_CONTAINER_E              228
#define EVT_CONTAINER_X              229
#define EVT_SYSCALL_EXECVE_16_E      230
#define EVT_SYSCALL_EXECVE_16_X      231
#define EVT_SIGNALDELIVER_E          232
#define EVT_SIGNALDELIVER_X          233
#define EVT_PROCINFO_E               234
#define EVT_PROCINFO_X               235
#define EVT_SYSCALL_GETDENTS_E       236
#define EVT_SYSCALL_GETDENTS_X       237
#define EVT_SYSCALL_GETDENTS64_E     238
#define EVT_SYSCALL_GETDENTS64_X     239
#define EVT_SYSCALL_SETNS_E          240
#define EVT_SYSCALL_SETNS_X          241
#define EVT_SYSCALL_FLOCK_E          242
#define EVT_SYSCALL_FLOCK_X          243
#define EVT_CPU_HOTPLUG_E            244
#define EVT_CPU_HOTPLUG_X            245
#define EVT_SOCKET_ACCEPT_5_E        246
#define EVT_SOCKET_ACCEPT_5_X        247
#define EVT_SOCKET_ACCEPT4_5_E       248
#define EVT_SOCKET_ACCEPT4_5_X       249
#define EVT_SYSCALL_SEMOP_E          250
#define EVT_SYSCALL_SEMOP_X          251
#define EVT_SYSCALL_SEMCTL_E         252
#define EVT_SYSCALL_SEMCTL_X         253
#define EVT_SYSCALL_PPOLL_E          254
#define EVT_SYSCALL_PPOLL_X          255
#define EVT_SYSCALL_MOUNT_E          256
#define EVT_SYSCALL_MOUNT_X          257
#define EVT_SYSCALL_UMOUNT_E         258
#define EVT_SYSCALL_UMOUNT_X         259
#define EVT_K8S_E                    260
#define EVT_K8S_X                    261
#define EVT_SYSCALL_SEMGET_E         262
#define EVT_SYSCALL_SEMGET_X         263
#define EVT_SYSCALL_ACCESS_E         264
#define EVT_SYSCALL_ACCESS_X         265
#define EVT_SYSCALL_CHROOT_E         266
#define EVT_SYSCALL_CHROOT_X         267
#define EVT_TRACER_E                 268
#define EVT_TRACER_X                 269
#define EVT_MESOS_E                  270
#define EVT_MESOS_X                  271
#define EVT_CONTAINER_JSON_E         272
#define EVT_CONTAINER_JSON_X         273
#define EVT_SYSCALL_SETSID_E         274
#define EVT_SYSCALL_SETSID_X         275
#define EVT_SYSCALL_MKDIR_2_E        276
#define EVT_SYSCALL_MKDIR_2_X        277
#define EVT_SYSCALL_RMDIR_2_E        278
#define EVT_SYSCALL_RMDIR_2_X        279
#define EVT_NOTIFICATION_E           280
#define EVT_NOTIFICATION_X           281
#define EVT_SYSCALL_EXECVE_17_E      282
#define EVT_SYSCALL_EXECVE_17_X      283
#define EVT_SYSCALL_UNSHARE_E        284
#define EVT_SYSCALL_UNSHARE_X        285
#define EVT_INFRASTRUCTURE_EVENT_E   286
#define EVT_INFRASTRUCTURE_EVENT_X   287
#define EVT_SYSCALL_EXECVE_18_E      288
#define EVT_SYSCALL_EXECVE_18_X      289
#define EVT_PAGE_FAULT_E             290
#define EVT_PAGE_FAULT_X             291
#define EVT_SYSCALL_EXECVE_19_E      292
#define EVT_SYSCALL_EXECVE_19_X      293
#define EVT_SYSCALL_SETPGID_E        294
#define EVT_SYSCALL_SETPGID_X        295
#define EVT_SYSCALL_BPF_E            296
#define EVT_SYSCALL_BPF_X            297
#define EVT_SYSCALL_SECCOMP_E        298
#define EVT_SYSCALL_SECCOMP_X        299
#define EVT_SYSCALL_UNLINK_2_E       300
#define EVT_SYSCALL_UNLINK_2_X       301
#define EVT_SYSCALL_UNLINKAT_2_E     302
#define EVT_SYSCALL_UNLINKAT_2_X     303
#define EVT_SYSCALL_MKDIRAT_E        304
#define EVT_SYSCALL_MKDIRAT_X        305
#define EVT_SYSCALL_OPENAT_2_E       306
#define EVT_SYSCALL_OPENAT_2_X       307
#define EVT_SYSCALL_LINK_2_E         308
#define EVT_SYSCALL_LINK_2_X         309
#define EVT_SYSCALL_LINKAT_2_E       310
#define EVT_SYSCALL_LINKAT_2_X       311
#define EVT_SYSCALL_FCHMODAT_E       312
#define EVT_SYSCALL_FCHMODAT_X       313
#define EVT_SYSCALL_CHMOD_E          314
#define EVT_SYSCALL_CHMOD_X          315
#define EVT_SYSCALL_FCHMOD_E         316
#define EVT_SYSCALL_FCHMOD_X         317
#define EVT_SYSCALL_RENAMEAT2_E      318
#define EVT_SYSCALL_RENAMEAT2_X      319
#define EVT_SYSCALL_USERFAULTFD_E    320
#define EVT_SYSCALL_USERFAULTFD_X    321
#define EVT_PLUGINEVENT_E            322
#define EVT_PLUGINEVENT_X            323
#define EVT_CONTAINER_JSON_2_E       324
#define EVT_CONTAINER_JSON_2_X       325
#define EVT_SYSCALL_OPENAT2_E        326
#define EVT_SYSCALL_OPENAT2_X        327
#define EVT_SYSCALL_MPROTECT_E       328
#define EVT_SYSCALL_MPROTECT_X       329
#define EVT_SYSCALL_EXECVEAT_E       330
#define EVT_SYSCALL_EXECVEAT_X       331
#define EVT_SYSCALL_COPY_FILE_RANGE_E 332
#define EVT_SYSCALL_COPY_FILE_RANGE_X 333
#define EVT_SYSCALL_CLONE3_E         334
#define EVT_SYSCALL_CLONE3_X         335
#define EVT_SYSCALL_OPEN_BY_HANDLE_AT_E 336
#define EVT_SYSCALL_OPEN_BY_HANDLE_AT_X 337
#define EVT_SYSCALL_IO_URING_SETUP_E 338
#define EVT_SYSCALL_IO_URING_SETUP_X 339
#define EVT_SYSCALL_IO_URING_ENTER_E 340
#define EVT_SYSCALL_IO_URING_ENTER_X 341
#define EVT_SYSCALL_IO_URING_REGISTER_E 342
#define EVT_SYSCALL_IO_URING_REGISTER_X 343
#define EVT_SYSCALL_MLOCK_E          344
#define EVT_SYSCALL_MLOCK_X          345
#define EVT_SYSCALL_MUNLOCK_E        346
#define EVT_SYSCALL_MUNLOCK_X        347
#define EVT_SYSCALL_MLOCKALL_E       348
#define EVT_SYSCALL_MLOCKALL_X       349
#define EVT_SYSCALL_MUNLOCKALL_E     350
#define EVT_SYSCALL_MUNLOCKALL_X     351
#define EVT_SYSCALL_CAPSET_E         352
#define EVT_SYSCALL_CAPSET_X         353
#define EVT_USER_ADDED_E             354
#define EVT_USER_ADDED_X             355
#define EVT_USER_DELETED_E           356
#define EVT_USER_DELETED_X           357
#define EVT_GROUP_ADDED_E            358
#define EVT_GROUP_ADDED_X            359
#define EVT_GROUP_DELETED_E          360
#define EVT_GROUP_DELETED_X          361
#define EVT_SYSCALL_DUP2_E           362
#define EVT_SYSCALL_DUP2_X           363
#define EVT_SYSCALL_DUP3_E           364
#define EVT_SYSCALL_DUP3_X           365
#define EVT_SYSCALL_DUP_1_E          366
#define EVT_SYSCALL_DUP_1_X          367
#define EVT_SYSCALL_BPF_2_E          368
#define EVT_SYSCALL_BPF_2_X          369
#define EVT_SYSCALL_MLOCK2_E         370
#define EVT_SYSCALL_MLOCK2_X         371
#define EVT_SYSCALL_FSCONFIG_E       372
#define EVT_SYSCALL_FSCONFIG_X       373
#define EVT_SYSCALL_EPOLL_CREATE_E   374
#define EVT_SYSCALL_EPOLL_CREATE_X   375
#define EVT_SYSCALL_EPOLL_CREATE1_E  376
#define EVT_SYSCALL_EPOLL_CREATE1_X  377
#define EVT_SYSCALL_CHOWN_E          378
#define EVT_SYSCALL_CHOWN_X          379
#define EVT_SYSCALL_LCHOWN_E         380
#define EVT_SYSCALL_LCHOWN_X         381
#define EVT_SYSCALL_FCHOWN_E         382
#define EVT_SYSCALL_FCHOWN_X         383
#define EVT_SYSCALL_FCHOWNAT_E       384
#define EVT_SYSCALL_FCHOWNAT_X       385
#define EVT_SYSCALL_UMOUNT_1_E       386
#define EVT_SYSCALL_UMOUNT_1_X       387
#define EVT_SOCKET_ACCEPT4_6_E       388
#define EVT_SOCKET_ACCEPT4_6_X       389
#define EVT_SYSCALL_UMOUNT2_E        390
#define EVT_SYSCALL_UMOUNT2_X        391
#define EVT_SYSCALL_PIPE2_E          392
#define EVT_SYSCALL_PIPE2_X          393
#define EVT_SYSCALL_INOTIFY_INIT1_E  394
#define EVT_SYSCALL_INOTIFY_INIT1_X  395
#define EVT_SYSCALL_EVENTFD2_E       396
#define EVT_SYSCALL_EVENTFD2_X       397
#define EVT_SYSCALL_SIGNALFD4_E      398
#define EVT_SYSCALL_SIGNALFD4_X      399
#define EVT_SYSCALL_PRCTL_E          400
#define EVT_SYSCALL_PRCTL_X          401
#define EVT_ASYNCEVENT_E             402
#define EVT_ASYNCEVENT_X             403
#define EVT_SYSCALL_MEMFD_CREATE_E   404
#define EVT_SYSCALL_MEMFD_CREATE_X   405
#define EVT_SYSCALL_PIDFD_GETFD_E    406
#define EVT_SYSCALL_PIDFD_GETFD_X    407
#define EVT_SYSCALL_PIDFD_OPEN_E     408
#define EVT_SYSCALL_PIDFD_OPEN_X     409
#define EVT_SYSCALL_INIT_MODULE_E    410
#define EVT_SYSCALL_INIT_MODULE_X    411
#define EVT_SYSCALL_FINIT_MODULE_E   412
#define EVT_SYSCALL_FINIT_MODULE_X   413
#define EVT_SYSCALL_MKNOD_E          414
#define EVT_SYSCALL_MKNOD_X          415
#define EVT_SYSCALL_MKNODAT_E        416
#define EVT_SYSCALL_MKNODAT_X        417
#define EVT_SYSCALL_NEWFSTATAT_E     418
#define EVT_SYSCALL_NEWFSTATAT_X     419
#define EVT_SYSCALL_PROCESS_VM_READV_E 420
#define EVT_SYSCALL_PROCESS_VM_READV_X 421
#define EVT_SYSCALL_PROCESS_VM_WRITEV_E 422
#define EVT_SYSCALL_PROCESS_VM_WRITEV_X 423
#define EVT_SYSCALL_DELETE_MODULE_E  424
#define EVT_SYSCALL_DELETE_MODULE_X  425
#define EVT_SYSCALL_SETREUID_E       426
#define EVT_SYSCALL_SETREUID_X       427
#define EVT_SYSCALL_SETREGID_E       428
#define EVT_SYSCALL_SETREGID_X       429

static const value_string event_type_vals[] = {
/* Value strings. Automatically generated by tools/generate-sysdig-event.py */
    { EVT_GENERIC_E,                   EVT_STR_SYSCALL },
    { EVT_GENERIC_X,                   EVT_STR_SYSCALL },
    { EVT_SYSCALL_OPEN_E,              EVT_STR_OPEN },
    { EVT_SYSCALL_OPEN_X,              EVT_STR_OPEN },
    { EVT_SYSCALL_CLOSE_E,             EVT_STR_CLOSE },
    { EVT_SYSCALL_CLOSE_X,             EVT_STR_CLOSE },
    { EVT_SYSCALL_READ_E,              EVT_STR_READ },
    { EVT_SYSCALL_READ_X,              EVT_STR_READ },
    { EVT_SYSCALL_WRITE_E,             EVT_STR_WRITE },
    { EVT_SYSCALL_WRITE_X,             EVT_STR_WRITE },
    { EVT_SYSCALL_BRK_1_E,             EVT_STR_BRK },
    { EVT_SYSCALL_BRK_1_X,             EVT_STR_BRK },
    { EVT_SYSCALL_EXECVE_8_E,          EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_8_X,          EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_11_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_11_X,          EVT_STR_CLONE },
    { EVT_PROCEXIT_E,                  EVT_STR_PROCEXIT },
    { EVT_PROCEXIT_X,                  EVT_STR_NA },
    { EVT_SOCKET_SOCKET_E,             EVT_STR_SOCKET },
    { EVT_SOCKET_SOCKET_X,             EVT_STR_SOCKET },
    { EVT_SOCKET_BIND_E,               EVT_STR_BIND },
    { EVT_SOCKET_BIND_X,               EVT_STR_BIND },
    { EVT_SOCKET_CONNECT_E,            EVT_STR_CONNECT },
    { EVT_SOCKET_CONNECT_X,            EVT_STR_CONNECT },
    { EVT_SOCKET_LISTEN_E,             EVT_STR_LISTEN },
    { EVT_SOCKET_LISTEN_X,             EVT_STR_LISTEN },
    { EVT_SOCKET_ACCEPT_E,             EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT_X,             EVT_STR_ACCEPT },
    { EVT_SOCKET_SEND_E,               EVT_STR_SEND },
    { EVT_SOCKET_SEND_X,               EVT_STR_SEND },
    { EVT_SOCKET_SENDTO_E,             EVT_STR_SENDTO },
    { EVT_SOCKET_SENDTO_X,             EVT_STR_SENDTO },
    { EVT_SOCKET_RECV_E,               EVT_STR_RECV },
    { EVT_SOCKET_RECV_X,               EVT_STR_RECV },
    { EVT_SOCKET_RECVFROM_E,           EVT_STR_RECVFROM },
    { EVT_SOCKET_RECVFROM_X,           EVT_STR_RECVFROM },
    { EVT_SOCKET_SHUTDOWN_E,           EVT_STR_SHUTDOWN },
    { EVT_SOCKET_SHUTDOWN_X,           EVT_STR_SHUTDOWN },
    { EVT_SOCKET_GETSOCKNAME_E,        EVT_STR_GETSOCKNAME },
    { EVT_SOCKET_GETSOCKNAME_X,        EVT_STR_GETSOCKNAME },
    { EVT_SOCKET_GETPEERNAME_E,        EVT_STR_GETPEERNAME },
    { EVT_SOCKET_GETPEERNAME_X,        EVT_STR_GETPEERNAME },
    { EVT_SOCKET_SOCKETPAIR_E,         EVT_STR_SOCKETPAIR },
    { EVT_SOCKET_SOCKETPAIR_X,         EVT_STR_SOCKETPAIR },
    { EVT_SOCKET_SETSOCKOPT_E,         EVT_STR_SETSOCKOPT },
    { EVT_SOCKET_SETSOCKOPT_X,         EVT_STR_SETSOCKOPT },
    { EVT_SOCKET_GETSOCKOPT_E,         EVT_STR_GETSOCKOPT },
    { EVT_SOCKET_GETSOCKOPT_X,         EVT_STR_GETSOCKOPT },
    { EVT_SOCKET_SENDMSG_E,            EVT_STR_SENDMSG },
    { EVT_SOCKET_SENDMSG_X,            EVT_STR_SENDMSG },
    { EVT_SOCKET_SENDMMSG_E,           EVT_STR_SENDMMSG },
    { EVT_SOCKET_SENDMMSG_X,           EVT_STR_SENDMMSG },
    { EVT_SOCKET_RECVMSG_E,            EVT_STR_RECVMSG },
    { EVT_SOCKET_RECVMSG_X,            EVT_STR_RECVMSG },
    { EVT_SOCKET_RECVMMSG_E,           EVT_STR_RECVMMSG },
    { EVT_SOCKET_RECVMMSG_X,           EVT_STR_RECVMMSG },
    { EVT_SOCKET_ACCEPT4_E,            EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_X,            EVT_STR_ACCEPT },
    { EVT_SYSCALL_CREAT_E,             EVT_STR_CREAT },
    { EVT_SYSCALL_CREAT_X,             EVT_STR_CREAT },
    { EVT_SYSCALL_PIPE_E,              EVT_STR_PIPE },
    { EVT_SYSCALL_PIPE_X,              EVT_STR_PIPE },
    { EVT_SYSCALL_EVENTFD_E,           EVT_STR_EVENTFD },
    { EVT_SYSCALL_EVENTFD_X,           EVT_STR_EVENTFD },
    { EVT_SYSCALL_FUTEX_E,             EVT_STR_FUTEX },
    { EVT_SYSCALL_FUTEX_X,             EVT_STR_FUTEX },
    { EVT_SYSCALL_STAT_E,              EVT_STR_STAT },
    { EVT_SYSCALL_STAT_X,              EVT_STR_STAT },
    { EVT_SYSCALL_LSTAT_E,             EVT_STR_LSTAT },
    { EVT_SYSCALL_LSTAT_X,             EVT_STR_LSTAT },
    { EVT_SYSCALL_FSTAT_E,             EVT_STR_FSTAT },
    { EVT_SYSCALL_FSTAT_X,             EVT_STR_FSTAT },
    { EVT_SYSCALL_STAT64_E,            EVT_STR_STAT64 },
    { EVT_SYSCALL_STAT64_X,            EVT_STR_STAT64 },
    { EVT_SYSCALL_LSTAT64_E,           EVT_STR_LSTAT64 },
    { EVT_SYSCALL_LSTAT64_X,           EVT_STR_LSTAT64 },
    { EVT_SYSCALL_FSTAT64_E,           EVT_STR_FSTAT64 },
    { EVT_SYSCALL_FSTAT64_X,           EVT_STR_FSTAT64 },
    { EVT_SYSCALL_EPOLLWAIT_E,         EVT_STR_EPOLL_WAIT },
    { EVT_SYSCALL_EPOLLWAIT_X,         EVT_STR_EPOLL_WAIT },
    { EVT_SYSCALL_POLL_E,              EVT_STR_POLL },
    { EVT_SYSCALL_POLL_X,              EVT_STR_POLL },
    { EVT_SYSCALL_SELECT_E,            EVT_STR_SELECT },
    { EVT_SYSCALL_SELECT_X,            EVT_STR_SELECT },
    { EVT_SYSCALL_NEWSELECT_E,         EVT_STR_SELECT },
    { EVT_SYSCALL_NEWSELECT_X,         EVT_STR_SELECT },
    { EVT_SYSCALL_LSEEK_E,             EVT_STR_LSEEK },
    { EVT_SYSCALL_LSEEK_X,             EVT_STR_LSEEK },
    { EVT_SYSCALL_LLSEEK_E,            EVT_STR_LLSEEK },
    { EVT_SYSCALL_LLSEEK_X,            EVT_STR_LLSEEK },
    { EVT_SYSCALL_IOCTL_2_E,           EVT_STR_IOCTL },
    { EVT_SYSCALL_IOCTL_2_X,           EVT_STR_IOCTL },
    { EVT_SYSCALL_GETCWD_E,            EVT_STR_GETCWD },
    { EVT_SYSCALL_GETCWD_X,            EVT_STR_GETCWD },
    { EVT_SYSCALL_CHDIR_E,             EVT_STR_CHDIR },
    { EVT_SYSCALL_CHDIR_X,             EVT_STR_CHDIR },
    { EVT_SYSCALL_FCHDIR_E,            EVT_STR_FCHDIR },
    { EVT_SYSCALL_FCHDIR_X,            EVT_STR_FCHDIR },
    { EVT_SYSCALL_MKDIR_E,             EVT_STR_MKDIR },
    { EVT_SYSCALL_MKDIR_X,             EVT_STR_MKDIR },
    { EVT_SYSCALL_RMDIR_E,             EVT_STR_RMDIR },
    { EVT_SYSCALL_RMDIR_X,             EVT_STR_RMDIR },
    { EVT_SYSCALL_OPENAT_E,            EVT_STR_OPENAT },
    { EVT_SYSCALL_OPENAT_X,            EVT_STR_OPENAT },
    { EVT_SYSCALL_LINK_E,              EVT_STR_LINK },
    { EVT_SYSCALL_LINK_X,              EVT_STR_LINK },
    { EVT_SYSCALL_LINKAT_E,            EVT_STR_LINKAT },
    { EVT_SYSCALL_LINKAT_X,            EVT_STR_LINKAT },
    { EVT_SYSCALL_UNLINK_E,            EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINK_X,            EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINKAT_E,          EVT_STR_UNLINKAT },
    { EVT_SYSCALL_UNLINKAT_X,          EVT_STR_UNLINKAT },
    { EVT_SYSCALL_PREAD_E,             EVT_STR_PREAD },
    { EVT_SYSCALL_PREAD_X,             EVT_STR_PREAD },
    { EVT_SYSCALL_PWRITE_E,            EVT_STR_PWRITE },
    { EVT_SYSCALL_PWRITE_X,            EVT_STR_PWRITE },
    { EVT_SYSCALL_READV_E,             EVT_STR_READV },
    { EVT_SYSCALL_READV_X,             EVT_STR_READV },
    { EVT_SYSCALL_WRITEV_E,            EVT_STR_WRITEV },
    { EVT_SYSCALL_WRITEV_X,            EVT_STR_WRITEV },
    { EVT_SYSCALL_PREADV_E,            EVT_STR_PREADV },
    { EVT_SYSCALL_PREADV_X,            EVT_STR_PREADV },
    { EVT_SYSCALL_PWRITEV_E,           EVT_STR_PWRITEV },
    { EVT_SYSCALL_PWRITEV_X,           EVT_STR_PWRITEV },
    { EVT_SYSCALL_DUP_E,               EVT_STR_DUP },
    { EVT_SYSCALL_DUP_X,               EVT_STR_DUP },
    { EVT_SYSCALL_SIGNALFD_E,          EVT_STR_SIGNALFD },
    { EVT_SYSCALL_SIGNALFD_X,          EVT_STR_SIGNALFD },
    { EVT_SYSCALL_KILL_E,              EVT_STR_KILL },
    { EVT_SYSCALL_KILL_X,              EVT_STR_KILL },
    { EVT_SYSCALL_TKILL_E,             EVT_STR_TKILL },
    { EVT_SYSCALL_TKILL_X,             EVT_STR_TKILL },
    { EVT_SYSCALL_TGKILL_E,            EVT_STR_TGKILL },
    { EVT_SYSCALL_TGKILL_X,            EVT_STR_TGKILL },
    { EVT_SYSCALL_NANOSLEEP_E,         EVT_STR_NANOSLEEP },
    { EVT_SYSCALL_NANOSLEEP_X,         EVT_STR_NANOSLEEP },
    { EVT_SYSCALL_TIMERFD_CREATE_E,    EVT_STR_TIMERFD_CREATE },
    { EVT_SYSCALL_TIMERFD_CREATE_X,    EVT_STR_TIMERFD_CREATE },
    { EVT_SYSCALL_INOTIFY_INIT_E,      EVT_STR_INOTIFY_INIT },
    { EVT_SYSCALL_INOTIFY_INIT_X,      EVT_STR_INOTIFY_INIT },
    { EVT_SYSCALL_GETRLIMIT_E,         EVT_STR_GETRLIMIT },
    { EVT_SYSCALL_GETRLIMIT_X,         EVT_STR_GETRLIMIT },
    { EVT_SYSCALL_SETRLIMIT_E,         EVT_STR_SETRLIMIT },
    { EVT_SYSCALL_SETRLIMIT_X,         EVT_STR_SETRLIMIT },
    { EVT_SYSCALL_PRLIMIT_E,           EVT_STR_PRLIMIT },
    { EVT_SYSCALL_PRLIMIT_X,           EVT_STR_PRLIMIT },
    { EVT_SCHEDSWITCH_1_E,             EVT_STR_SWITCH },
    { EVT_SCHEDSWITCH_1_X,             EVT_STR_NA },
    { EVT_DROP_E,                      EVT_STR_DROP },
    { EVT_DROP_X,                      EVT_STR_DROP },
    { EVT_SYSCALL_FCNTL_E,             EVT_STR_FCNTL },
    { EVT_SYSCALL_FCNTL_X,             EVT_STR_FCNTL },
    { EVT_SCHEDSWITCH_6_E,             EVT_STR_SWITCH },
    { EVT_SCHEDSWITCH_6_X,             EVT_STR_NA },
    { EVT_SYSCALL_EXECVE_13_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_13_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_16_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_16_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_BRK_4_E,             EVT_STR_BRK },
    { EVT_SYSCALL_BRK_4_X,             EVT_STR_BRK },
    { EVT_SYSCALL_MMAP_E,              EVT_STR_MMAP },
    { EVT_SYSCALL_MMAP_X,              EVT_STR_MMAP },
    { EVT_SYSCALL_MMAP2_E,             EVT_STR_MMAP2 },
    { EVT_SYSCALL_MMAP2_X,             EVT_STR_MMAP2 },
    { EVT_SYSCALL_MUNMAP_E,            EVT_STR_MUNMAP },
    { EVT_SYSCALL_MUNMAP_X,            EVT_STR_MUNMAP },
    { EVT_SYSCALL_SPLICE_E,            EVT_STR_SPLICE },
    { EVT_SYSCALL_SPLICE_X,            EVT_STR_SPLICE },
    { EVT_SYSCALL_PTRACE_E,            EVT_STR_PTRACE },
    { EVT_SYSCALL_PTRACE_X,            EVT_STR_PTRACE },
    { EVT_SYSCALL_IOCTL_3_E,           EVT_STR_IOCTL },
    { EVT_SYSCALL_IOCTL_3_X,           EVT_STR_IOCTL },
    { EVT_SYSCALL_EXECVE_14_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_14_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_RENAME_E,            EVT_STR_RENAME },
    { EVT_SYSCALL_RENAME_X,            EVT_STR_RENAME },
    { EVT_SYSCALL_RENAMEAT_E,          EVT_STR_RENAMEAT },
    { EVT_SYSCALL_RENAMEAT_X,          EVT_STR_RENAMEAT },
    { EVT_SYSCALL_SYMLINK_E,           EVT_STR_SYMLINK },
    { EVT_SYSCALL_SYMLINK_X,           EVT_STR_SYMLINK },
    { EVT_SYSCALL_SYMLINKAT_E,         EVT_STR_SYMLINKAT },
    { EVT_SYSCALL_SYMLINKAT_X,         EVT_STR_SYMLINKAT },
    { EVT_SYSCALL_FORK_E,              EVT_STR_FORK },
    { EVT_SYSCALL_FORK_X,              EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_E,             EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_X,             EVT_STR_VFORK },
    { EVT_PROCEXIT_1_E,                EVT_STR_PROCEXIT },
    { EVT_PROCEXIT_1_X,                EVT_STR_NA },
    { EVT_SYSCALL_SENDFILE_E,          EVT_STR_SENDFILE },
    { EVT_SYSCALL_SENDFILE_X,          EVT_STR_SENDFILE },
    { EVT_SYSCALL_QUOTACTL_E,          EVT_STR_QUOTACTL },
    { EVT_SYSCALL_QUOTACTL_X,          EVT_STR_QUOTACTL },
    { EVT_SYSCALL_SETRESUID_E,         EVT_STR_SETRESUID },
    { EVT_SYSCALL_SETRESUID_X,         EVT_STR_SETRESUID },
    { EVT_SYSCALL_SETRESGID_E,         EVT_STR_SETRESGID },
    { EVT_SYSCALL_SETRESGID_X,         EVT_STR_SETRESGID },
    { EVT_SCAPEVENT_E,                 EVT_STR_SCAPEVENT },
    { EVT_SCAPEVENT_X,                 EVT_STR_SCAPEVENT },
    { EVT_SYSCALL_SETUID_E,            EVT_STR_SETUID },
    { EVT_SYSCALL_SETUID_X,            EVT_STR_SETUID },
    { EVT_SYSCALL_SETGID_E,            EVT_STR_SETGID },
    { EVT_SYSCALL_SETGID_X,            EVT_STR_SETGID },
    { EVT_SYSCALL_GETUID_E,            EVT_STR_GETUID },
    { EVT_SYSCALL_GETUID_X,            EVT_STR_GETUID },
    { EVT_SYSCALL_GETEUID_E,           EVT_STR_GETEUID },
    { EVT_SYSCALL_GETEUID_X,           EVT_STR_GETEUID },
    { EVT_SYSCALL_GETGID_E,            EVT_STR_GETGID },
    { EVT_SYSCALL_GETGID_X,            EVT_STR_GETGID },
    { EVT_SYSCALL_GETEGID_E,           EVT_STR_GETEGID },
    { EVT_SYSCALL_GETEGID_X,           EVT_STR_GETEGID },
    { EVT_SYSCALL_GETRESUID_E,         EVT_STR_GETRESUID },
    { EVT_SYSCALL_GETRESUID_X,         EVT_STR_GETRESUID },
    { EVT_SYSCALL_GETRESGID_E,         EVT_STR_GETRESGID },
    { EVT_SYSCALL_GETRESGID_X,         EVT_STR_GETRESGID },
    { EVT_SYSCALL_EXECVE_15_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_15_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_17_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_17_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_FORK_17_E,           EVT_STR_FORK },
    { EVT_SYSCALL_FORK_17_X,           EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_17_E,          EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_17_X,          EVT_STR_VFORK },
    { EVT_SYSCALL_CLONE_20_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_20_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_FORK_20_E,           EVT_STR_FORK },
    { EVT_SYSCALL_FORK_20_X,           EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_20_E,          EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_20_X,          EVT_STR_VFORK },
    { EVT_CONTAINER_E,                 EVT_STR_CONTAINER },
    { EVT_CONTAINER_X,                 EVT_STR_NA },
    { EVT_SYSCALL_EXECVE_16_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_16_X,         EVT_STR_EXECVE },
    { EVT_SIGNALDELIVER_E,             EVT_STR_SIGNALDELIVER },
    { EVT_SIGNALDELIVER_X,             EVT_STR_NA },
    { EVT_PROCINFO_E,                  EVT_STR_PROCINFO },
    { EVT_PROCINFO_X,                  EVT_STR_NA },
    { EVT_SYSCALL_GETDENTS_E,          EVT_STR_GETDENTS },
    { EVT_SYSCALL_GETDENTS_X,          EVT_STR_GETDENTS },
    { EVT_SYSCALL_GETDENTS64_E,        EVT_STR_GETDENTS64 },
    { EVT_SYSCALL_GETDENTS64_X,        EVT_STR_GETDENTS64 },
    { EVT_SYSCALL_SETNS_E,             EVT_STR_SETNS },
    { EVT_SYSCALL_SETNS_X,             EVT_STR_SETNS },
    { EVT_SYSCALL_FLOCK_E,             EVT_STR_FLOCK },
    { EVT_SYSCALL_FLOCK_X,             EVT_STR_FLOCK },
    { EVT_CPU_HOTPLUG_E,               EVT_STR_CPU_HOTPLUG },
    { EVT_CPU_HOTPLUG_X,               EVT_STR_NA },
    { EVT_SOCKET_ACCEPT_5_E,           EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT_5_X,           EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_5_E,          EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_5_X,          EVT_STR_ACCEPT },
    { EVT_SYSCALL_SEMOP_E,             EVT_STR_SEMOP },
    { EVT_SYSCALL_SEMOP_X,             EVT_STR_SEMOP },
    { EVT_SYSCALL_SEMCTL_E,            EVT_STR_SEMCTL },
    { EVT_SYSCALL_SEMCTL_X,            EVT_STR_SEMCTL },
    { EVT_SYSCALL_PPOLL_E,             EVT_STR_PPOLL },
    { EVT_SYSCALL_PPOLL_X,             EVT_STR_PPOLL },
    { EVT_SYSCALL_MOUNT_E,             EVT_STR_MOUNT },
    { EVT_SYSCALL_MOUNT_X,             EVT_STR_MOUNT },
    { EVT_SYSCALL_UMOUNT_E,            EVT_STR_UMOUNT },
    { EVT_SYSCALL_UMOUNT_X,            EVT_STR_UMOUNT },
    { EVT_K8S_E,                       EVT_STR_K8S },
    { EVT_K8S_X,                       EVT_STR_NA },
    { EVT_SYSCALL_SEMGET_E,            EVT_STR_SEMGET },
    { EVT_SYSCALL_SEMGET_X,            EVT_STR_SEMGET },
    { EVT_SYSCALL_ACCESS_E,            EVT_STR_ACCESS },
    { EVT_SYSCALL_ACCESS_X,            EVT_STR_ACCESS },
    { EVT_SYSCALL_CHROOT_E,            EVT_STR_CHROOT },
    { EVT_SYSCALL_CHROOT_X,            EVT_STR_CHROOT },
    { EVT_TRACER_E,                    EVT_STR_TRACER },
    { EVT_TRACER_X,                    EVT_STR_TRACER },
    { EVT_MESOS_E,                     EVT_STR_MESOS },
    { EVT_MESOS_X,                     EVT_STR_NA },
    { EVT_CONTAINER_JSON_E,            EVT_STR_CONTAINER },
    { EVT_CONTAINER_JSON_X,            EVT_STR_NA },
    { EVT_SYSCALL_SETSID_E,            EVT_STR_SETSID },
    { EVT_SYSCALL_SETSID_X,            EVT_STR_SETSID },
    { EVT_SYSCALL_MKDIR_2_E,           EVT_STR_MKDIR },
    { EVT_SYSCALL_MKDIR_2_X,           EVT_STR_MKDIR },
    { EVT_SYSCALL_RMDIR_2_E,           EVT_STR_RMDIR },
    { EVT_SYSCALL_RMDIR_2_X,           EVT_STR_RMDIR },
    { EVT_NOTIFICATION_E,              EVT_STR_NOTIFICATION },
    { EVT_NOTIFICATION_X,              EVT_STR_NA },
    { EVT_SYSCALL_EXECVE_17_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_17_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_UNSHARE_E,           EVT_STR_UNSHARE },
    { EVT_SYSCALL_UNSHARE_X,           EVT_STR_UNSHARE },
    { EVT_INFRASTRUCTURE_EVENT_E,      EVT_STR_INFRA },
    { EVT_INFRASTRUCTURE_EVENT_X,      EVT_STR_NA },
    { EVT_SYSCALL_EXECVE_18_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_18_X,         EVT_STR_EXECVE },
    { EVT_PAGE_FAULT_E,                EVT_STR_PAGE_FAULT },
    { EVT_PAGE_FAULT_X,                EVT_STR_NA },
    { EVT_SYSCALL_EXECVE_19_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_19_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_SETPGID_E,           EVT_STR_SETPGID },
    { EVT_SYSCALL_SETPGID_X,           EVT_STR_SETPGID },
    { EVT_SYSCALL_BPF_E,               EVT_STR_BPF },
    { EVT_SYSCALL_BPF_X,               EVT_STR_BPF },
    { EVT_SYSCALL_SECCOMP_E,           EVT_STR_SECCOMP },
    { EVT_SYSCALL_SECCOMP_X,           EVT_STR_SECCOMP },
    { EVT_SYSCALL_UNLINK_2_E,          EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINK_2_X,          EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINKAT_2_E,        EVT_STR_UNLINKAT },
    { EVT_SYSCALL_UNLINKAT_2_X,        EVT_STR_UNLINKAT },
    { EVT_SYSCALL_MKDIRAT_E,           EVT_STR_MKDIRAT },
    { EVT_SYSCALL_MKDIRAT_X,           EVT_STR_MKDIRAT },
    { EVT_SYSCALL_OPENAT_2_E,          EVT_STR_OPENAT },
    { EVT_SYSCALL_OPENAT_2_X,          EVT_STR_OPENAT },
    { EVT_SYSCALL_LINK_2_E,            EVT_STR_LINK },
    { EVT_SYSCALL_LINK_2_X,            EVT_STR_LINK },
    { EVT_SYSCALL_LINKAT_2_E,          EVT_STR_LINKAT },
    { EVT_SYSCALL_LINKAT_2_X,          EVT_STR_LINKAT },
    { EVT_SYSCALL_FCHMODAT_E,          EVT_STR_FCHMODAT },
    { EVT_SYSCALL_FCHMODAT_X,          EVT_STR_FCHMODAT },
    { EVT_SYSCALL_CHMOD_E,             EVT_STR_CHMOD },
    { EVT_SYSCALL_CHMOD_X,             EVT_STR_CHMOD },
    { EVT_SYSCALL_FCHMOD_E,            EVT_STR_FCHMOD },
    { EVT_SYSCALL_FCHMOD_X,            EVT_STR_FCHMOD },
    { EVT_SYSCALL_RENAMEAT2_E,         EVT_STR_RENAMEAT2 },
    { EVT_SYSCALL_RENAMEAT2_X,         EVT_STR_RENAMEAT2 },
    { EVT_SYSCALL_USERFAULTFD_E,       EVT_STR_USERFAULTFD },
    { EVT_SYSCALL_USERFAULTFD_X,       EVT_STR_USERFAULTFD },
    { EVT_PLUGINEVENT_E,               EVT_STR_PLUGINEVENT },
    { EVT_PLUGINEVENT_X,               EVT_STR_NA },
    { EVT_CONTAINER_JSON_2_E,          EVT_STR_CONTAINER },
    { EVT_CONTAINER_JSON_2_X,          EVT_STR_NA },
    { EVT_SYSCALL_OPENAT2_E,           EVT_STR_OPENAT2 },
    { EVT_SYSCALL_OPENAT2_X,           EVT_STR_OPENAT2 },
    { EVT_SYSCALL_MPROTECT_E,          EVT_STR_MPROTECT },
    { EVT_SYSCALL_MPROTECT_X,          EVT_STR_MPROTECT },
    { EVT_SYSCALL_EXECVEAT_E,          EVT_STR_EXECVEAT },
    { EVT_SYSCALL_EXECVEAT_X,          EVT_STR_EXECVEAT },
    { EVT_SYSCALL_COPY_FILE_RANGE_E,   EVT_STR_COPY_FILE_RANGE },
    { EVT_SYSCALL_COPY_FILE_RANGE_X,   EVT_STR_COPY_FILE_RANGE },
    { EVT_SYSCALL_CLONE3_E,            EVT_STR_CLONE3 },
    { EVT_SYSCALL_CLONE3_X,            EVT_STR_CLONE3 },
    { EVT_SYSCALL_OPEN_BY_HANDLE_AT_E, EVT_STR_OPEN_BY_HANDLE_AT },
    { EVT_SYSCALL_OPEN_BY_HANDLE_AT_X, EVT_STR_OPEN_BY_HANDLE_AT },
    { EVT_SYSCALL_IO_URING_SETUP_E,    EVT_STR_IO_URING_SETUP },
    { EVT_SYSCALL_IO_URING_SETUP_X,    EVT_STR_IO_URING_SETUP },
    { EVT_SYSCALL_IO_URING_ENTER_E,    EVT_STR_IO_URING_ENTER },
    { EVT_SYSCALL_IO_URING_ENTER_X,    EVT_STR_IO_URING_ENTER },
    { EVT_SYSCALL_IO_URING_REGISTER_E, EVT_STR_IO_URING_REGISTER },
    { EVT_SYSCALL_IO_URING_REGISTER_X, EVT_STR_IO_URING_REGISTER },
    { EVT_SYSCALL_MLOCK_E,             EVT_STR_MLOCK },
    { EVT_SYSCALL_MLOCK_X,             EVT_STR_MLOCK },
    { EVT_SYSCALL_MUNLOCK_E,           EVT_STR_MUNLOCK },
    { EVT_SYSCALL_MUNLOCK_X,           EVT_STR_MUNLOCK },
    { EVT_SYSCALL_MLOCKALL_E,          EVT_STR_MLOCKALL },
    { EVT_SYSCALL_MLOCKALL_X,          EVT_STR_MLOCKALL },
    { EVT_SYSCALL_MUNLOCKALL_E,        EVT_STR_MUNLOCKALL },
    { EVT_SYSCALL_MUNLOCKALL_X,        EVT_STR_MUNLOCKALL },
    { EVT_SYSCALL_CAPSET_E,            EVT_STR_CAPSET },
    { EVT_SYSCALL_CAPSET_X,            EVT_STR_CAPSET },
    { EVT_USER_ADDED_E,                EVT_STR_USERADDED },
    { EVT_USER_ADDED_X,                EVT_STR_NA },
    { EVT_USER_DELETED_E,              EVT_STR_USERDELETED },
    { EVT_USER_DELETED_X,              EVT_STR_NA },
    { EVT_GROUP_ADDED_E,               EVT_STR_GROUPADDED },
    { EVT_GROUP_ADDED_X,               EVT_STR_NA },
    { EVT_GROUP_DELETED_E,             EVT_STR_GROUPDELETED },
    { EVT_GROUP_DELETED_X,             EVT_STR_NA },
    { EVT_SYSCALL_DUP2_E,              EVT_STR_DUP2 },
    { EVT_SYSCALL_DUP2_X,              EVT_STR_DUP2 },
    { EVT_SYSCALL_DUP3_E,              EVT_STR_DUP3 },
    { EVT_SYSCALL_DUP3_X,              EVT_STR_DUP3 },
    { EVT_SYSCALL_DUP_1_E,             EVT_STR_DUP },
    { EVT_SYSCALL_DUP_1_X,             EVT_STR_DUP },
    { EVT_SYSCALL_BPF_2_E,             EVT_STR_BPF },
    { EVT_SYSCALL_BPF_2_X,             EVT_STR_BPF },
    { EVT_SYSCALL_MLOCK2_E,            EVT_STR_MLOCK2 },
    { EVT_SYSCALL_MLOCK2_X,            EVT_STR_MLOCK2 },
    { EVT_SYSCALL_FSCONFIG_E,          EVT_STR_FSCONFIG },
    { EVT_SYSCALL_FSCONFIG_X,          EVT_STR_FSCONFIG },
    { EVT_SYSCALL_EPOLL_CREATE_E,      EVT_STR_EPOLL_CREATE },
    { EVT_SYSCALL_EPOLL_CREATE_X,      EVT_STR_EPOLL_CREATE },
    { EVT_SYSCALL_EPOLL_CREATE1_E,     EVT_STR_EPOLL_CREATE1 },
    { EVT_SYSCALL_EPOLL_CREATE1_X,     EVT_STR_EPOLL_CREATE1 },
    { EVT_SYSCALL_CHOWN_E,             EVT_STR_CHOWN },
    { EVT_SYSCALL_CHOWN_X,             EVT_STR_CHOWN },
    { EVT_SYSCALL_LCHOWN_E,            EVT_STR_LCHOWN },
    { EVT_SYSCALL_LCHOWN_X,            EVT_STR_LCHOWN },
    { EVT_SYSCALL_FCHOWN_E,            EVT_STR_FCHOWN },
    { EVT_SYSCALL_FCHOWN_X,            EVT_STR_FCHOWN },
    { EVT_SYSCALL_FCHOWNAT_E,          EVT_STR_FCHOWNAT },
    { EVT_SYSCALL_FCHOWNAT_X,          EVT_STR_FCHOWNAT },
    { EVT_SYSCALL_UMOUNT_1_E,          EVT_STR_UMOUNT },
    { EVT_SYSCALL_UMOUNT_1_X,          EVT_STR_UMOUNT },
    { EVT_SOCKET_ACCEPT4_6_E,          EVT_STR_ACCEPT4 },
    { EVT_SOCKET_ACCEPT4_6_X,          EVT_STR_ACCEPT4 },
    { EVT_SYSCALL_UMOUNT2_E,           EVT_STR_UMOUNT2 },
    { EVT_SYSCALL_UMOUNT2_X,           EVT_STR_UMOUNT2 },
    { EVT_SYSCALL_PIPE2_E,             EVT_STR_PIPE2 },
    { EVT_SYSCALL_PIPE2_X,             EVT_STR_PIPE2 },
    { EVT_SYSCALL_INOTIFY_INIT1_E,     EVT_STR_INOTIFY_INIT1 },
    { EVT_SYSCALL_INOTIFY_INIT1_X,     EVT_STR_INOTIFY_INIT1 },
    { EVT_SYSCALL_EVENTFD2_E,          EVT_STR_EVENTFD2 },
    { EVT_SYSCALL_EVENTFD2_X,          EVT_STR_EVENTFD2 },
    { EVT_SYSCALL_SIGNALFD4_E,         EVT_STR_SIGNALFD4 },
    { EVT_SYSCALL_SIGNALFD4_X,         EVT_STR_SIGNALFD4 },
    { EVT_SYSCALL_PRCTL_E,             EVT_STR_PRCTL },
    { EVT_SYSCALL_PRCTL_X,             EVT_STR_PRCTL },
    { EVT_ASYNCEVENT_E,                EVT_STR_ASYNCEVENT },
    { EVT_ASYNCEVENT_X,                EVT_STR_NA },
    { EVT_SYSCALL_MEMFD_CREATE_E,      EVT_STR_MEMFD_CREATE },
    { EVT_SYSCALL_MEMFD_CREATE_X,      EVT_STR_MEMFD_CREATE },
    { EVT_SYSCALL_PIDFD_GETFD_E,       EVT_STR_PIDFD_GETFD },
    { EVT_SYSCALL_PIDFD_GETFD_X,       EVT_STR_PIDFD_GETFD },
    { EVT_SYSCALL_PIDFD_OPEN_E,        EVT_STR_PIDFD_OPEN },
    { EVT_SYSCALL_PIDFD_OPEN_X,        EVT_STR_PIDFD_OPEN },
    { EVT_SYSCALL_INIT_MODULE_E,       EVT_STR_INIT_MODULE },
    { EVT_SYSCALL_INIT_MODULE_X,       EVT_STR_INIT_MODULE },
    { EVT_SYSCALL_FINIT_MODULE_E,      EVT_STR_FINIT_MODULE },
    { EVT_SYSCALL_FINIT_MODULE_X,      EVT_STR_FINIT_MODULE },
    { EVT_SYSCALL_MKNOD_E,             EVT_STR_MKNOD },
    { EVT_SYSCALL_MKNOD_X,             EVT_STR_MKNOD },
    { EVT_SYSCALL_MKNODAT_E,           EVT_STR_MKNODAT },
    { EVT_SYSCALL_MKNODAT_X,           EVT_STR_MKNODAT },
    { EVT_SYSCALL_NEWFSTATAT_E,        EVT_STR_NEWFSTATAT },
    { EVT_SYSCALL_NEWFSTATAT_X,        EVT_STR_NEWFSTATAT },
    { EVT_SYSCALL_PROCESS_VM_READV_E,  EVT_STR_PROCESS_VM_READV },
    { EVT_SYSCALL_PROCESS_VM_READV_X,  EVT_STR_PROCESS_VM_READV },
    { EVT_SYSCALL_PROCESS_VM_WRITEV_E, EVT_STR_PROCESS_VM_WRITEV },
    { EVT_SYSCALL_PROCESS_VM_WRITEV_X, EVT_STR_PROCESS_VM_WRITEV },
    { EVT_SYSCALL_DELETE_MODULE_E,     EVT_STR_DELETE_MODULE },
    { EVT_SYSCALL_DELETE_MODULE_X,     EVT_STR_DELETE_MODULE },
    { EVT_SYSCALL_SETREUID_E,          EVT_STR_SETREUID },
    { EVT_SYSCALL_SETREUID_X,          EVT_STR_SETREUID },
    { EVT_SYSCALL_SETREGID_E,          EVT_STR_SETREGID },
    { EVT_SYSCALL_SETREGID_X,          EVT_STR_SETREGID },

    {0, NULL }
};

/*
 * "Interesting" parameters, which are appended to COL_INFO.
 * Manually generated for now.
 */
struct _event_col_info_param {
    const int param_num;
    const char *param_name;
    enum ftenum param_ftype;
};

static const struct _event_col_info_param open_x_params[] = {
    { 0, "fd", FT_UINT64 },
    { 1, "name", FT_STRING },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param close_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param read_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param write_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param execve_15_x_params[] = {
    { 1, "exe", FT_STRING },
    { 2, "args", FT_STRING },
    { 0, NULL, FT_NONE }
};

struct _event_col_info {
    const unsigned event_type;
    const int num_len_fields;
    const struct _event_col_info_param *params;
};

/* Info column parameters */
static const struct _event_col_info event_col_info[] = {
    { EVT_SYSCALL_OPEN_X, 4,  open_x_params },
    { EVT_SYSCALL_CLOSE_E, 1,  close_e_params },
    { EVT_SYSCALL_READ_E, 2,  read_e_params },
    { EVT_SYSCALL_WRITE_E, 2,  write_e_params },
    { EVT_SYSCALL_EXECVE_15_X, 15,  execve_15_x_params },
    { 0, 0, NULL }
};

struct _event_tree_info {
    const unsigned event_type;
    /* int num_params; */
    int * const *hf_indexes;
};

static int * const no_indexes[] = { NULL };

/* Parameter indexes. Automatically generated by tools/generate-sysdig-event.py */
static int * const generic_e_indexes[] = { &hf_param_ID_uint16, &hf_param_nativeID_uint16, NULL };
static int * const generic_x_indexes[] = { &hf_param_ID_uint16, NULL };
static int * const syscall_open_e_indexes[] = { &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, NULL };
static int * const syscall_open_x_indexes[] = { &hf_param_fd_int64, &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, &hf_param_dev_uint32, &hf_param_ino_uint64, NULL };
static int * const syscall_close_e_indexes[] = { &hf_param_fd_int64, NULL };
static int * const syscall_close_x_indexes[] = { &hf_param_res_int64, NULL };
static int * const syscall_read_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, NULL };
static int * const syscall_read_x_indexes[] = { &hf_param_res_int64, &hf_param_data_bytes, NULL };
#define syscall_write_e_indexes syscall_read_e_indexes
#define syscall_write_x_indexes syscall_read_x_indexes
static int * const syscall_brk_1_e_indexes[] = { &hf_param_size_uint32, NULL };
static int * const syscall_brk_1_x_indexes[] = { &hf_param_res_uint64, NULL };
#define syscall_execve_8_e_indexes no_indexes
static int * const syscall_execve_8_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, NULL };
#define syscall_clone_11_e_indexes no_indexes
static int * const syscall_clone_11_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_flags_int32, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define procexit_e_indexes no_indexes
#define procexit_x_indexes no_indexes
static int * const socket_socket_e_indexes[] = { &hf_param_domain_bytes, &hf_param_type_uint32, &hf_param_proto_uint32, NULL };
#define socket_socket_x_indexes syscall_close_e_indexes
#define socket_bind_e_indexes syscall_close_e_indexes
static int * const socket_bind_x_indexes[] = { &hf_param_res_int64, &hf_param_addr_bytes, NULL };
static int * const socket_connect_e_indexes[] = { &hf_param_fd_int64, &hf_param_addr_bytes, NULL };
static int * const socket_connect_x_indexes[] = { &hf_param_res_int64, &hf_param_tuple_bytes, &hf_param_fd_int64, NULL };
static int * const socket_listen_e_indexes[] = { &hf_param_fd_int64, &hf_param_backlog_int32, NULL };
#define socket_listen_x_indexes syscall_close_x_indexes
#define socket_accept_e_indexes no_indexes
static int * const socket_accept_x_indexes[] = { &hf_param_fd_int64, &hf_param_tuple_bytes, &hf_param_queuepct_uint8, NULL };
#define socket_send_e_indexes syscall_read_e_indexes
#define socket_send_x_indexes syscall_read_x_indexes
static int * const socket_sendto_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, &hf_param_tuple_bytes, NULL };
#define socket_sendto_x_indexes syscall_read_x_indexes
#define socket_recv_e_indexes syscall_read_e_indexes
#define socket_recv_x_indexes syscall_read_x_indexes
#define socket_recvfrom_e_indexes syscall_read_e_indexes
static int * const socket_recvfrom_x_indexes[] = { &hf_param_res_int64, &hf_param_data_bytes, &hf_param_tuple_bytes, NULL };
static int * const socket_shutdown_e_indexes[] = { &hf_param_fd_int64, &hf_param_how_bytes, NULL };
#define socket_shutdown_x_indexes syscall_close_x_indexes
#define socket_getsockname_e_indexes no_indexes
#define socket_getsockname_x_indexes no_indexes
#define socket_getpeername_e_indexes no_indexes
#define socket_getpeername_x_indexes no_indexes
#define socket_socketpair_e_indexes socket_socket_e_indexes
static int * const socket_socketpair_x_indexes[] = { &hf_param_res_int64, &hf_param_fd1_int64, &hf_param_fd2_int64, &hf_param_source_uint64, &hf_param_peer_uint64, NULL };
#define socket_setsockopt_e_indexes no_indexes
static int * const socket_setsockopt_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_level_bytes, &hf_param_optname_bytes, &hf_param_val_bytes, &hf_param_optlen_uint32, NULL };
#define socket_getsockopt_e_indexes no_indexes
#define socket_getsockopt_x_indexes socket_setsockopt_x_indexes
#define socket_sendmsg_e_indexes socket_sendto_e_indexes
#define socket_sendmsg_x_indexes syscall_read_x_indexes
#define socket_sendmmsg_e_indexes no_indexes
#define socket_sendmmsg_x_indexes no_indexes
#define socket_recvmsg_e_indexes syscall_close_e_indexes
static int * const socket_recvmsg_x_indexes[] = { &hf_param_res_int64, &hf_param_size_uint32, &hf_param_data_bytes, &hf_param_tuple_bytes, &hf_param_msgcontrol_bytes, NULL };
#define socket_recvmmsg_e_indexes no_indexes
#define socket_recvmmsg_x_indexes no_indexes
static int * const socket_accept4_e_indexes[] = { &hf_param_flags_uint32, NULL };
#define socket_accept4_x_indexes socket_accept_x_indexes
static int * const syscall_creat_e_indexes[] = { &hf_param_name_string, &hf_param_mode_uint32, NULL };
static int * const syscall_creat_x_indexes[] = { &hf_param_fd_int64, &hf_param_name_string, &hf_param_mode_uint32, &hf_param_dev_uint32, &hf_param_ino_uint64, NULL };
#define syscall_pipe_e_indexes no_indexes
static int * const syscall_pipe_x_indexes[] = { &hf_param_res_int64, &hf_param_fd1_int64, &hf_param_fd2_int64, &hf_param_ino_uint64, NULL };
static int * const syscall_eventfd_e_indexes[] = { &hf_param_initval_uint64, &hf_param_flags_uint32, NULL };
#define syscall_eventfd_x_indexes syscall_close_x_indexes
static int * const syscall_futex_e_indexes[] = { &hf_param_addr_uint64, &hf_param_op_bytes, &hf_param_val_uint64, NULL };
#define syscall_futex_x_indexes syscall_close_x_indexes
#define syscall_stat_e_indexes no_indexes
static int * const syscall_stat_x_indexes[] = { &hf_param_res_int64, &hf_param_path_string, NULL };
#define syscall_lstat_e_indexes no_indexes
#define syscall_lstat_x_indexes syscall_stat_x_indexes
#define syscall_fstat_e_indexes syscall_close_e_indexes
#define syscall_fstat_x_indexes syscall_close_x_indexes
#define syscall_stat64_e_indexes no_indexes
#define syscall_stat64_x_indexes syscall_stat_x_indexes
#define syscall_lstat64_e_indexes no_indexes
#define syscall_lstat64_x_indexes syscall_stat_x_indexes
#define syscall_fstat64_e_indexes syscall_close_e_indexes
#define syscall_fstat64_x_indexes syscall_close_x_indexes
static int * const syscall_epollwait_e_indexes[] = { &hf_param_maxevents_int64, NULL };
#define syscall_epollwait_x_indexes syscall_close_x_indexes
static int * const syscall_poll_e_indexes[] = { &hf_param_fds_bytes, &hf_param_timeout_int64, NULL };
static int * const syscall_poll_x_indexes[] = { &hf_param_res_int64, &hf_param_fds_bytes, NULL };
#define syscall_select_e_indexes no_indexes
#define syscall_select_x_indexes syscall_close_x_indexes
#define syscall_newselect_e_indexes no_indexes
#define syscall_newselect_x_indexes syscall_close_x_indexes
static int * const syscall_lseek_e_indexes[] = { &hf_param_fd_int64, &hf_param_offset_uint64, &hf_param_whence_bytes, NULL };
#define syscall_lseek_x_indexes syscall_close_x_indexes
#define syscall_llseek_e_indexes syscall_lseek_e_indexes
#define syscall_llseek_x_indexes syscall_close_x_indexes
static int * const syscall_ioctl_2_e_indexes[] = { &hf_param_fd_int64, &hf_param_request_uint64, NULL };
#define syscall_ioctl_2_x_indexes syscall_close_x_indexes
#define syscall_getcwd_e_indexes no_indexes
#define syscall_getcwd_x_indexes syscall_stat_x_indexes
#define syscall_chdir_e_indexes no_indexes
#define syscall_chdir_x_indexes syscall_stat_x_indexes
#define syscall_fchdir_e_indexes syscall_close_e_indexes
#define syscall_fchdir_x_indexes syscall_close_x_indexes
static int * const syscall_mkdir_e_indexes[] = { &hf_param_path_string, &hf_param_mode_uint32, NULL };
#define syscall_mkdir_x_indexes syscall_close_x_indexes
static int * const syscall_rmdir_e_indexes[] = { &hf_param_path_string, NULL };
#define syscall_rmdir_x_indexes syscall_close_x_indexes
static int * const syscall_openat_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, NULL };
#define syscall_openat_x_indexes syscall_close_e_indexes
static int * const syscall_link_e_indexes[] = { &hf_param_oldpath_string, &hf_param_newpath_string, NULL };
#define syscall_link_x_indexes syscall_close_x_indexes
static int * const syscall_linkat_e_indexes[] = { &hf_param_olddir_int64, &hf_param_oldpath_string, &hf_param_newdir_int64, &hf_param_newpath_string, NULL };
#define syscall_linkat_x_indexes syscall_close_x_indexes
#define syscall_unlink_e_indexes syscall_rmdir_e_indexes
#define syscall_unlink_x_indexes syscall_close_x_indexes
static int * const syscall_unlinkat_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_name_string, NULL };
#define syscall_unlinkat_x_indexes syscall_close_x_indexes
static int * const syscall_pread_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, &hf_param_pos_uint64, NULL };
#define syscall_pread_x_indexes syscall_read_x_indexes
#define syscall_pwrite_e_indexes syscall_pread_e_indexes
#define syscall_pwrite_x_indexes syscall_read_x_indexes
#define syscall_readv_e_indexes syscall_close_e_indexes
static int * const syscall_readv_x_indexes[] = { &hf_param_res_int64, &hf_param_size_uint32, &hf_param_data_bytes, NULL };
#define syscall_writev_e_indexes syscall_read_e_indexes
#define syscall_writev_x_indexes syscall_read_x_indexes
static int * const syscall_preadv_e_indexes[] = { &hf_param_fd_int64, &hf_param_pos_uint64, NULL };
#define syscall_preadv_x_indexes syscall_readv_x_indexes
#define syscall_pwritev_e_indexes syscall_pread_e_indexes
#define syscall_pwritev_x_indexes syscall_read_x_indexes
#define syscall_dup_e_indexes syscall_close_e_indexes
#define syscall_dup_x_indexes syscall_close_x_indexes
static int * const syscall_signalfd_e_indexes[] = { &hf_param_fd_int64, &hf_param_mask_uint32, &hf_param_flags_uint8, NULL };
#define syscall_signalfd_x_indexes syscall_close_x_indexes
static int * const syscall_kill_e_indexes[] = { &hf_param_pid_int64, &hf_param_sig_bytes, NULL };
#define syscall_kill_x_indexes syscall_close_x_indexes
static int * const syscall_tkill_e_indexes[] = { &hf_param_tid_int64, &hf_param_sig_bytes, NULL };
#define syscall_tkill_x_indexes syscall_close_x_indexes
static int * const syscall_tgkill_e_indexes[] = { &hf_param_pid_int64, &hf_param_tid_int64, &hf_param_sig_bytes, NULL };
#define syscall_tgkill_x_indexes syscall_close_x_indexes
static int * const syscall_nanosleep_e_indexes[] = { &hf_param_interval_bytes, NULL };
#define syscall_nanosleep_x_indexes syscall_close_x_indexes
static int * const syscall_timerfd_create_e_indexes[] = { &hf_param_clockid_uint8, &hf_param_flags_uint8, NULL };
#define syscall_timerfd_create_x_indexes syscall_close_x_indexes
static int * const syscall_inotify_init_e_indexes[] = { &hf_param_flags_uint8, NULL };
#define syscall_inotify_init_x_indexes syscall_close_x_indexes
static int * const syscall_getrlimit_e_indexes[] = { &hf_param_resource_bytes, NULL };
static int * const syscall_getrlimit_x_indexes[] = { &hf_param_res_int64, &hf_param_cur_int64, &hf_param_max_int64, NULL };
#define syscall_setrlimit_e_indexes syscall_getrlimit_e_indexes
static int * const syscall_setrlimit_x_indexes[] = { &hf_param_res_int64, &hf_param_cur_int64, &hf_param_max_int64, &hf_param_resource_bytes, NULL };
static int * const syscall_prlimit_e_indexes[] = { &hf_param_pid_int64, &hf_param_resource_bytes, NULL };
static int * const syscall_prlimit_x_indexes[] = { &hf_param_res_int64, &hf_param_newcur_int64, &hf_param_newmax_int64, &hf_param_oldcur_int64, &hf_param_oldmax_int64, &hf_param_pid_int64, &hf_param_resource_bytes, NULL };
static int * const schedswitch_1_e_indexes[] = { &hf_param_next_int64, NULL };
#define schedswitch_1_x_indexes no_indexes
static int * const drop_e_indexes[] = { &hf_param_ratio_uint32, NULL };
#define drop_x_indexes drop_e_indexes
static int * const syscall_fcntl_e_indexes[] = { &hf_param_fd_int64, &hf_param_cmd_bytes, NULL };
static int * const syscall_fcntl_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_cmd_bytes, NULL };
static int * const schedswitch_6_e_indexes[] = { &hf_param_next_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
#define schedswitch_6_x_indexes no_indexes
#define syscall_execve_13_e_indexes no_indexes
static int * const syscall_execve_13_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
#define syscall_clone_16_e_indexes no_indexes
static int * const syscall_clone_16_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_flags_int32, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
static int * const syscall_brk_4_e_indexes[] = { &hf_param_addr_uint64, NULL };
static int * const syscall_brk_4_x_indexes[] = { &hf_param_res_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
static int * const syscall_mmap_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, &hf_param_prot_int32, &hf_param_flags_int32, &hf_param_fd_int64, &hf_param_offset_uint64, NULL };
static int * const syscall_mmap_x_indexes[] = { &hf_param_res_int64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
static int * const syscall_mmap2_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, &hf_param_prot_int32, &hf_param_flags_int32, &hf_param_fd_int64, &hf_param_pgoffset_uint64, NULL };
#define syscall_mmap2_x_indexes syscall_mmap_x_indexes
static int * const syscall_munmap_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, NULL };
#define syscall_munmap_x_indexes syscall_mmap_x_indexes
static int * const syscall_splice_e_indexes[] = { &hf_param_fd_in_int64, &hf_param_fd_out_int64, &hf_param_size_uint64, &hf_param_flags_int32, NULL };
#define syscall_splice_x_indexes syscall_close_x_indexes
static int * const syscall_ptrace_e_indexes[] = { &hf_param_request_bytes, &hf_param_pid_int64, NULL };
static int * const syscall_ptrace_x_indexes[] = { &hf_param_res_int64, &hf_param_addr_bytes, &hf_param_data_bytes, NULL };
static int * const syscall_ioctl_3_e_indexes[] = { &hf_param_fd_int64, &hf_param_request_uint64, &hf_param_argument_uint64, NULL };
#define syscall_ioctl_3_x_indexes syscall_close_x_indexes
#define syscall_execve_14_e_indexes no_indexes
static int * const syscall_execve_14_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_env_string, NULL };
#define syscall_rename_e_indexes no_indexes
static int * const syscall_rename_x_indexes[] = { &hf_param_res_int64, &hf_param_oldpath_string, &hf_param_newpath_string, NULL };
#define syscall_renameat_e_indexes no_indexes
static int * const syscall_renameat_x_indexes[] = { &hf_param_res_int64, &hf_param_olddirfd_int64, &hf_param_oldpath_string, &hf_param_newdirfd_int64, &hf_param_newpath_string, NULL };
#define syscall_symlink_e_indexes no_indexes
static int * const syscall_symlink_x_indexes[] = { &hf_param_res_int64, &hf_param_target_string, &hf_param_linkpath_string, NULL };
#define syscall_symlinkat_e_indexes no_indexes
static int * const syscall_symlinkat_x_indexes[] = { &hf_param_res_int64, &hf_param_target_string, &hf_param_linkdirfd_int64, &hf_param_linkpath_string, NULL };
#define syscall_fork_e_indexes no_indexes
#define syscall_fork_x_indexes syscall_clone_16_x_indexes
#define syscall_vfork_e_indexes no_indexes
#define syscall_vfork_x_indexes syscall_clone_16_x_indexes
static int * const procexit_1_e_indexes[] = { &hf_param_status_int64, &hf_param_ret_int64, &hf_param_sig_bytes, &hf_param_core_uint8, &hf_param_reaper_tid_int64, NULL };
#define procexit_1_x_indexes no_indexes
static int * const syscall_sendfile_e_indexes[] = { &hf_param_out_fd_int64, &hf_param_in_fd_int64, &hf_param_offset_uint64, &hf_param_size_uint64, NULL };
static int * const syscall_sendfile_x_indexes[] = { &hf_param_res_int64, &hf_param_offset_uint64, NULL };
static int * const syscall_quotactl_e_indexes[] = { &hf_param_cmd_int16, &hf_param_type_int8, &hf_param_id_uint32, &hf_param_quota_fmt_int8, NULL };
static int * const syscall_quotactl_x_indexes[] = { &hf_param_res_int64, &hf_param_special_string, &hf_param_quotafilepath_string, &hf_param_dqb_bhardlimit_uint64, &hf_param_dqb_bsoftlimit_uint64, &hf_param_dqb_curspace_uint64, &hf_param_dqb_ihardlimit_uint64, &hf_param_dqb_isoftlimit_uint64, &hf_param_dqb_btime_bytes, &hf_param_dqb_itime_bytes, &hf_param_dqi_bgrace_bytes, &hf_param_dqi_igrace_bytes, &hf_param_dqi_flags_int8, &hf_param_quota_fmt_out_int8, NULL };
static int * const syscall_setresuid_e_indexes[] = { &hf_param_ruid_int32, &hf_param_euid_int32, &hf_param_suid_int32, NULL };
#define syscall_setresuid_x_indexes syscall_close_x_indexes
static int * const syscall_setresgid_e_indexes[] = { &hf_param_rgid_int32, &hf_param_egid_int32, &hf_param_sgid_int32, NULL };
#define syscall_setresgid_x_indexes syscall_close_x_indexes
static int * const scapevent_e_indexes[] = { &hf_param_event_type_uint32, &hf_param_event_data_uint64, NULL };
#define scapevent_x_indexes no_indexes
static int * const syscall_setuid_e_indexes[] = { &hf_param_uid_int32, NULL };
#define syscall_setuid_x_indexes syscall_close_x_indexes
static int * const syscall_setgid_e_indexes[] = { &hf_param_gid_int32, NULL };
#define syscall_setgid_x_indexes syscall_close_x_indexes
#define syscall_getuid_e_indexes no_indexes
#define syscall_getuid_x_indexes syscall_setuid_e_indexes
#define syscall_geteuid_e_indexes no_indexes
static int * const syscall_geteuid_x_indexes[] = { &hf_param_euid_int32, NULL };
#define syscall_getgid_e_indexes no_indexes
#define syscall_getgid_x_indexes syscall_setgid_e_indexes
#define syscall_getegid_e_indexes no_indexes
static int * const syscall_getegid_x_indexes[] = { &hf_param_egid_int32, NULL };
#define syscall_getresuid_e_indexes no_indexes
static int * const syscall_getresuid_x_indexes[] = { &hf_param_res_int64, &hf_param_ruid_int32, &hf_param_euid_int32, &hf_param_suid_int32, NULL };
#define syscall_getresgid_e_indexes no_indexes
static int * const syscall_getresgid_x_indexes[] = { &hf_param_res_int64, &hf_param_rgid_int32, &hf_param_egid_int32, &hf_param_sgid_int32, NULL };
#define syscall_execve_15_e_indexes no_indexes
static int * const syscall_execve_15_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_env_string, NULL };
#define syscall_clone_17_e_indexes no_indexes
static int * const syscall_clone_17_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_flags_int32, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define syscall_fork_17_e_indexes no_indexes
#define syscall_fork_17_x_indexes syscall_clone_17_x_indexes
#define syscall_vfork_17_e_indexes no_indexes
#define syscall_vfork_17_x_indexes syscall_clone_17_x_indexes
#define syscall_clone_20_e_indexes no_indexes
static int * const syscall_clone_20_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_flags_int32, &hf_param_uid_uint32, &hf_param_gid_uint32, &hf_param_vtid_int64, &hf_param_vpid_int64, &hf_param_pidns_init_start_ts_uint64, NULL };
#define syscall_fork_20_e_indexes no_indexes
#define syscall_fork_20_x_indexes syscall_clone_20_x_indexes
#define syscall_vfork_20_e_indexes no_indexes
#define syscall_vfork_20_x_indexes syscall_clone_20_x_indexes
static int * const container_e_indexes[] = { &hf_param_id_string, &hf_param_type_uint32, &hf_param_name_string, &hf_param_image_string, NULL };
#define container_x_indexes no_indexes
#define syscall_execve_16_e_indexes no_indexes
static int * const syscall_execve_16_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_env_string, NULL };
static int * const signaldeliver_e_indexes[] = { &hf_param_spid_int64, &hf_param_dpid_int64, &hf_param_sig_bytes, NULL };
#define signaldeliver_x_indexes no_indexes
static int * const procinfo_e_indexes[] = { &hf_param_cpu_usr_uint64, &hf_param_cpu_sys_uint64, NULL };
#define procinfo_x_indexes no_indexes
#define syscall_getdents_e_indexes syscall_close_e_indexes
#define syscall_getdents_x_indexes syscall_close_x_indexes
#define syscall_getdents64_e_indexes syscall_close_e_indexes
#define syscall_getdents64_x_indexes syscall_close_x_indexes
static int * const syscall_setns_e_indexes[] = { &hf_param_fd_int64, &hf_param_nstype_int32, NULL };
#define syscall_setns_x_indexes syscall_close_x_indexes
static int * const syscall_flock_e_indexes[] = { &hf_param_fd_int64, &hf_param_operation_int32, NULL };
#define syscall_flock_x_indexes syscall_close_x_indexes
static int * const cpu_hotplug_e_indexes[] = { &hf_param_cpu_uint32, &hf_param_action_uint32, NULL };
#define cpu_hotplug_x_indexes no_indexes
#define socket_accept_5_e_indexes no_indexes
static int * const socket_accept_5_x_indexes[] = { &hf_param_fd_int64, &hf_param_tuple_bytes, &hf_param_queuepct_uint8, &hf_param_queuelen_uint32, &hf_param_queuemax_uint32, NULL };
#define socket_accept4_5_e_indexes socket_accept4_e_indexes
#define socket_accept4_5_x_indexes socket_accept_5_x_indexes
static int * const syscall_semop_e_indexes[] = { &hf_param_semid_int32, NULL };
static int * const syscall_semop_x_indexes[] = { &hf_param_res_int64, &hf_param_nsops_uint32, &hf_param_sem_num_0_uint16, &hf_param_sem_op_0_int16, &hf_param_sem_flg_0_int16, &hf_param_sem_num_1_uint16, &hf_param_sem_op_1_int16, &hf_param_sem_flg_1_int16, NULL };
static int * const syscall_semctl_e_indexes[] = { &hf_param_semid_int32, &hf_param_semnum_int32, &hf_param_cmd_int16, &hf_param_val_int32, NULL };
#define syscall_semctl_x_indexes syscall_close_x_indexes
static int * const syscall_ppoll_e_indexes[] = { &hf_param_fds_bytes, &hf_param_timeout_bytes, &hf_param_sigmask_bytes, NULL };
#define syscall_ppoll_x_indexes syscall_poll_x_indexes
static int * const syscall_mount_e_indexes[] = { &hf_param_flags_int32, NULL };
static int * const syscall_mount_x_indexes[] = { &hf_param_res_int64, &hf_param_dev_string, &hf_param_dir_string, &hf_param_type_string, NULL };
#define syscall_umount_e_indexes syscall_mount_e_indexes
static int * const syscall_umount_x_indexes[] = { &hf_param_res_int64, &hf_param_name_string, NULL };
static int * const k8s_e_indexes[] = { &hf_param_json_string, NULL };
#define k8s_x_indexes no_indexes
static int * const syscall_semget_e_indexes[] = { &hf_param_key_int32, &hf_param_nsems_int32, &hf_param_semflg_int32, NULL };
#define syscall_semget_x_indexes syscall_close_x_indexes
static int * const syscall_access_e_indexes[] = { &hf_param_mode_int32, NULL };
#define syscall_access_x_indexes syscall_umount_x_indexes
#define syscall_chroot_e_indexes no_indexes
#define syscall_chroot_x_indexes syscall_stat_x_indexes
static int * const tracer_e_indexes[] = { &hf_param_id_int64, &hf_param_tags_bytes, &hf_param_args_string, NULL };
#define tracer_x_indexes tracer_e_indexes
#define mesos_e_indexes k8s_e_indexes
#define mesos_x_indexes no_indexes
#define container_json_e_indexes k8s_e_indexes
#define container_json_x_indexes no_indexes
#define syscall_setsid_e_indexes no_indexes
#define syscall_setsid_x_indexes syscall_close_x_indexes
static int * const syscall_mkdir_2_e_indexes[] = { &hf_param_mode_uint32, NULL };
#define syscall_mkdir_2_x_indexes syscall_stat_x_indexes
#define syscall_rmdir_2_e_indexes no_indexes
#define syscall_rmdir_2_x_indexes syscall_stat_x_indexes
static int * const notification_e_indexes[] = { &hf_param_id_string, &hf_param_desc_string, NULL };
#define notification_x_indexes no_indexes
#define syscall_execve_17_e_indexes no_indexes
static int * const syscall_execve_17_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_env_string, &hf_param_tty_int32, NULL };
#define syscall_unshare_e_indexes syscall_mount_e_indexes
#define syscall_unshare_x_indexes syscall_close_x_indexes
static int * const infrastructure_event_e_indexes[] = { &hf_param_source_string, &hf_param_name_string, &hf_param_description_string, &hf_param_scope_string, NULL };
#define infrastructure_event_x_indexes no_indexes
static int * const syscall_execve_18_e_indexes[] = { &hf_param_filename_string, NULL };
#define syscall_execve_18_x_indexes syscall_execve_17_x_indexes
static int * const page_fault_e_indexes[] = { &hf_param_addr_uint64, &hf_param_ip_uint64, &hf_param_error_int32, NULL };
#define page_fault_x_indexes no_indexes
#define syscall_execve_19_e_indexes syscall_execve_18_e_indexes
static int * const syscall_execve_19_x_indexes[] = { &hf_param_res_int64, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_int64, &hf_param_pid_int64, &hf_param_ptid_int64, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_env_string, &hf_param_tty_uint32, &hf_param_pgid_int64, &hf_param_loginuid_int32, &hf_param_flags_int32, &hf_param_cap_inheritable_uint64, &hf_param_cap_permitted_uint64, &hf_param_cap_effective_uint64, &hf_param_exe_ino_uint64, &hf_param_exe_ino_ctime_bytes, &hf_param_exe_ino_mtime_bytes, &hf_param_uid_int32, &hf_param_trusted_exepath_string, NULL };
static int * const syscall_setpgid_e_indexes[] = { &hf_param_pid_int64, &hf_param_pgid_int64, NULL };
#define syscall_setpgid_x_indexes syscall_close_x_indexes
static int * const syscall_bpf_e_indexes[] = { &hf_param_cmd_int64, NULL };
static int * const syscall_bpf_x_indexes[] = { &hf_param_res_or_fd_bytes, NULL };
static int * const syscall_seccomp_e_indexes[] = { &hf_param_op_uint64, &hf_param_flags_uint64, NULL };
#define syscall_seccomp_x_indexes syscall_close_x_indexes
#define syscall_unlink_2_e_indexes no_indexes
#define syscall_unlink_2_x_indexes syscall_stat_x_indexes
#define syscall_unlinkat_2_e_indexes no_indexes
static int * const syscall_unlinkat_2_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_int32, NULL };
#define syscall_mkdirat_e_indexes no_indexes
static int * const syscall_mkdirat_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_path_string, &hf_param_mode_uint32, NULL };
#define syscall_openat_2_e_indexes syscall_openat_e_indexes
static int * const syscall_openat_2_x_indexes[] = { &hf_param_fd_int64, &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, &hf_param_dev_uint32, &hf_param_ino_uint64, NULL };
#define syscall_link_2_e_indexes no_indexes
#define syscall_link_2_x_indexes syscall_rename_x_indexes
#define syscall_linkat_2_e_indexes no_indexes
static int * const syscall_linkat_2_x_indexes[] = { &hf_param_res_int64, &hf_param_olddir_int64, &hf_param_oldpath_string, &hf_param_newdir_int64, &hf_param_newpath_string, &hf_param_flags_int32, NULL };
#define syscall_fchmodat_e_indexes no_indexes
static int * const syscall_fchmodat_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_filename_string, &hf_param_mode_int32, NULL };
#define syscall_chmod_e_indexes no_indexes
static int * const syscall_chmod_x_indexes[] = { &hf_param_res_int64, &hf_param_filename_string, &hf_param_mode_int32, NULL };
#define syscall_fchmod_e_indexes no_indexes
static int * const syscall_fchmod_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_mode_int32, NULL };
#define syscall_renameat2_e_indexes no_indexes
static int * const syscall_renameat2_x_indexes[] = { &hf_param_res_int64, &hf_param_olddirfd_int64, &hf_param_oldpath_string, &hf_param_newdirfd_int64, &hf_param_newpath_string, &hf_param_flags_int32, NULL };
#define syscall_userfaultfd_e_indexes no_indexes
static int * const syscall_userfaultfd_x_indexes[] = { &hf_param_res_int64, &hf_param_flags_int32, NULL };
static int * const pluginevent_e_indexes[] = { &hf_param_plugin_id_uint32, &hf_param_event_data_bytes, NULL };
#define pluginevent_x_indexes no_indexes
#define container_json_2_e_indexes k8s_e_indexes
#define container_json_2_x_indexes no_indexes
static int * const syscall_openat2_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, &hf_param_resolve_int32, NULL };
static int * const syscall_openat2_x_indexes[] = { &hf_param_fd_int64, &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_int32, &hf_param_mode_uint32, &hf_param_resolve_int32, &hf_param_dev_uint32, &hf_param_ino_uint64, NULL };
static int * const syscall_mprotect_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, &hf_param_prot_int32, NULL };
#define syscall_mprotect_x_indexes syscall_close_x_indexes
static int * const syscall_execveat_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_pathname_string, &hf_param_flags_int32, NULL };
#define syscall_execveat_x_indexes syscall_execve_19_x_indexes
static int * const syscall_copy_file_range_e_indexes[] = { &hf_param_fdin_int64, &hf_param_offin_uint64, &hf_param_len_uint64, NULL };
static int * const syscall_copy_file_range_x_indexes[] = { &hf_param_res_int64, &hf_param_fdout_int64, &hf_param_offout_uint64, NULL };
#define syscall_clone3_e_indexes no_indexes
#define syscall_clone3_x_indexes syscall_clone_20_x_indexes
#define syscall_open_by_handle_at_e_indexes no_indexes
static int * const syscall_open_by_handle_at_x_indexes[] = { &hf_param_fd_int64, &hf_param_mountfd_int64, &hf_param_flags_int32, &hf_param_path_string, &hf_param_dev_uint32, &hf_param_ino_uint64, NULL };
#define syscall_io_uring_setup_e_indexes no_indexes
static int * const syscall_io_uring_setup_x_indexes[] = { &hf_param_res_int64, &hf_param_entries_uint32, &hf_param_sq_entries_uint32, &hf_param_cq_entries_uint32, &hf_param_flags_int32, &hf_param_sq_thread_cpu_uint32, &hf_param_sq_thread_idle_uint32, &hf_param_features_int32, NULL };
#define syscall_io_uring_enter_e_indexes no_indexes
static int * const syscall_io_uring_enter_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_to_submit_uint32, &hf_param_min_complete_uint32, &hf_param_flags_int32, &hf_param_sig_bytes, NULL };
#define syscall_io_uring_register_e_indexes no_indexes
static int * const syscall_io_uring_register_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_opcode_bytes, &hf_param_arg_uint64, &hf_param_nr_args_uint32, NULL };
#define syscall_mlock_e_indexes no_indexes
static int * const syscall_mlock_x_indexes[] = { &hf_param_res_int64, &hf_param_addr_uint64, &hf_param_len_uint64, NULL };
#define syscall_munlock_e_indexes no_indexes
#define syscall_munlock_x_indexes syscall_mlock_x_indexes
#define syscall_mlockall_e_indexes no_indexes
#define syscall_mlockall_x_indexes syscall_userfaultfd_x_indexes
#define syscall_munlockall_e_indexes no_indexes
#define syscall_munlockall_x_indexes syscall_close_x_indexes
#define syscall_capset_e_indexes no_indexes
static int * const syscall_capset_x_indexes[] = { &hf_param_res_int64, &hf_param_cap_inheritable_uint64, &hf_param_cap_permitted_uint64, &hf_param_cap_effective_uint64, NULL };
static int * const user_added_e_indexes[] = { &hf_param_uid_uint32, &hf_param_gid_uint32, &hf_param_name_string, &hf_param_home_string, &hf_param_shell_string, &hf_param_container_id_string, NULL };
#define user_added_x_indexes no_indexes
#define user_deleted_e_indexes user_added_e_indexes
#define user_deleted_x_indexes no_indexes
static int * const group_added_e_indexes[] = { &hf_param_gid_uint32, &hf_param_name_string, &hf_param_container_id_string, NULL };
#define group_added_x_indexes no_indexes
#define group_deleted_e_indexes group_added_e_indexes
#define group_deleted_x_indexes no_indexes
#define syscall_dup2_e_indexes syscall_close_e_indexes
static int * const syscall_dup2_x_indexes[] = { &hf_param_res_int64, &hf_param_oldfd_int64, &hf_param_newfd_int64, NULL };
#define syscall_dup3_e_indexes syscall_close_e_indexes
static int * const syscall_dup3_x_indexes[] = { &hf_param_res_int64, &hf_param_oldfd_int64, &hf_param_newfd_int64, &hf_param_flags_int32, NULL };
#define syscall_dup_1_e_indexes syscall_close_e_indexes
static int * const syscall_dup_1_x_indexes[] = { &hf_param_res_int64, &hf_param_oldfd_int64, NULL };
#define syscall_bpf_2_e_indexes syscall_bpf_e_indexes
#define syscall_bpf_2_x_indexes syscall_fcntl_e_indexes
#define syscall_mlock2_e_indexes no_indexes
static int * const syscall_mlock2_x_indexes[] = { &hf_param_res_int64, &hf_param_addr_uint64, &hf_param_len_uint64, &hf_param_flags_int32, NULL };
#define syscall_fsconfig_e_indexes no_indexes
static int * const syscall_fsconfig_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_cmd_bytes, &hf_param_key_string, &hf_param_value_bytebuf_bytes, &hf_param_value_charbuf_string, &hf_param_aux_int32, NULL };
static int * const syscall_epoll_create_e_indexes[] = { &hf_param_size_int32, NULL };
#define syscall_epoll_create_x_indexes syscall_close_x_indexes
#define syscall_epoll_create1_e_indexes syscall_mount_e_indexes
#define syscall_epoll_create1_x_indexes syscall_close_x_indexes
#define syscall_chown_e_indexes no_indexes
static int * const syscall_chown_x_indexes[] = { &hf_param_res_int64, &hf_param_path_string, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define syscall_lchown_e_indexes no_indexes
#define syscall_lchown_x_indexes syscall_chown_x_indexes
#define syscall_fchown_e_indexes no_indexes
static int * const syscall_fchown_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define syscall_fchownat_e_indexes no_indexes
static int * const syscall_fchownat_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_pathname_string, &hf_param_uid_uint32, &hf_param_gid_uint32, &hf_param_flags_int32, NULL };
#define syscall_umount_1_e_indexes no_indexes
#define syscall_umount_1_x_indexes syscall_umount_x_indexes
#define socket_accept4_6_e_indexes socket_accept4_e_indexes
#define socket_accept4_6_x_indexes socket_accept_5_x_indexes
#define syscall_umount2_e_indexes syscall_mount_e_indexes
#define syscall_umount2_x_indexes syscall_umount_x_indexes
#define syscall_pipe2_e_indexes no_indexes
static int * const syscall_pipe2_x_indexes[] = { &hf_param_res_int64, &hf_param_fd1_int64, &hf_param_fd2_int64, &hf_param_ino_uint64, &hf_param_flags_int32, NULL };
#define syscall_inotify_init1_e_indexes no_indexes
static int * const syscall_inotify_init1_x_indexes[] = { &hf_param_res_int64, &hf_param_flags_int16, NULL };
static int * const syscall_eventfd2_e_indexes[] = { &hf_param_initval_uint64, NULL };
#define syscall_eventfd2_x_indexes syscall_inotify_init1_x_indexes
static int * const syscall_signalfd4_e_indexes[] = { &hf_param_fd_int64, &hf_param_mask_uint32, NULL };
#define syscall_signalfd4_x_indexes syscall_inotify_init1_x_indexes
#define syscall_prctl_e_indexes no_indexes
static int * const syscall_prctl_x_indexes[] = { &hf_param_res_int64, &hf_param_option_bytes, &hf_param_arg2_str_string, &hf_param_arg2_int_int64, NULL };
static int * const asyncevent_e_indexes[] = { &hf_param_plugin_id_uint32, &hf_param_name_string, &hf_param_data_bytes, NULL };
#define asyncevent_x_indexes no_indexes
#define syscall_memfd_create_e_indexes no_indexes
static int * const syscall_memfd_create_x_indexes[] = { &hf_param_fd_int64, &hf_param_name_string, &hf_param_flags_int32, NULL };
#define syscall_pidfd_getfd_e_indexes no_indexes
static int * const syscall_pidfd_getfd_x_indexes[] = { &hf_param_fd_int64, &hf_param_pid_fd_int64, &hf_param_target_fd_int64, &hf_param_flags_uint32, NULL };
#define syscall_pidfd_open_e_indexes no_indexes
static int * const syscall_pidfd_open_x_indexes[] = { &hf_param_fd_int64, &hf_param_pid_int64, &hf_param_flags_int32, NULL };
#define syscall_init_module_e_indexes no_indexes
static int * const syscall_init_module_x_indexes[] = { &hf_param_res_int64, &hf_param_img_bytes, &hf_param_length_uint64, &hf_param_uargs_string, NULL };
#define syscall_finit_module_e_indexes no_indexes
static int * const syscall_finit_module_x_indexes[] = { &hf_param_res_int64, &hf_param_fd_int64, &hf_param_uargs_string, &hf_param_flags_int32, NULL };
#define syscall_mknod_e_indexes no_indexes
static int * const syscall_mknod_x_indexes[] = { &hf_param_res_int64, &hf_param_path_string, &hf_param_mode_int32, &hf_param_dev_uint32, NULL };
#define syscall_mknodat_e_indexes no_indexes
static int * const syscall_mknodat_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_path_string, &hf_param_mode_int32, &hf_param_dev_uint32, NULL };
#define syscall_newfstatat_e_indexes no_indexes
static int * const syscall_newfstatat_x_indexes[] = { &hf_param_res_int64, &hf_param_dirfd_int64, &hf_param_path_string, &hf_param_flags_int32, NULL };
#define syscall_process_vm_readv_e_indexes no_indexes
static int * const syscall_process_vm_readv_x_indexes[] = { &hf_param_res_int64, &hf_param_pid_int64, &hf_param_data_bytes, NULL };
#define syscall_process_vm_writev_e_indexes no_indexes
#define syscall_process_vm_writev_x_indexes syscall_process_vm_readv_x_indexes
#define syscall_delete_module_e_indexes no_indexes
static int * const syscall_delete_module_x_indexes[] = { &hf_param_res_int64, &hf_param_name_string, &hf_param_flags_int32, NULL };
#define syscall_setreuid_e_indexes no_indexes
static int * const syscall_setreuid_x_indexes[] = { &hf_param_res_int64, &hf_param_ruid_int32, &hf_param_euid_int32, NULL };
#define syscall_setregid_e_indexes no_indexes
static int * const syscall_setregid_x_indexes[] = { &hf_param_res_int64, &hf_param_rgid_int32, &hf_param_egid_int32, NULL };

static const struct _event_tree_info event_tree_info[] = {
/* Event tree. Automatically generated by tools/generate-sysdig-event.py */
    { EVT_GENERIC_E, generic_e_indexes },
    { EVT_GENERIC_X, generic_x_indexes },
    { EVT_SYSCALL_OPEN_E, syscall_open_e_indexes },
    { EVT_SYSCALL_OPEN_X, syscall_open_x_indexes },
    { EVT_SYSCALL_CLOSE_E, syscall_close_e_indexes },
    { EVT_SYSCALL_CLOSE_X, syscall_close_x_indexes },
    { EVT_SYSCALL_READ_E, syscall_read_e_indexes },
    { EVT_SYSCALL_READ_X, syscall_read_x_indexes },
    { EVT_SYSCALL_WRITE_E, syscall_write_e_indexes },
    { EVT_SYSCALL_WRITE_X, syscall_write_x_indexes },
    { EVT_SYSCALL_BRK_1_E, syscall_brk_1_e_indexes },
    { EVT_SYSCALL_BRK_1_X, syscall_brk_1_x_indexes },
    { EVT_SYSCALL_EXECVE_8_E, syscall_execve_8_e_indexes },
    { EVT_SYSCALL_EXECVE_8_X, syscall_execve_8_x_indexes },
    { EVT_SYSCALL_CLONE_11_E, syscall_clone_11_e_indexes },
    { EVT_SYSCALL_CLONE_11_X, syscall_clone_11_x_indexes },
    { EVT_PROCEXIT_E, procexit_e_indexes },
    { EVT_PROCEXIT_X, procexit_x_indexes },
    { EVT_SOCKET_SOCKET_E, socket_socket_e_indexes },
    { EVT_SOCKET_SOCKET_X, socket_socket_x_indexes },
    { EVT_SOCKET_BIND_E, socket_bind_e_indexes },
    { EVT_SOCKET_BIND_X, socket_bind_x_indexes },
    { EVT_SOCKET_CONNECT_E, socket_connect_e_indexes },
    { EVT_SOCKET_CONNECT_X, socket_connect_x_indexes },
    { EVT_SOCKET_LISTEN_E, socket_listen_e_indexes },
    { EVT_SOCKET_LISTEN_X, socket_listen_x_indexes },
    { EVT_SOCKET_ACCEPT_E, socket_accept_e_indexes },
    { EVT_SOCKET_ACCEPT_X, socket_accept_x_indexes },
    { EVT_SOCKET_SEND_E, socket_send_e_indexes },
    { EVT_SOCKET_SEND_X, socket_send_x_indexes },
    { EVT_SOCKET_SENDTO_E, socket_sendto_e_indexes },
    { EVT_SOCKET_SENDTO_X, socket_sendto_x_indexes },
    { EVT_SOCKET_RECV_E, socket_recv_e_indexes },
    { EVT_SOCKET_RECV_X, socket_recv_x_indexes },
    { EVT_SOCKET_RECVFROM_E, socket_recvfrom_e_indexes },
    { EVT_SOCKET_RECVFROM_X, socket_recvfrom_x_indexes },
    { EVT_SOCKET_SHUTDOWN_E, socket_shutdown_e_indexes },
    { EVT_SOCKET_SHUTDOWN_X, socket_shutdown_x_indexes },
    { EVT_SOCKET_GETSOCKNAME_E, socket_getsockname_e_indexes },
    { EVT_SOCKET_GETSOCKNAME_X, socket_getsockname_x_indexes },
    { EVT_SOCKET_GETPEERNAME_E, socket_getpeername_e_indexes },
    { EVT_SOCKET_GETPEERNAME_X, socket_getpeername_x_indexes },
    { EVT_SOCKET_SOCKETPAIR_E, socket_socketpair_e_indexes },
    { EVT_SOCKET_SOCKETPAIR_X, socket_socketpair_x_indexes },
    { EVT_SOCKET_SETSOCKOPT_E, socket_setsockopt_e_indexes },
    { EVT_SOCKET_SETSOCKOPT_X, socket_setsockopt_x_indexes },
    { EVT_SOCKET_GETSOCKOPT_E, socket_getsockopt_e_indexes },
    { EVT_SOCKET_GETSOCKOPT_X, socket_getsockopt_x_indexes },
    { EVT_SOCKET_SENDMSG_E, socket_sendmsg_e_indexes },
    { EVT_SOCKET_SENDMSG_X, socket_sendmsg_x_indexes },
    { EVT_SOCKET_SENDMMSG_E, socket_sendmmsg_e_indexes },
    { EVT_SOCKET_SENDMMSG_X, socket_sendmmsg_x_indexes },
    { EVT_SOCKET_RECVMSG_E, socket_recvmsg_e_indexes },
    { EVT_SOCKET_RECVMSG_X, socket_recvmsg_x_indexes },
    { EVT_SOCKET_RECVMMSG_E, socket_recvmmsg_e_indexes },
    { EVT_SOCKET_RECVMMSG_X, socket_recvmmsg_x_indexes },
    { EVT_SOCKET_ACCEPT4_E, socket_accept4_e_indexes },
    { EVT_SOCKET_ACCEPT4_X, socket_accept4_x_indexes },
    { EVT_SYSCALL_CREAT_E, syscall_creat_e_indexes },
    { EVT_SYSCALL_CREAT_X, syscall_creat_x_indexes },
    { EVT_SYSCALL_PIPE_E, syscall_pipe_e_indexes },
    { EVT_SYSCALL_PIPE_X, syscall_pipe_x_indexes },
    { EVT_SYSCALL_EVENTFD_E, syscall_eventfd_e_indexes },
    { EVT_SYSCALL_EVENTFD_X, syscall_eventfd_x_indexes },
    { EVT_SYSCALL_FUTEX_E, syscall_futex_e_indexes },
    { EVT_SYSCALL_FUTEX_X, syscall_futex_x_indexes },
    { EVT_SYSCALL_STAT_E, syscall_stat_e_indexes },
    { EVT_SYSCALL_STAT_X, syscall_stat_x_indexes },
    { EVT_SYSCALL_LSTAT_E, syscall_lstat_e_indexes },
    { EVT_SYSCALL_LSTAT_X, syscall_lstat_x_indexes },
    { EVT_SYSCALL_FSTAT_E, syscall_fstat_e_indexes },
    { EVT_SYSCALL_FSTAT_X, syscall_fstat_x_indexes },
    { EVT_SYSCALL_STAT64_E, syscall_stat64_e_indexes },
    { EVT_SYSCALL_STAT64_X, syscall_stat64_x_indexes },
    { EVT_SYSCALL_LSTAT64_E, syscall_lstat64_e_indexes },
    { EVT_SYSCALL_LSTAT64_X, syscall_lstat64_x_indexes },
    { EVT_SYSCALL_FSTAT64_E, syscall_fstat64_e_indexes },
    { EVT_SYSCALL_FSTAT64_X, syscall_fstat64_x_indexes },
    { EVT_SYSCALL_EPOLLWAIT_E, syscall_epollwait_e_indexes },
    { EVT_SYSCALL_EPOLLWAIT_X, syscall_epollwait_x_indexes },
    { EVT_SYSCALL_POLL_E, syscall_poll_e_indexes },
    { EVT_SYSCALL_POLL_X, syscall_poll_x_indexes },
    { EVT_SYSCALL_SELECT_E, syscall_select_e_indexes },
    { EVT_SYSCALL_SELECT_X, syscall_select_x_indexes },
    { EVT_SYSCALL_NEWSELECT_E, syscall_newselect_e_indexes },
    { EVT_SYSCALL_NEWSELECT_X, syscall_newselect_x_indexes },
    { EVT_SYSCALL_LSEEK_E, syscall_lseek_e_indexes },
    { EVT_SYSCALL_LSEEK_X, syscall_lseek_x_indexes },
    { EVT_SYSCALL_LLSEEK_E, syscall_llseek_e_indexes },
    { EVT_SYSCALL_LLSEEK_X, syscall_llseek_x_indexes },
    { EVT_SYSCALL_IOCTL_2_E, syscall_ioctl_2_e_indexes },
    { EVT_SYSCALL_IOCTL_2_X, syscall_ioctl_2_x_indexes },
    { EVT_SYSCALL_GETCWD_E, syscall_getcwd_e_indexes },
    { EVT_SYSCALL_GETCWD_X, syscall_getcwd_x_indexes },
    { EVT_SYSCALL_CHDIR_E, syscall_chdir_e_indexes },
    { EVT_SYSCALL_CHDIR_X, syscall_chdir_x_indexes },
    { EVT_SYSCALL_FCHDIR_E, syscall_fchdir_e_indexes },
    { EVT_SYSCALL_FCHDIR_X, syscall_fchdir_x_indexes },
    { EVT_SYSCALL_MKDIR_E, syscall_mkdir_e_indexes },
    { EVT_SYSCALL_MKDIR_X, syscall_mkdir_x_indexes },
    { EVT_SYSCALL_RMDIR_E, syscall_rmdir_e_indexes },
    { EVT_SYSCALL_RMDIR_X, syscall_rmdir_x_indexes },
    { EVT_SYSCALL_OPENAT_E, syscall_openat_e_indexes },
    { EVT_SYSCALL_OPENAT_X, syscall_openat_x_indexes },
    { EVT_SYSCALL_LINK_E, syscall_link_e_indexes },
    { EVT_SYSCALL_LINK_X, syscall_link_x_indexes },
    { EVT_SYSCALL_LINKAT_E, syscall_linkat_e_indexes },
    { EVT_SYSCALL_LINKAT_X, syscall_linkat_x_indexes },
    { EVT_SYSCALL_UNLINK_E, syscall_unlink_e_indexes },
    { EVT_SYSCALL_UNLINK_X, syscall_unlink_x_indexes },
    { EVT_SYSCALL_UNLINKAT_E, syscall_unlinkat_e_indexes },
    { EVT_SYSCALL_UNLINKAT_X, syscall_unlinkat_x_indexes },
    { EVT_SYSCALL_PREAD_E, syscall_pread_e_indexes },
    { EVT_SYSCALL_PREAD_X, syscall_pread_x_indexes },
    { EVT_SYSCALL_PWRITE_E, syscall_pwrite_e_indexes },
    { EVT_SYSCALL_PWRITE_X, syscall_pwrite_x_indexes },
    { EVT_SYSCALL_READV_E, syscall_readv_e_indexes },
    { EVT_SYSCALL_READV_X, syscall_readv_x_indexes },
    { EVT_SYSCALL_WRITEV_E, syscall_writev_e_indexes },
    { EVT_SYSCALL_WRITEV_X, syscall_writev_x_indexes },
    { EVT_SYSCALL_PREADV_E, syscall_preadv_e_indexes },
    { EVT_SYSCALL_PREADV_X, syscall_preadv_x_indexes },
    { EVT_SYSCALL_PWRITEV_E, syscall_pwritev_e_indexes },
    { EVT_SYSCALL_PWRITEV_X, syscall_pwritev_x_indexes },
    { EVT_SYSCALL_DUP_E, syscall_dup_e_indexes },
    { EVT_SYSCALL_DUP_X, syscall_dup_x_indexes },
    { EVT_SYSCALL_SIGNALFD_E, syscall_signalfd_e_indexes },
    { EVT_SYSCALL_SIGNALFD_X, syscall_signalfd_x_indexes },
    { EVT_SYSCALL_KILL_E, syscall_kill_e_indexes },
    { EVT_SYSCALL_KILL_X, syscall_kill_x_indexes },
    { EVT_SYSCALL_TKILL_E, syscall_tkill_e_indexes },
    { EVT_SYSCALL_TKILL_X, syscall_tkill_x_indexes },
    { EVT_SYSCALL_TGKILL_E, syscall_tgkill_e_indexes },
    { EVT_SYSCALL_TGKILL_X, syscall_tgkill_x_indexes },
    { EVT_SYSCALL_NANOSLEEP_E, syscall_nanosleep_e_indexes },
    { EVT_SYSCALL_NANOSLEEP_X, syscall_nanosleep_x_indexes },
    { EVT_SYSCALL_TIMERFD_CREATE_E, syscall_timerfd_create_e_indexes },
    { EVT_SYSCALL_TIMERFD_CREATE_X, syscall_timerfd_create_x_indexes },
    { EVT_SYSCALL_INOTIFY_INIT_E, syscall_inotify_init_e_indexes },
    { EVT_SYSCALL_INOTIFY_INIT_X, syscall_inotify_init_x_indexes },
    { EVT_SYSCALL_GETRLIMIT_E, syscall_getrlimit_e_indexes },
    { EVT_SYSCALL_GETRLIMIT_X, syscall_getrlimit_x_indexes },
    { EVT_SYSCALL_SETRLIMIT_E, syscall_setrlimit_e_indexes },
    { EVT_SYSCALL_SETRLIMIT_X, syscall_setrlimit_x_indexes },
    { EVT_SYSCALL_PRLIMIT_E, syscall_prlimit_e_indexes },
    { EVT_SYSCALL_PRLIMIT_X, syscall_prlimit_x_indexes },
    { EVT_SCHEDSWITCH_1_E, schedswitch_1_e_indexes },
    { EVT_SCHEDSWITCH_1_X, schedswitch_1_x_indexes },
    { EVT_DROP_E, drop_e_indexes },
    { EVT_DROP_X, drop_x_indexes },
    { EVT_SYSCALL_FCNTL_E, syscall_fcntl_e_indexes },
    { EVT_SYSCALL_FCNTL_X, syscall_fcntl_x_indexes },
    { EVT_SCHEDSWITCH_6_E, schedswitch_6_e_indexes },
    { EVT_SCHEDSWITCH_6_X, schedswitch_6_x_indexes },
    { EVT_SYSCALL_EXECVE_13_E, syscall_execve_13_e_indexes },
    { EVT_SYSCALL_EXECVE_13_X, syscall_execve_13_x_indexes },
    { EVT_SYSCALL_CLONE_16_E, syscall_clone_16_e_indexes },
    { EVT_SYSCALL_CLONE_16_X, syscall_clone_16_x_indexes },
    { EVT_SYSCALL_BRK_4_E, syscall_brk_4_e_indexes },
    { EVT_SYSCALL_BRK_4_X, syscall_brk_4_x_indexes },
    { EVT_SYSCALL_MMAP_E, syscall_mmap_e_indexes },
    { EVT_SYSCALL_MMAP_X, syscall_mmap_x_indexes },
    { EVT_SYSCALL_MMAP2_E, syscall_mmap2_e_indexes },
    { EVT_SYSCALL_MMAP2_X, syscall_mmap2_x_indexes },
    { EVT_SYSCALL_MUNMAP_E, syscall_munmap_e_indexes },
    { EVT_SYSCALL_MUNMAP_X, syscall_munmap_x_indexes },
    { EVT_SYSCALL_SPLICE_E, syscall_splice_e_indexes },
    { EVT_SYSCALL_SPLICE_X, syscall_splice_x_indexes },
    { EVT_SYSCALL_PTRACE_E, syscall_ptrace_e_indexes },
    { EVT_SYSCALL_PTRACE_X, syscall_ptrace_x_indexes },
    { EVT_SYSCALL_IOCTL_3_E, syscall_ioctl_3_e_indexes },
    { EVT_SYSCALL_IOCTL_3_X, syscall_ioctl_3_x_indexes },
    { EVT_SYSCALL_EXECVE_14_E, syscall_execve_14_e_indexes },
    { EVT_SYSCALL_EXECVE_14_X, syscall_execve_14_x_indexes },
    { EVT_SYSCALL_RENAME_E, syscall_rename_e_indexes },
    { EVT_SYSCALL_RENAME_X, syscall_rename_x_indexes },
    { EVT_SYSCALL_RENAMEAT_E, syscall_renameat_e_indexes },
    { EVT_SYSCALL_RENAMEAT_X, syscall_renameat_x_indexes },
    { EVT_SYSCALL_SYMLINK_E, syscall_symlink_e_indexes },
    { EVT_SYSCALL_SYMLINK_X, syscall_symlink_x_indexes },
    { EVT_SYSCALL_SYMLINKAT_E, syscall_symlinkat_e_indexes },
    { EVT_SYSCALL_SYMLINKAT_X, syscall_symlinkat_x_indexes },
    { EVT_SYSCALL_FORK_E, syscall_fork_e_indexes },
    { EVT_SYSCALL_FORK_X, syscall_fork_x_indexes },
    { EVT_SYSCALL_VFORK_E, syscall_vfork_e_indexes },
    { EVT_SYSCALL_VFORK_X, syscall_vfork_x_indexes },
    { EVT_PROCEXIT_1_E, procexit_1_e_indexes },
    { EVT_PROCEXIT_1_X, procexit_1_x_indexes },
    { EVT_SYSCALL_SENDFILE_E, syscall_sendfile_e_indexes },
    { EVT_SYSCALL_SENDFILE_X, syscall_sendfile_x_indexes },
    { EVT_SYSCALL_QUOTACTL_E, syscall_quotactl_e_indexes },
    { EVT_SYSCALL_QUOTACTL_X, syscall_quotactl_x_indexes },
    { EVT_SYSCALL_SETRESUID_E, syscall_setresuid_e_indexes },
    { EVT_SYSCALL_SETRESUID_X, syscall_setresuid_x_indexes },
    { EVT_SYSCALL_SETRESGID_E, syscall_setresgid_e_indexes },
    { EVT_SYSCALL_SETRESGID_X, syscall_setresgid_x_indexes },
    { EVT_SCAPEVENT_E, scapevent_e_indexes },
    { EVT_SCAPEVENT_X, scapevent_x_indexes },
    { EVT_SYSCALL_SETUID_E, syscall_setuid_e_indexes },
    { EVT_SYSCALL_SETUID_X, syscall_setuid_x_indexes },
    { EVT_SYSCALL_SETGID_E, syscall_setgid_e_indexes },
    { EVT_SYSCALL_SETGID_X, syscall_setgid_x_indexes },
    { EVT_SYSCALL_GETUID_E, syscall_getuid_e_indexes },
    { EVT_SYSCALL_GETUID_X, syscall_getuid_x_indexes },
    { EVT_SYSCALL_GETEUID_E, syscall_geteuid_e_indexes },
    { EVT_SYSCALL_GETEUID_X, syscall_geteuid_x_indexes },
    { EVT_SYSCALL_GETGID_E, syscall_getgid_e_indexes },
    { EVT_SYSCALL_GETGID_X, syscall_getgid_x_indexes },
    { EVT_SYSCALL_GETEGID_E, syscall_getegid_e_indexes },
    { EVT_SYSCALL_GETEGID_X, syscall_getegid_x_indexes },
    { EVT_SYSCALL_GETRESUID_E, syscall_getresuid_e_indexes },
    { EVT_SYSCALL_GETRESUID_X, syscall_getresuid_x_indexes },
    { EVT_SYSCALL_GETRESGID_E, syscall_getresgid_e_indexes },
    { EVT_SYSCALL_GETRESGID_X, syscall_getresgid_x_indexes },
    { EVT_SYSCALL_EXECVE_15_E, syscall_execve_15_e_indexes },
    { EVT_SYSCALL_EXECVE_15_X, syscall_execve_15_x_indexes },
    { EVT_SYSCALL_CLONE_17_E, syscall_clone_17_e_indexes },
    { EVT_SYSCALL_CLONE_17_X, syscall_clone_17_x_indexes },
    { EVT_SYSCALL_FORK_17_E, syscall_fork_17_e_indexes },
    { EVT_SYSCALL_FORK_17_X, syscall_fork_17_x_indexes },
    { EVT_SYSCALL_VFORK_17_E, syscall_vfork_17_e_indexes },
    { EVT_SYSCALL_VFORK_17_X, syscall_vfork_17_x_indexes },
    { EVT_SYSCALL_CLONE_20_E, syscall_clone_20_e_indexes },
    { EVT_SYSCALL_CLONE_20_X, syscall_clone_20_x_indexes },
    { EVT_SYSCALL_FORK_20_E, syscall_fork_20_e_indexes },
    { EVT_SYSCALL_FORK_20_X, syscall_fork_20_x_indexes },
    { EVT_SYSCALL_VFORK_20_E, syscall_vfork_20_e_indexes },
    { EVT_SYSCALL_VFORK_20_X, syscall_vfork_20_x_indexes },
    { EVT_CONTAINER_E, container_e_indexes },
    { EVT_CONTAINER_X, container_x_indexes },
    { EVT_SYSCALL_EXECVE_16_E, syscall_execve_16_e_indexes },
    { EVT_SYSCALL_EXECVE_16_X, syscall_execve_16_x_indexes },
    { EVT_SIGNALDELIVER_E, signaldeliver_e_indexes },
    { EVT_SIGNALDELIVER_X, signaldeliver_x_indexes },
    { EVT_PROCINFO_E, procinfo_e_indexes },
    { EVT_PROCINFO_X, procinfo_x_indexes },
    { EVT_SYSCALL_GETDENTS_E, syscall_getdents_e_indexes },
    { EVT_SYSCALL_GETDENTS_X, syscall_getdents_x_indexes },
    { EVT_SYSCALL_GETDENTS64_E, syscall_getdents64_e_indexes },
    { EVT_SYSCALL_GETDENTS64_X, syscall_getdents64_x_indexes },
    { EVT_SYSCALL_SETNS_E, syscall_setns_e_indexes },
    { EVT_SYSCALL_SETNS_X, syscall_setns_x_indexes },
    { EVT_SYSCALL_FLOCK_E, syscall_flock_e_indexes },
    { EVT_SYSCALL_FLOCK_X, syscall_flock_x_indexes },
    { EVT_CPU_HOTPLUG_E, cpu_hotplug_e_indexes },
    { EVT_CPU_HOTPLUG_X, cpu_hotplug_x_indexes },
    { EVT_SOCKET_ACCEPT_5_E, socket_accept_5_e_indexes },
    { EVT_SOCKET_ACCEPT_5_X, socket_accept_5_x_indexes },
    { EVT_SOCKET_ACCEPT4_5_E, socket_accept4_5_e_indexes },
    { EVT_SOCKET_ACCEPT4_5_X, socket_accept4_5_x_indexes },
    { EVT_SYSCALL_SEMOP_E, syscall_semop_e_indexes },
    { EVT_SYSCALL_SEMOP_X, syscall_semop_x_indexes },
    { EVT_SYSCALL_SEMCTL_E, syscall_semctl_e_indexes },
    { EVT_SYSCALL_SEMCTL_X, syscall_semctl_x_indexes },
    { EVT_SYSCALL_PPOLL_E, syscall_ppoll_e_indexes },
    { EVT_SYSCALL_PPOLL_X, syscall_ppoll_x_indexes },
    { EVT_SYSCALL_MOUNT_E, syscall_mount_e_indexes },
    { EVT_SYSCALL_MOUNT_X, syscall_mount_x_indexes },
    { EVT_SYSCALL_UMOUNT_E, syscall_umount_e_indexes },
    { EVT_SYSCALL_UMOUNT_X, syscall_umount_x_indexes },
    { EVT_K8S_E, k8s_e_indexes },
    { EVT_K8S_X, k8s_x_indexes },
    { EVT_SYSCALL_SEMGET_E, syscall_semget_e_indexes },
    { EVT_SYSCALL_SEMGET_X, syscall_semget_x_indexes },
    { EVT_SYSCALL_ACCESS_E, syscall_access_e_indexes },
    { EVT_SYSCALL_ACCESS_X, syscall_access_x_indexes },
    { EVT_SYSCALL_CHROOT_E, syscall_chroot_e_indexes },
    { EVT_SYSCALL_CHROOT_X, syscall_chroot_x_indexes },
    { EVT_TRACER_E, tracer_e_indexes },
    { EVT_TRACER_X, tracer_x_indexes },
    { EVT_MESOS_E, mesos_e_indexes },
    { EVT_MESOS_X, mesos_x_indexes },
    { EVT_CONTAINER_JSON_E, container_json_e_indexes },
    { EVT_CONTAINER_JSON_X, container_json_x_indexes },
    { EVT_SYSCALL_SETSID_E, syscall_setsid_e_indexes },
    { EVT_SYSCALL_SETSID_X, syscall_setsid_x_indexes },
    { EVT_SYSCALL_MKDIR_2_E, syscall_mkdir_2_e_indexes },
    { EVT_SYSCALL_MKDIR_2_X, syscall_mkdir_2_x_indexes },
    { EVT_SYSCALL_RMDIR_2_E, syscall_rmdir_2_e_indexes },
    { EVT_SYSCALL_RMDIR_2_X, syscall_rmdir_2_x_indexes },
    { EVT_NOTIFICATION_E, notification_e_indexes },
    { EVT_NOTIFICATION_X, notification_x_indexes },
    { EVT_SYSCALL_EXECVE_17_E, syscall_execve_17_e_indexes },
    { EVT_SYSCALL_EXECVE_17_X, syscall_execve_17_x_indexes },
    { EVT_SYSCALL_UNSHARE_E, syscall_unshare_e_indexes },
    { EVT_SYSCALL_UNSHARE_X, syscall_unshare_x_indexes },
    { EVT_INFRASTRUCTURE_EVENT_E, infrastructure_event_e_indexes },
    { EVT_INFRASTRUCTURE_EVENT_X, infrastructure_event_x_indexes },
    { EVT_SYSCALL_EXECVE_18_E, syscall_execve_18_e_indexes },
    { EVT_SYSCALL_EXECVE_18_X, syscall_execve_18_x_indexes },
    { EVT_PAGE_FAULT_E, page_fault_e_indexes },
    { EVT_PAGE_FAULT_X, page_fault_x_indexes },
    { EVT_SYSCALL_EXECVE_19_E, syscall_execve_19_e_indexes },
    { EVT_SYSCALL_EXECVE_19_X, syscall_execve_19_x_indexes },
    { EVT_SYSCALL_SETPGID_E, syscall_setpgid_e_indexes },
    { EVT_SYSCALL_SETPGID_X, syscall_setpgid_x_indexes },
    { EVT_SYSCALL_BPF_E, syscall_bpf_e_indexes },
    { EVT_SYSCALL_BPF_X, syscall_bpf_x_indexes },
    { EVT_SYSCALL_SECCOMP_E, syscall_seccomp_e_indexes },
    { EVT_SYSCALL_SECCOMP_X, syscall_seccomp_x_indexes },
    { EVT_SYSCALL_UNLINK_2_E, syscall_unlink_2_e_indexes },
    { EVT_SYSCALL_UNLINK_2_X, syscall_unlink_2_x_indexes },
    { EVT_SYSCALL_UNLINKAT_2_E, syscall_unlinkat_2_e_indexes },
    { EVT_SYSCALL_UNLINKAT_2_X, syscall_unlinkat_2_x_indexes },
    { EVT_SYSCALL_MKDIRAT_E, syscall_mkdirat_e_indexes },
    { EVT_SYSCALL_MKDIRAT_X, syscall_mkdirat_x_indexes },
    { EVT_SYSCALL_OPENAT_2_E, syscall_openat_2_e_indexes },
    { EVT_SYSCALL_OPENAT_2_X, syscall_openat_2_x_indexes },
    { EVT_SYSCALL_LINK_2_E, syscall_link_2_e_indexes },
    { EVT_SYSCALL_LINK_2_X, syscall_link_2_x_indexes },
    { EVT_SYSCALL_LINKAT_2_E, syscall_linkat_2_e_indexes },
    { EVT_SYSCALL_LINKAT_2_X, syscall_linkat_2_x_indexes },
    { EVT_SYSCALL_FCHMODAT_E, syscall_fchmodat_e_indexes },
    { EVT_SYSCALL_FCHMODAT_X, syscall_fchmodat_x_indexes },
    { EVT_SYSCALL_CHMOD_E, syscall_chmod_e_indexes },
    { EVT_SYSCALL_CHMOD_X, syscall_chmod_x_indexes },
    { EVT_SYSCALL_FCHMOD_E, syscall_fchmod_e_indexes },
    { EVT_SYSCALL_FCHMOD_X, syscall_fchmod_x_indexes },
    { EVT_SYSCALL_RENAMEAT2_E, syscall_renameat2_e_indexes },
    { EVT_SYSCALL_RENAMEAT2_X, syscall_renameat2_x_indexes },
    { EVT_SYSCALL_USERFAULTFD_E, syscall_userfaultfd_e_indexes },
    { EVT_SYSCALL_USERFAULTFD_X, syscall_userfaultfd_x_indexes },
    { EVT_PLUGINEVENT_E, pluginevent_e_indexes },
    { EVT_PLUGINEVENT_X, pluginevent_x_indexes },
    { EVT_CONTAINER_JSON_2_E, container_json_2_e_indexes },
    { EVT_CONTAINER_JSON_2_X, container_json_2_x_indexes },
    { EVT_SYSCALL_OPENAT2_E, syscall_openat2_e_indexes },
    { EVT_SYSCALL_OPENAT2_X, syscall_openat2_x_indexes },
    { EVT_SYSCALL_MPROTECT_E, syscall_mprotect_e_indexes },
    { EVT_SYSCALL_MPROTECT_X, syscall_mprotect_x_indexes },
    { EVT_SYSCALL_EXECVEAT_E, syscall_execveat_e_indexes },
    { EVT_SYSCALL_EXECVEAT_X, syscall_execveat_x_indexes },
    { EVT_SYSCALL_COPY_FILE_RANGE_E, syscall_copy_file_range_e_indexes },
    { EVT_SYSCALL_COPY_FILE_RANGE_X, syscall_copy_file_range_x_indexes },
    { EVT_SYSCALL_CLONE3_E, syscall_clone3_e_indexes },
    { EVT_SYSCALL_CLONE3_X, syscall_clone3_x_indexes },
    { EVT_SYSCALL_OPEN_BY_HANDLE_AT_E, syscall_open_by_handle_at_e_indexes },
    { EVT_SYSCALL_OPEN_BY_HANDLE_AT_X, syscall_open_by_handle_at_x_indexes },
    { EVT_SYSCALL_IO_URING_SETUP_E, syscall_io_uring_setup_e_indexes },
    { EVT_SYSCALL_IO_URING_SETUP_X, syscall_io_uring_setup_x_indexes },
    { EVT_SYSCALL_IO_URING_ENTER_E, syscall_io_uring_enter_e_indexes },
    { EVT_SYSCALL_IO_URING_ENTER_X, syscall_io_uring_enter_x_indexes },
    { EVT_SYSCALL_IO_URING_REGISTER_E, syscall_io_uring_register_e_indexes },
    { EVT_SYSCALL_IO_URING_REGISTER_X, syscall_io_uring_register_x_indexes },
    { EVT_SYSCALL_MLOCK_E, syscall_mlock_e_indexes },
    { EVT_SYSCALL_MLOCK_X, syscall_mlock_x_indexes },
    { EVT_SYSCALL_MUNLOCK_E, syscall_munlock_e_indexes },
    { EVT_SYSCALL_MUNLOCK_X, syscall_munlock_x_indexes },
    { EVT_SYSCALL_MLOCKALL_E, syscall_mlockall_e_indexes },
    { EVT_SYSCALL_MLOCKALL_X, syscall_mlockall_x_indexes },
    { EVT_SYSCALL_MUNLOCKALL_E, syscall_munlockall_e_indexes },
    { EVT_SYSCALL_MUNLOCKALL_X, syscall_munlockall_x_indexes },
    { EVT_SYSCALL_CAPSET_E, syscall_capset_e_indexes },
    { EVT_SYSCALL_CAPSET_X, syscall_capset_x_indexes },
    { EVT_USER_ADDED_E, user_added_e_indexes },
    { EVT_USER_ADDED_X, user_added_x_indexes },
    { EVT_USER_DELETED_E, user_deleted_e_indexes },
    { EVT_USER_DELETED_X, user_deleted_x_indexes },
    { EVT_GROUP_ADDED_E, group_added_e_indexes },
    { EVT_GROUP_ADDED_X, group_added_x_indexes },
    { EVT_GROUP_DELETED_E, group_deleted_e_indexes },
    { EVT_GROUP_DELETED_X, group_deleted_x_indexes },
    { EVT_SYSCALL_DUP2_E, syscall_dup2_e_indexes },
    { EVT_SYSCALL_DUP2_X, syscall_dup2_x_indexes },
    { EVT_SYSCALL_DUP3_E, syscall_dup3_e_indexes },
    { EVT_SYSCALL_DUP3_X, syscall_dup3_x_indexes },
    { EVT_SYSCALL_DUP_1_E, syscall_dup_1_e_indexes },
    { EVT_SYSCALL_DUP_1_X, syscall_dup_1_x_indexes },
    { EVT_SYSCALL_BPF_2_E, syscall_bpf_2_e_indexes },
    { EVT_SYSCALL_BPF_2_X, syscall_bpf_2_x_indexes },
    { EVT_SYSCALL_MLOCK2_E, syscall_mlock2_e_indexes },
    { EVT_SYSCALL_MLOCK2_X, syscall_mlock2_x_indexes },
    { EVT_SYSCALL_FSCONFIG_E, syscall_fsconfig_e_indexes },
    { EVT_SYSCALL_FSCONFIG_X, syscall_fsconfig_x_indexes },
    { EVT_SYSCALL_EPOLL_CREATE_E, syscall_epoll_create_e_indexes },
    { EVT_SYSCALL_EPOLL_CREATE_X, syscall_epoll_create_x_indexes },
    { EVT_SYSCALL_EPOLL_CREATE1_E, syscall_epoll_create1_e_indexes },
    { EVT_SYSCALL_EPOLL_CREATE1_X, syscall_epoll_create1_x_indexes },
    { EVT_SYSCALL_CHOWN_E, syscall_chown_e_indexes },
    { EVT_SYSCALL_CHOWN_X, syscall_chown_x_indexes },
    { EVT_SYSCALL_LCHOWN_E, syscall_lchown_e_indexes },
    { EVT_SYSCALL_LCHOWN_X, syscall_lchown_x_indexes },
    { EVT_SYSCALL_FCHOWN_E, syscall_fchown_e_indexes },
    { EVT_SYSCALL_FCHOWN_X, syscall_fchown_x_indexes },
    { EVT_SYSCALL_FCHOWNAT_E, syscall_fchownat_e_indexes },
    { EVT_SYSCALL_FCHOWNAT_X, syscall_fchownat_x_indexes },
    { EVT_SYSCALL_UMOUNT_1_E, syscall_umount_1_e_indexes },
    { EVT_SYSCALL_UMOUNT_1_X, syscall_umount_1_x_indexes },
    { EVT_SOCKET_ACCEPT4_6_E, socket_accept4_6_e_indexes },
    { EVT_SOCKET_ACCEPT4_6_X, socket_accept4_6_x_indexes },
    { EVT_SYSCALL_UMOUNT2_E, syscall_umount2_e_indexes },
    { EVT_SYSCALL_UMOUNT2_X, syscall_umount2_x_indexes },
    { EVT_SYSCALL_PIPE2_E, syscall_pipe2_e_indexes },
    { EVT_SYSCALL_PIPE2_X, syscall_pipe2_x_indexes },
    { EVT_SYSCALL_INOTIFY_INIT1_E, syscall_inotify_init1_e_indexes },
    { EVT_SYSCALL_INOTIFY_INIT1_X, syscall_inotify_init1_x_indexes },
    { EVT_SYSCALL_EVENTFD2_E, syscall_eventfd2_e_indexes },
    { EVT_SYSCALL_EVENTFD2_X, syscall_eventfd2_x_indexes },
    { EVT_SYSCALL_SIGNALFD4_E, syscall_signalfd4_e_indexes },
    { EVT_SYSCALL_SIGNALFD4_X, syscall_signalfd4_x_indexes },
    { EVT_SYSCALL_PRCTL_E, syscall_prctl_e_indexes },
    { EVT_SYSCALL_PRCTL_X, syscall_prctl_x_indexes },
    { EVT_ASYNCEVENT_E, asyncevent_e_indexes },
    { EVT_ASYNCEVENT_X, asyncevent_x_indexes },
    { EVT_SYSCALL_MEMFD_CREATE_E, syscall_memfd_create_e_indexes },
    { EVT_SYSCALL_MEMFD_CREATE_X, syscall_memfd_create_x_indexes },
    { EVT_SYSCALL_PIDFD_GETFD_E, syscall_pidfd_getfd_e_indexes },
    { EVT_SYSCALL_PIDFD_GETFD_X, syscall_pidfd_getfd_x_indexes },
    { EVT_SYSCALL_PIDFD_OPEN_E, syscall_pidfd_open_e_indexes },
    { EVT_SYSCALL_PIDFD_OPEN_X, syscall_pidfd_open_x_indexes },
    { EVT_SYSCALL_INIT_MODULE_E, syscall_init_module_e_indexes },
    { EVT_SYSCALL_INIT_MODULE_X, syscall_init_module_x_indexes },
    { EVT_SYSCALL_FINIT_MODULE_E, syscall_finit_module_e_indexes },
    { EVT_SYSCALL_FINIT_MODULE_X, syscall_finit_module_x_indexes },
    { EVT_SYSCALL_MKNOD_E, syscall_mknod_e_indexes },
    { EVT_SYSCALL_MKNOD_X, syscall_mknod_x_indexes },
    { EVT_SYSCALL_MKNODAT_E, syscall_mknodat_e_indexes },
    { EVT_SYSCALL_MKNODAT_X, syscall_mknodat_x_indexes },
    { EVT_SYSCALL_NEWFSTATAT_E, syscall_newfstatat_e_indexes },
    { EVT_SYSCALL_NEWFSTATAT_X, syscall_newfstatat_x_indexes },
    { EVT_SYSCALL_PROCESS_VM_READV_E, syscall_process_vm_readv_e_indexes },
    { EVT_SYSCALL_PROCESS_VM_READV_X, syscall_process_vm_readv_x_indexes },
    { EVT_SYSCALL_PROCESS_VM_WRITEV_E, syscall_process_vm_writev_e_indexes },
    { EVT_SYSCALL_PROCESS_VM_WRITEV_X, syscall_process_vm_writev_x_indexes },
    { EVT_SYSCALL_DELETE_MODULE_E, syscall_delete_module_e_indexes },
    { EVT_SYSCALL_DELETE_MODULE_X, syscall_delete_module_x_indexes },
    { EVT_SYSCALL_SETREUID_E, syscall_setreuid_e_indexes },
    { EVT_SYSCALL_SETREUID_X, syscall_setreuid_x_indexes },
    { EVT_SYSCALL_SETREGID_E, syscall_setregid_e_indexes },
    { EVT_SYSCALL_SETREGID_X, syscall_setregid_x_indexes },

    { 0, NULL }
};

/*
 * Value strings.
 * If the X_Y_vals has a matching hf_param_X_Y it will be added as a
 * VALS field conversion below.
 */

static const value_string ID_uint16_vals[] = {
/* Syscall codes. Automatically generated by tools/generate-sysdig-event.py */
    {   0, "unknown" }, // PPM_SC_UNKNOWN
    {   1, "restart_syscall" }, // PPM_SC_RESTART_SYSCALL
    {   2, "exit" }, // PPM_SC_EXIT
    {   3, "read" }, // PPM_SC_READ
    {   4, "write" }, // PPM_SC_WRITE
    {   5, "open" }, // PPM_SC_OPEN
    {   6, "close" }, // PPM_SC_CLOSE
    {   7, "creat" }, // PPM_SC_CREAT
    {   8, "link" }, // PPM_SC_LINK
    {   9, "unlink" }, // PPM_SC_UNLINK
    {  10, "chdir" }, // PPM_SC_CHDIR
    {  11, "time" }, // PPM_SC_TIME
    {  12, "mknod" }, // PPM_SC_MKNOD
    {  13, "chmod" }, // PPM_SC_CHMOD
    {  14, "stat" }, // PPM_SC_STAT
    {  15, "lseek" }, // PPM_SC_LSEEK
    {  16, "getpid" }, // PPM_SC_GETPID
    {  17, "mount" }, // PPM_SC_MOUNT
    {  18, "ptrace" }, // PPM_SC_PTRACE
    {  19, "alarm" }, // PPM_SC_ALARM
    {  20, "fstat" }, // PPM_SC_FSTAT
    {  21, "pause" }, // PPM_SC_PAUSE
    {  22, "utime" }, // PPM_SC_UTIME
    {  23, "access" }, // PPM_SC_ACCESS
    {  24, "sync" }, // PPM_SC_SYNC
    {  25, "kill" }, // PPM_SC_KILL
    {  26, "rename" }, // PPM_SC_RENAME
    {  27, "mkdir" }, // PPM_SC_MKDIR
    {  28, "rmdir" }, // PPM_SC_RMDIR
    {  29, "dup" }, // PPM_SC_DUP
    {  30, "pipe" }, // PPM_SC_PIPE
    {  31, "times" }, // PPM_SC_TIMES
    {  32, "brk" }, // PPM_SC_BRK
    {  33, "acct" }, // PPM_SC_ACCT
    {  34, "ioctl" }, // PPM_SC_IOCTL
    {  35, "fcntl" }, // PPM_SC_FCNTL
    {  36, "setpgid" }, // PPM_SC_SETPGID
    {  37, "umask" }, // PPM_SC_UMASK
    {  38, "chroot" }, // PPM_SC_CHROOT
    {  39, "ustat" }, // PPM_SC_USTAT
    {  40, "dup2" }, // PPM_SC_DUP2
    {  41, "getppid" }, // PPM_SC_GETPPID
    {  42, "getpgrp" }, // PPM_SC_GETPGRP
    {  43, "setsid" }, // PPM_SC_SETSID
    {  44, "sethostname" }, // PPM_SC_SETHOSTNAME
    {  45, "setrlimit" }, // PPM_SC_SETRLIMIT
    {  46, "getrusage" }, // PPM_SC_GETRUSAGE
    {  47, "gettimeofday" }, // PPM_SC_GETTIMEOFDAY
    {  48, "settimeofday" }, // PPM_SC_SETTIMEOFDAY
    {  49, "symlink" }, // PPM_SC_SYMLINK
    {  50, "lstat" }, // PPM_SC_LSTAT
    {  51, "readlink" }, // PPM_SC_READLINK
    {  52, "uselib" }, // PPM_SC_USELIB
    {  53, "swapon" }, // PPM_SC_SWAPON
    {  54, "reboot" }, // PPM_SC_REBOOT
    {  55, "mmap" }, // PPM_SC_MMAP
    {  56, "munmap" }, // PPM_SC_MUNMAP
    {  57, "truncate" }, // PPM_SC_TRUNCATE
    {  58, "ftruncate" }, // PPM_SC_FTRUNCATE
    {  59, "fchmod" }, // PPM_SC_FCHMOD
    {  60, "getpriority" }, // PPM_SC_GETPRIORITY
    {  61, "setpriority" }, // PPM_SC_SETPRIORITY
    {  62, "statfs" }, // PPM_SC_STATFS
    {  63, "fstatfs" }, // PPM_SC_FSTATFS
    {  64, "syslog" }, // PPM_SC_SYSLOG
    {  65, "setitimer" }, // PPM_SC_SETITIMER
    {  66, "getitimer" }, // PPM_SC_GETITIMER
    {  67, "uname" }, // PPM_SC_UNAME
    {  68, "vhangup" }, // PPM_SC_VHANGUP
    {  69, "wait4" }, // PPM_SC_WAIT4
    {  70, "swapoff" }, // PPM_SC_SWAPOFF
    {  71, "sysinfo" }, // PPM_SC_SYSINFO
    {  72, "fsync" }, // PPM_SC_FSYNC
    {  73, "setdomainname" }, // PPM_SC_SETDOMAINNAME
    {  74, "adjtimex" }, // PPM_SC_ADJTIMEX
    {  75, "mprotect" }, // PPM_SC_MPROTECT
    {  76, "init_module" }, // PPM_SC_INIT_MODULE
    {  77, "delete_module" }, // PPM_SC_DELETE_MODULE
    {  78, "quotactl" }, // PPM_SC_QUOTACTL
    {  79, "getpgid" }, // PPM_SC_GETPGID
    {  80, "fchdir" }, // PPM_SC_FCHDIR
    {  81, "sysfs" }, // PPM_SC_SYSFS
    {  82, "personality" }, // PPM_SC_PERSONALITY
    {  83, "getdents" }, // PPM_SC_GETDENTS
    {  84, "select" }, // PPM_SC_SELECT
    {  85, "flock" }, // PPM_SC_FLOCK
    {  86, "msync" }, // PPM_SC_MSYNC
    {  87, "readv" }, // PPM_SC_READV
    {  88, "writev" }, // PPM_SC_WRITEV
    {  89, "getsid" }, // PPM_SC_GETSID
    {  90, "fdatasync" }, // PPM_SC_FDATASYNC
    {  91, "mlock" }, // PPM_SC_MLOCK
    {  92, "munlock" }, // PPM_SC_MUNLOCK
    {  93, "mlockall" }, // PPM_SC_MLOCKALL
    {  94, "munlockall" }, // PPM_SC_MUNLOCKALL
    {  95, "sched_setparam" }, // PPM_SC_SCHED_SETPARAM
    {  96, "sched_getparam" }, // PPM_SC_SCHED_GETPARAM
    {  97, "sched_setscheduler" }, // PPM_SC_SCHED_SETSCHEDULER
    {  98, "sched_getscheduler" }, // PPM_SC_SCHED_GETSCHEDULER
    {  99, "sched_yield" }, // PPM_SC_SCHED_YIELD
    { 100, "sched_get_priority_max" }, // PPM_SC_SCHED_GET_PRIORITY_MAX
    { 101, "sched_get_priority_min" }, // PPM_SC_SCHED_GET_PRIORITY_MIN
    { 102, "sched_rr_get_interval" }, // PPM_SC_SCHED_RR_GET_INTERVAL
    { 103, "nanosleep" }, // PPM_SC_NANOSLEEP
    { 104, "mremap" }, // PPM_SC_MREMAP
    { 105, "poll" }, // PPM_SC_POLL
    { 106, "prctl" }, // PPM_SC_PRCTL
    { 107, "rt_sigaction" }, // PPM_SC_RT_SIGACTION
    { 108, "rt_sigprocmask" }, // PPM_SC_RT_SIGPROCMASK
    { 109, "rt_sigpending" }, // PPM_SC_RT_SIGPENDING
    { 110, "rt_sigtimedwait" }, // PPM_SC_RT_SIGTIMEDWAIT
    { 111, "rt_sigqueueinfo" }, // PPM_SC_RT_SIGQUEUEINFO
    { 112, "rt_sigsuspend" }, // PPM_SC_RT_SIGSUSPEND
    { 113, "getcwd" }, // PPM_SC_GETCWD
    { 114, "capget" }, // PPM_SC_CAPGET
    { 115, "capset" }, // PPM_SC_CAPSET
    { 116, "sendfile" }, // PPM_SC_SENDFILE
    { 117, "getrlimit" }, // PPM_SC_GETRLIMIT
    { 118, "lchown" }, // PPM_SC_LCHOWN
    { 119, "getuid" }, // PPM_SC_GETUID
    { 120, "getgid" }, // PPM_SC_GETGID
    { 121, "geteuid" }, // PPM_SC_GETEUID
    { 122, "getegid" }, // PPM_SC_GETEGID
    { 123, "setreuid" }, // PPM_SC_SETREUID
    { 124, "setregid" }, // PPM_SC_SETREGID
    { 125, "getgroups" }, // PPM_SC_GETGROUPS
    { 126, "setgroups" }, // PPM_SC_SETGROUPS
    { 127, "fchown" }, // PPM_SC_FCHOWN
    { 128, "setresuid" }, // PPM_SC_SETRESUID
    { 129, "getresuid" }, // PPM_SC_GETRESUID
    { 130, "setresgid" }, // PPM_SC_SETRESGID
    { 131, "getresgid" }, // PPM_SC_GETRESGID
    { 132, "chown" }, // PPM_SC_CHOWN
    { 133, "setuid" }, // PPM_SC_SETUID
    { 134, "setgid" }, // PPM_SC_SETGID
    { 135, "setfsuid" }, // PPM_SC_SETFSUID
    { 136, "setfsgid" }, // PPM_SC_SETFSGID
    { 137, "pivot_root" }, // PPM_SC_PIVOT_ROOT
    { 138, "mincore" }, // PPM_SC_MINCORE
    { 139, "madvise" }, // PPM_SC_MADVISE
    { 140, "gettid" }, // PPM_SC_GETTID
    { 141, "setxattr" }, // PPM_SC_SETXATTR
    { 142, "lsetxattr" }, // PPM_SC_LSETXATTR
    { 143, "fsetxattr" }, // PPM_SC_FSETXATTR
    { 144, "getxattr" }, // PPM_SC_GETXATTR
    { 145, "lgetxattr" }, // PPM_SC_LGETXATTR
    { 146, "fgetxattr" }, // PPM_SC_FGETXATTR
    { 147, "listxattr" }, // PPM_SC_LISTXATTR
    { 148, "llistxattr" }, // PPM_SC_LLISTXATTR
    { 149, "flistxattr" }, // PPM_SC_FLISTXATTR
    { 150, "removexattr" }, // PPM_SC_REMOVEXATTR
    { 151, "lremovexattr" }, // PPM_SC_LREMOVEXATTR
    { 152, "fremovexattr" }, // PPM_SC_FREMOVEXATTR
    { 153, "tkill" }, // PPM_SC_TKILL
    { 154, "futex" }, // PPM_SC_FUTEX
    { 155, "sched_setaffinity" }, // PPM_SC_SCHED_SETAFFINITY
    { 156, "sched_getaffinity" }, // PPM_SC_SCHED_GETAFFINITY
    { 157, "set_thread_area" }, // PPM_SC_SET_THREAD_AREA
    { 158, "get_thread_area" }, // PPM_SC_GET_THREAD_AREA
    { 159, "io_setup" }, // PPM_SC_IO_SETUP
    { 160, "io_destroy" }, // PPM_SC_IO_DESTROY
    { 161, "io_getevents" }, // PPM_SC_IO_GETEVENTS
    { 162, "io_submit" }, // PPM_SC_IO_SUBMIT
    { 163, "io_cancel" }, // PPM_SC_IO_CANCEL
    { 164, "exit_group" }, // PPM_SC_EXIT_GROUP
    { 165, "epoll_create" }, // PPM_SC_EPOLL_CREATE
    { 166, "epoll_ctl" }, // PPM_SC_EPOLL_CTL
    { 167, "epoll_wait" }, // PPM_SC_EPOLL_WAIT
    { 168, "remap_file_pages" }, // PPM_SC_REMAP_FILE_PAGES
    { 169, "set_tid_address" }, // PPM_SC_SET_TID_ADDRESS
    { 170, "timer_create" }, // PPM_SC_TIMER_CREATE
    { 171, "timer_settime" }, // PPM_SC_TIMER_SETTIME
    { 172, "timer_gettime" }, // PPM_SC_TIMER_GETTIME
    { 173, "timer_getoverrun" }, // PPM_SC_TIMER_GETOVERRUN
    { 174, "timer_delete" }, // PPM_SC_TIMER_DELETE
    { 175, "clock_settime" }, // PPM_SC_CLOCK_SETTIME
    { 176, "clock_gettime" }, // PPM_SC_CLOCK_GETTIME
    { 177, "clock_getres" }, // PPM_SC_CLOCK_GETRES
    { 178, "clock_nanosleep" }, // PPM_SC_CLOCK_NANOSLEEP
    { 179, "tgkill" }, // PPM_SC_TGKILL
    { 180, "utimes" }, // PPM_SC_UTIMES
    { 181, "mq_open" }, // PPM_SC_MQ_OPEN
    { 182, "mq_unlink" }, // PPM_SC_MQ_UNLINK
    { 183, "mq_timedsend" }, // PPM_SC_MQ_TIMEDSEND
    { 184, "mq_timedreceive" }, // PPM_SC_MQ_TIMEDRECEIVE
    { 185, "mq_notify" }, // PPM_SC_MQ_NOTIFY
    { 186, "mq_getsetattr" }, // PPM_SC_MQ_GETSETATTR
    { 187, "kexec_load" }, // PPM_SC_KEXEC_LOAD
    { 188, "waitid" }, // PPM_SC_WAITID
    { 189, "add_key" }, // PPM_SC_ADD_KEY
    { 190, "request_key" }, // PPM_SC_REQUEST_KEY
    { 191, "keyctl" }, // PPM_SC_KEYCTL
    { 192, "ioprio_set" }, // PPM_SC_IOPRIO_SET
    { 193, "ioprio_get" }, // PPM_SC_IOPRIO_GET
    { 194, "inotify_init" }, // PPM_SC_INOTIFY_INIT
    { 195, "inotify_add_watch" }, // PPM_SC_INOTIFY_ADD_WATCH
    { 196, "inotify_rm_watch" }, // PPM_SC_INOTIFY_RM_WATCH
    { 197, "openat" }, // PPM_SC_OPENAT
    { 198, "mkdirat" }, // PPM_SC_MKDIRAT
    { 199, "mknodat" }, // PPM_SC_MKNODAT
    { 200, "fchownat" }, // PPM_SC_FCHOWNAT
    { 201, "futimesat" }, // PPM_SC_FUTIMESAT
    { 202, "unlinkat" }, // PPM_SC_UNLINKAT
    { 203, "renameat" }, // PPM_SC_RENAMEAT
    { 204, "linkat" }, // PPM_SC_LINKAT
    { 205, "symlinkat" }, // PPM_SC_SYMLINKAT
    { 206, "readlinkat" }, // PPM_SC_READLINKAT
    { 207, "fchmodat" }, // PPM_SC_FCHMODAT
    { 208, "faccessat" }, // PPM_SC_FACCESSAT
    { 209, "pselect6" }, // PPM_SC_PSELECT6
    { 210, "ppoll" }, // PPM_SC_PPOLL
    { 211, "unshare" }, // PPM_SC_UNSHARE
    { 212, "set_robust_list" }, // PPM_SC_SET_ROBUST_LIST
    { 213, "get_robust_list" }, // PPM_SC_GET_ROBUST_LIST
    { 214, "splice" }, // PPM_SC_SPLICE
    { 215, "tee" }, // PPM_SC_TEE
    { 216, "vmsplice" }, // PPM_SC_VMSPLICE
    { 217, "getcpu" }, // PPM_SC_GETCPU
    { 218, "epoll_pwait" }, // PPM_SC_EPOLL_PWAIT
    { 219, "utimensat" }, // PPM_SC_UTIMENSAT
    { 220, "signalfd" }, // PPM_SC_SIGNALFD
    { 221, "timerfd_create" }, // PPM_SC_TIMERFD_CREATE
    { 222, "eventfd" }, // PPM_SC_EVENTFD
    { 223, "timerfd_settime" }, // PPM_SC_TIMERFD_SETTIME
    { 224, "timerfd_gettime" }, // PPM_SC_TIMERFD_GETTIME
    { 225, "signalfd4" }, // PPM_SC_SIGNALFD4
    { 226, "eventfd2" }, // PPM_SC_EVENTFD2
    { 227, "epoll_create1" }, // PPM_SC_EPOLL_CREATE1
    { 228, "dup3" }, // PPM_SC_DUP3
    { 229, "pipe2" }, // PPM_SC_PIPE2
    { 230, "inotify_init1" }, // PPM_SC_INOTIFY_INIT1
    { 231, "preadv" }, // PPM_SC_PREADV
    { 232, "pwritev" }, // PPM_SC_PWRITEV
    { 233, "rt_tgsigqueueinfo" }, // PPM_SC_RT_TGSIGQUEUEINFO
    { 234, "perf_event_open" }, // PPM_SC_PERF_EVENT_OPEN
    { 235, "fanotify_init" }, // PPM_SC_FANOTIFY_INIT
    { 236, "prlimit64" }, // PPM_SC_PRLIMIT64
    { 237, "clock_adjtime" }, // PPM_SC_CLOCK_ADJTIME
    { 238, "syncfs" }, // PPM_SC_SYNCFS
    { 239, "setns" }, // PPM_SC_SETNS
    { 240, "getdents64" }, // PPM_SC_GETDENTS64
    { 241, "socket" }, // PPM_SC_SOCKET
    { 242, "bind" }, // PPM_SC_BIND
    { 243, "connect" }, // PPM_SC_CONNECT
    { 244, "listen" }, // PPM_SC_LISTEN
    { 245, "accept" }, // PPM_SC_ACCEPT
    { 246, "getsockname" }, // PPM_SC_GETSOCKNAME
    { 247, "getpeername" }, // PPM_SC_GETPEERNAME
    { 248, "socketpair" }, // PPM_SC_SOCKETPAIR
    { 249, "sendto" }, // PPM_SC_SENDTO
    { 250, "recvfrom" }, // PPM_SC_RECVFROM
    { 251, "shutdown" }, // PPM_SC_SHUTDOWN
    { 252, "setsockopt" }, // PPM_SC_SETSOCKOPT
    { 253, "getsockopt" }, // PPM_SC_GETSOCKOPT
    { 254, "sendmsg" }, // PPM_SC_SENDMSG
    { 255, "sendmmsg" }, // PPM_SC_SENDMMSG
    { 256, "recvmsg" }, // PPM_SC_RECVMSG
    { 257, "recvmmsg" }, // PPM_SC_RECVMMSG
    { 258, "accept4" }, // PPM_SC_ACCEPT4
    { 259, "semop" }, // PPM_SC_SEMOP
    { 260, "semget" }, // PPM_SC_SEMGET
    { 261, "semctl" }, // PPM_SC_SEMCTL
    { 262, "msgsnd" }, // PPM_SC_MSGSND
    { 263, "msgrcv" }, // PPM_SC_MSGRCV
    { 264, "msgget" }, // PPM_SC_MSGGET
    { 265, "msgctl" }, // PPM_SC_MSGCTL
    { 266, "shmdt" }, // PPM_SC_SHMDT
    { 267, "shmget" }, // PPM_SC_SHMGET
    { 268, "shmctl" }, // PPM_SC_SHMCTL
    { 269, "statfs64" }, // PPM_SC_STATFS64
    { 270, "fstatfs64" }, // PPM_SC_FSTATFS64
    { 271, "fstatat64" }, // PPM_SC_FSTATAT64
    { 272, "sendfile64" }, // PPM_SC_SENDFILE64
    { 273, "ugetrlimit" }, // PPM_SC_UGETRLIMIT
    { 274, "bdflush" }, // PPM_SC_BDFLUSH
    { 275, "sigprocmask" }, // PPM_SC_SIGPROCMASK
    { 276, "ipc" }, // PPM_SC_IPC
    { 277, "socketcall" }, // PPM_SC_SOCKETCALL
    { 278, "stat64" }, // PPM_SC_STAT64
    { 279, "lstat64" }, // PPM_SC_LSTAT64
    { 280, "fstat64" }, // PPM_SC_FSTAT64
    { 281, "fcntl64" }, // PPM_SC_FCNTL64
    { 282, "mmap2" }, // PPM_SC_MMAP2
    { 283, "_newselect" }, // PPM_SC__NEWSELECT
    { 284, "sgetmask" }, // PPM_SC_SGETMASK
    { 285, "ssetmask" }, // PPM_SC_SSETMASK
    { 286, "sigpending" }, // PPM_SC_SIGPENDING
    { 287, "olduname" }, // PPM_SC_OLDUNAME
    { 288, "umount" }, // PPM_SC_UMOUNT
    { 289, "signal" }, // PPM_SC_SIGNAL
    { 290, "nice" }, // PPM_SC_NICE
    { 291, "stime" }, // PPM_SC_STIME
    { 292, "_llseek" }, // PPM_SC__LLSEEK
    { 293, "waitpid" }, // PPM_SC_WAITPID
    { 294, "pread64" }, // PPM_SC_PREAD64
    { 295, "pwrite64" }, // PPM_SC_PWRITE64
    { 296, "arch_prctl" }, // PPM_SC_ARCH_PRCTL
    { 297, "shmat" }, // PPM_SC_SHMAT
    { 298, "rt_sigreturn" }, // PPM_SC_RT_SIGRETURN
    { 299, "fallocate" }, // PPM_SC_FALLOCATE
    { 300, "newfstatat" }, // PPM_SC_NEWFSTATAT
    { 301, "process_vm_readv" }, // PPM_SC_PROCESS_VM_READV
    { 302, "process_vm_writev" }, // PPM_SC_PROCESS_VM_WRITEV
    { 303, "fork" }, // PPM_SC_FORK
    { 304, "vfork" }, // PPM_SC_VFORK
    { 305, "setuid32" }, // PPM_SC_SETUID32
    { 306, "getuid32" }, // PPM_SC_GETUID32
    { 307, "setgid32" }, // PPM_SC_SETGID32
    { 308, "geteuid32" }, // PPM_SC_GETEUID32
    { 309, "getgid32" }, // PPM_SC_GETGID32
    { 310, "setresuid32" }, // PPM_SC_SETRESUID32
    { 311, "setresgid32" }, // PPM_SC_SETRESGID32
    { 312, "getresuid32" }, // PPM_SC_GETRESUID32
    { 313, "getresgid32" }, // PPM_SC_GETRESGID32
    { 314, "finit_module" }, // PPM_SC_FINIT_MODULE
    { 315, "bpf" }, // PPM_SC_BPF
    { 316, "seccomp" }, // PPM_SC_SECCOMP
    { 317, "sigaltstack" }, // PPM_SC_SIGALTSTACK
    { 318, "getrandom" }, // PPM_SC_GETRANDOM
    { 319, "fadvise64" }, // PPM_SC_FADVISE64
    { 320, "renameat2" }, // PPM_SC_RENAMEAT2
    { 321, "userfaultfd" }, // PPM_SC_USERFAULTFD
    { 322, "openat2" }, // PPM_SC_OPENAT2
    { 323, "umount2" }, // PPM_SC_UMOUNT2
    { 324, "execve" }, // PPM_SC_EXECVE
    { 325, "execveat" }, // PPM_SC_EXECVEAT
    { 326, "copy_file_range" }, // PPM_SC_COPY_FILE_RANGE
    { 327, "clone" }, // PPM_SC_CLONE
    { 328, "clone3" }, // PPM_SC_CLONE3
    { 329, "open_by_handle_at" }, // PPM_SC_OPEN_BY_HANDLE_AT
    { 330, "io_uring_setup" }, // PPM_SC_IO_URING_SETUP
    { 331, "io_uring_enter" }, // PPM_SC_IO_URING_ENTER
    { 332, "io_uring_register" }, // PPM_SC_IO_URING_REGISTER
    { 333, "mlock2" }, // PPM_SC_MLOCK2
    { 334, "getegid32" }, // PPM_SC_GETEGID32
    { 335, "fsconfig" }, // PPM_SC_FSCONFIG
    { 336, "fspick" }, // PPM_SC_FSPICK
    { 337, "fsmount" }, // PPM_SC_FSMOUNT
    { 338, "fsopen" }, // PPM_SC_FSOPEN
    { 339, "open_tree" }, // PPM_SC_OPEN_TREE
    { 340, "move_mount" }, // PPM_SC_MOVE_MOUNT
    { 341, "mount_setattr" }, // PPM_SC_MOUNT_SETATTR
    { 342, "memfd_create" }, // PPM_SC_MEMFD_CREATE
    { 343, "memfd_secret" }, // PPM_SC_MEMFD_SECRET
    { 344, "ioperm" }, // PPM_SC_IOPERM
    { 345, "kexec_file_load" }, // PPM_SC_KEXEC_FILE_LOAD
    { 346, "pidfd_getfd" }, // PPM_SC_PIDFD_GETFD
    { 347, "pidfd_open" }, // PPM_SC_PIDFD_OPEN
    { 348, "pidfd_send_signal" }, // PPM_SC_PIDFD_SEND_SIGNAL
    { 349, "pkey_alloc" }, // PPM_SC_PKEY_ALLOC
    { 350, "pkey_mprotect" }, // PPM_SC_PKEY_MPROTECT
    { 351, "pkey_free" }, // PPM_SC_PKEY_FREE
    { 352, "landlock_create_ruleset" }, // PPM_SC_LANDLOCK_CREATE_RULESET
    { 353, "quotactl_fd" }, // PPM_SC_QUOTACTL_FD
    { 354, "landlock_restrict_self" }, // PPM_SC_LANDLOCK_RESTRICT_SELF
    { 355, "landlock_add_rule" }, // PPM_SC_LANDLOCK_ADD_RULE
    { 356, "epoll_pwait2" }, // PPM_SC_EPOLL_PWAIT2
    { 357, "migrate_pages" }, // PPM_SC_MIGRATE_PAGES
    { 358, "move_pages" }, // PPM_SC_MOVE_PAGES
    { 359, "preadv2" }, // PPM_SC_PREADV2
    { 360, "pwritev2" }, // PPM_SC_PWRITEV2
    { 361, "kcmp" }, // PPM_SC_KCMP
    { 362, "sched_setattr" }, // PPM_SC_SCHED_SETATTR
    { 363, "mbind" }, // PPM_SC_MBIND
    { 364, "epoll_ctl_old" }, // PPM_SC_EPOLL_CTL_OLD
    { 365, "lookup_dcookie" }, // PPM_SC_LOOKUP_DCOOKIE
    { 366, "modify_ldt" }, // PPM_SC_MODIFY_LDT
    { 367, "statx" }, // PPM_SC_STATX
    { 368, "set_mempolicy" }, // PPM_SC_SET_MEMPOLICY
    { 369, "io_pgetevents" }, // PPM_SC_IO_PGETEVENTS
    { 370, "set_mempolicy_home_node" }, // PPM_SC_SET_MEMPOLICY_HOME_NODE
    { 371, "semtimedop" }, // PPM_SC_SEMTIMEDOP
    { 372, "get_kernel_syms" }, // PPM_SC_GET_KERNEL_SYMS
    { 373, "readahead" }, // PPM_SC_READAHEAD
    { 374, "futex_waitv" }, // PPM_SC_FUTEX_WAITV
    { 375, "getpmsg" }, // PPM_SC_GETPMSG
    { 376, "name_to_handle_at" }, // PPM_SC_NAME_TO_HANDLE_AT
    { 377, "process_mrelease" }, // PPM_SC_PROCESS_MRELEASE
    { 378, "nfsservctl" }, // PPM_SC_NFSSERVCTL
    { 379, "epoll_wait_old" }, // PPM_SC_EPOLL_WAIT_OLD
    { 380, "rseq" }, // PPM_SC_RSEQ
    { 381, "create_module" }, // PPM_SC_CREATE_MODULE
    { 383, "sched_getattr" }, // PPM_SC_SCHED_GETATTR
    { 384, "faccessat2" }, // PPM_SC_FACCESSAT2
    { 385, "_sysctl" }, // PPM_SC__SYSCTL
    { 386, "query_module" }, // PPM_SC_QUERY_MODULE
    { 387, "get_mempolicy" }, // PPM_SC_GET_MEMPOLICY
    { 388, "sync_file_range" }, // PPM_SC_SYNC_FILE_RANGE
    { 389, "process_madvise" }, // PPM_SC_PROCESS_MADVISE
    { 390, "membarrier" }, // PPM_SC_MEMBARRIER
    { 391, "iopl" }, // PPM_SC_IOPL
    { 392, "close_range" }, // PPM_SC_CLOSE_RANGE
    { 393, "fanotify_mark" }, // PPM_SC_FANOTIFY_MARK
    { 394, "recv" }, // PPM_SC_RECV
    { 395, "send" }, // PPM_SC_SEND
    { 396, "sched_process_exit" }, // PPM_SC_SCHED_PROCESS_EXIT
    { 397, "sched_switch" }, // PPM_SC_SCHED_SWITCH
    { 398, "page_fault_user" }, // PPM_SC_PAGE_FAULT_USER
    { 399, "page_fault_kernel" }, // PPM_SC_PAGE_FAULT_KERNEL
    { 400, "signal_deliver" }, // PPM_SC_SIGNAL_DELIVER
    { 401, "timerfd" }, // PPM_SC_TIMERFD
    { 402, "s390_pci_mmio_read" }, // PPM_SC_S390_PCI_MMIO_READ
    { 403, "sigaction" }, // PPM_SC_SIGACTION
    { 404, "s390_pci_mmio_write" }, // PPM_SC_S390_PCI_MMIO_WRITE
    { 405, "readdir" }, // PPM_SC_READDIR
    { 406, "s390_sthyi" }, // PPM_SC_S390_STHYI
    { 407, "sigsuspend" }, // PPM_SC_SIGSUSPEND
    { 408, "idle" }, // PPM_SC_IDLE
    { 409, "s390_runtime_instr" }, // PPM_SC_S390_RUNTIME_INSTR
    { 410, "sigreturn" }, // PPM_SC_SIGRETURN
    { 411, "s390_guarded_storage" }, // PPM_SC_S390_GUARDED_STORAGE
    { 412, "cachestat" }, // PPM_SC_CACHESTAT
    { 413, "fchmodat2" }, // PPM_SC_FCHMODAT2
    { 414, "map_shadow_stack" }, // PPM_SC_MAP_SHADOW_STACK
    { 415, "riscv_flush_icache" }, // PPM_SC_RISCV_FLUSH_ICACHE
    { 416, "riscv_hwprobe" }, // PPM_SC_RISCV_HWPROBE
    { 417, "futex_wake" }, // PPM_SC_FUTEX_WAKE
    { 418, "futex_requeue" }, // PPM_SC_FUTEX_REQUEUE
    { 419, "futex_wait" }, // PPM_SC_FUTEX_WAIT
    { 420, "oldstat" }, // PPM_SC_OLDSTAT
    { 421, "switch_endian" }, // PPM_SC_SWITCH_ENDIAN
    { 422, "multiplexer" }, // PPM_SC_MULTIPLEXER
    { 423, "oldlstat" }, // PPM_SC_OLDLSTAT
    { 424, "spu_create" }, // PPM_SC_SPU_CREATE
    { 425, "sync_file_range2" }, // PPM_SC_SYNC_FILE_RANGE2
    { 426, "oldfstat" }, // PPM_SC_OLDFSTAT
    { 427, "spu_run" }, // PPM_SC_SPU_RUN
    { 428, "swapcontext" }, // PPM_SC_SWAPCONTEXT
    { 429, "pciconfig_write" }, // PPM_SC_PCICONFIG_WRITE
    { 430, "rtas" }, // PPM_SC_RTAS
    { 431, "pciconfig_read" }, // PPM_SC_PCICONFIG_READ
    { 432, "sys_debug_setcontext" }, // PPM_SC_SYS_DEBUG_SETCONTEXT
    { 433, "vm86" }, // PPM_SC_VM86
    { 434, "oldolduname" }, // PPM_SC_OLDOLDUNAME
    { 435, "subpage_prot" }, // PPM_SC_SUBPAGE_PROT
    { 436, "pciconfig_iobase" }, // PPM_SC_PCICONFIG_IOBASE
    { 437, "listmount" }, // PPM_SC_LISTMOUNT
    { 438, "statmount" }, // PPM_SC_STATMOUNT
    { 439, "lsm_get_self_attr" }, // PPM_SC_LSM_GET_SELF_ATTR
    { 440, "lsm_set_self_attr" }, // PPM_SC_LSM_SET_SELF_ATTR
    { 441, "lsm_list_modules" }, // PPM_SC_LSM_LIST_MODULES
    { 442, "mseal" }, // PPM_SC_MSEAL

    { 0, NULL }
};

/*
static const value_string param_category_vals[] = {
    {  1, "Other"},
    {  2, "File"},
    {  3, "Network operation"},
    {  4, "IPC operation"},
    {  5, "Memory operation"},
    {  6, "Process operation"},
    {  7, "Plain sleep"},
    {  8, "System operation"},
    {  9, "Signal operation"},
    { 10, "User operation"},
    { 11, "Time"},
    { 12, "User-level processing"},
    { 32, "I/O read"},
    { 33, "I/O write"},
    { 34, "I/O other"},
    { 64, "General wait"},
    {128, "Scheduler event"},
    {256, "Internal event"},
    {0, NULL}
};
*/

/*
static const value_string param_flag_vals[] = {
    {     0, "None"},
    {1 << 0, "Creates FD"},
    {1 << 1, "Destroys FD"},
    {1 << 2, "Uses FD"},
    {1 << 3, "Reads from FD"},
    {1 << 4, "Writes to FD"},
    {1 << 5, "Modifies state"},
    {1 << 6, "Unused"},
    {1 << 7, "Waits"},
    {1 << 8, "Skip parse reset"},
    {1 << 9, "Old version"},
    {0, NULL}
};
*/

/*
static const value_string param_subcategory_vals[] = {
    {  0, "Unknown"},
    {  1, "None"},
    {  2, "Other"},
    {  3, "File"},
    {  4, "Net"},
    {  5, "IPC"},
    {0, NULL}
};
*/

static inline const char *format_param_str(wmem_allocator_t *scope, tvbuff_t *tvb, int offset, int len) {
    char *param_str;

    param_str = tvb_get_string_enc(scope, tvb, offset, len, ENC_UTF_8|ENC_NA);

    if (len < 2) {
        return param_str;
    }
    return format_text_chr(scope, param_str, len - 1, ' '); /* Leave terminating NULLs alone. */
}

/* Code to actually dissect the packets */

static int
dissect_header_lens_v1(tvbuff_t *tvb, proto_tree *tree, unsigned encoding, int * const *hf_indexes)
{
    int param_count;
    proto_item *ti;
    proto_tree *len_tree;

    for (param_count = 0; hf_indexes[param_count]; param_count++);

    ti = proto_tree_add_item(tree, hf_se_param_lens, tvb, 0, param_count * SYSDIG_PARAM_SIZE, ENC_NA);
    len_tree = proto_item_add_subtree(ti, ett_sysdig_parm_lens);

    for (param_count = 0; hf_indexes[param_count]; param_count++) {
        proto_tree_add_item(len_tree, hf_se_param_len, tvb, param_count * SYSDIG_PARAM_SIZE, SYSDIG_PARAM_SIZE, encoding);
    }

    proto_item_set_len(ti, param_count * SYSDIG_PARAM_SIZE);
    return param_count * SYSDIG_PARAM_SIZE;
}

static int
dissect_header_lens_v2(tvbuff_t *tvb, wtap_syscall_header* syscall_header, proto_tree *tree, unsigned encoding)
{
    uint32_t param_count;
    proto_item *ti;
    proto_tree *len_tree;

    ti = proto_tree_add_item(tree, hf_se_param_lens, tvb, 0, syscall_header->nparams * SYSDIG_PARAM_SIZE_V2, ENC_NA);
    len_tree = proto_item_add_subtree(ti, ett_sysdig_parm_lens);

    for (param_count = 0; param_count < syscall_header->nparams; param_count++) {
        proto_tree_add_item(len_tree, hf_se_param_len, tvb, param_count * SYSDIG_PARAM_SIZE_V2, SYSDIG_PARAM_SIZE_V2, encoding);
    }

    proto_item_set_len(ti, syscall_header->nparams * SYSDIG_PARAM_SIZE_V2);
    return syscall_header->nparams * SYSDIG_PARAM_SIZE_V2;
}

static int
dissect_header_lens_v2_large(tvbuff_t *tvb, wtap_syscall_header* syscall_header, proto_tree *tree, unsigned encoding)
{
    uint32_t param_count;
    proto_item *ti;
    proto_tree *len_tree;

    ti = proto_tree_add_item(tree, hf_se_param_lens, tvb, 0, syscall_header->nparams * SYSDIG_PARAM_SIZE_V2_LARGE, ENC_NA);
    len_tree = proto_item_add_subtree(ti, ett_sysdig_parm_lens);

    for (param_count = 0; param_count < syscall_header->nparams; param_count++) {
        proto_tree_add_item(len_tree, hf_se_param_len, tvb, param_count * SYSDIG_PARAM_SIZE_V2_LARGE, SYSDIG_PARAM_SIZE_V2_LARGE, encoding);
    }

    proto_item_set_len(ti, syscall_header->nparams * SYSDIG_PARAM_SIZE_V2_LARGE);
    return syscall_header->nparams * SYSDIG_PARAM_SIZE_V2_LARGE;
}

/* Dissect events */

static int
dissect_event_params(tvbuff_t *tvb, packet_info *pinfo, const char **event_name, wtap_syscall_header* syscall_header, proto_tree *tree, unsigned encoding, int * const *hf_indexes, sysdig_event_param_data *event_param_data)
{
    int len_offset = 0;
    int param_offset;
    int len_size;
    uint32_t cur_param;

    switch (syscall_header->record_type) {
        case BLOCK_TYPE_SYSDIG_EVENT_V2_LARGE:
            param_offset = dissect_header_lens_v2_large(tvb, syscall_header, tree, encoding);
            len_size = SYSDIG_PARAM_SIZE_V2_LARGE;
            break;
        case BLOCK_TYPE_SYSDIG_EVENT_V2:
            param_offset = dissect_header_lens_v2(tvb, syscall_header, tree, encoding);
            len_size = SYSDIG_PARAM_SIZE_V2;
            break;
        default:
            param_offset = dissect_header_lens_v1(tvb, tree, encoding, hf_indexes);
            len_size = SYSDIG_PARAM_SIZE;
            break;
    }

    for (cur_param = 0; cur_param < syscall_header->nparams; cur_param++) {
        if (!hf_indexes[cur_param]) {
            // This happens when new params are added to existent events in sysdig,
            // if the event is already mapped in wireshark with a lower number of params.
            // hf_indexes array size would be < than event being dissected, leading to SIGSEGV.
            break;
        }

        uint32_t param_len;
        if (syscall_header->record_type == BLOCK_TYPE_SYSDIG_EVENT_V2_LARGE) {
            param_len = tvb_get_uint32(tvb, len_offset, encoding);
        } else {
            param_len = tvb_get_uint16(tvb, len_offset, encoding);
        }
        const int hf_index = *hf_indexes[cur_param];
        if (proto_registrar_get_ftype(hf_index) == FT_STRING) {
            proto_tree_add_string(tree, hf_index, tvb, param_offset, param_len,
                                  format_param_str(pinfo->pool, tvb, param_offset, param_len));
        } else {
            proto_tree_add_item(tree, hf_index, tvb, param_offset, param_len, encoding);
            if (hf_index == hf_param_data_bytes) {
                event_param_data->data_bytes_offset = param_offset;
                event_param_data->data_bytes_length = param_len;
            }
        }

        if (hf_index == hf_param_ID_uint16) {
            uint16_t id = tvb_get_uint16(tvb, param_offset, encoding);
            *event_name = val_to_str(pinfo->pool, id, ID_uint16_vals, "Unknown ID %u");
            col_add_str(pinfo->cinfo, COL_INFO, *event_name);
        }
        param_offset += param_len;
        len_offset += len_size;
    }
    return param_offset;
}

static int
dissect_sysdig_event(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree,
        void *data _U_)
{
    proto_item *ti;
    proto_tree *se_tree, *syscall_tree;
    unsigned    event_type = pinfo->rec->rec_header.syscall_header.event_type;
    unsigned    encoding = pinfo->rec->rec_header.syscall_header.byte_order == G_BIG_ENDIAN ? ENC_BIG_ENDIAN : ENC_LITTLE_ENDIAN;
    const struct _event_col_info *cur_col_info;
    const struct _event_tree_info *cur_tree_info;

    /*** COLUMN DATA ***/

    /*
     * If this is a plugin event, handle it appropriately and return
     */
    if (event_type == EVT_PLUGINEVENT_E && sinsp_dissector_handle) {
        return call_dissector(sinsp_dissector_handle, tvb, pinfo, tree);
    }

    const char *event_name = val_to_str(pinfo->pool, event_type, event_type_vals, "Unknown syscall %u");
    sysdig_event_param_data event_param_data = {0};

    /*
     * Sysdig uses the term "event" internally. So far every event has been
     * a syscall.
     */
    col_clear(pinfo->cinfo, COL_INFO);
    col_set_str(pinfo->cinfo, COL_PROTOCOL, "Sysdig Event");
    col_add_str(pinfo->cinfo, COL_INFO, event_name);

    /*
     * XXX We can ditch this in favor of a simple index when event_col_info
     * is contiguous and in the correct order.
     */
    for (cur_col_info = event_col_info; cur_col_info->params; cur_col_info++) {
        if (cur_col_info->event_type == event_type) {
            const struct _event_col_info_param *cur_param = cur_col_info->params;
            int param_offset = cur_col_info->num_len_fields * 2;

            /* Find the data offset */
            int cur_len_field;
            for (cur_len_field = 0;
                    cur_len_field < cur_col_info->num_len_fields && cur_param->param_name;
                    cur_len_field++) {
                unsigned param_len = tvb_get_uint16(tvb, cur_len_field * 2, encoding);
                if (cur_param->param_num == cur_len_field) {
                    col_append_fstr(pinfo->cinfo, COL_INFO, ", %s=", cur_param->param_name);
                    switch (cur_param->param_ftype) {
                    case FT_STRING:
                        col_append_str(pinfo->cinfo, COL_INFO, format_param_str(pinfo->pool, tvb, param_offset, param_len));
                        break;
                    case FT_UINT64:
                        col_append_fstr(pinfo->cinfo, COL_INFO, "%" PRIu64, tvb_get_uint64(tvb, param_offset, encoding));
                    default:
                        break;
                    }
                    cur_param++;
                }
                param_offset += param_len;
            }
        }
    }

    /*** PROTOCOL TREE ***/

    /* create display subtree for the protocol */
    ti = proto_tree_add_item(tree, proto_sysdig_event, tvb, 0, -1, ENC_NA);

    se_tree = proto_item_add_subtree(ti, ett_sysdig_event);

    proto_tree_add_uint(se_tree, hf_se_cpu_id, tvb, 0, 0, pinfo->rec->rec_header.syscall_header.cpu_id);
    proto_tree_add_uint64(se_tree, hf_se_thread_id, tvb, 0, 0, pinfo->rec->rec_header.syscall_header.thread_id);
    proto_tree_add_uint(se_tree, hf_se_event_length, tvb, 0, 0, pinfo->rec->rec_header.syscall_header.event_len);
    proto_tree_add_uint(se_tree, hf_se_event_data_length, tvb, 0, 0, pinfo->rec->rec_header.syscall_header.event_data_len);
    if (pinfo->rec->rec_header.syscall_header.nparams != 0) {
        proto_tree_add_uint(se_tree, hf_se_nparams, tvb, 0, 0, pinfo->rec->rec_header.syscall_header.nparams);
    }
    ti = proto_tree_add_uint(se_tree, hf_se_event_type, tvb, 0, 0, event_type);

    syscall_tree = proto_item_add_subtree(ti, ett_sysdig_syscall);

    if (pinfo->rec->rec_header.syscall_header.nparams > 0) {
        for (cur_tree_info = event_tree_info; cur_tree_info->hf_indexes; cur_tree_info++) {
            if (cur_tree_info->event_type == event_type) {
                dissect_event_params(tvb, pinfo, &event_name, &pinfo->rec->rec_header.syscall_header, syscall_tree, encoding, cur_tree_info->hf_indexes, &event_param_data);
                break;
            }
        }
    }

    proto_tree_add_string(se_tree, hf_se_event_name, tvb, 0, 0, event_name);

    if (!sinsp_dissector_handle) {
        return tvb_reported_length(tvb);
    }

    int ret = call_dissector_with_data(sinsp_dissector_handle, tvb, pinfo, tree, &event_param_data);

    if (event_param_data.data_bytes_offset > 0 && event_param_data.data_bytes_length > 0) {
#define ELF_MAGIC 0x7f454c46 // 7f 'E' 'L' 'F'
        if (tvb_get_uint32(tvb, event_param_data.data_bytes_offset, ENC_BIG_ENDIAN) == ELF_MAGIC && elf_dissector_handle) {
            tvbuff_t *elf_tvb = tvb_new_subset_length(tvb, event_param_data.data_bytes_offset, event_param_data.data_bytes_length);
            TRY {
                call_dissector(elf_dissector_handle, elf_tvb, pinfo, tree);
            } CATCH_NONFATAL_ERRORS {
                // Partial dissection is OK.
            } ENDTRY;
        }
    }

    return ret;
}

/* Register the protocol with Wireshark.
 *
 * This format is required because a script is used to build the C function that
 * calls all the protocol registration.
 */
void
proto_register_sysdig_event(void)
{
    /* XXX Match up with Sysdig's names. */
    static hf_register_info hf[] = {
        { &hf_se_cpu_id,
          { "CPU ID", "sysdig.cpu_id",
            FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_thread_id,
          { "Thread ID", "sysdig.thread_id",
            FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_event_length,
          { "Event length", "sysdig.event_len",
            FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_event_data_length,
          { "Event data length", "sysdig.event_data_len",
            FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_nparams,
          { "Number of parameters", "sysdig.nparams",
            FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_event_type,
          { "Event type", "sysdig.event_type",
            FT_UINT16, BASE_DEC, VALS(event_type_vals), 0, NULL, HFILL }
        },
        { &hf_se_event_name,
          { "Event name", "sysdig.event_name",
            FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL }
        },
        { &hf_se_param_lens,
          { "Parameter lengths", "sysdig.param.lens",
            FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL }
        },
        { &hf_se_param_len,
          { "Parameter length", "sysdig.param.len",
            FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL }
        },

/* Header field registration. Automatically generated by tools/generate-sysdig-event.py */
        { &hf_param_ID_uint16, { "ID", "sysdig.param.syscall.ID", FT_UINT16, BASE_DEC, VALS(ID_uint16_vals), 0, NULL, HFILL } },
        { &hf_param_action_uint32, { "action", "sysdig.param.cpu_hotplug.action", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_addr_bytes, { "addr", "sysdig.param.ptrace.addr", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_addr_uint64, { "addr", "sysdig.param.mlock2.addr", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_arg2_int_int64, { "arg2_int", "sysdig.param.prctl.arg2_int", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_arg2_str_string, { "arg2_str", "sysdig.param.prctl.arg2_str", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_arg_uint64, { "arg", "sysdig.param.io_uring_register.arg", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_args_string, { "args", "sysdig.param.clone3.args", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_argument_uint64, { "I/O control: argument", "sysdig.param.ioctl.argument", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_aux_int32, { "aux", "sysdig.param.fsconfig.aux", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_backlog_int32, { "backlog", "sysdig.param.listen.backlog", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cap_effective_uint64, { "cap_effective", "sysdig.param.capset.cap_effective", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_cap_inheritable_uint64, { "cap_inheritable", "sysdig.param.capset.cap_inheritable", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_cap_permitted_uint64, { "cap_permitted", "sysdig.param.capset.cap_permitted", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_cgroups_bytes, { "cgroups", "sysdig.param.clone3.cgroups", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_clockid_uint8, { "clockid", "sysdig.param.timerfd_create.clockid", FT_UINT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cmd_bytes, { "cmd", "sysdig.param.fsconfig.cmd", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_cmd_int16, { "cmd", "sysdig.param.semctl.cmd", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cmd_int64, { "cmd", "sysdig.param.bpf.cmd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_comm_string, { "comm", "sysdig.param.clone3.comm", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_container_id_string, { "container_id", "sysdig.param.groupdeleted.container_id", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_core_uint8, { "core", "sysdig.param.procexit.core", FT_UINT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_sys_uint64, { "cpu_sys", "sysdig.param.procinfo.cpu_sys", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_uint32, { "cpu", "sysdig.param.cpu_hotplug.cpu", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_usr_uint64, { "cpu_usr", "sysdig.param.procinfo.cpu_usr", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cq_entries_uint32, { "cq_entries", "sysdig.param.io_uring_setup.cq_entries", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cur_int64, { "cur", "sysdig.param.setrlimit.cur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cwd_string, { "cwd", "sysdig.param.clone3.cwd", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_data_bytes, { "data", "sysdig.param.process_vm_writev.data", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_desc_string, { "desc", "sysdig.param.notification.desc", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_description_string, { "description", "sysdig.param.infra.description", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dev_string, { "dev", "sysdig.param.mount.dev", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dev_uint32, { "dev", "sysdig.param.mknodat.dev", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dir_string, { "dir", "sysdig.param.mount.dir", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dirfd_int64, { "dirfd", "sysdig.param.newfstatat.dirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_domain_bytes, { "domain", "sysdig.param.socketpair.domain", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dpid_int64, { "dpid", "sysdig.param.signaldeliver.dpid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_bhardlimit_uint64, { "dqb_bhardlimit", "sysdig.param.quotactl.dqb_bhardlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_bsoftlimit_uint64, { "dqb_bsoftlimit", "sysdig.param.quotactl.dqb_bsoftlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_btime_bytes, { "dqb_btime", "sysdig.param.quotactl.dqb_btime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_curspace_uint64, { "dqb_curspace", "sysdig.param.quotactl.dqb_curspace", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_ihardlimit_uint64, { "dqb_ihardlimit", "sysdig.param.quotactl.dqb_ihardlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_isoftlimit_uint64, { "dqb_isoftlimit", "sysdig.param.quotactl.dqb_isoftlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_itime_bytes, { "dqb_itime", "sysdig.param.quotactl.dqb_itime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_bgrace_bytes, { "dqi_bgrace", "sysdig.param.quotactl.dqi_bgrace", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_flags_int8, { "dqi_flags", "sysdig.param.quotactl.dqi_flags", FT_INT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_igrace_bytes, { "dqi_igrace", "sysdig.param.quotactl.dqi_igrace", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_egid_int32, { "egid", "sysdig.param.setregid.egid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_entries_uint32, { "entries", "sysdig.param.io_uring_setup.entries", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_env_string, { "env", "sysdig.param.execveat.env", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_error_int32, { "error", "sysdig.param.page_fault.error", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_euid_int32, { "euid", "sysdig.param.setreuid.euid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_event_data_bytes, { "event_data", "sysdig.param.pluginevent.event_data", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_event_data_uint64, { "event_data", "sysdig.param.scapevent.event_data", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_event_type_uint32, { "event_type", "sysdig.param.scapevent.event_type", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_exe_ino_ctime_bytes, { "exe_ino_ctime", "sysdig.param.execveat.exe_ino_ctime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_exe_ino_mtime_bytes, { "exe_ino_mtime", "sysdig.param.execveat.exe_ino_mtime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_exe_ino_uint64, { "exe_ino", "sysdig.param.execveat.exe_ino", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_exe_string, { "exe", "sysdig.param.clone3.exe", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_fd1_int64, { "fd1", "sysdig.param.pipe2.fd1", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd2_int64, { "fd2", "sysdig.param.pipe2.fd2", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_in_int64, { "fd_in", "sysdig.param.splice.fd_in", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_int64, { "fd", "sysdig.param.finit_module.fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_out_int64, { "fd_out", "sysdig.param.splice.fd_out", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdin_int64, { "fdin", "sysdig.param.copy_file_range.fdin", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdlimit_int64, { "fdlimit", "sysdig.param.clone3.fdlimit", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdlimit_uint64, { "fdlimit", "sysdig.param.execveat.fdlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdout_int64, { "fdout", "sysdig.param.copy_file_range.fdout", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fds_bytes, { "fds", "sysdig.param.ppoll.fds", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_features_int32, { "features", "sysdig.param.io_uring_setup.features", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_filename_string, { "filename", "sysdig.param.chmod.filename", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_int16, { "flags", "sysdig.param.signalfd4.flags", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_int32, { "flags", "sysdig.param.delete_module.flags", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_uint32, { "flags", "sysdig.param.pidfd_getfd.flags", FT_UINT32, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_uint64, { "flags", "sysdig.param.seccomp.flags", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_uint8, { "flags", "sysdig.param.inotify_init.flags", FT_UINT8, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_gid_int32, { "gid", "sysdig.param.getgid.gid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_gid_uint32, { "gid", "sysdig.param.fchownat.gid", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_home_string, { "home", "sysdig.param.userdeleted.home", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_how_bytes, { "how", "sysdig.param.shutdown.how", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_id_int64, { "id", "sysdig.param.tracer.id", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_id_string, { "id", "sysdig.param.notification.id", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_id_uint32, { "id", "sysdig.param.quotactl.id", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_image_string, { "image", "sysdig.param.container.image", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_img_bytes, { "img", "sysdig.param.init_module.img", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_in_fd_int64, { "in_fd", "sysdig.param.sendfile.in_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_initval_uint64, { "initval", "sysdig.param.eventfd2.initval", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_ino_uint64, { "ino", "sysdig.param.pipe2.ino", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_interval_bytes, { "interval", "sysdig.param.nanosleep.interval", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_ip_uint64, { "ip", "sysdig.param.page_fault.ip", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_json_string, { "json", "sysdig.param.container.json", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_key_int32, { "key", "sysdig.param.semget.key", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_key_string, { "key", "sysdig.param.fsconfig.key", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_len_uint64, { "len", "sysdig.param.mlock2.len", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_length_uint64, { "length", "sysdig.param.init_module.length", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_level_bytes, { "level", "sysdig.param.getsockopt.level", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_linkdirfd_int64, { "linkdirfd", "sysdig.param.symlinkat.linkdirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_linkpath_string, { "linkpath", "sysdig.param.symlinkat.linkpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_loginuid_int32, { "loginuid", "sysdig.param.execveat.loginuid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_mask_uint32, { "mask", "sysdig.param.signalfd4.mask", FT_UINT32, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_max_int64, { "max", "sysdig.param.setrlimit.max", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_maxevents_int64, { "maxevents", "sysdig.param.epoll_wait.maxevents", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_min_complete_uint32, { "min_complete", "sysdig.param.io_uring_enter.min_complete", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_mode_int32, { "mode", "sysdig.param.mknodat.mode", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_mode_uint32, { "mode", "sysdig.param.openat2.mode", FT_UINT32, BASE_OCT, NULL, 0, NULL, HFILL } },
        { &hf_param_mountfd_int64, { "mountfd", "sysdig.param.open_by_handle_at.mountfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_msgcontrol_bytes, { "msgcontrol", "sysdig.param.recvmsg.msgcontrol", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_name_string, { "name", "sysdig.param.delete_module.name", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_nativeID_uint16, { "nativeID", "sysdig.param.syscall.nativeID", FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newcur_int64, { "newcur", "sysdig.param.prlimit.newcur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newdir_int64, { "newdir", "sysdig.param.linkat.newdir", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newdirfd_int64, { "newdirfd", "sysdig.param.renameat2.newdirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newfd_int64, { "newfd", "sysdig.param.dup3.newfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newmax_int64, { "newmax", "sysdig.param.prlimit.newmax", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newpath_string, { "newpath", "sysdig.param.renameat2.newpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_next_int64, { "next", "sysdig.param.switch.next", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_nr_args_uint32, { "nr_args", "sysdig.param.io_uring_register.nr_args", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_nsems_int32, { "nsems", "sysdig.param.semget.nsems", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_nsops_uint32, { "nsops", "sysdig.param.semop.nsops", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_nstype_int32, { "nstype", "sysdig.param.setns.nstype", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_offin_uint64, { "offin", "sysdig.param.copy_file_range.offin", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_offout_uint64, { "offout", "sysdig.param.copy_file_range.offout", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_offset_uint64, { "offset", "sysdig.param.sendfile.offset", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldcur_int64, { "oldcur", "sysdig.param.prlimit.oldcur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_olddir_int64, { "olddir", "sysdig.param.linkat.olddir", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_olddirfd_int64, { "olddirfd", "sysdig.param.renameat2.olddirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldfd_int64, { "oldfd", "sysdig.param.dup.oldfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldmax_int64, { "oldmax", "sysdig.param.prlimit.oldmax", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldpath_string, { "oldpath", "sysdig.param.renameat2.oldpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_op_bytes, { "op", "sysdig.param.futex.op", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_op_uint64, { "op", "sysdig.param.seccomp.op", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_opcode_bytes, { "opcode", "sysdig.param.io_uring_register.opcode", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_operation_int32, { "operation", "sysdig.param.flock.operation", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_option_bytes, { "option", "sysdig.param.prctl.option", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_optlen_uint32, { "optlen", "sysdig.param.getsockopt.optlen", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_optname_bytes, { "optname", "sysdig.param.getsockopt.optname", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_out_fd_int64, { "out_fd", "sysdig.param.sendfile.out_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_path_string, { "path", "sysdig.param.newfstatat.path", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_pathname_string, { "pathname", "sysdig.param.fchownat.pathname", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_peer_uint64, { "peer", "sysdig.param.socketpair.peer", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_pgft_maj_uint64, { "pgft_maj", "sysdig.param.clone3.pgft_maj", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pgft_min_uint64, { "pgft_min", "sysdig.param.clone3.pgft_min", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pgid_int64, { "pgid", "sysdig.param.execveat.pgid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pgoffset_uint64, { "pgoffset", "sysdig.param.mmap2.pgoffset", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pid_fd_int64, { "pid_fd", "sysdig.param.pidfd_getfd.pid_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pid_int64, { "pid", "sysdig.param.process_vm_writev.pid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pidns_init_start_ts_uint64, { "pidns_init_start_ts", "sysdig.param.clone3.pidns_init_start_ts", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_plugin_id_uint32, { "plugin_id", "sysdig.param.asyncevent.plugin_id", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pos_uint64, { "pos", "sysdig.param.pwritev.pos", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_prot_int32, { "prot", "sysdig.param.mprotect.prot", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_proto_uint32, { "proto", "sysdig.param.socketpair.proto", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_ptid_int64, { "ptid", "sysdig.param.clone3.ptid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_queuelen_uint32, { "queuelen", "sysdig.param.accept4.queuelen", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_queuemax_uint32, { "queuemax", "sysdig.param.accept4.queuemax", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_queuepct_uint8, { "queuepct", "sysdig.param.accept4.queuepct", FT_UINT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_quota_fmt_int8, { "quota_fmt", "sysdig.param.quotactl.quota_fmt", FT_INT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_quota_fmt_out_int8, { "quota_fmt_out", "sysdig.param.quotactl.quota_fmt_out", FT_INT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_quotafilepath_string, { "quotafilepath", "sysdig.param.quotactl.quotafilepath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_ratio_uint32, { "ratio", "sysdig.param.drop.ratio", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_reaper_tid_int64, { "reaper_tid", "sysdig.param.procexit.reaper_tid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_request_bytes, { "request", "sysdig.param.ptrace.request", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_request_uint64, { "I/O control: request", "sysdig.param.ioctl.request", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_res_int64, { "res", "sysdig.param.setregid.res", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_res_or_fd_bytes, { "res_or_fd", "sysdig.param.bpf.res_or_fd", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_res_uint64, { "res", "sysdig.param.brk.res", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_resolve_int32, { "resolve", "sysdig.param.openat2.resolve", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_resource_bytes, { "resource", "sysdig.param.prlimit.resource", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_ret_int64, { "ret", "sysdig.param.procexit.ret", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_rgid_int32, { "rgid", "sysdig.param.setregid.rgid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_ruid_int32, { "ruid", "sysdig.param.setreuid.ruid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_scope_string, { "scope", "sysdig.param.infra.scope", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_flg_0_int16, { "sem_flg_0", "sysdig.param.semop.sem_flg_0", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_flg_1_int16, { "sem_flg_1", "sysdig.param.semop.sem_flg_1", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_num_0_uint16, { "sem_num_0", "sysdig.param.semop.sem_num_0", FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_num_1_uint16, { "sem_num_1", "sysdig.param.semop.sem_num_1", FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_op_0_int16, { "sem_op_0", "sysdig.param.semop.sem_op_0", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_op_1_int16, { "sem_op_1", "sysdig.param.semop.sem_op_1", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_semflg_int32, { "semflg", "sysdig.param.semget.semflg", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_semid_int32, { "semid", "sysdig.param.semctl.semid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_semnum_int32, { "semnum", "sysdig.param.semctl.semnum", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sgid_int32, { "sgid", "sysdig.param.getresgid.sgid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_shell_string, { "shell", "sysdig.param.userdeleted.shell", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sig_bytes, { "sig", "sysdig.param.io_uring_enter.sig", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sigmask_bytes, { "sigmask", "sysdig.param.ppoll.sigmask", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_size_int32, { "size", "sysdig.param.epoll_create.size", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_size_uint32, { "size", "sysdig.param.pwritev.size", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_size_uint64, { "size", "sysdig.param.sendfile.size", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_source_string, { "source", "sysdig.param.infra.source", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_source_uint64, { "source", "sysdig.param.socketpair.source", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_special_string, { "special", "sysdig.param.quotactl.special", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_spid_int64, { "spid", "sysdig.param.signaldeliver.spid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sq_entries_uint32, { "sq_entries", "sysdig.param.io_uring_setup.sq_entries", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sq_thread_cpu_uint32, { "sq_thread_cpu", "sysdig.param.io_uring_setup.sq_thread_cpu", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sq_thread_idle_uint32, { "sq_thread_idle", "sysdig.param.io_uring_setup.sq_thread_idle", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_status_int64, { "status", "sysdig.param.procexit.status", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_suid_int32, { "suid", "sysdig.param.getresuid.suid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_tags_bytes, { "tags", "sysdig.param.tracer.tags", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_target_fd_int64, { "target_fd", "sysdig.param.pidfd_getfd.target_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_target_string, { "target", "sysdig.param.symlinkat.target", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_tid_int64, { "tid", "sysdig.param.clone3.tid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_timeout_bytes, { "timeout", "sysdig.param.ppoll.timeout", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_timeout_int64, { "timeout", "sysdig.param.poll.timeout", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_to_submit_uint32, { "to_submit", "sysdig.param.io_uring_enter.to_submit", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_trusted_exepath_string, { "trusted_exepath", "sysdig.param.execveat.trusted_exepath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_tty_int32, { "tty", "sysdig.param.execve.tty", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_tty_uint32, { "tty", "sysdig.param.execveat.tty", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_tuple_bytes, { "tuple", "sysdig.param.accept4.tuple", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_type_int8, { "type", "sysdig.param.quotactl.type", FT_INT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_type_string, { "type", "sysdig.param.mount.type", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_type_uint32, { "type", "sysdig.param.container.type", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_uargs_string, { "uargs", "sysdig.param.finit_module.uargs", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_uid_int32, { "uid", "sysdig.param.execveat.uid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_uid_uint32, { "uid", "sysdig.param.fchownat.uid", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_val_bytes, { "val", "sysdig.param.getsockopt.val", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_val_int32, { "val", "sysdig.param.semctl.val", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_val_uint64, { "val", "sysdig.param.futex.val", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_value_bytebuf_bytes, { "value_bytebuf", "sysdig.param.fsconfig.value_bytebuf", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_value_charbuf_string, { "value_charbuf", "sysdig.param.fsconfig.value_charbuf", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_rss_uint32, { "vm_rss", "sysdig.param.clone3.vm_rss", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_size_uint32, { "vm_size", "sysdig.param.clone3.vm_size", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_swap_uint32, { "vm_swap", "sysdig.param.clone3.vm_swap", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vpid_int64, { "vpid", "sysdig.param.clone3.vpid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vtid_int64, { "vtid", "sysdig.param.clone3.vtid", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_whence_bytes, { "whence", "sysdig.param.llseek.whence", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
    };

    /* Setup protocol subtree array */
    static int *ett[] = {
        &ett_sysdig_event,
        &ett_sysdig_parm_lens,
        &ett_sysdig_syscall
    };

    /* Register the protocol name and description */
    proto_sysdig_event = proto_register_protocol("Sysdig Event", "Sysdig Event", "sysdig");

    /* Required function calls to register the header fields and subtrees */
    proto_register_field_array(proto_sysdig_event, hf, array_length(hf));
    proto_register_subtree_array(ett, array_length(ett));

    sysdig_event_handle = register_dissector("sysdig", dissect_sysdig_event, proto_sysdig_event);
}

void
proto_reg_handoff_sysdig_event(void)
{
    dissector_add_uint("pcapng.block_type", BLOCK_TYPE_SYSDIG_EVENT, sysdig_event_handle);
    dissector_add_uint("pcapng.block_type", BLOCK_TYPE_SYSDIG_EVENT_V2, sysdig_event_handle);
    dissector_add_uint("pcapng.block_type", BLOCK_TYPE_SYSDIG_EVENT_V2_LARGE, sysdig_event_handle);

    sinsp_dissector_handle = find_dissector("falcoevents");
    elf_dissector_handle = find_dissector("elf");
}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
