//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: datatransfer.proto

package hadoop_hdfs

import (
	hadoop_common "github.com/colinmarc/hdfs/v2/internal/protocol/hadoop_common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Status is a 4-bit enum
type Status int32

const (
	Status_SUCCESS            Status = 0
	Status_ERROR              Status = 1
	Status_ERROR_CHECKSUM     Status = 2
	Status_ERROR_INVALID      Status = 3
	Status_ERROR_EXISTS       Status = 4
	Status_ERROR_ACCESS_TOKEN Status = 5
	Status_CHECKSUM_OK        Status = 6
	Status_ERROR_UNSUPPORTED  Status = 7
	Status_OOB_RESTART        Status = 8  // Quick restart
	Status_OOB_RESERVED1      Status = 9  // Reserved
	Status_OOB_RESERVED2      Status = 10 // Reserved
	Status_OOB_RESERVED3      Status = 11 // Reserved
	Status_IN_PROGRESS        Status = 12
	Status_ERROR_BLOCK_PINNED Status = 13
)

// Enum value maps for Status.
var (
	Status_name = map[int32]string{
		0:  "SUCCESS",
		1:  "ERROR",
		2:  "ERROR_CHECKSUM",
		3:  "ERROR_INVALID",
		4:  "ERROR_EXISTS",
		5:  "ERROR_ACCESS_TOKEN",
		6:  "CHECKSUM_OK",
		7:  "ERROR_UNSUPPORTED",
		8:  "OOB_RESTART",
		9:  "OOB_RESERVED1",
		10: "OOB_RESERVED2",
		11: "OOB_RESERVED3",
		12: "IN_PROGRESS",
		13: "ERROR_BLOCK_PINNED",
	}
	Status_value = map[string]int32{
		"SUCCESS":            0,
		"ERROR":              1,
		"ERROR_CHECKSUM":     2,
		"ERROR_INVALID":      3,
		"ERROR_EXISTS":       4,
		"ERROR_ACCESS_TOKEN": 5,
		"CHECKSUM_OK":        6,
		"ERROR_UNSUPPORTED":  7,
		"OOB_RESTART":        8,
		"OOB_RESERVED1":      9,
		"OOB_RESERVED2":      10,
		"OOB_RESERVED3":      11,
		"IN_PROGRESS":        12,
		"ERROR_BLOCK_PINNED": 13,
	}
)

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}

func (x Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Status) Descriptor() protoreflect.EnumDescriptor {
	return file_datatransfer_proto_enumTypes[0].Descriptor()
}

func (Status) Type() protoreflect.EnumType {
	return &file_datatransfer_proto_enumTypes[0]
}

func (x Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Status) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Status(num)
	return nil
}

// Deprecated: Use Status.Descriptor instead.
func (Status) EnumDescriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{0}
}

type ShortCircuitFdResponse int32

const (
	ShortCircuitFdResponse_DO_NOT_USE_RECEIPT_VERIFICATION ShortCircuitFdResponse = 0
	ShortCircuitFdResponse_USE_RECEIPT_VERIFICATION        ShortCircuitFdResponse = 1
)

// Enum value maps for ShortCircuitFdResponse.
var (
	ShortCircuitFdResponse_name = map[int32]string{
		0: "DO_NOT_USE_RECEIPT_VERIFICATION",
		1: "USE_RECEIPT_VERIFICATION",
	}
	ShortCircuitFdResponse_value = map[string]int32{
		"DO_NOT_USE_RECEIPT_VERIFICATION": 0,
		"USE_RECEIPT_VERIFICATION":        1,
	}
)

func (x ShortCircuitFdResponse) Enum() *ShortCircuitFdResponse {
	p := new(ShortCircuitFdResponse)
	*p = x
	return p
}

func (x ShortCircuitFdResponse) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShortCircuitFdResponse) Descriptor() protoreflect.EnumDescriptor {
	return file_datatransfer_proto_enumTypes[1].Descriptor()
}

func (ShortCircuitFdResponse) Type() protoreflect.EnumType {
	return &file_datatransfer_proto_enumTypes[1]
}

func (x ShortCircuitFdResponse) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ShortCircuitFdResponse) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ShortCircuitFdResponse(num)
	return nil
}

// Deprecated: Use ShortCircuitFdResponse.Descriptor instead.
func (ShortCircuitFdResponse) EnumDescriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{1}
}

type DataTransferEncryptorMessageProto_DataTransferEncryptorStatus int32

const (
	DataTransferEncryptorMessageProto_SUCCESS           DataTransferEncryptorMessageProto_DataTransferEncryptorStatus = 0
	DataTransferEncryptorMessageProto_ERROR_UNKNOWN_KEY DataTransferEncryptorMessageProto_DataTransferEncryptorStatus = 1
	DataTransferEncryptorMessageProto_ERROR             DataTransferEncryptorMessageProto_DataTransferEncryptorStatus = 2
)

// Enum value maps for DataTransferEncryptorMessageProto_DataTransferEncryptorStatus.
var (
	DataTransferEncryptorMessageProto_DataTransferEncryptorStatus_name = map[int32]string{
		0: "SUCCESS",
		1: "ERROR_UNKNOWN_KEY",
		2: "ERROR",
	}
	DataTransferEncryptorMessageProto_DataTransferEncryptorStatus_value = map[string]int32{
		"SUCCESS":           0,
		"ERROR_UNKNOWN_KEY": 1,
		"ERROR":             2,
	}
)

func (x DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) Enum() *DataTransferEncryptorMessageProto_DataTransferEncryptorStatus {
	p := new(DataTransferEncryptorMessageProto_DataTransferEncryptorStatus)
	*p = x
	return p
}

func (x DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_datatransfer_proto_enumTypes[2].Descriptor()
}

func (DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) Type() protoreflect.EnumType {
	return &file_datatransfer_proto_enumTypes[2]
}

func (x DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = DataTransferEncryptorMessageProto_DataTransferEncryptorStatus(num)
	return nil
}

// Deprecated: Use DataTransferEncryptorMessageProto_DataTransferEncryptorStatus.Descriptor instead.
func (DataTransferEncryptorMessageProto_DataTransferEncryptorStatus) EnumDescriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{0, 0}
}

type OpWriteBlockProto_BlockConstructionStage int32

const (
	OpWriteBlockProto_PIPELINE_SETUP_APPEND OpWriteBlockProto_BlockConstructionStage = 0
	// pipeline set up for failed PIPELINE_SETUP_APPEND recovery
	OpWriteBlockProto_PIPELINE_SETUP_APPEND_RECOVERY OpWriteBlockProto_BlockConstructionStage = 1
	// data streaming
	OpWriteBlockProto_DATA_STREAMING OpWriteBlockProto_BlockConstructionStage = 2
	// pipeline setup for failed data streaming recovery
	OpWriteBlockProto_PIPELINE_SETUP_STREAMING_RECOVERY OpWriteBlockProto_BlockConstructionStage = 3
	// close the block and pipeline
	OpWriteBlockProto_PIPELINE_CLOSE OpWriteBlockProto_BlockConstructionStage = 4
	// Recover a failed PIPELINE_CLOSE
	OpWriteBlockProto_PIPELINE_CLOSE_RECOVERY OpWriteBlockProto_BlockConstructionStage = 5
	// pipeline set up for block creation
	OpWriteBlockProto_PIPELINE_SETUP_CREATE OpWriteBlockProto_BlockConstructionStage = 6
	// transfer RBW for adding datanodes
	OpWriteBlockProto_TRANSFER_RBW OpWriteBlockProto_BlockConstructionStage = 7
	// transfer Finalized for adding datanodes
	OpWriteBlockProto_TRANSFER_FINALIZED OpWriteBlockProto_BlockConstructionStage = 8
)

// Enum value maps for OpWriteBlockProto_BlockConstructionStage.
var (
	OpWriteBlockProto_BlockConstructionStage_name = map[int32]string{
		0: "PIPELINE_SETUP_APPEND",
		1: "PIPELINE_SETUP_APPEND_RECOVERY",
		2: "DATA_STREAMING",
		3: "PIPELINE_SETUP_STREAMING_RECOVERY",
		4: "PIPELINE_CLOSE",
		5: "PIPELINE_CLOSE_RECOVERY",
		6: "PIPELINE_SETUP_CREATE",
		7: "TRANSFER_RBW",
		8: "TRANSFER_FINALIZED",
	}
	OpWriteBlockProto_BlockConstructionStage_value = map[string]int32{
		"PIPELINE_SETUP_APPEND":             0,
		"PIPELINE_SETUP_APPEND_RECOVERY":    1,
		"DATA_STREAMING":                    2,
		"PIPELINE_SETUP_STREAMING_RECOVERY": 3,
		"PIPELINE_CLOSE":                    4,
		"PIPELINE_CLOSE_RECOVERY":           5,
		"PIPELINE_SETUP_CREATE":             6,
		"TRANSFER_RBW":                      7,
		"TRANSFER_FINALIZED":                8,
	}
)

func (x OpWriteBlockProto_BlockConstructionStage) Enum() *OpWriteBlockProto_BlockConstructionStage {
	p := new(OpWriteBlockProto_BlockConstructionStage)
	*p = x
	return p
}

func (x OpWriteBlockProto_BlockConstructionStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpWriteBlockProto_BlockConstructionStage) Descriptor() protoreflect.EnumDescriptor {
	return file_datatransfer_proto_enumTypes[3].Descriptor()
}

func (OpWriteBlockProto_BlockConstructionStage) Type() protoreflect.EnumType {
	return &file_datatransfer_proto_enumTypes[3]
}

func (x OpWriteBlockProto_BlockConstructionStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *OpWriteBlockProto_BlockConstructionStage) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = OpWriteBlockProto_BlockConstructionStage(num)
	return nil
}

// Deprecated: Use OpWriteBlockProto_BlockConstructionStage.Descriptor instead.
func (OpWriteBlockProto_BlockConstructionStage) EnumDescriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{8, 0}
}

type DataTransferEncryptorMessageProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status          *DataTransferEncryptorMessageProto_DataTransferEncryptorStatus `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.DataTransferEncryptorMessageProto_DataTransferEncryptorStatus" json:"status,omitempty"`
	Payload         []byte                                                         `protobuf:"bytes,2,opt,name=payload" json:"payload,omitempty"`
	Message         *string                                                        `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	CipherOption    []*CipherOptionProto                                           `protobuf:"bytes,4,rep,name=cipherOption" json:"cipherOption,omitempty"`
	HandshakeSecret *HandshakeSecretProto                                          `protobuf:"bytes,5,opt,name=handshakeSecret" json:"handshakeSecret,omitempty"`
}

func (x *DataTransferEncryptorMessageProto) Reset() {
	*x = DataTransferEncryptorMessageProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataTransferEncryptorMessageProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataTransferEncryptorMessageProto) ProtoMessage() {}

func (x *DataTransferEncryptorMessageProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataTransferEncryptorMessageProto.ProtoReflect.Descriptor instead.
func (*DataTransferEncryptorMessageProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{0}
}

func (x *DataTransferEncryptorMessageProto) GetStatus() DataTransferEncryptorMessageProto_DataTransferEncryptorStatus {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return DataTransferEncryptorMessageProto_SUCCESS
}

func (x *DataTransferEncryptorMessageProto) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *DataTransferEncryptorMessageProto) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *DataTransferEncryptorMessageProto) GetCipherOption() []*CipherOptionProto {
	if x != nil {
		return x.CipherOption
	}
	return nil
}

func (x *DataTransferEncryptorMessageProto) GetHandshakeSecret() *HandshakeSecretProto {
	if x != nil {
		return x.HandshakeSecret
	}
	return nil
}

type HandshakeSecretProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Secret []byte  `protobuf:"bytes,1,req,name=secret" json:"secret,omitempty"`
	Bpid   *string `protobuf:"bytes,2,req,name=bpid" json:"bpid,omitempty"`
}

func (x *HandshakeSecretProto) Reset() {
	*x = HandshakeSecretProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HandshakeSecretProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HandshakeSecretProto) ProtoMessage() {}

func (x *HandshakeSecretProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HandshakeSecretProto.ProtoReflect.Descriptor instead.
func (*HandshakeSecretProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{1}
}

func (x *HandshakeSecretProto) GetSecret() []byte {
	if x != nil {
		return x.Secret
	}
	return nil
}

func (x *HandshakeSecretProto) GetBpid() string {
	if x != nil && x.Bpid != nil {
		return *x.Bpid
	}
	return ""
}

type BaseHeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block     *ExtendedBlockProto         `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`
	Token     *hadoop_common.TokenProto   `protobuf:"bytes,2,opt,name=token" json:"token,omitempty"`
	TraceInfo *DataTransferTraceInfoProto `protobuf:"bytes,3,opt,name=traceInfo" json:"traceInfo,omitempty"`
}

func (x *BaseHeaderProto) Reset() {
	*x = BaseHeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BaseHeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BaseHeaderProto) ProtoMessage() {}

func (x *BaseHeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BaseHeaderProto.ProtoReflect.Descriptor instead.
func (*BaseHeaderProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{2}
}

func (x *BaseHeaderProto) GetBlock() *ExtendedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *BaseHeaderProto) GetToken() *hadoop_common.TokenProto {
	if x != nil {
		return x.Token
	}
	return nil
}

func (x *BaseHeaderProto) GetTraceInfo() *DataTransferTraceInfoProto {
	if x != nil {
		return x.TraceInfo
	}
	return nil
}

type DataTransferTraceInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TraceId  *uint64 `protobuf:"varint,1,req,name=traceId" json:"traceId,omitempty"`
	ParentId *uint64 `protobuf:"varint,2,req,name=parentId" json:"parentId,omitempty"`
}

func (x *DataTransferTraceInfoProto) Reset() {
	*x = DataTransferTraceInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataTransferTraceInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataTransferTraceInfoProto) ProtoMessage() {}

func (x *DataTransferTraceInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataTransferTraceInfoProto.ProtoReflect.Descriptor instead.
func (*DataTransferTraceInfoProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{3}
}

func (x *DataTransferTraceInfoProto) GetTraceId() uint64 {
	if x != nil && x.TraceId != nil {
		return *x.TraceId
	}
	return 0
}

func (x *DataTransferTraceInfoProto) GetParentId() uint64 {
	if x != nil && x.ParentId != nil {
		return *x.ParentId
	}
	return 0
}

type ClientOperationHeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BaseHeader *BaseHeaderProto `protobuf:"bytes,1,req,name=baseHeader" json:"baseHeader,omitempty"`
	ClientName *string          `protobuf:"bytes,2,req,name=clientName" json:"clientName,omitempty"`
}

func (x *ClientOperationHeaderProto) Reset() {
	*x = ClientOperationHeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientOperationHeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientOperationHeaderProto) ProtoMessage() {}

func (x *ClientOperationHeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientOperationHeaderProto.ProtoReflect.Descriptor instead.
func (*ClientOperationHeaderProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{4}
}

func (x *ClientOperationHeaderProto) GetBaseHeader() *BaseHeaderProto {
	if x != nil {
		return x.BaseHeader
	}
	return nil
}

func (x *ClientOperationHeaderProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

type CachingStrategyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DropBehind *bool  `protobuf:"varint,1,opt,name=dropBehind" json:"dropBehind,omitempty"`
	Readahead  *int64 `protobuf:"varint,2,opt,name=readahead" json:"readahead,omitempty"`
}

func (x *CachingStrategyProto) Reset() {
	*x = CachingStrategyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CachingStrategyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CachingStrategyProto) ProtoMessage() {}

func (x *CachingStrategyProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CachingStrategyProto.ProtoReflect.Descriptor instead.
func (*CachingStrategyProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{5}
}

func (x *CachingStrategyProto) GetDropBehind() bool {
	if x != nil && x.DropBehind != nil {
		return *x.DropBehind
	}
	return false
}

func (x *CachingStrategyProto) GetReadahead() int64 {
	if x != nil && x.Readahead != nil {
		return *x.Readahead
	}
	return 0
}

type OpReadBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header          *ClientOperationHeaderProto `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	Offset          *uint64                     `protobuf:"varint,2,req,name=offset" json:"offset,omitempty"`
	Len             *uint64                     `protobuf:"varint,3,req,name=len" json:"len,omitempty"`
	SendChecksums   *bool                       `protobuf:"varint,4,opt,name=sendChecksums,def=1" json:"sendChecksums,omitempty"`
	CachingStrategy *CachingStrategyProto       `protobuf:"bytes,5,opt,name=cachingStrategy" json:"cachingStrategy,omitempty"`
}

// Default values for OpReadBlockProto fields.
const (
	Default_OpReadBlockProto_SendChecksums = bool(true)
)

func (x *OpReadBlockProto) Reset() {
	*x = OpReadBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpReadBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpReadBlockProto) ProtoMessage() {}

func (x *OpReadBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpReadBlockProto.ProtoReflect.Descriptor instead.
func (*OpReadBlockProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{6}
}

func (x *OpReadBlockProto) GetHeader() *ClientOperationHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpReadBlockProto) GetOffset() uint64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *OpReadBlockProto) GetLen() uint64 {
	if x != nil && x.Len != nil {
		return *x.Len
	}
	return 0
}

func (x *OpReadBlockProto) GetSendChecksums() bool {
	if x != nil && x.SendChecksums != nil {
		return *x.SendChecksums
	}
	return Default_OpReadBlockProto_SendChecksums
}

func (x *OpReadBlockProto) GetCachingStrategy() *CachingStrategyProto {
	if x != nil {
		return x.CachingStrategy
	}
	return nil
}

type ChecksumProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type             *ChecksumTypeProto `protobuf:"varint,1,req,name=type,enum=hadoop.hdfs.ChecksumTypeProto" json:"type,omitempty"`
	BytesPerChecksum *uint32            `protobuf:"varint,2,req,name=bytesPerChecksum" json:"bytesPerChecksum,omitempty"`
}

func (x *ChecksumProto) Reset() {
	*x = ChecksumProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChecksumProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChecksumProto) ProtoMessage() {}

func (x *ChecksumProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChecksumProto.ProtoReflect.Descriptor instead.
func (*ChecksumProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{7}
}

func (x *ChecksumProto) GetType() ChecksumTypeProto {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ChecksumTypeProto_CHECKSUM_NULL
}

func (x *ChecksumProto) GetBytesPerChecksum() uint32 {
	if x != nil && x.BytesPerChecksum != nil {
		return *x.BytesPerChecksum
	}
	return 0
}

type OpWriteBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header                *ClientOperationHeaderProto               `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	Targets               []*DatanodeInfoProto                      `protobuf:"bytes,2,rep,name=targets" json:"targets,omitempty"`
	Source                *DatanodeInfoProto                        `protobuf:"bytes,3,opt,name=source" json:"source,omitempty"`
	Stage                 *OpWriteBlockProto_BlockConstructionStage `protobuf:"varint,4,req,name=stage,enum=hadoop.hdfs.OpWriteBlockProto_BlockConstructionStage" json:"stage,omitempty"`
	PipelineSize          *uint32                                   `protobuf:"varint,5,req,name=pipelineSize" json:"pipelineSize,omitempty"`
	MinBytesRcvd          *uint64                                   `protobuf:"varint,6,req,name=minBytesRcvd" json:"minBytesRcvd,omitempty"`
	MaxBytesRcvd          *uint64                                   `protobuf:"varint,7,req,name=maxBytesRcvd" json:"maxBytesRcvd,omitempty"`
	LatestGenerationStamp *uint64                                   `protobuf:"varint,8,req,name=latestGenerationStamp" json:"latestGenerationStamp,omitempty"`
	//*
	// The requested checksum mechanism for this block write.
	RequestedChecksum  *ChecksumProto        `protobuf:"bytes,9,req,name=requestedChecksum" json:"requestedChecksum,omitempty"`
	CachingStrategy    *CachingStrategyProto `protobuf:"bytes,10,opt,name=cachingStrategy" json:"cachingStrategy,omitempty"`
	StorageType        *StorageTypeProto     `protobuf:"varint,11,opt,name=storageType,enum=hadoop.hdfs.StorageTypeProto,def=1" json:"storageType,omitempty"`
	TargetStorageTypes []StorageTypeProto    `protobuf:"varint,12,rep,name=targetStorageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"targetStorageTypes,omitempty"`
	//*
	// Hint to the DataNode that the block can be allocated on transient
	// storage i.e. memory and written to disk lazily. The DataNode is free
	// to ignore this hint.
	AllowLazyPersist *bool `protobuf:"varint,13,opt,name=allowLazyPersist,def=0" json:"allowLazyPersist,omitempty"`
	//whether to pin the block, so Balancer won't move it.
	Pinning          *bool    `protobuf:"varint,14,opt,name=pinning,def=0" json:"pinning,omitempty"`
	TargetPinnings   []bool   `protobuf:"varint,15,rep,name=targetPinnings" json:"targetPinnings,omitempty"`
	StorageId        *string  `protobuf:"bytes,16,opt,name=storageId" json:"storageId,omitempty"`
	TargetStorageIds []string `protobuf:"bytes,17,rep,name=targetStorageIds" json:"targetStorageIds,omitempty"`
}

// Default values for OpWriteBlockProto fields.
const (
	Default_OpWriteBlockProto_StorageType      = StorageTypeProto_DISK
	Default_OpWriteBlockProto_AllowLazyPersist = bool(false)
	Default_OpWriteBlockProto_Pinning          = bool(false)
)

func (x *OpWriteBlockProto) Reset() {
	*x = OpWriteBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpWriteBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpWriteBlockProto) ProtoMessage() {}

func (x *OpWriteBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpWriteBlockProto.ProtoReflect.Descriptor instead.
func (*OpWriteBlockProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{8}
}

func (x *OpWriteBlockProto) GetHeader() *ClientOperationHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpWriteBlockProto) GetTargets() []*DatanodeInfoProto {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *OpWriteBlockProto) GetSource() *DatanodeInfoProto {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *OpWriteBlockProto) GetStage() OpWriteBlockProto_BlockConstructionStage {
	if x != nil && x.Stage != nil {
		return *x.Stage
	}
	return OpWriteBlockProto_PIPELINE_SETUP_APPEND
}

func (x *OpWriteBlockProto) GetPipelineSize() uint32 {
	if x != nil && x.PipelineSize != nil {
		return *x.PipelineSize
	}
	return 0
}

func (x *OpWriteBlockProto) GetMinBytesRcvd() uint64 {
	if x != nil && x.MinBytesRcvd != nil {
		return *x.MinBytesRcvd
	}
	return 0
}

func (x *OpWriteBlockProto) GetMaxBytesRcvd() uint64 {
	if x != nil && x.MaxBytesRcvd != nil {
		return *x.MaxBytesRcvd
	}
	return 0
}

func (x *OpWriteBlockProto) GetLatestGenerationStamp() uint64 {
	if x != nil && x.LatestGenerationStamp != nil {
		return *x.LatestGenerationStamp
	}
	return 0
}

func (x *OpWriteBlockProto) GetRequestedChecksum() *ChecksumProto {
	if x != nil {
		return x.RequestedChecksum
	}
	return nil
}

func (x *OpWriteBlockProto) GetCachingStrategy() *CachingStrategyProto {
	if x != nil {
		return x.CachingStrategy
	}
	return nil
}

func (x *OpWriteBlockProto) GetStorageType() StorageTypeProto {
	if x != nil && x.StorageType != nil {
		return *x.StorageType
	}
	return Default_OpWriteBlockProto_StorageType
}

func (x *OpWriteBlockProto) GetTargetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.TargetStorageTypes
	}
	return nil
}

func (x *OpWriteBlockProto) GetAllowLazyPersist() bool {
	if x != nil && x.AllowLazyPersist != nil {
		return *x.AllowLazyPersist
	}
	return Default_OpWriteBlockProto_AllowLazyPersist
}

func (x *OpWriteBlockProto) GetPinning() bool {
	if x != nil && x.Pinning != nil {
		return *x.Pinning
	}
	return Default_OpWriteBlockProto_Pinning
}

func (x *OpWriteBlockProto) GetTargetPinnings() []bool {
	if x != nil {
		return x.TargetPinnings
	}
	return nil
}

func (x *OpWriteBlockProto) GetStorageId() string {
	if x != nil && x.StorageId != nil {
		return *x.StorageId
	}
	return ""
}

func (x *OpWriteBlockProto) GetTargetStorageIds() []string {
	if x != nil {
		return x.TargetStorageIds
	}
	return nil
}

type OpTransferBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header             *ClientOperationHeaderProto `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	Targets            []*DatanodeInfoProto        `protobuf:"bytes,2,rep,name=targets" json:"targets,omitempty"`
	TargetStorageTypes []StorageTypeProto          `protobuf:"varint,3,rep,name=targetStorageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"targetStorageTypes,omitempty"`
	TargetStorageIds   []string                    `protobuf:"bytes,4,rep,name=targetStorageIds" json:"targetStorageIds,omitempty"`
}

func (x *OpTransferBlockProto) Reset() {
	*x = OpTransferBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpTransferBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpTransferBlockProto) ProtoMessage() {}

func (x *OpTransferBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpTransferBlockProto.ProtoReflect.Descriptor instead.
func (*OpTransferBlockProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{9}
}

func (x *OpTransferBlockProto) GetHeader() *ClientOperationHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpTransferBlockProto) GetTargets() []*DatanodeInfoProto {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *OpTransferBlockProto) GetTargetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.TargetStorageTypes
	}
	return nil
}

func (x *OpTransferBlockProto) GetTargetStorageIds() []string {
	if x != nil {
		return x.TargetStorageIds
	}
	return nil
}

type OpReplaceBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *BaseHeaderProto   `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	DelHint     *string            `protobuf:"bytes,2,req,name=delHint" json:"delHint,omitempty"`
	Source      *DatanodeInfoProto `protobuf:"bytes,3,req,name=source" json:"source,omitempty"`
	StorageType *StorageTypeProto  `protobuf:"varint,4,opt,name=storageType,enum=hadoop.hdfs.StorageTypeProto,def=1" json:"storageType,omitempty"`
	StorageId   *string            `protobuf:"bytes,5,opt,name=storageId" json:"storageId,omitempty"`
}

// Default values for OpReplaceBlockProto fields.
const (
	Default_OpReplaceBlockProto_StorageType = StorageTypeProto_DISK
)

func (x *OpReplaceBlockProto) Reset() {
	*x = OpReplaceBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpReplaceBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpReplaceBlockProto) ProtoMessage() {}

func (x *OpReplaceBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpReplaceBlockProto.ProtoReflect.Descriptor instead.
func (*OpReplaceBlockProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{10}
}

func (x *OpReplaceBlockProto) GetHeader() *BaseHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpReplaceBlockProto) GetDelHint() string {
	if x != nil && x.DelHint != nil {
		return *x.DelHint
	}
	return ""
}

func (x *OpReplaceBlockProto) GetSource() *DatanodeInfoProto {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *OpReplaceBlockProto) GetStorageType() StorageTypeProto {
	if x != nil && x.StorageType != nil {
		return *x.StorageType
	}
	return Default_OpReplaceBlockProto_StorageType
}

func (x *OpReplaceBlockProto) GetStorageId() string {
	if x != nil && x.StorageId != nil {
		return *x.StorageId
	}
	return ""
}

type OpCopyBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *BaseHeaderProto `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
}

func (x *OpCopyBlockProto) Reset() {
	*x = OpCopyBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpCopyBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpCopyBlockProto) ProtoMessage() {}

func (x *OpCopyBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpCopyBlockProto.ProtoReflect.Descriptor instead.
func (*OpCopyBlockProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{11}
}

func (x *OpCopyBlockProto) GetHeader() *BaseHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

type OpBlockChecksumProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header               *BaseHeaderProto           `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	BlockChecksumOptions *BlockChecksumOptionsProto `protobuf:"bytes,2,opt,name=blockChecksumOptions" json:"blockChecksumOptions,omitempty"`
}

func (x *OpBlockChecksumProto) Reset() {
	*x = OpBlockChecksumProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpBlockChecksumProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpBlockChecksumProto) ProtoMessage() {}

func (x *OpBlockChecksumProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpBlockChecksumProto.ProtoReflect.Descriptor instead.
func (*OpBlockChecksumProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{12}
}

func (x *OpBlockChecksumProto) GetHeader() *BaseHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpBlockChecksumProto) GetBlockChecksumOptions() *BlockChecksumOptionsProto {
	if x != nil {
		return x.BlockChecksumOptions
	}
	return nil
}

type OpBlockGroupChecksumProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *BaseHeaderProto    `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	Datanodes *DatanodeInfosProto `protobuf:"bytes,2,req,name=datanodes" json:"datanodes,omitempty"`
	// each internal block has a block token
	BlockTokens          []*hadoop_common.TokenProto `protobuf:"bytes,3,rep,name=blockTokens" json:"blockTokens,omitempty"`
	EcPolicy             *ErasureCodingPolicyProto   `protobuf:"bytes,4,req,name=ecPolicy" json:"ecPolicy,omitempty"`
	BlockIndices         []uint32                    `protobuf:"varint,5,rep,name=blockIndices" json:"blockIndices,omitempty"`
	RequestedNumBytes    *uint64                     `protobuf:"varint,6,req,name=requestedNumBytes" json:"requestedNumBytes,omitempty"`
	BlockChecksumOptions *BlockChecksumOptionsProto  `protobuf:"bytes,7,opt,name=blockChecksumOptions" json:"blockChecksumOptions,omitempty"`
}

func (x *OpBlockGroupChecksumProto) Reset() {
	*x = OpBlockGroupChecksumProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpBlockGroupChecksumProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpBlockGroupChecksumProto) ProtoMessage() {}

func (x *OpBlockGroupChecksumProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpBlockGroupChecksumProto.ProtoReflect.Descriptor instead.
func (*OpBlockGroupChecksumProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{13}
}

func (x *OpBlockGroupChecksumProto) GetHeader() *BaseHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpBlockGroupChecksumProto) GetDatanodes() *DatanodeInfosProto {
	if x != nil {
		return x.Datanodes
	}
	return nil
}

func (x *OpBlockGroupChecksumProto) GetBlockTokens() []*hadoop_common.TokenProto {
	if x != nil {
		return x.BlockTokens
	}
	return nil
}

func (x *OpBlockGroupChecksumProto) GetEcPolicy() *ErasureCodingPolicyProto {
	if x != nil {
		return x.EcPolicy
	}
	return nil
}

func (x *OpBlockGroupChecksumProto) GetBlockIndices() []uint32 {
	if x != nil {
		return x.BlockIndices
	}
	return nil
}

func (x *OpBlockGroupChecksumProto) GetRequestedNumBytes() uint64 {
	if x != nil && x.RequestedNumBytes != nil {
		return *x.RequestedNumBytes
	}
	return 0
}

func (x *OpBlockGroupChecksumProto) GetBlockChecksumOptions() *BlockChecksumOptionsProto {
	if x != nil {
		return x.BlockChecksumOptions
	}
	return nil
}

//*
// An ID uniquely identifying a shared memory segment.
type ShortCircuitShmIdProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Hi *int64 `protobuf:"varint,1,req,name=hi" json:"hi,omitempty"`
	Lo *int64 `protobuf:"varint,2,req,name=lo" json:"lo,omitempty"`
}

func (x *ShortCircuitShmIdProto) Reset() {
	*x = ShortCircuitShmIdProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShortCircuitShmIdProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShortCircuitShmIdProto) ProtoMessage() {}

func (x *ShortCircuitShmIdProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShortCircuitShmIdProto.ProtoReflect.Descriptor instead.
func (*ShortCircuitShmIdProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{14}
}

func (x *ShortCircuitShmIdProto) GetHi() int64 {
	if x != nil && x.Hi != nil {
		return *x.Hi
	}
	return 0
}

func (x *ShortCircuitShmIdProto) GetLo() int64 {
	if x != nil && x.Lo != nil {
		return *x.Lo
	}
	return 0
}

//*
// An ID uniquely identifying a slot within a shared memory segment.
type ShortCircuitShmSlotProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ShmId   *ShortCircuitShmIdProto `protobuf:"bytes,1,req,name=shmId" json:"shmId,omitempty"`
	SlotIdx *int32                  `protobuf:"varint,2,req,name=slotIdx" json:"slotIdx,omitempty"`
}

func (x *ShortCircuitShmSlotProto) Reset() {
	*x = ShortCircuitShmSlotProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShortCircuitShmSlotProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShortCircuitShmSlotProto) ProtoMessage() {}

func (x *ShortCircuitShmSlotProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShortCircuitShmSlotProto.ProtoReflect.Descriptor instead.
func (*ShortCircuitShmSlotProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{15}
}

func (x *ShortCircuitShmSlotProto) GetShmId() *ShortCircuitShmIdProto {
	if x != nil {
		return x.ShmId
	}
	return nil
}

func (x *ShortCircuitShmSlotProto) GetSlotIdx() int32 {
	if x != nil && x.SlotIdx != nil {
		return *x.SlotIdx
	}
	return 0
}

type OpRequestShortCircuitAccessProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *BaseHeaderProto `protobuf:"bytes,1,req,name=header" json:"header,omitempty"`
	//* In order to get short-circuit access to block data, clients must set this
	// to the highest version of the block data that they can understand.
	// Currently 1 is the only version, but more versions may exist in the future
	// if the on-disk format changes.
	MaxVersion *uint32 `protobuf:"varint,2,req,name=maxVersion" json:"maxVersion,omitempty"`
	//*
	// The shared memory slot to use, if we are using one.
	SlotId *ShortCircuitShmSlotProto `protobuf:"bytes,3,opt,name=slotId" json:"slotId,omitempty"`
	//*
	// True if the client supports verifying that the file descriptor has been
	// sent successfully.
	SupportsReceiptVerification *bool `protobuf:"varint,4,opt,name=supportsReceiptVerification,def=0" json:"supportsReceiptVerification,omitempty"`
}

// Default values for OpRequestShortCircuitAccessProto fields.
const (
	Default_OpRequestShortCircuitAccessProto_SupportsReceiptVerification = bool(false)
)

func (x *OpRequestShortCircuitAccessProto) Reset() {
	*x = OpRequestShortCircuitAccessProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpRequestShortCircuitAccessProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpRequestShortCircuitAccessProto) ProtoMessage() {}

func (x *OpRequestShortCircuitAccessProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpRequestShortCircuitAccessProto.ProtoReflect.Descriptor instead.
func (*OpRequestShortCircuitAccessProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{16}
}

func (x *OpRequestShortCircuitAccessProto) GetHeader() *BaseHeaderProto {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *OpRequestShortCircuitAccessProto) GetMaxVersion() uint32 {
	if x != nil && x.MaxVersion != nil {
		return *x.MaxVersion
	}
	return 0
}

func (x *OpRequestShortCircuitAccessProto) GetSlotId() *ShortCircuitShmSlotProto {
	if x != nil {
		return x.SlotId
	}
	return nil
}

func (x *OpRequestShortCircuitAccessProto) GetSupportsReceiptVerification() bool {
	if x != nil && x.SupportsReceiptVerification != nil {
		return *x.SupportsReceiptVerification
	}
	return Default_OpRequestShortCircuitAccessProto_SupportsReceiptVerification
}

type ReleaseShortCircuitAccessRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SlotId    *ShortCircuitShmSlotProto   `protobuf:"bytes,1,req,name=slotId" json:"slotId,omitempty"`
	TraceInfo *DataTransferTraceInfoProto `protobuf:"bytes,2,opt,name=traceInfo" json:"traceInfo,omitempty"`
}

func (x *ReleaseShortCircuitAccessRequestProto) Reset() {
	*x = ReleaseShortCircuitAccessRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseShortCircuitAccessRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseShortCircuitAccessRequestProto) ProtoMessage() {}

func (x *ReleaseShortCircuitAccessRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseShortCircuitAccessRequestProto.ProtoReflect.Descriptor instead.
func (*ReleaseShortCircuitAccessRequestProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{17}
}

func (x *ReleaseShortCircuitAccessRequestProto) GetSlotId() *ShortCircuitShmSlotProto {
	if x != nil {
		return x.SlotId
	}
	return nil
}

func (x *ReleaseShortCircuitAccessRequestProto) GetTraceInfo() *DataTransferTraceInfoProto {
	if x != nil {
		return x.TraceInfo
	}
	return nil
}

type ReleaseShortCircuitAccessResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.Status" json:"status,omitempty"`
	Error  *string `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
}

func (x *ReleaseShortCircuitAccessResponseProto) Reset() {
	*x = ReleaseShortCircuitAccessResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseShortCircuitAccessResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseShortCircuitAccessResponseProto) ProtoMessage() {}

func (x *ReleaseShortCircuitAccessResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseShortCircuitAccessResponseProto.ProtoReflect.Descriptor instead.
func (*ReleaseShortCircuitAccessResponseProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{18}
}

func (x *ReleaseShortCircuitAccessResponseProto) GetStatus() Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Status_SUCCESS
}

func (x *ReleaseShortCircuitAccessResponseProto) GetError() string {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ""
}

type ShortCircuitShmRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the client requesting the shared memory segment.  This is
	// purely for logging / debugging purposes.
	ClientName *string                     `protobuf:"bytes,1,req,name=clientName" json:"clientName,omitempty"`
	TraceInfo  *DataTransferTraceInfoProto `protobuf:"bytes,2,opt,name=traceInfo" json:"traceInfo,omitempty"`
}

func (x *ShortCircuitShmRequestProto) Reset() {
	*x = ShortCircuitShmRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShortCircuitShmRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShortCircuitShmRequestProto) ProtoMessage() {}

func (x *ShortCircuitShmRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShortCircuitShmRequestProto.ProtoReflect.Descriptor instead.
func (*ShortCircuitShmRequestProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{19}
}

func (x *ShortCircuitShmRequestProto) GetClientName() string {
	if x != nil && x.ClientName != nil {
		return *x.ClientName
	}
	return ""
}

func (x *ShortCircuitShmRequestProto) GetTraceInfo() *DataTransferTraceInfoProto {
	if x != nil {
		return x.TraceInfo
	}
	return nil
}

type ShortCircuitShmResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status                 `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.Status" json:"status,omitempty"`
	Error  *string                 `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	Id     *ShortCircuitShmIdProto `protobuf:"bytes,3,opt,name=id" json:"id,omitempty"`
}

func (x *ShortCircuitShmResponseProto) Reset() {
	*x = ShortCircuitShmResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShortCircuitShmResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShortCircuitShmResponseProto) ProtoMessage() {}

func (x *ShortCircuitShmResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShortCircuitShmResponseProto.ProtoReflect.Descriptor instead.
func (*ShortCircuitShmResponseProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{20}
}

func (x *ShortCircuitShmResponseProto) GetStatus() Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Status_SUCCESS
}

func (x *ShortCircuitShmResponseProto) GetError() string {
	if x != nil && x.Error != nil {
		return *x.Error
	}
	return ""
}

func (x *ShortCircuitShmResponseProto) GetId() *ShortCircuitShmIdProto {
	if x != nil {
		return x.Id
	}
	return nil
}

type PacketHeaderProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All fields must be fixed-length!
	OffsetInBlock     *int64 `protobuf:"fixed64,1,req,name=offsetInBlock" json:"offsetInBlock,omitempty"`
	Seqno             *int64 `protobuf:"fixed64,2,req,name=seqno" json:"seqno,omitempty"`
	LastPacketInBlock *bool  `protobuf:"varint,3,req,name=lastPacketInBlock" json:"lastPacketInBlock,omitempty"`
	DataLen           *int32 `protobuf:"fixed32,4,req,name=dataLen" json:"dataLen,omitempty"`
	SyncBlock         *bool  `protobuf:"varint,5,opt,name=syncBlock,def=0" json:"syncBlock,omitempty"`
}

// Default values for PacketHeaderProto fields.
const (
	Default_PacketHeaderProto_SyncBlock = bool(false)
)

func (x *PacketHeaderProto) Reset() {
	*x = PacketHeaderProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketHeaderProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketHeaderProto) ProtoMessage() {}

func (x *PacketHeaderProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketHeaderProto.ProtoReflect.Descriptor instead.
func (*PacketHeaderProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{21}
}

func (x *PacketHeaderProto) GetOffsetInBlock() int64 {
	if x != nil && x.OffsetInBlock != nil {
		return *x.OffsetInBlock
	}
	return 0
}

func (x *PacketHeaderProto) GetSeqno() int64 {
	if x != nil && x.Seqno != nil {
		return *x.Seqno
	}
	return 0
}

func (x *PacketHeaderProto) GetLastPacketInBlock() bool {
	if x != nil && x.LastPacketInBlock != nil {
		return *x.LastPacketInBlock
	}
	return false
}

func (x *PacketHeaderProto) GetDataLen() int32 {
	if x != nil && x.DataLen != nil {
		return *x.DataLen
	}
	return 0
}

func (x *PacketHeaderProto) GetSyncBlock() bool {
	if x != nil && x.SyncBlock != nil {
		return *x.SyncBlock
	}
	return Default_PacketHeaderProto_SyncBlock
}

type PipelineAckProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Seqno                  *int64   `protobuf:"zigzag64,1,req,name=seqno" json:"seqno,omitempty"`
	Reply                  []Status `protobuf:"varint,2,rep,name=reply,enum=hadoop.hdfs.Status" json:"reply,omitempty"`
	DownstreamAckTimeNanos *uint64  `protobuf:"varint,3,opt,name=downstreamAckTimeNanos,def=0" json:"downstreamAckTimeNanos,omitempty"`
	Flag                   []uint32 `protobuf:"varint,4,rep,packed,name=flag" json:"flag,omitempty"`
}

// Default values for PipelineAckProto fields.
const (
	Default_PipelineAckProto_DownstreamAckTimeNanos = uint64(0)
)

func (x *PipelineAckProto) Reset() {
	*x = PipelineAckProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineAckProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineAckProto) ProtoMessage() {}

func (x *PipelineAckProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineAckProto.ProtoReflect.Descriptor instead.
func (*PipelineAckProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{22}
}

func (x *PipelineAckProto) GetSeqno() int64 {
	if x != nil && x.Seqno != nil {
		return *x.Seqno
	}
	return 0
}

func (x *PipelineAckProto) GetReply() []Status {
	if x != nil {
		return x.Reply
	}
	return nil
}

func (x *PipelineAckProto) GetDownstreamAckTimeNanos() uint64 {
	if x != nil && x.DownstreamAckTimeNanos != nil {
		return *x.DownstreamAckTimeNanos
	}
	return Default_PipelineAckProto_DownstreamAckTimeNanos
}

func (x *PipelineAckProto) GetFlag() []uint32 {
	if x != nil {
		return x.Flag
	}
	return nil
}

//*
// Sent as part of the BlockOpResponseProto
// for READ_BLOCK and COPY_BLOCK operations.
type ReadOpChecksumInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Checksum *ChecksumProto `protobuf:"bytes,1,req,name=checksum" json:"checksum,omitempty"`
	//*
	// The offset into the block at which the first packet
	// will start. This is necessary since reads will align
	// backwards to a checksum chunk boundary.
	ChunkOffset *uint64 `protobuf:"varint,2,req,name=chunkOffset" json:"chunkOffset,omitempty"`
}

func (x *ReadOpChecksumInfoProto) Reset() {
	*x = ReadOpChecksumInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadOpChecksumInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadOpChecksumInfoProto) ProtoMessage() {}

func (x *ReadOpChecksumInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadOpChecksumInfoProto.ProtoReflect.Descriptor instead.
func (*ReadOpChecksumInfoProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{23}
}

func (x *ReadOpChecksumInfoProto) GetChecksum() *ChecksumProto {
	if x != nil {
		return x.Checksum
	}
	return nil
}

func (x *ReadOpChecksumInfoProto) GetChunkOffset() uint64 {
	if x != nil && x.ChunkOffset != nil {
		return *x.ChunkOffset
	}
	return 0
}

type BlockOpResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status             *Status                       `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.Status" json:"status,omitempty"`
	FirstBadLink       *string                       `protobuf:"bytes,2,opt,name=firstBadLink" json:"firstBadLink,omitempty"`
	ChecksumResponse   *OpBlockChecksumResponseProto `protobuf:"bytes,3,opt,name=checksumResponse" json:"checksumResponse,omitempty"`
	ReadOpChecksumInfo *ReadOpChecksumInfoProto      `protobuf:"bytes,4,opt,name=readOpChecksumInfo" json:"readOpChecksumInfo,omitempty"`
	//* explanatory text which may be useful to log on the client side
	Message *string `protobuf:"bytes,5,opt,name=message" json:"message,omitempty"`
	//* If the server chooses to agree to the request of a client for
	// short-circuit access, it will send a response message with the relevant
	// file descriptors attached.
	//
	// In the body of the message, this version number will be set to the
	// specific version number of the block data that the client is about to
	// read.
	ShortCircuitAccessVersion *uint32 `protobuf:"varint,6,opt,name=shortCircuitAccessVersion" json:"shortCircuitAccessVersion,omitempty"`
}

func (x *BlockOpResponseProto) Reset() {
	*x = BlockOpResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockOpResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockOpResponseProto) ProtoMessage() {}

func (x *BlockOpResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockOpResponseProto.ProtoReflect.Descriptor instead.
func (*BlockOpResponseProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{24}
}

func (x *BlockOpResponseProto) GetStatus() Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Status_SUCCESS
}

func (x *BlockOpResponseProto) GetFirstBadLink() string {
	if x != nil && x.FirstBadLink != nil {
		return *x.FirstBadLink
	}
	return ""
}

func (x *BlockOpResponseProto) GetChecksumResponse() *OpBlockChecksumResponseProto {
	if x != nil {
		return x.ChecksumResponse
	}
	return nil
}

func (x *BlockOpResponseProto) GetReadOpChecksumInfo() *ReadOpChecksumInfoProto {
	if x != nil {
		return x.ReadOpChecksumInfo
	}
	return nil
}

func (x *BlockOpResponseProto) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *BlockOpResponseProto) GetShortCircuitAccessVersion() uint32 {
	if x != nil && x.ShortCircuitAccessVersion != nil {
		return *x.ShortCircuitAccessVersion
	}
	return 0
}

//*
// Message sent from the client to the DN after reading the entire
// read request.
type ClientReadStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.Status" json:"status,omitempty"`
}

func (x *ClientReadStatusProto) Reset() {
	*x = ClientReadStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientReadStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientReadStatusProto) ProtoMessage() {}

func (x *ClientReadStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientReadStatusProto.ProtoReflect.Descriptor instead.
func (*ClientReadStatusProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{25}
}

func (x *ClientReadStatusProto) GetStatus() Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Status_SUCCESS
}

type DNTransferAckProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status *Status `protobuf:"varint,1,req,name=status,enum=hadoop.hdfs.Status" json:"status,omitempty"`
}

func (x *DNTransferAckProto) Reset() {
	*x = DNTransferAckProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DNTransferAckProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNTransferAckProto) ProtoMessage() {}

func (x *DNTransferAckProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNTransferAckProto.ProtoReflect.Descriptor instead.
func (*DNTransferAckProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{26}
}

func (x *DNTransferAckProto) GetStatus() Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Status_SUCCESS
}

type OpBlockChecksumResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BytesPerCrc          *uint32                    `protobuf:"varint,1,req,name=bytesPerCrc" json:"bytesPerCrc,omitempty"`
	CrcPerBlock          *uint64                    `protobuf:"varint,2,req,name=crcPerBlock" json:"crcPerBlock,omitempty"`
	BlockChecksum        []byte                     `protobuf:"bytes,3,req,name=blockChecksum" json:"blockChecksum,omitempty"`
	CrcType              *ChecksumTypeProto         `protobuf:"varint,4,opt,name=crcType,enum=hadoop.hdfs.ChecksumTypeProto" json:"crcType,omitempty"`
	BlockChecksumOptions *BlockChecksumOptionsProto `protobuf:"bytes,5,opt,name=blockChecksumOptions" json:"blockChecksumOptions,omitempty"`
}

func (x *OpBlockChecksumResponseProto) Reset() {
	*x = OpBlockChecksumResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpBlockChecksumResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpBlockChecksumResponseProto) ProtoMessage() {}

func (x *OpBlockChecksumResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpBlockChecksumResponseProto.ProtoReflect.Descriptor instead.
func (*OpBlockChecksumResponseProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{27}
}

func (x *OpBlockChecksumResponseProto) GetBytesPerCrc() uint32 {
	if x != nil && x.BytesPerCrc != nil {
		return *x.BytesPerCrc
	}
	return 0
}

func (x *OpBlockChecksumResponseProto) GetCrcPerBlock() uint64 {
	if x != nil && x.CrcPerBlock != nil {
		return *x.CrcPerBlock
	}
	return 0
}

func (x *OpBlockChecksumResponseProto) GetBlockChecksum() []byte {
	if x != nil {
		return x.BlockChecksum
	}
	return nil
}

func (x *OpBlockChecksumResponseProto) GetCrcType() ChecksumTypeProto {
	if x != nil && x.CrcType != nil {
		return *x.CrcType
	}
	return ChecksumTypeProto_CHECKSUM_NULL
}

func (x *OpBlockChecksumResponseProto) GetBlockChecksumOptions() *BlockChecksumOptionsProto {
	if x != nil {
		return x.BlockChecksumOptions
	}
	return nil
}

type OpCustomProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CustomId *string `protobuf:"bytes,1,req,name=customId" json:"customId,omitempty"`
}

func (x *OpCustomProto) Reset() {
	*x = OpCustomProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_datatransfer_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpCustomProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpCustomProto) ProtoMessage() {}

func (x *OpCustomProto) ProtoReflect() protoreflect.Message {
	mi := &file_datatransfer_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpCustomProto.ProtoReflect.Descriptor instead.
func (*OpCustomProto) Descriptor() ([]byte, []int) {
	return file_datatransfer_proto_rawDescGZIP(), []int{28}
}

func (x *OpCustomProto) GetCustomId() string {
	if x != nil && x.CustomId != nil {
		return *x.CustomId
	}
	return ""
}

var File_datatransfer_proto protoreflect.FileDescriptor

var file_datatransfer_proto_rawDesc = []byte{
	0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x1a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x0a, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9a, 0x03,
	0x0a, 0x21, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x62, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x63,
	0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0c, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x0f, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0f, 0x68, 0x61, 0x6e,
	0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x4c, 0x0a, 0x1b,
	0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0x42, 0x0a, 0x14, 0x48, 0x61,
	0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0c, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x70,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x62, 0x70, 0x69, 0x64, 0x22, 0xc0,
	0x01, 0x0a, 0x0f, 0x42, 0x61, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x35, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2f, 0x0a, 0x05, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x45, 0x0a, 0x09, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x22, 0x52, 0x0a, 0x1a, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x18, 0x0a, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x08, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x1a, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x3c, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x54, 0x0a, 0x14, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x72, 0x6f,
	0x70, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64,
	0x72, 0x6f, 0x70, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x61, 0x68, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x61, 0x68, 0x65, 0x61, 0x64, 0x22, 0xf6, 0x01, 0x0a, 0x10, 0x4f, 0x70, 0x52, 0x65,
	0x61, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3f, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x03, 0x6c, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04,
	0x74, 0x72, 0x75, 0x65, 0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x73, 0x12, 0x4b, 0x0a, 0x0f, 0x63, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x0f, 0x63, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x22, 0x6f, 0x0a, 0x0d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32,
	0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65,
	0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52,
	0x10, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x22, 0xb3, 0x09, 0x0a, 0x11, 0x4f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3f, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x12, 0x36, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4f, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0c, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6d,
	0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x63, 0x76, 0x64, 0x18, 0x06, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x63, 0x76, 0x64, 0x12,
	0x22, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x63, 0x76, 0x64, 0x18,
	0x07, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x52,
	0x63, 0x76, 0x64, 0x12, 0x34, 0x0a, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x08, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x15, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x48, 0x0a, 0x11, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x09,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x12, 0x4b, 0x0a, 0x0f, 0x63, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x0f, 0x63, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x12, 0x45, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x04, 0x44, 0x49, 0x53, 0x4b, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4c,
	0x61, 0x7a, 0x79, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08,
	0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4c, 0x61,
	0x7a, 0x79, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x07, 0x70, 0x69, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73,
	0x65, 0x52, 0x07, 0x70, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x26, 0x0a, 0x0e, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x08, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x69, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64,
	0x12, 0x2a, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x49, 0x64, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x22, 0x88, 0x02, 0x0a,
	0x16, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x49, 0x50, 0x45, 0x4c,
	0x49, 0x4e, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44,
	0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53,
	0x45, 0x54, 0x55, 0x50, 0x5f, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x56, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x49,
	0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10,
	0x03, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x43, 0x4c,
	0x4f, 0x53, 0x45, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e,
	0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59,
	0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53,
	0x45, 0x54, 0x55, 0x50, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12, 0x10, 0x0a,
	0x0c, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x52, 0x42, 0x57, 0x10, 0x07, 0x12,
	0x16, 0x0a, 0x12, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x08, 0x22, 0x8c, 0x02, 0x0a, 0x14, 0x4f, 0x70, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x3f, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x38, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x12, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x22, 0x82, 0x02, 0x0a, 0x13, 0x4f, 0x70, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x34,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x48, 0x69, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x36,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x04, 0x44, 0x49, 0x53, 0x4b,
	0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x22, 0x48, 0x0a, 0x10, 0x4f,
	0x70, 0x43, 0x6f, 0x70, 0x79, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0xa8, 0x01, 0x0a, 0x14, 0x4f, 0x70, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x34,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xbe, 0x03, 0x0a, 0x19, 0x4f, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x34,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x61, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x12, 0x41, 0x0a, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x64, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x4e, 0x75, 0x6d, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x75, 0x6d,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x38, 0x0a, 0x16, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69,
	0x74, 0x53, 0x68, 0x6d, 0x49, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x68,
	0x69, 0x18, 0x01, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x68, 0x69, 0x12, 0x0e, 0x0a, 0x02, 0x6c,
	0x6f, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x02, 0x6c, 0x6f, 0x22, 0x6f, 0x0a, 0x18, 0x53,
	0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x53, 0x68, 0x6d, 0x53, 0x6c,
	0x6f, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x39, 0x0a, 0x05, 0x73, 0x68, 0x6d, 0x49, 0x64,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69,
	0x74, 0x53, 0x68, 0x6d, 0x49, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73, 0x68, 0x6d,
	0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x6c, 0x6f, 0x74, 0x49, 0x64, 0x78, 0x18, 0x02, 0x20,
	0x02, 0x28, 0x05, 0x52, 0x07, 0x73, 0x6c, 0x6f, 0x74, 0x49, 0x64, 0x78, 0x22, 0x80, 0x02, 0x0a,
	0x20, 0x4f, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43,
	0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x42, 0x61, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x6c, 0x6f, 0x74, 0x49,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75,
	0x69, 0x74, 0x53, 0x68, 0x6d, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x73, 0x6c, 0x6f, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x1b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x52, 0x1b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x63, 0x65,
	0x69, 0x70, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xad, 0x01, 0x0a, 0x25, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x53, 0x68, 0x6f, 0x72, 0x74,
	0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x6c, 0x6f,
	0x74, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72,
	0x63, 0x75, 0x69, 0x74, 0x53, 0x68, 0x6d, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x06, 0x73, 0x6c, 0x6f, 0x74, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22,
	0x6b, 0x0a, 0x26, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43,
	0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x84, 0x01, 0x0a,
	0x1b, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x53, 0x68, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x09,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x96, 0x01, 0x0a, 0x1c, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72,
	0x63, 0x75, 0x69, 0x74, 0x53, 0x68, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x33, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x53, 0x68,
	0x6d, 0x49, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x69, 0x64, 0x22, 0xbc, 0x01, 0x0a,
	0x11, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x24, 0x0a, 0x0d, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x10, 0x52, 0x0d, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x49, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x65, 0x71, 0x6e,
	0x6f, 0x18, 0x02, 0x20, 0x02, 0x28, 0x10, 0x52, 0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x12, 0x2c,
	0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x6e, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x18, 0x0a, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0f, 0x52, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x09, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0xa6, 0x01, 0x0a, 0x10,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x14, 0x0a, 0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x18, 0x01, 0x20, 0x02, 0x28, 0x12, 0x52,
	0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x12, 0x29, 0x0a, 0x05, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41,
	0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x3a, 0x01, 0x30, 0x52, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x41, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x73, 0x12, 0x16, 0x0a, 0x04,
	0x66, 0x6c, 0x61, 0x67, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0d, 0x42, 0x02, 0x10, 0x01, 0x52, 0x04,
	0x66, 0x6c, 0x61, 0x67, 0x22, 0x73, 0x0a, 0x17, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x36, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0b, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xec, 0x02, 0x0a, 0x14, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x4f, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x22, 0x0a, 0x0c, 0x66, 0x69, 0x72, 0x73, 0x74, 0x42, 0x61, 0x64, 0x4c, 0x69, 0x6e, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x72, 0x73, 0x74, 0x42, 0x61, 0x64, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x55, 0x0a, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4f, 0x70, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x12, 0x72, 0x65,
	0x61, 0x64, 0x4f, 0x70, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x70, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x12, 0x72, 0x65,
	0x61, 0x64, 0x4f, 0x70, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x19, 0x73, 0x68,
	0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x19, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x15, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x41,
	0x0a, 0x12, 0x44, 0x4e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x41, 0x63, 0x6b, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x22, 0x9e, 0x02, 0x0a, 0x1c, 0x4f, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x43, 0x72,
	0x63, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0b, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65,
	0x72, 0x43, 0x72, 0x63, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x72, 0x63, 0x50, 0x65, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0b, 0x63, 0x72, 0x63, 0x50, 0x65,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x24, 0x0a, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x0d, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x38, 0x0a, 0x07,
	0x63, 0x72, 0x63, 0x54, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x63,
	0x72, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x2b, 0x0a, 0x0d, 0x4f, 0x70, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x64, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x64, 0x2a,
	0x8c, 0x02, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x53, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45,
	0x4e, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x53, 0x55, 0x4d, 0x5f,
	0x4f, 0x4b, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x4f,
	0x4f, 0x42, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d,
	0x4f, 0x4f, 0x42, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x31, 0x10, 0x09, 0x12,
	0x11, 0x0a, 0x0d, 0x4f, 0x4f, 0x42, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x45, 0x44, 0x32,
	0x10, 0x0a, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x4f, 0x42, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x44, 0x33, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x10, 0x0c, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f,
	0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x50, 0x49, 0x4e, 0x4e, 0x45, 0x44, 0x10, 0x0d, 0x2a, 0x5b,
	0x0a, 0x16, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x43, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x46, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x4f, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x50, 0x54, 0x5f, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x1c, 0x0a,
	0x18, 0x55, 0x53, 0x45, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x50, 0x54, 0x5f, 0x56, 0x45, 0x52,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x42, 0x7a, 0x0a, 0x25, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x42, 0x12, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c, 0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68,
	0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f,
	0x68, 0x64, 0x66, 0x73, 0xa0, 0x01, 0x01,
}

var (
	file_datatransfer_proto_rawDescOnce sync.Once
	file_datatransfer_proto_rawDescData = file_datatransfer_proto_rawDesc
)

func file_datatransfer_proto_rawDescGZIP() []byte {
	file_datatransfer_proto_rawDescOnce.Do(func() {
		file_datatransfer_proto_rawDescData = protoimpl.X.CompressGZIP(file_datatransfer_proto_rawDescData)
	})
	return file_datatransfer_proto_rawDescData
}

var file_datatransfer_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_datatransfer_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_datatransfer_proto_goTypes = []interface{}{
	(Status)(0),                 // 0: hadoop.hdfs.Status
	(ShortCircuitFdResponse)(0), // 1: hadoop.hdfs.ShortCircuitFdResponse
	(DataTransferEncryptorMessageProto_DataTransferEncryptorStatus)(0), // 2: hadoop.hdfs.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus
	(OpWriteBlockProto_BlockConstructionStage)(0),                      // 3: hadoop.hdfs.OpWriteBlockProto.BlockConstructionStage
	(*DataTransferEncryptorMessageProto)(nil),                          // 4: hadoop.hdfs.DataTransferEncryptorMessageProto
	(*HandshakeSecretProto)(nil),                                       // 5: hadoop.hdfs.HandshakeSecretProto
	(*BaseHeaderProto)(nil),                                            // 6: hadoop.hdfs.BaseHeaderProto
	(*DataTransferTraceInfoProto)(nil),                                 // 7: hadoop.hdfs.DataTransferTraceInfoProto
	(*ClientOperationHeaderProto)(nil),                                 // 8: hadoop.hdfs.ClientOperationHeaderProto
	(*CachingStrategyProto)(nil),                                       // 9: hadoop.hdfs.CachingStrategyProto
	(*OpReadBlockProto)(nil),                                           // 10: hadoop.hdfs.OpReadBlockProto
	(*ChecksumProto)(nil),                                              // 11: hadoop.hdfs.ChecksumProto
	(*OpWriteBlockProto)(nil),                                          // 12: hadoop.hdfs.OpWriteBlockProto
	(*OpTransferBlockProto)(nil),                                       // 13: hadoop.hdfs.OpTransferBlockProto
	(*OpReplaceBlockProto)(nil),                                        // 14: hadoop.hdfs.OpReplaceBlockProto
	(*OpCopyBlockProto)(nil),                                           // 15: hadoop.hdfs.OpCopyBlockProto
	(*OpBlockChecksumProto)(nil),                                       // 16: hadoop.hdfs.OpBlockChecksumProto
	(*OpBlockGroupChecksumProto)(nil),                                  // 17: hadoop.hdfs.OpBlockGroupChecksumProto
	(*ShortCircuitShmIdProto)(nil),                                     // 18: hadoop.hdfs.ShortCircuitShmIdProto
	(*ShortCircuitShmSlotProto)(nil),                                   // 19: hadoop.hdfs.ShortCircuitShmSlotProto
	(*OpRequestShortCircuitAccessProto)(nil),                           // 20: hadoop.hdfs.OpRequestShortCircuitAccessProto
	(*ReleaseShortCircuitAccessRequestProto)(nil),                      // 21: hadoop.hdfs.ReleaseShortCircuitAccessRequestProto
	(*ReleaseShortCircuitAccessResponseProto)(nil),                     // 22: hadoop.hdfs.ReleaseShortCircuitAccessResponseProto
	(*ShortCircuitShmRequestProto)(nil),                                // 23: hadoop.hdfs.ShortCircuitShmRequestProto
	(*ShortCircuitShmResponseProto)(nil),                               // 24: hadoop.hdfs.ShortCircuitShmResponseProto
	(*PacketHeaderProto)(nil),                                          // 25: hadoop.hdfs.PacketHeaderProto
	(*PipelineAckProto)(nil),                                           // 26: hadoop.hdfs.PipelineAckProto
	(*ReadOpChecksumInfoProto)(nil),                                    // 27: hadoop.hdfs.ReadOpChecksumInfoProto
	(*BlockOpResponseProto)(nil),                                       // 28: hadoop.hdfs.BlockOpResponseProto
	(*ClientReadStatusProto)(nil),                                      // 29: hadoop.hdfs.ClientReadStatusProto
	(*DNTransferAckProto)(nil),                                         // 30: hadoop.hdfs.DNTransferAckProto
	(*OpBlockChecksumResponseProto)(nil),                               // 31: hadoop.hdfs.OpBlockChecksumResponseProto
	(*OpCustomProto)(nil),                                              // 32: hadoop.hdfs.OpCustomProto
	(*CipherOptionProto)(nil),                                          // 33: hadoop.hdfs.CipherOptionProto
	(*ExtendedBlockProto)(nil),                                         // 34: hadoop.hdfs.ExtendedBlockProto
	(*hadoop_common.TokenProto)(nil),                                   // 35: hadoop.common.TokenProto
	(ChecksumTypeProto)(0),                                             // 36: hadoop.hdfs.ChecksumTypeProto
	(*DatanodeInfoProto)(nil),                                          // 37: hadoop.hdfs.DatanodeInfoProto
	(StorageTypeProto)(0),                                              // 38: hadoop.hdfs.StorageTypeProto
	(*BlockChecksumOptionsProto)(nil),                                  // 39: hadoop.hdfs.BlockChecksumOptionsProto
	(*DatanodeInfosProto)(nil),                                         // 40: hadoop.hdfs.DatanodeInfosProto
	(*ErasureCodingPolicyProto)(nil),                                   // 41: hadoop.hdfs.ErasureCodingPolicyProto
}
var file_datatransfer_proto_depIdxs = []int32{
	2,  // 0: hadoop.hdfs.DataTransferEncryptorMessageProto.status:type_name -> hadoop.hdfs.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus
	33, // 1: hadoop.hdfs.DataTransferEncryptorMessageProto.cipherOption:type_name -> hadoop.hdfs.CipherOptionProto
	5,  // 2: hadoop.hdfs.DataTransferEncryptorMessageProto.handshakeSecret:type_name -> hadoop.hdfs.HandshakeSecretProto
	34, // 3: hadoop.hdfs.BaseHeaderProto.block:type_name -> hadoop.hdfs.ExtendedBlockProto
	35, // 4: hadoop.hdfs.BaseHeaderProto.token:type_name -> hadoop.common.TokenProto
	7,  // 5: hadoop.hdfs.BaseHeaderProto.traceInfo:type_name -> hadoop.hdfs.DataTransferTraceInfoProto
	6,  // 6: hadoop.hdfs.ClientOperationHeaderProto.baseHeader:type_name -> hadoop.hdfs.BaseHeaderProto
	8,  // 7: hadoop.hdfs.OpReadBlockProto.header:type_name -> hadoop.hdfs.ClientOperationHeaderProto
	9,  // 8: hadoop.hdfs.OpReadBlockProto.cachingStrategy:type_name -> hadoop.hdfs.CachingStrategyProto
	36, // 9: hadoop.hdfs.ChecksumProto.type:type_name -> hadoop.hdfs.ChecksumTypeProto
	8,  // 10: hadoop.hdfs.OpWriteBlockProto.header:type_name -> hadoop.hdfs.ClientOperationHeaderProto
	37, // 11: hadoop.hdfs.OpWriteBlockProto.targets:type_name -> hadoop.hdfs.DatanodeInfoProto
	37, // 12: hadoop.hdfs.OpWriteBlockProto.source:type_name -> hadoop.hdfs.DatanodeInfoProto
	3,  // 13: hadoop.hdfs.OpWriteBlockProto.stage:type_name -> hadoop.hdfs.OpWriteBlockProto.BlockConstructionStage
	11, // 14: hadoop.hdfs.OpWriteBlockProto.requestedChecksum:type_name -> hadoop.hdfs.ChecksumProto
	9,  // 15: hadoop.hdfs.OpWriteBlockProto.cachingStrategy:type_name -> hadoop.hdfs.CachingStrategyProto
	38, // 16: hadoop.hdfs.OpWriteBlockProto.storageType:type_name -> hadoop.hdfs.StorageTypeProto
	38, // 17: hadoop.hdfs.OpWriteBlockProto.targetStorageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	8,  // 18: hadoop.hdfs.OpTransferBlockProto.header:type_name -> hadoop.hdfs.ClientOperationHeaderProto
	37, // 19: hadoop.hdfs.OpTransferBlockProto.targets:type_name -> hadoop.hdfs.DatanodeInfoProto
	38, // 20: hadoop.hdfs.OpTransferBlockProto.targetStorageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	6,  // 21: hadoop.hdfs.OpReplaceBlockProto.header:type_name -> hadoop.hdfs.BaseHeaderProto
	37, // 22: hadoop.hdfs.OpReplaceBlockProto.source:type_name -> hadoop.hdfs.DatanodeInfoProto
	38, // 23: hadoop.hdfs.OpReplaceBlockProto.storageType:type_name -> hadoop.hdfs.StorageTypeProto
	6,  // 24: hadoop.hdfs.OpCopyBlockProto.header:type_name -> hadoop.hdfs.BaseHeaderProto
	6,  // 25: hadoop.hdfs.OpBlockChecksumProto.header:type_name -> hadoop.hdfs.BaseHeaderProto
	39, // 26: hadoop.hdfs.OpBlockChecksumProto.blockChecksumOptions:type_name -> hadoop.hdfs.BlockChecksumOptionsProto
	6,  // 27: hadoop.hdfs.OpBlockGroupChecksumProto.header:type_name -> hadoop.hdfs.BaseHeaderProto
	40, // 28: hadoop.hdfs.OpBlockGroupChecksumProto.datanodes:type_name -> hadoop.hdfs.DatanodeInfosProto
	35, // 29: hadoop.hdfs.OpBlockGroupChecksumProto.blockTokens:type_name -> hadoop.common.TokenProto
	41, // 30: hadoop.hdfs.OpBlockGroupChecksumProto.ecPolicy:type_name -> hadoop.hdfs.ErasureCodingPolicyProto
	39, // 31: hadoop.hdfs.OpBlockGroupChecksumProto.blockChecksumOptions:type_name -> hadoop.hdfs.BlockChecksumOptionsProto
	18, // 32: hadoop.hdfs.ShortCircuitShmSlotProto.shmId:type_name -> hadoop.hdfs.ShortCircuitShmIdProto
	6,  // 33: hadoop.hdfs.OpRequestShortCircuitAccessProto.header:type_name -> hadoop.hdfs.BaseHeaderProto
	19, // 34: hadoop.hdfs.OpRequestShortCircuitAccessProto.slotId:type_name -> hadoop.hdfs.ShortCircuitShmSlotProto
	19, // 35: hadoop.hdfs.ReleaseShortCircuitAccessRequestProto.slotId:type_name -> hadoop.hdfs.ShortCircuitShmSlotProto
	7,  // 36: hadoop.hdfs.ReleaseShortCircuitAccessRequestProto.traceInfo:type_name -> hadoop.hdfs.DataTransferTraceInfoProto
	0,  // 37: hadoop.hdfs.ReleaseShortCircuitAccessResponseProto.status:type_name -> hadoop.hdfs.Status
	7,  // 38: hadoop.hdfs.ShortCircuitShmRequestProto.traceInfo:type_name -> hadoop.hdfs.DataTransferTraceInfoProto
	0,  // 39: hadoop.hdfs.ShortCircuitShmResponseProto.status:type_name -> hadoop.hdfs.Status
	18, // 40: hadoop.hdfs.ShortCircuitShmResponseProto.id:type_name -> hadoop.hdfs.ShortCircuitShmIdProto
	0,  // 41: hadoop.hdfs.PipelineAckProto.reply:type_name -> hadoop.hdfs.Status
	11, // 42: hadoop.hdfs.ReadOpChecksumInfoProto.checksum:type_name -> hadoop.hdfs.ChecksumProto
	0,  // 43: hadoop.hdfs.BlockOpResponseProto.status:type_name -> hadoop.hdfs.Status
	31, // 44: hadoop.hdfs.BlockOpResponseProto.checksumResponse:type_name -> hadoop.hdfs.OpBlockChecksumResponseProto
	27, // 45: hadoop.hdfs.BlockOpResponseProto.readOpChecksumInfo:type_name -> hadoop.hdfs.ReadOpChecksumInfoProto
	0,  // 46: hadoop.hdfs.ClientReadStatusProto.status:type_name -> hadoop.hdfs.Status
	0,  // 47: hadoop.hdfs.DNTransferAckProto.status:type_name -> hadoop.hdfs.Status
	36, // 48: hadoop.hdfs.OpBlockChecksumResponseProto.crcType:type_name -> hadoop.hdfs.ChecksumTypeProto
	39, // 49: hadoop.hdfs.OpBlockChecksumResponseProto.blockChecksumOptions:type_name -> hadoop.hdfs.BlockChecksumOptionsProto
	50, // [50:50] is the sub-list for method output_type
	50, // [50:50] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_datatransfer_proto_init() }
func file_datatransfer_proto_init() {
	if File_datatransfer_proto != nil {
		return
	}
	file_hdfs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_datatransfer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataTransferEncryptorMessageProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HandshakeSecretProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BaseHeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataTransferTraceInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientOperationHeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CachingStrategyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpReadBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChecksumProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpWriteBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpTransferBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpReplaceBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpCopyBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpBlockChecksumProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpBlockGroupChecksumProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShortCircuitShmIdProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShortCircuitShmSlotProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpRequestShortCircuitAccessProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseShortCircuitAccessRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseShortCircuitAccessResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShortCircuitShmRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShortCircuitShmResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketHeaderProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineAckProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadOpChecksumInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockOpResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientReadStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DNTransferAckProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpBlockChecksumResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_datatransfer_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpCustomProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_datatransfer_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_datatransfer_proto_goTypes,
		DependencyIndexes: file_datatransfer_proto_depIdxs,
		EnumInfos:         file_datatransfer_proto_enumTypes,
		MessageInfos:      file_datatransfer_proto_msgTypes,
	}.Build()
	File_datatransfer_proto = out.File
	file_datatransfer_proto_rawDesc = nil
	file_datatransfer_proto_goTypes = nil
	file_datatransfer_proto_depIdxs = nil
}
