# Copyright 2024 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
EXPERIMENTAL: This is experimental and may be removed without notice

Create repositories for uv toolchain dependencies
"""

load("//python/private:auth.bzl", "AUTH_ATTRS", "get_auth")

UV_BUILD_TMPL = """\
# Generated by repositories.bzl
load("@rules_python//python/uv:uv_toolchain.bzl", "uv_toolchain")

uv_toolchain(
    name = "uv_toolchain",
    uv = "{binary}",
    version = "{version}",
)
"""

def _uv_repo_impl(repository_ctx):
    platform = repository_ctx.attr.platform

    is_windows = "windows" in platform
    _, _, filename = repository_ctx.attr.urls[0].rpartition("/")
    if filename.endswith(".tar.gz"):
        strip_prefix = filename[:-len(".tar.gz")]
    else:
        strip_prefix = ""

    result = repository_ctx.download_and_extract(
        url = repository_ctx.attr.urls,
        sha256 = repository_ctx.attr.sha256,
        stripPrefix = strip_prefix,
        auth = get_auth(repository_ctx, repository_ctx.attr.urls),
    )

    binary = "uv.exe" if is_windows else "uv"
    repository_ctx.file(
        "BUILD.bazel",
        UV_BUILD_TMPL.format(
            binary = binary,
            version = repository_ctx.attr.version,
        ),
    )

    return {
        "name": repository_ctx.attr.name,
        "platform": repository_ctx.attr.platform,
        "sha256": result.sha256,
        "urls": repository_ctx.attr.urls,
        "version": repository_ctx.attr.version,
    }

uv_repository = repository_rule(
    _uv_repo_impl,
    doc = "Fetch external tools needed for uv toolchain",
    attrs = {
        "platform": attr.string(mandatory = True),
        "sha256": attr.string(mandatory = False),
        "urls": attr.string_list(mandatory = True),
        "version": attr.string(mandatory = True),
    } | AUTH_ATTRS,
)
