// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListBucketAnalyticsConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    pub is_truncated: ::std::option::Option<bool>,
    /// <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    pub continuation_token: ::std::option::Option<::std::string::String>,
    /// <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    pub next_continuation_token: ::std::option::Option<::std::string::String>,
    /// <p>The list of analytics configurations for a bucket.</p>
    pub analytics_configuration_list: ::std::option::Option<::std::vec::Vec<crate::types::AnalyticsConfiguration>>,
    _extended_request_id: Option<String>,
    _request_id: Option<String>,
}
impl ListBucketAnalyticsConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    pub fn is_truncated(&self) -> ::std::option::Option<bool> {
        self.is_truncated
    }
    /// <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    pub fn continuation_token(&self) -> ::std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    pub fn next_continuation_token(&self) -> ::std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
    /// <p>The list of analytics configurations for a bucket.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.analytics_configuration_list.is_none()`.
    pub fn analytics_configuration_list(&self) -> &[crate::types::AnalyticsConfiguration] {
        self.analytics_configuration_list.as_deref().unwrap_or_default()
    }
}
impl crate::s3_request_id::RequestIdExt for ListBucketAnalyticsConfigurationsOutput {
    fn extended_request_id(&self) -> Option<&str> {
        self._extended_request_id.as_deref()
    }
}
impl ::aws_types::request_id::RequestId for ListBucketAnalyticsConfigurationsOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl ListBucketAnalyticsConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketAnalyticsConfigurationsOutput`](crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsOutput).
    pub fn builder() -> crate::operation::list_bucket_analytics_configurations::builders::ListBucketAnalyticsConfigurationsOutputBuilder {
        crate::operation::list_bucket_analytics_configurations::builders::ListBucketAnalyticsConfigurationsOutputBuilder::default()
    }
}

/// A builder for [`ListBucketAnalyticsConfigurationsOutput`](crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ListBucketAnalyticsConfigurationsOutputBuilder {
    pub(crate) is_truncated: ::std::option::Option<bool>,
    pub(crate) continuation_token: ::std::option::Option<::std::string::String>,
    pub(crate) next_continuation_token: ::std::option::Option<::std::string::String>,
    pub(crate) analytics_configuration_list: ::std::option::Option<::std::vec::Vec<crate::types::AnalyticsConfiguration>>,
    _extended_request_id: Option<String>,
    _request_id: Option<String>,
}
impl ListBucketAnalyticsConfigurationsOutputBuilder {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    pub fn is_truncated(mut self, input: bool) -> Self {
        self.is_truncated = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    pub fn set_is_truncated(mut self, input: ::std::option::Option<bool>) -> Self {
        self.is_truncated = input;
        self
    }
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    pub fn get_is_truncated(&self) -> &::std::option::Option<bool> {
        &self.is_truncated
    }
    /// <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    pub fn continuation_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.continuation_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    pub fn set_continuation_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.continuation_token = input;
        self
    }
    /// <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    pub fn get_continuation_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.continuation_token
    }
    /// <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    pub fn next_continuation_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_continuation_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    pub fn set_next_continuation_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_continuation_token = input;
        self
    }
    /// <p><code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    pub fn get_next_continuation_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_continuation_token
    }
    /// Appends an item to `analytics_configuration_list`.
    ///
    /// To override the contents of this collection use [`set_analytics_configuration_list`](Self::set_analytics_configuration_list).
    ///
    /// <p>The list of analytics configurations for a bucket.</p>
    pub fn analytics_configuration_list(mut self, input: crate::types::AnalyticsConfiguration) -> Self {
        let mut v = self.analytics_configuration_list.unwrap_or_default();
        v.push(input);
        self.analytics_configuration_list = ::std::option::Option::Some(v);
        self
    }
    /// <p>The list of analytics configurations for a bucket.</p>
    pub fn set_analytics_configuration_list(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::AnalyticsConfiguration>>) -> Self {
        self.analytics_configuration_list = input;
        self
    }
    /// <p>The list of analytics configurations for a bucket.</p>
    pub fn get_analytics_configuration_list(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::AnalyticsConfiguration>> {
        &self.analytics_configuration_list
    }
    pub(crate) fn _extended_request_id(mut self, extended_request_id: impl Into<String>) -> Self {
        self._extended_request_id = Some(extended_request_id.into());
        self
    }

    pub(crate) fn _set_extended_request_id(&mut self, extended_request_id: Option<String>) -> &mut Self {
        self._extended_request_id = extended_request_id;
        self
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`ListBucketAnalyticsConfigurationsOutput`](crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsOutput).
    pub fn build(self) -> crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsOutput {
        crate::operation::list_bucket_analytics_configurations::ListBucketAnalyticsConfigurationsOutput {
            is_truncated: self.is_truncated,
            continuation_token: self.continuation_token,
            next_continuation_token: self.next_continuation_token,
            analytics_configuration_list: self.analytics_configuration_list,
            _extended_request_id: self._extended_request_id,
            _request_id: self._request_id,
        }
    }
}
