/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.CompoundCurve;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.CurvePolygon;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.GeometryCollection;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiCurve;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPoint;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.MultiSurface;
import org.cugos.wkg.Point;
import org.cugos.wkg.PolyHedralSurface;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Surface;
import org.cugos.wkg.Tin;
import org.cugos.wkg.Triangle;
import org.cugos.wkg.WKB;
import org.cugos.wkg.Writer;

public class WKBWriter
implements Writer<byte[]> {
    private final WKB.Type wkbType;
    private final WKB.Endian endian;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public WKBWriter() {
        this(WKB.Type.WKB, WKB.Endian.Big);
    }

    public WKBWriter(WKB.Type wkbType, WKB.Endian edian) {
        this.endian = edian;
        this.wkbType = wkbType;
    }

    public String writeToHex(Geometry geometry) {
        return WKBWriter.toHex(this.write(geometry));
    }

    @Override
    public byte[] write(Geometry g) {
        if (g instanceof Point) {
            return this.write((Point)g);
        }
        if (g instanceof LineString) {
            return this.write((LineString)g);
        }
        if (g instanceof LinearRing) {
            return this.write((LinearRing)g);
        }
        if (g instanceof Triangle) {
            return this.write((Triangle)g);
        }
        if (g instanceof Polygon) {
            return this.write((Polygon)g);
        }
        if (g instanceof MultiPoint) {
            return this.write((MultiPoint)g);
        }
        if (g instanceof MultiLineString) {
            return this.write((MultiLineString)g);
        }
        if (g instanceof MultiPolygon) {
            return this.write((MultiPolygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.write((GeometryCollection)g);
        }
        if (g instanceof CircularString) {
            return this.write((CircularString)g);
        }
        if (g instanceof CurvePolygon) {
            return this.write((CurvePolygon)g);
        }
        if (g instanceof CompoundCurve) {
            return this.write((CompoundCurve)g);
        }
        if (g instanceof MultiCurve) {
            return this.write((MultiCurve)g);
        }
        if (g instanceof PolyHedralSurface) {
            return this.write((PolyHedralSurface)g);
        }
        if (g instanceof MultiSurface) {
            return this.write((MultiSurface)g);
        }
        if (g instanceof Tin) {
            return this.write((Tin)g);
        }
        throw new IllegalArgumentException("Unsupported Geometry! " + g.getClass().getName());
    }

    @Override
    public String getName() {
        return "WKB";
    }

    protected int calculateNumberOfBytes(Geometry g) {
        if (g instanceof Point) {
            return this.calculateNumberOfBytes((Point)g);
        }
        if (g instanceof LineString) {
            return this.calculateNumberOfBytes((LineString)g);
        }
        if (g instanceof LinearRing) {
            return this.calculateNumberOfBytes((LinearRing)g);
        }
        if (g instanceof Triangle) {
            return this.calculateNumberOfBytes((Triangle)g);
        }
        if (g instanceof Polygon) {
            return this.calculateNumberOfBytes((Polygon)g);
        }
        if (g instanceof MultiPoint) {
            return this.calculateNumberOfBytes((MultiPoint)g);
        }
        if (g instanceof MultiLineString) {
            return this.calculateNumberOfBytes((MultiLineString)g);
        }
        if (g instanceof MultiPolygon) {
            return this.calculateNumberOfBytes((MultiPolygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.calculateNumberOfBytes((GeometryCollection)g);
        }
        if (g instanceof CircularString) {
            return this.calculateNumberOfBytes((CircularString)g);
        }
        if (g instanceof CompoundCurve) {
            return this.calculateNumberOfBytes((CompoundCurve)g);
        }
        if (g instanceof CurvePolygon) {
            return this.calculateNumberOfBytes((CurvePolygon)g);
        }
        if (g instanceof MultiCurve) {
            return this.calculateNumberOfBytes((MultiCurve)g);
        }
        if (g instanceof PolyHedralSurface) {
            return this.calculateNumberOfBytes((PolyHedralSurface)g);
        }
        if (g instanceof MultiSurface) {
            return this.calculateNumberOfBytes((MultiSurface)g);
        }
        if (g instanceof Tin) {
            return this.calculateNumberOfBytes((Tin)g);
        }
        throw new IllegalArgumentException("Unsupported Geometry! " + g.getClass().getName());
    }

    protected void putGeometry(ByteBuffer buffer, Geometry g) {
        if (g instanceof Point) {
            this.putPoint(buffer, (Point)g);
        } else if (g instanceof LineString) {
            this.putLineString(buffer, (LineString)g);
        } else if (g instanceof LinearRing) {
            this.putLinearRing(buffer, (LinearRing)g);
        } else if (g instanceof Triangle) {
            this.putTriangle(buffer, (Triangle)g);
        } else if (g instanceof Polygon) {
            this.putPolygon(buffer, (Polygon)g);
        } else if (g instanceof MultiPoint) {
            this.putMultiPoint(buffer, (MultiPoint)g);
        } else if (g instanceof MultiLineString) {
            this.putMultiLineString(buffer, (MultiLineString)g);
        } else if (g instanceof MultiPolygon) {
            this.putMultiPolygon(buffer, (MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.putGeometryCollection(buffer, (GeometryCollection)g);
        } else if (g instanceof CircularString) {
            this.putCircularString(buffer, (CircularString)g);
        } else if (g instanceof CompoundCurve) {
            this.putCompoundCurve(buffer, (CompoundCurve)g);
        } else if (g instanceof CurvePolygon) {
            this.putCurvePolygon(buffer, (CurvePolygon)g);
        } else if (g instanceof MultiCurve) {
            this.putMultiCurve(buffer, (MultiCurve)g);
        } else if (g instanceof PolyHedralSurface) {
            this.putPolyHedralSurface(buffer, (PolyHedralSurface)g);
        } else if (g instanceof MultiSurface) {
            this.putMultiSurface(buffer, (MultiSurface)g);
        } else if (g instanceof Tin) {
            this.putTin(buffer, (Tin)g);
        } else {
            throw new IllegalArgumentException("Unsupported Geometry! " + g.getClass().getName());
        }
    }

    private int calculateNumberOfBytes(String srid) {
        int numberOfBytes = 5;
        if (this.wkbType == WKB.Type.EWKB && srid != null) {
            numberOfBytes += 4;
        }
        return numberOfBytes;
    }

    private int calculateNumberOfBytes(int numberOfCoordinates, Dimension dimension) {
        int multiplier = this.getMultiplier(dimension);
        return 8 * (numberOfCoordinates * multiplier);
    }

    private int getMultiplier(Dimension dimension) {
        if (dimension == Dimension.Two) {
            return 2;
        }
        if (dimension == Dimension.TwoMeasured || dimension == Dimension.Three) {
            return 3;
        }
        if (dimension == Dimension.ThreeMeasured) {
            return 4;
        }
        return 2;
    }

    private void putByteOrder(ByteBuffer buffer) {
        if (this.endian == WKB.Endian.Big) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        buffer.put((byte)this.endian.getValue());
    }

    private void putGeometryType(ByteBuffer buffer, WKB.GeometryType geometryType, Dimension dimension, String srid) {
        int b = geometryType.getValue();
        if (this.wkbType == WKB.Type.EWKB) {
            if (dimension == Dimension.Three || dimension == Dimension.ThreeMeasured) {
                b |= WKB.GeometryTypeFlag.Z.getValue();
            }
            if (dimension == Dimension.TwoMeasured || dimension == Dimension.ThreeMeasured) {
                b |= WKB.GeometryTypeFlag.M.getValue();
            }
            if (srid != null) {
                b |= WKB.GeometryTypeFlag.SRID.getValue();
            }
        }
        buffer.putInt(b);
    }

    private void putSrid(ByteBuffer buffer, String srid) {
        if (this.wkbType == WKB.Type.EWKB && srid != null) {
            buffer.putInt(Integer.parseInt(srid));
        }
    }

    private void putCoordinate(ByteBuffer buffer, Coordinate coord) {
        Dimension dimension = coord.getDimension();
        buffer.putDouble(coord.getX());
        buffer.putDouble(coord.getY());
        if (dimension == Dimension.Three || dimension == Dimension.ThreeMeasured) {
            buffer.putDouble(coord.getZ());
        }
        if (dimension == Dimension.TwoMeasured || dimension == Dimension.ThreeMeasured) {
            buffer.putDouble(coord.getM());
        }
    }

    private void putCoordinates(ByteBuffer buffer, List<Coordinate> coords) {
        buffer.putInt(coords.size());
        for (Coordinate coord : coords) {
            this.putCoordinate(buffer, coord);
        }
    }

    public String writeToHex(Point point) {
        return WKBWriter.toHex(this.write(point));
    }

    public byte[] write(Point point) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(point));
        this.putPoint(buffer, point);
        return buffer.array();
    }

    private int calculateNumberOfBytes(Point point) {
        return this.calculateNumberOfBytes(point.getSrid()) + this.calculateNumberOfBytes(point.getNumberOfCoordinates(), point.getDimension());
    }

    private void putPoint(ByteBuffer buffer, Point point) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.Point, point.getDimension(), point.getSrid());
        this.putSrid(buffer, point.getSrid());
        if (!point.isEmpty()) {
            this.putCoordinate(buffer, point.getCoordinate());
        }
    }

    public String writeToHex(LinearRing linearRing) {
        return WKBWriter.toHex(this.write(linearRing));
    }

    public byte[] write(LinearRing linearRing) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(linearRing));
        this.putLineString(buffer, linearRing);
        return buffer.array();
    }

    private int calculateNumberOfBytes(LinearRing linearRing) {
        return 4 + this.calculateNumberOfBytes(linearRing.getSrid()) + this.calculateNumberOfBytes(linearRing.getNumberOfCoordinates(), linearRing.getDimension());
    }

    private void putLinearRing(ByteBuffer buffer, LinearRing linearRing) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.LineString, linearRing.getDimension(), linearRing.getSrid());
        this.putSrid(buffer, linearRing.getSrid());
        if (!linearRing.isEmpty()) {
            this.putCoordinates(buffer, linearRing.getCoordinates());
        }
    }

    public String writeToHex(LineString lineString) {
        return WKBWriter.toHex(this.write(lineString));
    }

    public byte[] write(LineString lineString) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(lineString));
        this.putLineString(buffer, lineString);
        return buffer.array();
    }

    private int calculateNumberOfBytes(LineString lineString) {
        return 4 + this.calculateNumberOfBytes(lineString.getSrid()) + this.calculateNumberOfBytes(lineString.getNumberOfCoordinates(), lineString.getDimension());
    }

    private void putLineString(ByteBuffer buffer, LineString lineString) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.LineString, lineString.getDimension(), lineString.getSrid());
        this.putSrid(buffer, lineString.getSrid());
        if (!lineString.isEmpty()) {
            this.putCoordinates(buffer, lineString.getCoordinates());
        }
    }

    public String writeToHex(Polygon polygon) {
        return WKBWriter.toHex(this.write(polygon));
    }

    public byte[] write(Polygon polygon) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(polygon));
        this.putPolygon(buffer, polygon);
        return buffer.array();
    }

    private int calculateNumberOfBytes(Polygon polygon) {
        int numberOfRings = 0;
        if (!polygon.isEmpty()) {
            numberOfRings = 1 + polygon.getInnerLinearRings().size();
        }
        return 4 + numberOfRings * 4 + this.calculateNumberOfBytes(polygon.getSrid()) + this.calculateNumberOfBytes(polygon.getNumberOfCoordinates(), polygon.getDimension());
    }

    private void putPolygon(ByteBuffer buffer, Polygon polygon) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.Polygon, polygon.getDimension(), polygon.getSrid());
        this.putSrid(buffer, polygon.getSrid());
        int numberOfRings = 0;
        if (!polygon.isEmpty()) {
            numberOfRings = 1 + polygon.getInnerLinearRings().size();
        }
        buffer.putInt(numberOfRings);
        if (!polygon.isEmpty()) {
            this.putCoordinates(buffer, polygon.getOuterLinearRing().getCoordinates());
            for (LinearRing ring : polygon.getInnerLinearRings()) {
                this.putCoordinates(buffer, ring.getCoordinates());
            }
        }
    }

    public String writeToHex(MultiPoint multiPoint) {
        return WKBWriter.toHex(this.write(multiPoint));
    }

    public byte[] write(MultiPoint multiPoint) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(multiPoint));
        this.putMultiPoint(buffer, multiPoint);
        return buffer.array();
    }

    private int calculateNumberOfBytes(MultiPoint multiPoint) {
        return 4 + this.calculateNumberOfBytes(multiPoint.getSrid()) + (this.calculateNumberOfBytes(multiPoint.getSrid()) + this.calculateNumberOfBytes(1, multiPoint.getDimension())) * multiPoint.getPoints().size();
    }

    private void putMultiPoint(ByteBuffer buffer, MultiPoint multiPoint) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.MultiPoint, multiPoint.getDimension(), multiPoint.getSrid());
        this.putSrid(buffer, multiPoint.getSrid());
        buffer.putInt(multiPoint.getNumberOfCoordinates());
        if (!multiPoint.isEmpty()) {
            for (Point pt : multiPoint.getPoints()) {
                this.putPoint(buffer, pt);
            }
        }
    }

    public String writeToHex(MultiLineString multiLineString) {
        return WKBWriter.toHex(this.write(multiLineString));
    }

    public byte[] write(MultiLineString multiLineString) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(multiLineString));
        this.putMultiLineString(buffer, multiLineString);
        return buffer.array();
    }

    private int calculateNumberOfBytes(MultiLineString multiLineString) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(multiLineString.getSrid());
        for (LineString lineString : multiLineString.getLineStrings()) {
            numberOfBytes += this.calculateNumberOfBytes(lineString);
        }
        return numberOfBytes;
    }

    private void putMultiLineString(ByteBuffer buffer, MultiLineString multiLineString) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.MultiLineString, multiLineString.getDimension(), multiLineString.getSrid());
        this.putSrid(buffer, multiLineString.getSrid());
        buffer.putInt(multiLineString.getLineStrings().size());
        if (!multiLineString.isEmpty()) {
            for (LineString lineString : multiLineString.getLineStrings()) {
                this.putLineString(buffer, lineString);
            }
        }
    }

    public String writeToHex(MultiPolygon multiPolygon) {
        return WKBWriter.toHex(this.write(multiPolygon));
    }

    public byte[] write(MultiPolygon multiPolygon) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(multiPolygon));
        this.putMultiPolygon(buffer, multiPolygon);
        return buffer.array();
    }

    private int calculateNumberOfBytes(MultiPolygon multiPolygon) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(multiPolygon.getSrid());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            numberOfBytes += this.calculateNumberOfBytes(polygon);
        }
        return numberOfBytes;
    }

    private void putMultiPolygon(ByteBuffer buffer, MultiPolygon multiPolygon) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.MultiPolygon, multiPolygon.getDimension(), multiPolygon.getSrid());
        this.putSrid(buffer, multiPolygon.getSrid());
        buffer.putInt(multiPolygon.getPolygons().size());
        if (!multiPolygon.isEmpty()) {
            for (Polygon polygon : multiPolygon.getPolygons()) {
                this.putPolygon(buffer, polygon);
            }
        }
    }

    public String writeToHex(GeometryCollection geometryCollection) {
        return WKBWriter.toHex(this.write(geometryCollection));
    }

    public byte[] write(GeometryCollection geometryCollection) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(geometryCollection));
        this.putGeometryCollection(buffer, geometryCollection);
        return buffer.array();
    }

    private int calculateNumberOfBytes(GeometryCollection geometryCollection) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(geometryCollection.getSrid());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            numberOfBytes += this.calculateNumberOfBytes(geometry);
        }
        return numberOfBytes;
    }

    private void putGeometryCollection(ByteBuffer buffer, GeometryCollection geometryCollection) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.GeometryCollection, geometryCollection.getDimension(), geometryCollection.getSrid());
        this.putSrid(buffer, geometryCollection.getSrid());
        buffer.putInt(geometryCollection.getGeometries().size());
        if (!geometryCollection.isEmpty()) {
            for (Geometry geometry : geometryCollection.getGeometries()) {
                this.putGeometry(buffer, geometry);
            }
        }
    }

    public String writeToHex(CircularString circularString) {
        return WKBWriter.toHex(this.write(circularString));
    }

    public byte[] write(CircularString circularString) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(circularString));
        this.putCircularString(buffer, circularString);
        return buffer.array();
    }

    private int calculateNumberOfBytes(CircularString circularString) {
        return 4 + this.calculateNumberOfBytes(circularString.getSrid()) + this.calculateNumberOfBytes(circularString.getNumberOfCoordinates(), circularString.getDimension());
    }

    private void putCircularString(ByteBuffer buffer, CircularString circularString) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.CircularString, circularString.getDimension(), circularString.getSrid());
        this.putSrid(buffer, circularString.getSrid());
        if (!circularString.isEmpty()) {
            this.putCoordinates(buffer, circularString.getCoordinates());
        }
    }

    private int calculateNumberOfBytes(Curve curve) {
        if (curve instanceof LineString) {
            return this.calculateNumberOfBytes((LineString)curve);
        }
        if (curve instanceof CircularString) {
            return this.calculateNumberOfBytes((CircularString)curve);
        }
        if (curve instanceof CompoundCurve) {
            return this.calculateNumberOfBytes((CompoundCurve)curve);
        }
        throw new IllegalArgumentException("Unsupported Curve! " + curve.getClass().getName());
    }

    private void putCurve(ByteBuffer buffer, Curve curve) {
        if (curve instanceof LineString) {
            this.putLineString(buffer, (LineString)curve);
        } else if (curve instanceof CircularString) {
            this.putCircularString(buffer, (CircularString)curve);
        } else if (curve instanceof CompoundCurve) {
            this.putCompoundCurve(buffer, (CompoundCurve)curve);
        } else {
            throw new IllegalArgumentException("Unsupported Curve! " + curve.getClass().getName());
        }
    }

    public String writeToHex(CompoundCurve compoundCurve) {
        return WKBWriter.toHex(this.write(compoundCurve));
    }

    public byte[] write(CompoundCurve compoundCurve) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(compoundCurve));
        this.putCompoundCurve(buffer, compoundCurve);
        return buffer.array();
    }

    private int calculateNumberOfBytes(CompoundCurve compoundCurve) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(compoundCurve.getSrid());
        for (Curve curve : compoundCurve.getCurves()) {
            numberOfBytes += this.calculateNumberOfBytes(curve);
        }
        return numberOfBytes;
    }

    private void putCompoundCurve(ByteBuffer buffer, CompoundCurve compoundCurve) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.CompoundCurve, compoundCurve.getDimension(), compoundCurve.getSrid());
        this.putSrid(buffer, compoundCurve.getSrid());
        buffer.putInt(compoundCurve.getCurves().size());
        if (!compoundCurve.isEmpty()) {
            for (Curve curve : compoundCurve.getCurves()) {
                this.putCurve(buffer, curve);
            }
        }
    }

    public String writeToHex(CurvePolygon curvePolygon) {
        return WKBWriter.toHex(this.write(curvePolygon));
    }

    public byte[] write(CurvePolygon curvePolygon) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(curvePolygon));
        this.putCurvePolygon(buffer, curvePolygon);
        return buffer.array();
    }

    private int calculateNumberOfBytes(CurvePolygon curvePolygon) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(curvePolygon.getSrid());
        numberOfBytes += this.calculateNumberOfBytes(curvePolygon.getOuterCurve());
        for (Curve curve : curvePolygon.getInnerCurves()) {
            numberOfBytes += this.calculateNumberOfBytes(curve);
        }
        return numberOfBytes;
    }

    private void putCurvePolygon(ByteBuffer buffer, CurvePolygon curvePolygon) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.CurvePolygon, curvePolygon.getDimension(), curvePolygon.getSrid());
        this.putSrid(buffer, curvePolygon.getSrid());
        int numberOfCurves = 0;
        if (!curvePolygon.isEmpty()) {
            numberOfCurves += 1 + curvePolygon.getInnerCurves().size();
        }
        buffer.putInt(numberOfCurves);
        if (!curvePolygon.isEmpty()) {
            this.putCurve(buffer, curvePolygon.getOuterCurve());
            for (Curve curve : curvePolygon.getInnerCurves()) {
                this.putCurve(buffer, curve);
            }
        }
    }

    public String writeToHex(MultiCurve multiCurve) {
        return WKBWriter.toHex(this.write(multiCurve));
    }

    public byte[] write(MultiCurve multiCurve) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(multiCurve));
        this.putMultiCurve(buffer, multiCurve);
        return buffer.array();
    }

    private int calculateNumberOfBytes(MultiCurve multiCurve) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(multiCurve.getSrid());
        for (Curve curve : multiCurve.getCurves()) {
            numberOfBytes += this.calculateNumberOfBytes(curve);
        }
        return numberOfBytes;
    }

    private void putMultiCurve(ByteBuffer buffer, MultiCurve multiCurve) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.MultiCurve, multiCurve.getDimension(), multiCurve.getSrid());
        this.putSrid(buffer, multiCurve.getSrid());
        buffer.putInt(multiCurve.getCurves().size());
        if (!multiCurve.isEmpty()) {
            for (Curve curve : multiCurve.getCurves()) {
                this.putCurve(buffer, curve);
            }
        }
    }

    private int calculateNumberOfBytes(Surface surface) {
        if (surface instanceof Triangle) {
            return this.calculateNumberOfBytes((Triangle)surface);
        }
        if (surface instanceof Polygon) {
            return this.calculateNumberOfBytes((Polygon)surface);
        }
        if (surface instanceof PolyHedralSurface) {
            return this.calculateNumberOfBytes((PolyHedralSurface)surface);
        }
        if (surface instanceof Tin) {
            return this.calculateNumberOfBytes((Tin)surface);
        }
        if (surface instanceof CurvePolygon) {
            return this.calculateNumberOfBytes((CurvePolygon)surface);
        }
        throw new IllegalArgumentException("Unknown Surface: " + surface.getClass().getName());
    }

    private void putSurface(ByteBuffer buffer, Surface surface) {
        if (surface instanceof Triangle) {
            this.putTriangle(buffer, (Triangle)surface);
        } else if (surface instanceof Polygon) {
            this.putPolygon(buffer, (Polygon)surface);
        } else if (surface instanceof PolyHedralSurface) {
            this.putPolyHedralSurface(buffer, (PolyHedralSurface)surface);
        } else if (surface instanceof Tin) {
            this.putTin(buffer, (Tin)surface);
        } else if (surface instanceof CurvePolygon) {
            this.putCurvePolygon(buffer, (CurvePolygon)surface);
        } else {
            throw new IllegalArgumentException("Unknown Surface: " + surface.getClass().getName());
        }
    }

    public String writeToHex(MultiSurface multiSurface) {
        return WKBWriter.toHex(this.write(multiSurface));
    }

    public byte[] write(MultiSurface multiSurface) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(multiSurface));
        this.putMultiSurface(buffer, multiSurface);
        return buffer.array();
    }

    private int calculateNumberOfBytes(MultiSurface multiSurface) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(multiSurface.getSrid());
        for (Surface surface : multiSurface.getSurfaces()) {
            numberOfBytes += this.calculateNumberOfBytes(surface);
        }
        return numberOfBytes;
    }

    private void putMultiSurface(ByteBuffer buffer, MultiSurface multiSurface) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.MultiSurface, multiSurface.getDimension(), multiSurface.getSrid());
        this.putSrid(buffer, multiSurface.getSrid());
        buffer.putInt(multiSurface.getSurfaces().size());
        if (!multiSurface.isEmpty()) {
            for (Surface surface : multiSurface.getSurfaces()) {
                this.putSurface(buffer, surface);
            }
        }
    }

    public String writeToHex(Tin tin) {
        return WKBWriter.toHex(this.write(tin));
    }

    public byte[] write(Tin tin) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(tin));
        this.putTin(buffer, tin);
        return buffer.array();
    }

    private int calculateNumberOfBytes(Tin tin) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(tin.getSrid());
        for (Triangle triangle : tin.getTriangles()) {
            numberOfBytes += this.calculateNumberOfBytes(triangle);
        }
        return numberOfBytes;
    }

    private void putTin(ByteBuffer buffer, Tin tin) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.Tin, tin.getDimension(), tin.getSrid());
        this.putSrid(buffer, tin.getSrid());
        buffer.putInt(tin.getTriangles().size());
        if (!tin.isEmpty()) {
            for (Triangle triangle : tin.getTriangles()) {
                this.putTriangle(buffer, triangle);
            }
        }
    }

    public String writeToHex(Triangle triangle) {
        return WKBWriter.toHex(this.write(triangle));
    }

    public byte[] write(Triangle triangle) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(triangle));
        this.putTriangle(buffer, triangle);
        return buffer.array();
    }

    private int calculateNumberOfBytes(Triangle triangle) {
        int numberOfRings = 0;
        if (!triangle.isEmpty()) {
            numberOfRings = 1 + triangle.getInnerLinearRings().size();
        }
        return 4 + numberOfRings * 4 + this.calculateNumberOfBytes(triangle.getSrid()) + this.calculateNumberOfBytes(triangle.getNumberOfCoordinates(), triangle.getDimension());
    }

    private void putTriangle(ByteBuffer buffer, Triangle triangle) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.Triangle, triangle.getDimension(), triangle.getSrid());
        this.putSrid(buffer, triangle.getSrid());
        int numberOfRings = 0;
        if (!triangle.isEmpty()) {
            numberOfRings = 1 + triangle.getInnerLinearRings().size();
        }
        buffer.putInt(numberOfRings);
        if (!triangle.isEmpty()) {
            this.putCoordinates(buffer, triangle.getOuterLinearRing().getCoordinates());
            for (LinearRing ring : triangle.getInnerLinearRings()) {
                this.putCoordinates(buffer, ring.getCoordinates());
            }
        }
    }

    public String writeToHex(PolyHedralSurface polyHedralSurface) {
        return WKBWriter.toHex(this.write(polyHedralSurface));
    }

    public byte[] write(PolyHedralSurface polyHedralSurface) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(polyHedralSurface));
        this.putPolyHedralSurface(buffer, polyHedralSurface);
        return buffer.array();
    }

    private int calculateNumberOfBytes(PolyHedralSurface polyHedralSurface) {
        int numberOfBytes = 4 + this.calculateNumberOfBytes(polyHedralSurface.getSrid());
        for (Polygon polygon : polyHedralSurface.getPolygons()) {
            numberOfBytes += this.calculateNumberOfBytes(polygon);
        }
        return numberOfBytes;
    }

    private void putPolyHedralSurface(ByteBuffer buffer, PolyHedralSurface polyHedralSurface) {
        this.putByteOrder(buffer);
        this.putGeometryType(buffer, WKB.GeometryType.PolyHedralSurface, polyHedralSurface.getDimension(), polyHedralSurface.getSrid());
        this.putSrid(buffer, polyHedralSurface.getSrid());
        buffer.putInt(polyHedralSurface.getPolygons().size());
        if (!polyHedralSurface.isEmpty()) {
            for (Polygon polygon : polyHedralSurface.getPolygons()) {
                this.putPolygon(buffer, polygon);
            }
        }
    }

    private static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

