/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourceParseResults;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.xml.sax.Attributes;

class DataSourceSerializerLegacy<T extends DataSourceDescriptor>
implements DataSourceSerializer<T> {
    private static final Log log = Log.getLog(DataSourceSerializerLegacy.class);
    private final DataSourceRegistry<T> registry;
    private static final String LEGACY_DEFAULT_AUTO_COMMIT = "default.autocommit";
    private static final String LEGACY_DEFAULT_ISOLATION = "default.isolation";
    private static final String LEGACY_DEFAULT_ACTIVE_OBJECT = "default.activeObject";

    DataSourceSerializerLegacy(DataSourceRegistry<T> registry) {
        this.registry = registry;
    }

    @Override
    public void saveDataSources(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceConfigurationManager configurationManager, @NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull List<T> localDataSources) throws IOException {
        throw new IOException("Legacy serializer is deprecated, save not possible");
    }

    @Override
    public boolean parseDataSources(@NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull DataSourceConfigurationManager configurationManager, @NotNull DataSourceParseResults parseResults, Collection<String> dataSourceIds) throws DBException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream is = configurationManager.readConfiguration(configurationStorage.getStorageName(), dataSourceIds);){
                if (is != null) {
                    SAXReader parser = new SAXReader(is);
                    DataSourcesParser dsp = new DataSourcesParser(this.registry, configurationStorage, parseResults);
                    parser.parse((SAXListener)dsp);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new DBException("Datasource config parse error", (Throwable)ex);
        }
        return false;
    }

    @Nullable
    private static String decryptPassword(String encPassword) {
        if (!CommonUtils.isEmpty((String)encPassword)) {
            try {
                encPassword = SimpleStringEncrypter.INSTANCE.decrypt(encPassword);
            }
            catch (Throwable throwable) {
                encPassword = null;
            }
        }
        return encPassword;
    }

    private static class DataSourcesParser
    implements SAXListener {
        DataSourceRegistry<?> registry;
        DataSourceDescriptor curDataSource;
        DBPDataSourceConfigurationStorage storage;
        boolean isDescription = false;
        DBRShellCommand curCommand = null;
        private DBWHandlerConfiguration curNetworkHandler;
        private DBSObjectFilter curFilter;
        private StringBuilder curQuery;
        private final DataSourceParseResults parseResults;
        private boolean passwordReadCanceled = false;

        private DataSourcesParser(DataSourceRegistry<?> registry, DBPDataSourceConfigurationStorage storage, DataSourceParseResults parseResults) {
            this.registry = registry;
            this.storage = storage;
            this.parseResults = parseResults;
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) {
            this.isDescription = false;
            this.curCommand = null;
            block18 : switch (localName) {
                case "folder": {
                    DataSourceFolder folder;
                    String name = attributes.getValue("name");
                    String description = attributes.getValue("description");
                    String parentFolder = attributes.getValue("parent");
                    DataSourceFolder parent = parentFolder == null ? null : this.registry.findFolderByPath(parentFolder, true, this.parseResults);
                    DataSourceFolder dataSourceFolder = folder = parent == null ? this.registry.findFolderByPath(name, true, this.parseResults) : parent.getChild(name);
                    if (folder == null) {
                        folder = new DataSourceFolder(this.registry, parent, name, description);
                        this.parseResults.addedFolders.add(folder);
                        break;
                    }
                    folder.setDescription(description);
                    this.parseResults.updatedFolders.add(folder);
                    break;
                }
                case "data-source": {
                    String legacySchemaFilter;
                    boolean newDataSource;
                    String name = attributes.getValue("name");
                    String id = attributes.getValue("id");
                    if (id == null) {
                        id = name;
                    }
                    String providerId = attributes.getValue("provider");
                    DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                    if (provider == null) {
                        log.warn((Object)("Can't find datasource provider " + providerId + " for datasource '" + name + "'"));
                        this.curDataSource = null;
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    String driverId = attributes.getValue("driver");
                    DriverDescriptor driver = provider.getDriver(driverId);
                    if (driver == null) {
                        log.warn((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + name + "'. Create new driver"));
                        driver = provider.createDriver(driverId);
                        provider.addDriver(driver);
                    }
                    this.curDataSource = this.registry.getDataSource(id);
                    boolean bl = newDataSource = this.curDataSource == null;
                    if (newDataSource) {
                        this.curDataSource = new DataSourceDescriptor(this.registry, this.storage, DataSourceOriginLocal.INSTANCE, id, driver, new DBPConnectionConfiguration());
                    } else {
                        this.curDataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                        this.curDataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                        this.curDataSource.clearFilters();
                    }
                    this.curDataSource.setName(name);
                    this.curDataSource.setSavePassword(CommonUtils.getBoolean((String)attributes.getValue("save-password")));
                    DataSourceNavigatorSettings navSettings = this.curDataSource.getOriginalNavigatorSettings();
                    navSettings.setShowSystemObjects(CommonUtils.getBoolean((String)attributes.getValue("show-system-objects")));
                    navSettings.setShowUtilityObjects(CommonUtils.getBoolean((String)attributes.getValue("show-util-objects")));
                    navSettings.setShowOnlyEntities(CommonUtils.getBoolean((String)attributes.getValue("navigator-show-only-entities")));
                    navSettings.setHideFolders(CommonUtils.getBoolean((String)attributes.getValue("navigator-hide-folders")));
                    navSettings.setHideSchemas(CommonUtils.getBoolean((String)attributes.getValue("navigator-hide-schemas")));
                    navSettings.setHideVirtualModel(CommonUtils.getBoolean((String)attributes.getValue("navigator-hide-virtual")));
                    navSettings.setMergeEntities(CommonUtils.getBoolean((String)attributes.getValue("navigator-merge-entities")));
                    this.curDataSource.setConnectionReadOnly(CommonUtils.getBoolean((String)attributes.getValue("read-only")));
                    String folderPath = attributes.getValue("folder");
                    if (folderPath != null) {
                        this.curDataSource.setFolder(this.registry.findFolderByPath(folderPath, true, this.parseResults));
                    }
                    this.curDataSource.setLockPasswordHash(attributes.getValue("lockPassword"));
                    String legacyCatalogFilter = attributes.getValue("filter-catalog");
                    if (!CommonUtils.isEmpty((String)legacyCatalogFilter)) {
                        this.curDataSource.updateObjectFilter(DBSCatalog.class.getName(), null, new DBSObjectFilter(legacyCatalogFilter, null));
                    }
                    if (!CommonUtils.isEmpty((String)(legacySchemaFilter = attributes.getValue("filter-schema")))) {
                        this.curDataSource.updateObjectFilter(DBSSchema.class.getName(), null, new DBSObjectFilter(legacySchemaFilter, null));
                    }
                    if (newDataSource) {
                        this.parseResults.addedDataSources.add(this.curDataSource);
                        break;
                    }
                    this.parseResults.updatedDataSources.add(this.curDataSource);
                    break;
                }
                case "connection": {
                    String keepAlive;
                    if (this.curDataSource == null) break;
                    DBPDriver driver = this.curDataSource.getDriver();
                    if (CommonUtils.isEmpty((String)driver.getName()) && driver instanceof DriverDescriptor) {
                        ((DriverDescriptor)driver).setName(attributes.getValue("url"));
                        ((DriverDescriptor)driver).setDriverClassName("java.sql.Driver");
                    }
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    config.setHostName(attributes.getValue("host"));
                    config.setHostPort(attributes.getValue("port"));
                    config.setServerName(attributes.getValue("server"));
                    config.setDatabaseName(attributes.getValue("database"));
                    config.setUrl(attributes.getValue("url"));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(attributes, this.curDataSource, null);
                        config.setUserName(creds[0]);
                        if (this.curDataSource.isSavePassword()) {
                            config.setUserPassword(creds[1]);
                        }
                    }
                    config.setClientHomeId(attributes.getValue("home"));
                    config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(CommonUtils.toString((Object)attributes.getValue("type")), DBPConnectionType.DEFAULT_TYPE));
                    String colorValue = attributes.getValue("color");
                    if (!CommonUtils.isEmpty((String)colorValue)) {
                        config.setConnectionColor(colorValue);
                    }
                    if (CommonUtils.isEmpty((String)(keepAlive = attributes.getValue("keepAlive")))) break;
                    try {
                        config.setKeepAliveInterval(Integer.parseInt(keepAlive));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)"Bad keep-alive interval value", (Throwable)e);
                    }
                    break;
                }
                case "bootstrap": {
                    if (this.curDataSource == null) break;
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    if (attributes.getValue("autocommit") != null) {
                        config.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)attributes.getValue("autocommit"))));
                    }
                    if (attributes.getValue("txnIsolation") != null) {
                        config.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)attributes.getValue("txnIsolation"))));
                    }
                    if (!CommonUtils.isEmpty((String)attributes.getValue("defaultObject"))) {
                        config.getBootstrap().setDefaultCatalogName(attributes.getValue("defaultObject"));
                    }
                    if (attributes.getValue("ignoreErrors") == null) break;
                    config.getBootstrap().setIgnoreErrors(CommonUtils.toBoolean((Object)attributes.getValue("ignoreErrors")));
                    break;
                }
                case "query": {
                    this.curQuery = new StringBuilder();
                    break;
                }
                case "property": {
                    if (this.curNetworkHandler != null) {
                        this.curNetworkHandler.setProperty(attributes.getValue("name"), (Object)attributes.getValue("value"));
                        break;
                    }
                    if (this.curDataSource == null) break;
                    String propName = attributes.getValue("name");
                    String propValue = attributes.getValue("value");
                    if (propName == null) break;
                    if (propName.startsWith("@dbeaver-")) {
                        this.curDataSource.getConnectionConfiguration().setProviderProperty(propName, propValue);
                        break;
                    }
                    this.curDataSource.getConnectionConfiguration().setProperty(propName, propValue);
                    break;
                }
                case "provider-property": {
                    if (this.curDataSource == null) break;
                    this.curDataSource.getConnectionConfiguration().setProviderProperty(attributes.getValue("name"), attributes.getValue("value"));
                    break;
                }
                case "event": {
                    if (this.curDataSource == null) break;
                    DBPConnectionEventType eventType = DBPConnectionEventType.valueOf((String)attributes.getValue("type"));
                    this.curCommand = new DBRShellCommand("");
                    this.curCommand.setEnabled(CommonUtils.getBoolean((String)attributes.getValue("enabled")));
                    this.curCommand.setShowProcessPanel(CommonUtils.getBoolean((String)attributes.getValue("show-panel")));
                    this.curCommand.setWaitProcessFinish(CommonUtils.getBoolean((String)attributes.getValue("wait-process")));
                    if (this.curCommand.isWaitProcessFinish()) {
                        String timeoutString = attributes.getValue("wait-process-timeout");
                        int timeoutMs = CommonUtils.toInt((Object)timeoutString, (int)-1);
                        this.curCommand.setWaitProcessTimeoutMs(timeoutMs);
                    }
                    this.curCommand.setTerminateAtDisconnect(CommonUtils.getBoolean((String)attributes.getValue("terminate-at-disconnect")));
                    this.curCommand.setPauseAfterExecute(CommonUtils.toInt((Object)attributes.getValue("pauseAfterExecute")));
                    this.curCommand.setWorkingDirectory(attributes.getValue("workingDirectory"));
                    this.curDataSource.getConnectionConfiguration().setEvent(eventType, this.curCommand);
                    break;
                }
                case "custom-property": {
                    if (this.curDataSource == null) break;
                    String propName = attributes.getValue("name");
                    String propValue = attributes.getValue("value");
                    switch (propName) {
                        case "default.autocommit": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)propValue)));
                            break block18;
                        }
                        case "default.isolation": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)propValue)));
                            break block18;
                        }
                        case "default.activeObject": {
                            if (CommonUtils.isEmpty((String)propValue)) break block18;
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultCatalogName(propValue);
                            break block18;
                        }
                    }
                    this.curDataSource.getPreferenceStore().getProperties().put(propName, propValue);
                    break;
                }
                case "network-handler": {
                    if (this.curDataSource == null) break;
                    String handlerId = attributes.getValue("id");
                    NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
                    if (handlerDescriptor == null) {
                        log.warn((Object)("Can't find network handler '" + handlerId + "'"));
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    this.curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDataSourceContainer)this.curDataSource);
                    this.curNetworkHandler.setEnabled(CommonUtils.getBoolean((String)attributes.getValue("enabled")));
                    this.curNetworkHandler.setSavePassword(CommonUtils.getBoolean((String)attributes.getValue("save-password")));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(attributes, this.curDataSource, "network/" + handlerId);
                        this.curNetworkHandler.setUserName(creds[0]);
                        if (this.curNetworkHandler.isSavePassword()) {
                            this.curNetworkHandler.setPassword(creds[1]);
                        }
                    }
                    this.curDataSource.getConnectionConfiguration().updateHandler(this.curNetworkHandler);
                    break;
                }
                case "filter": {
                    if (this.curDataSource != null) {
                        String typeName = attributes.getValue("type");
                        String objectID = attributes.getValue("id");
                        if (typeName == null) break;
                        this.curFilter = new DBSObjectFilter();
                        this.curFilter.setName(attributes.getValue("name"));
                        this.curFilter.setDescription(attributes.getValue("description"));
                        this.curFilter.setEnabled(CommonUtils.getBoolean((String)attributes.getValue("enabled"), (boolean)true));
                        this.curDataSource.updateObjectFilter(typeName, objectID, this.curFilter);
                        break;
                    }
                    this.curFilter = new DBSObjectFilter();
                    this.curFilter.setName(attributes.getValue("name"));
                    this.curFilter.setDescription(attributes.getValue("description"));
                    this.curFilter.setEnabled(CommonUtils.getBoolean((String)attributes.getValue("enabled"), (boolean)true));
                    this.registry.addSavedFilter(this.curFilter);
                    break;
                }
                case "include": {
                    if (this.curFilter == null) break;
                    this.curFilter.addInclude(CommonUtils.notEmpty((String)attributes.getValue("name")));
                    break;
                }
                case "exclude": {
                    if (this.curFilter == null) break;
                    this.curFilter.addExclude(CommonUtils.notEmpty((String)attributes.getValue("name")));
                    break;
                }
                case "description": {
                    this.isDescription = true;
                    break;
                }
                case "virtual-meta-data": {
                    if (this.curDataSource == null) break;
                    reader.setListener(this.curDataSource.getVirtualModel().getModelParser());
                }
            }
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
            if (this.isDescription && this.curDataSource != null) {
                this.curDataSource.setDescription(data);
            } else if (this.curCommand != null) {
                this.curCommand.setCommand(data);
                this.curCommand = null;
            } else if (this.curQuery != null) {
                this.curQuery.append(data);
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) {
            switch (localName) {
                case "data-source": {
                    this.curDataSource = null;
                    break;
                }
                case "network-handler": {
                    this.curNetworkHandler = null;
                    break;
                }
                case "filter": {
                    this.curFilter = null;
                    break;
                }
                case "query": {
                    if (this.curDataSource == null || this.curQuery == null || this.curQuery.isEmpty()) break;
                    this.curDataSource.getConnectionConfiguration().getBootstrap().getInitQueries().add(this.curQuery.toString());
                    this.curQuery = null;
                }
            }
            this.isDescription = false;
        }

        private String[] readSecuredCredentials(Attributes xmlAttrs, DataSourceDescriptor dataSource, String subNode) {
            String[] creds = new String[2];
            DBPProject project = dataSource.getProject();
            try {
                if (project.isUseSecretStorage()) {
                    DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)project);
                    String keyPrefix = dataSource == null ? "projects/" + project.getId() : "datasources/" + dataSource.getId();
                    Path itemPath = Path.of(keyPrefix, new String[0]).resolve(CommonUtils.notEmpty((String)subNode));
                    creds[0] = secretController.getPrivateSecretValue(itemPath.resolve("user").toString());
                    creds[1] = secretController.getPrivateSecretValue(itemPath.resolve("password").toString());
                }
            }
            catch (Throwable e) {
                log.error((Object)"Can't read password from secure storage", e);
                this.passwordReadCanceled = true;
            }
            if (CommonUtils.isEmpty((String)creds[0])) {
                creds[0] = xmlAttrs.getValue("user");
            }
            if (CommonUtils.isEmpty((String)creds[1])) {
                String encPassword = xmlAttrs.getValue("password");
                creds[1] = CommonUtils.isEmpty((String)encPassword) ? null : DataSourceSerializerLegacy.decryptPassword(encPassword);
            }
            return creds;
        }
    }
}

