/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.responses.highlevel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.hampelratte.svdrp.responses.highlevel.Genre;
import org.hampelratte.svdrp.responses.highlevel.Stream;

public class EPGEntry
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String channelID = "";
    private String channelName = "";
    private long eventID = 0L;
    private long startTime;
    private Calendar startTimeCal;
    private long endTime;
    private Calendar endTimeCal;
    private int tableID = 0;
    private int version = 0;
    private String title = "";
    private String shortText = "";
    private String description = "";
    private long vpsTime;
    private Calendar vpsTimeCal;
    private List<Stream> streams = new ArrayList<Stream>();
    private List<Genre> genres = new ArrayList<Genre>();

    public String getChannelID() {
        return this.channelID;
    }

    public void setChannelID(String channelID) {
        this.channelID = channelID;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Calendar getEndTime() {
        if (this.endTimeCal == null) {
            this.endTimeCal = Calendar.getInstance();
            this.endTimeCal.setTimeInMillis(this.endTime);
        }
        return this.endTimeCal;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
        this.endTimeCal = null;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime.getTimeInMillis();
        this.endTimeCal = endTime;
    }

    public String getShortText() {
        return this.shortText;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public Calendar getStartTime() {
        if (this.startTimeCal == null) {
            this.startTimeCal = Calendar.getInstance();
            this.startTimeCal.setTimeInMillis(this.startTime);
        }
        return this.startTimeCal;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.startTimeCal = null;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime.getTimeInMillis();
        this.startTimeCal = startTime;
    }

    public int getTableID() {
        return this.tableID;
    }

    public void setTableID(int tableId) {
        this.tableID = tableId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Calendar getVpsTime() {
        if (this.vpsTimeCal == null) {
            this.vpsTimeCal = Calendar.getInstance();
            this.vpsTimeCal.setTimeInMillis(this.vpsTime);
        }
        return this.vpsTimeCal;
    }

    public void setVpsTime(long vpsTime) {
        this.vpsTime = vpsTime;
        this.vpsTimeCal = null;
    }

    public void setVpsTime(Calendar vpsTime) {
        this.vpsTime = vpsTime.getTimeInMillis();
        this.vpsTimeCal = vpsTime;
    }

    public long getEventID() {
        return this.eventID;
    }

    public void setEventID(long eventID) {
        this.eventID = eventID;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public void setStreams(List<Stream> streams) {
        this.streams = streams;
    }

    public List<Genre> getGenres() {
        return this.genres;
    }

    public void setGenres(List<Genre> genres) {
        this.genres = genres;
    }

    public List<Stream> getAudioStreams() {
        ArrayList<Stream> audioStreams = new ArrayList<Stream>(this.getStreams());
        Iterator iterator = audioStreams.iterator();
        while (iterator.hasNext()) {
            Stream stream = (Stream)iterator.next();
            if (stream.getContent() == Stream.CONTENT.MP2A || stream.getContent() == Stream.CONTENT.AC3 || stream.getContent() == Stream.CONTENT.HEAAC) continue;
            iterator.remove();
        }
        return audioStreams;
    }

    public String toString() {
        return this.getTitle() + " starts: " + this.getStartTime().get(11) + ":" + this.getStartTime().get(12) + " ends: " + this.getEndTime().get(11) + ":" + this.getEndTime().get(12);
    }
}

