// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListBucketMetricsConfigurations`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket containing the metrics configurations to retrieve.</p><br>
    ///   - [`continuation_token(impl Into<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::continuation_token) / [`set_continuation_token(Option<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::set_continuation_token):<br>required: **false**<br><p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the <code>NextContinuationToken</code> from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`ListBucketMetricsConfigurationsOutput`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsOutput) with field(s):
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsOutput::is_truncated): <p>Indicates whether the returned list of metrics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    ///   - [`continuation_token(Option<String>)`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsOutput::continuation_token): <p>The marker that is used as a starting point for this metrics configuration list response. This value is present if it was sent in the request.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsOutput::next_continuation_token): <p>The marker used to continue a metrics configuration listing that has been truncated. Use the <code>NextContinuationToken</code> from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
    ///   - [`metrics_configuration_list(Option<Vec::<MetricsConfiguration>>)`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsOutput::metrics_configuration_list): <p>The list of metrics configurations for a bucket.</p>
    /// - On failure, responds with [`SdkError<ListBucketMetricsConfigurationsError>`](crate::operation::list_bucket_metrics_configurations::ListBucketMetricsConfigurationsError)
    pub fn list_bucket_metrics_configurations(
        &self,
    ) -> crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder {
        crate::operation::list_bucket_metrics_configurations::builders::ListBucketMetricsConfigurationsFluentBuilder::new(self.handle.clone())
    }
}
