/*
    SPDX-FileCopyrightText: 2009 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef OKTETA_CHAR8EDITOR_HPP
#define OKTETA_CHAR8EDITOR_HPP

// lib
#include "char8stringparser.hpp"
// libdatatypes
#include <char8.hpp>
// Qt
#include <QLineEdit>
// Std
#include <optional>

namespace Okteta {
class CharCodec;

class Char8Editor : public QLineEdit
{
    Q_OBJECT
    Q_PROPERTY(Char8 data READ data WRITE setData USER true)

public:
    Char8Editor(const CharCodec* charCodec, QWidget* parent);

    ~Char8Editor() override;

public:
    void setByte(quint8 byte);
    [[nodiscard]]
    std::optional<quint8> byte() const;

    void setData(Char8 data);
    [[nodiscard]]
    Char8 data() const;

private:
    Char8StringParser m_parser;
};

}

#endif
