/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PBKDF2Core;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBMAC1Core
extends HmacCore {
    private final String kdfAlgo;
    private final String hashAlgo;
    private final int blockLength;

    PBMAC1Core(String string, String string2, int n) throws NoSuchAlgorithmException {
        super(string2, n);
        this.kdfAlgo = string;
        this.hashAlgo = string2;
        this.blockLength = n;
    }

    private static PBKDF2Core getKDFImpl(String string) {
        PBKDF2Core pBKDF2Core = null;
        switch (string) {
            case "HmacSHA1": {
                pBKDF2Core = new PBKDF2Core.HmacSHA1();
                break;
            }
            case "HmacSHA224": {
                pBKDF2Core = new PBKDF2Core.HmacSHA224();
                break;
            }
            case "HmacSHA256": {
                pBKDF2Core = new PBKDF2Core.HmacSHA256();
                break;
            }
            case "HmacSHA384": {
                pBKDF2Core = new PBKDF2Core.HmacSHA384();
                break;
            }
            case "HmacSHA512": {
                pBKDF2Core = new PBKDF2Core.HmacSHA512();
                break;
            }
            default: {
                throw new ProviderException("No MAC implementation for " + string);
            }
        }
        return pBKDF2Core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey secretKey;
        char[] cArray;
        Object object;
        int n;
        byte[] byArray;
        block24: {
            block25: {
                block27: {
                    block26: {
                        block23: {
                            byArray = null;
                            n = 0;
                            if (!(key instanceof PBEKey)) break block23;
                            object = (PBEKey)key;
                            cArray = object.getPassword();
                            byArray = object.getSalt();
                            n = object.getIterationCount();
                            break block24;
                        }
                        if (!(key instanceof SecretKey)) break block25;
                        if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) break block26;
                        byte[] byArray2 = key.getEncoded();
                        object = byArray2;
                        if (byArray2 != null) break block27;
                    }
                    throw new InvalidKeyException("Missing password");
                }
                cArray = new char[((Object)object).length];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)(object[i] & 0x7F);
                }
                Arrays.fill((byte[])object, (byte)0);
                break block24;
            }
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (algorithmParameterSpec == null) {
                if (byArray == null || n == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                if (byArray != null) {
                    if (!Arrays.equals(byArray, pBEParameterSpec.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    byArray = pBEParameterSpec.getSalt();
                }
                if (n != 0) {
                    if (n != pBEParameterSpec.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    n = pBEParameterSpec.getIterationCount();
                }
            }
            if (byArray.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (n <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            object = new PBEKeySpec(cArray, byArray, n, this.blockLength);
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
        PBKDF2Core pBKDF2Core = PBMAC1Core.getKDFImpl(this.kdfAlgo);
        try {
            secretKey = pBKDF2Core.engineGenerateSecret((KeySpec)object);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Cannot construct PBE key");
            invalidKeyException.initCause(invalidKeySpecException);
            throw invalidKeyException;
        }
        byte[] byArray3 = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, this.kdfAlgo);
        super.engineInit(secretKeySpec, null);
    }

    public static final class HmacSHA512
    extends PBMAC1Core {
        public HmacSHA512() throws NoSuchAlgorithmException {
            super("HmacSHA512", "SHA-512", 128);
        }
    }

    public static final class HmacSHA384
    extends PBMAC1Core {
        public HmacSHA384() throws NoSuchAlgorithmException {
            super("HmacSHA384", "SHA-384", 128);
        }
    }

    public static final class HmacSHA256
    extends PBMAC1Core {
        public HmacSHA256() throws NoSuchAlgorithmException {
            super("HmacSHA256", "SHA-256", 64);
        }
    }

    public static final class HmacSHA224
    extends PBMAC1Core {
        public HmacSHA224() throws NoSuchAlgorithmException {
            super("HmacSHA224", "SHA-224", 64);
        }
    }

    public static final class HmacSHA1
    extends PBMAC1Core {
        public HmacSHA1() throws NoSuchAlgorithmException {
            super("HmacSHA1", "SHA1", 64);
        }
    }
}

