/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class AbstractLocator
implements Locator {
    private int relativePosition = 2;
    private int gap;

    public int getGap() {
        return this.gap;
    }

    protected abstract Point getReferencePoint();

    protected Rectangle getNewBounds(Dimension size, Point center) {
        Rectangle bounds = new Rectangle(center, size);
        bounds.x -= bounds.width / 2;
        bounds.y -= bounds.height / 2;
        int xFactor = 0;
        int yFactor = 0;
        int position = this.getRelativePosition();
        if ((position & 1) != 0) {
            yFactor = -1;
        } else if ((position & 4) != 0) {
            yFactor = 1;
        }
        if ((position & 8) != 0) {
            xFactor = -1;
        } else if ((position & 0x10) != 0) {
            xFactor = 1;
        }
        bounds.x += xFactor * (bounds.width / 2 + this.getGap());
        bounds.y += yFactor * (bounds.height / 2 + this.getGap());
        return bounds;
    }

    public int getRelativePosition() {
        return this.relativePosition;
    }

    @Override
    public void relocate(IFigure target) {
        Dimension prefSize = target.getPreferredSize();
        Point center = this.getReferencePoint();
        target.translateToRelative(center);
        target.setBounds(this.getNewBounds(prefSize, center));
    }

    public void setGap(int i) {
        this.gap = i;
    }

    public void setRelativePosition(int pos) {
        this.relativePosition = pos;
    }
}

