/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.inspection.AbstractLocalLibrariesInspection;
import com.intellij.packageChecker.inspection.MaliciousLibrariesUtilsKt;
import com.intellij.packageChecker.inspection.problemDescriptor.LocalProblemDescriptorBuilder;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.service.Malicious;
import com.intellij.packageChecker.service.PackageChecker;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/packageChecker/inspection/MaliciousLibrariesLocalInspection;", "Lcom/intellij/packageChecker/inspection/AbstractLocalLibrariesInspection;", "<init>", "()V", "collectProblemDescriptors", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "service", "Lcom/intellij/packageChecker/service/PackageService;", "isHeadlessMode", "", "reportStatistics", "", "problemDescriptors", "intellij.packageChecker"})
public final class MaliciousLibrariesLocalInspection
extends AbstractLocalLibrariesInspection {
    @Override
    @NotNull
    public List<ProblemDescriptor> collectProblemDescriptors(@NotNull PsiFile file, @NotNull Project project, @NotNull Module module, @NotNull PackageService service, boolean isHeadlessMode) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Map<Package, PackageDeclaration> declaredDependencies = MaliciousLibrariesUtilsKt.getDeclaredDependencies(file, service);
        PackageChecker packageChecker = PackageChecker.Companion.getInstance(project);
        List<Malicious> maliciousPackages = MaliciousLibrariesUtilsKt.findMaliciousPackages(declaredDependencies, packageChecker);
        String moduleModelId = MaliciousLibrariesUtilsKt.getModuleId(file, project);
        String string = this.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        LocalProblemDescriptorBuilder descriptorBuilder = new LocalProblemDescriptorBuilder(file, declaredDependencies, service, isHeadlessMode, module, moduleModelId, string);
        List<ProblemDescriptor> problemDescriptors = descriptorBuilder.descriptorsForMalicious(maliciousPackages);
        return problemDescriptors;
    }

    @Override
    protected void reportStatistics(@NotNull Project project, @NotNull List<? extends ProblemDescriptor> problemDescriptors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(problemDescriptors, (String)"problemDescriptors");
        PackageCheckerUsageStat.INSTANCE.getLocalInspectionResultMalicious().log(project, (Object)problemDescriptors.size());
    }
}

