/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputApi;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.trust.JupyterFileTrustManager;
import com.intellij.jupyter.core.jupyter.trust.JupyterHashTrustManager;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterTrustManager;", "", "<init>", "()V", "isTrusted", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "trust", "", "recreateWebOutputs", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterTrustManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class JupyterTrustManager {
    @NotNull
    public static final JupyterTrustManager INSTANCE = new JupyterTrustManager();

    private JupyterTrustManager() {
    }

    public final boolean isTrusted(@NotNull Editor editor) {
        JupyterFileTrustManager.FileSpecificView filePathTrustManager;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull(editor);
        if (jupyterNotebook == null) {
            return false;
        }
        JupyterNotebook notebook = jupyterNotebook;
        JupyterFileTrustManager.FileSpecificView fileSpecificView = filePathTrustManager = JupyterFileTrustManager.Companion.getForEditor(editor);
        boolean bl = fileSpecificView != null ? fileSpecificView.getTrusted() : false;
        if (bl) {
            JupyterHashTrustManager.Companion.saveTrustedNotebook(notebook);
            filePathTrustManager.setTrusted(false);
        }
        return JupyterHashTrustManager.Companion.getIsTrusted(notebook);
    }

    public final void trust(@NotNull Editor editor) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
            if (object == null || (object = object.getNotebookOrNull()) == null) {
                return;
            }
            Object notebook = object;
            JupyterHashTrustManager.Companion.saveTrustedNotebook((JupyterNotebook)notebook);
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl == null) break block1;
            EditorImpl it = editorImpl;
            boolean bl = false;
            INSTANCE.recreateWebOutputs(it);
        }
    }

    public final void recreateWebOutputs(@NotNull EditorImpl editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            JupyterWebOutputApi.Companion.reinstall(editor);
            NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
            if (notebookCellInlayManager == null) break block0;
            notebookCellInlayManager.refresh();
        }
    }
}

