/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.ast.PyAstStatementWithElse;
import com.jetbrains.python.ast.PyAstTryExceptStatement;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PyUnindentUtil {
    public static boolean unindentAsNeeded(Project project, Editor editor, PsiFile file) {
        int local_length;
        CharSequence text;
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (offset >= (text = document.getCharsSequence()).length()) {
            offset = text.length() - 1;
        }
        int line_start_offset = document.getLineStartOffset(document.getLineNumber(offset));
        int nonspace_offset = PyUnindentUtil.findBeginning(line_start_offset, text);
        Class<PyAstStatementWithElse> parentClass = null;
        int last_offset = nonspace_offset + "finally".length();
        if (last_offset > offset) {
            last_offset = offset;
        }
        if ((local_length = last_offset - nonspace_offset + 1) > 0) {
            int finally_len;
            int except_len;
            String piece = text.subSequence(nonspace_offset, last_offset + 1).toString();
            int else_len = "else".length();
            if (local_length >= else_len && (piece.startsWith("else") || piece.startsWith("elif")) && (else_len == piece.length() || piece.charAt(else_len) < 'a' || piece.charAt(else_len) > 'z')) {
                parentClass = PyAstStatementWithElse.class;
            }
            if (local_length >= (except_len = "except".length()) && piece.startsWith("except") && (except_len == piece.length() || piece.charAt(except_len) < 'a' || piece.charAt(except_len) > 'z')) {
                parentClass = PyAstTryExceptStatement.class;
            }
            if (local_length >= (finally_len = "finally".length()) && piece.startsWith("finally") && (finally_len == piece.length() || piece.charAt(finally_len) < 'a' || piece.charAt(finally_len) > 'z')) {
                parentClass = PyAstTryExceptStatement.class;
            }
        }
        if (parentClass == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiElement token = file.findElementAt(offset - 2);
        PsiElement outer = PsiTreeUtil.getParentOfType((PsiElement)token, parentClass);
        if (outer != null) {
            int outer_offset = outer.getTextOffset();
            int outer_indent = outer_offset - document.getLineStartOffset(document.getLineNumber(outer_offset));
            assert (outer_indent >= 0);
            int current_indent = nonspace_offset - line_start_offset;
            int indent = outer_indent - current_indent;
            EditorCoreUtil.indentLine((Project)project, (Editor)editor, (int)document.getLineNumber(offset), (int)(editor.getSettings().isUseTabCharacter(project) ? indent * editor.getSettings().getTabSize(project) : indent), (boolean)false);
            return true;
        }
        return false;
    }

    private static int findBeginning(int start_offset, CharSequence text) {
        char current_char;
        int current_offset;
        int text_length = text.length();
        for (current_offset = start_offset; current_offset < text_length && ((current_char = text.charAt(current_offset)) == ' ' || current_char == '\t' || current_char == '\n'); ++current_offset) {
        }
        return current_offset;
    }
}

